/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.CobolFocusable;
import com.iscobol.gui.Constants;
import com.iscobol.gui.Events;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.LocalImage;
import com.iscobol.gui.client.TerminalAccept;
import com.iscobol.gui.client.swing.BaseRemoteObject;
import com.iscobol.gui.client.swing.BorderedFrame;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.Filterable;
import com.iscobol.gui.client.swing.FilterableTreeViewModel;
import com.iscobol.gui.client.swing.FilterableTreeViewNode;
import com.iscobol.gui.client.swing.FlatStyleUI;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.HamburgerMenuAttrs;
import com.iscobol.gui.client.swing.MenuManager;
import com.iscobol.gui.client.swing.MenuScroller;
import com.iscobol.gui.client.swing.PicobolMenu;
import com.iscobol.gui.client.swing.PicobolMenuBar;
import com.iscobol.gui.client.swing.PicobolMenuItem;
import com.iscobol.gui.client.swing.PicobolPopupMenu;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteBaseGUIWindow;
import com.iscobol.gui.client.swing.RemoteDisplayToolBar;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.RemoteJavaBean;
import com.iscobol.gui.client.swing.RemoteTerminalAccept;
import com.iscobol.gui.client.swing.SearchPanel;
import com.iscobol.gui.client.swing.SwingWorker;
import com.iscobol.gui.client.swing.TreeViewPanel;
import com.iscobol.rts.IscobolSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class RemoteMenu
implements Constants,
BaseRemoteObject {
    private static final Class flatLafCls;
    private MenuChangeListener menuChangeListener;
    private MenuCDMChangeListener menuCDMChangeListener;
    private boolean isMenuBar;
    private int parentWindowId;
    private RemoteBaseGUIWindow parentWindow;
    private int type = -1;
    private Hamburger hamburger;
    private MenuTreeNode hamburgerItem;
    private JMenuBar menuBar;
    PicobolPopupMenu menuPopup;
    private MenuScroller ms;
    JMenuItem menu;
    private RemoteMenu parent;
    private Vector<RemoteMenu> children = new Vector();
    int menuId = -1000;
    int menuId2 = -1000;
    private int separatorId = -1000;
    private boolean menuChecked;
    private boolean menuEnabled = true;
    private Icon menuIcon;
    private String menuText;
    private BaseRemoteObject invoker;
    private int xCoordinate;
    private int yCoordinate;
    private int maxWidth;
    private GuiFactoryImpl gf;
    private MenuManager manager;
    private boolean navigateswingdefault = true;
    private boolean altdownpressed;
    private MouseListener menumouselistener;
    private MenuKeyListener menukeylistener;
    private int[] exceptionvalues;
    private MouseListener menuCDMmouselistener;
    private MenuKeyListener menuCDMkeylistener;

    private CobolEventCouple getCEC(BaseRemoteObject sender, RemoteRecordAccept rra) {
        if (sender instanceof RemoteBaseGUIControl) {
            return new CobolEventCouple((RemoteBaseGUIControl)sender, (BaseRemoteObject)this, rra);
        }
        return new CobolEventCouple(sender, (BaseRemoteObject)this, rra);
    }

    public RemoteMenu(GuiFactoryImpl gf, int type) {
        this(gf, type, null, null);
    }

    public RemoteMenu(GuiFactoryImpl gf, String trayTooltip, int id, int id2, int imageId, int bitmapNumber, int bitmapWidth, MenuManager manager) {
        this.gf = gf;
        this.type = 3;
        this.menuId = id;
        this.menuId2 = id2;
        this.parent = null;
        this.manager = manager;
        this.menuPopup = new PicobolPopupMenu(false);
        this.menuPopup.addPopupMenuListener(new EndPopupMenuListener());
        this.menu = new PicobolMenu(this);
        this.menu.setText(trayTooltip);
        this.setIcon(imageId, bitmapNumber, bitmapWidth, this);
        this.navigateswingdefault = gf.getCsProperty().get("iscobol.gui.menu.altkey_default", true);
    }

    private RemoteMenu(GuiFactoryImpl gf, int type, RemoteMenu par, JMenuItem comp) {
        this.gf = gf;
        this.type = type;
        switch (type) {
            case 0: 
            case 4: {
                if (comp == null) {
                    this.menu = new PicobolMenu(this);
                } else {
                    this.menu = comp;
                    this.removeListeners(this.menu);
                }
                this.menu.addActionListener(new MyMenuActionListener());
                break;
            }
            case 2: {
                if (comp != null) break;
                this.menuPopup = new PicobolPopupMenu(false);
                this.menuPopup.addPopupMenuListener(new EndPopupMenuListener());
            }
        }
        this.parent = par;
        this.navigateswingdefault = gf.getCsProperty().get("iscobol.gui.menu.altkey_default", true);
    }

    private void responseOnAction() {
        RemoteRecordAccept rra = new RemoteRecordAccept(3, this.menuId, 16397, 0, this.menuId, true, true, true);
        if (this.invoker != null && this.invoker instanceof RemoteBaseGUIControl) {
            ((RemoteBaseGUIControl)this.invoker).pushEvent(this.getCEC(this.invoker, rra), 16397);
        } else if (this.parentWindow != null && ((RemoteDisplayWindow)this.parentWindow).getMainWindow() != null) {
            ((RemoteDisplayWindow)this.parentWindow).getMainWindow().push(this.getCEC(this.invoker != null ? this.invoker : this.parentWindow, rra));
            for (int i = 0; this.exceptionvalues != null && i < this.exceptionvalues.length; ++i) {
                rra = new RemoteRecordAccept(3, this.exceptionvalues[i], 16397, 0, this.exceptionvalues[i], true, true, true);
                ((RemoteDisplayWindow)this.parentWindow).getMainWindow().push(this.getCEC(this.invoker != null ? this.invoker : this.parentWindow, rra));
            }
        } else {
            MenuManager mm = this.getManager();
            if (mm != null) {
                mm.sendTrayEvent(this, 1);
            }
        }
        Hamburger h = this.getHamburger();
        if (h != null && !h.keepOpen) {
            h.hide();
        }
    }

    private MenuManager getManager() {
        if (this.manager != null) {
            return this.manager;
        }
        if (this.parent != null) {
            return this.parent.getManager();
        }
        return null;
    }

    private void responseOnActionMenu(int id) {
        Hamburger h;
        if (this.parentWindow != null && ((RemoteDisplayWindow)this.parentWindow).getMainWindow() != null) {
            RemoteRecordAccept rra = new RemoteRecordAccept(3, id, 16397, 0, id, true, true, true);
            ((RemoteDisplayWindow)this.parentWindow).getMainWindow().push(this.getCEC(this.parentWindow, rra));
        }
        if ((h = this.getHamburger()) != null && !h.webStyle) {
            h.hide();
        }
    }

    public void setMaxWidth(int mw) {
        this.maxWidth = mw;
    }

    public void destroy() {
        if (this.ms != null) {
            this.ms.dispose();
        }
        if (this.parent != null) {
            this.parent.removeMenu(this);
        }
    }

    private DefaultTreeModel getHamburgerTreeModel() {
        if (this.hamburger != null) {
            return this.hamburger.treeModel;
        }
        if (this.parent != null) {
            return this.parent.getHamburgerTreeModel();
        }
        return null;
    }

    private Hamburger getHamburger() {
        if (this.hamburger != null) {
            return this.hamburger;
        }
        if (this.parent != null) {
            return this.parent.getHamburger();
        }
        return null;
    }

    public void setChecked(int id, boolean checked) {
        RemoteMenu menuToCheck = this.findMenu(id);
        if (menuToCheck == null) {
            return;
        }
        RemoteMenu par = menuToCheck.parent;
        JMenuItem oldmi = menuToCheck.menu;
        if (menuToCheck.getItemCount() == 0 && par != null && oldmi != null && oldmi instanceof PicobolMenuItem && checked ^ menuToCheck.menuChecked) {
            switch (par.type) {
                case 0: 
                case 2: 
                case 3: 
                case 4: {
                    DefaultTreeModel model;
                    menuToCheck.menuChecked = checked;
                    ((PicobolMenuItem)oldmi).setChecked(checked);
                    if (menuToCheck.hamburgerItem == null) break;
                    if (this.getHamburger() != null) {
                        this.getConstraints(true);
                    }
                    if ((model = this.getHamburgerTreeModel()) == null) break;
                    model.nodeChanged(menuToCheck.hamburgerItem);
                }
            }
        }
    }

    public void setEnabled(boolean b, int id) {
        RemoteMenu rm;
        RemoteMenu remoteMenu = rm = id < 0 ? this : this.findMenu(id);
        if (rm != null) {
            rm.setEnabled(b, true, true);
        }
    }

    private void setEnabled(boolean b, boolean setParent, boolean setChildren) {
        DefaultTreeModel model;
        if (b && setParent && this.parent != null) {
            this.parent.setEnabled(true, true, false);
        }
        if (this.menu != null) {
            this.menu.setEnabled(b);
        }
        this.menuEnabled = b;
        if (this.hamburgerItem != null && (model = this.getHamburgerTreeModel()) != null) {
            model.nodeChanged(this.hamburgerItem);
        }
        if (setChildren) {
            for (RemoteMenu rm : this.children) {
                rm.setEnabled(b, false, true);
            }
        }
    }

    public void delete(int id) {
        RemoteMenu par;
        int pos;
        RemoteMenu menuToDelete = this.findMenu(id);
        if (menuToDelete == null) {
            menuToDelete = this.findSeparator(id);
        }
        if (menuToDelete != null && menuToDelete.parent != null && (pos = (par = menuToDelete.parent).getMenuPosition(id)) < par.getItemCount()) {
            par.removeMenu(pos);
        }
    }

    public void setParentWindow(int windowId) {
        this.setParentWindow(windowId, (RemoteBaseGUIWindow)this.gf.getClient().getId(windowId));
    }

    private void setParentWindow(int wId, RemoteBaseGUIWindow pw) {
        this.parentWindowId = wId;
        if (this.parentWindow != pw) {
            this.parentWindow = pw;
            if (this.hamburger != null && this.parentWindow != null) {
                this.hamburger.configureLayoutManager(this.parentWindow);
            }
        }
        for (RemoteMenu rm : this.children) {
            rm.setParentWindow(wId, pw);
        }
    }

    private void setInvoker(BaseRemoteObject invoker) {
        this.invoker = invoker;
        if (!this.isMenuBar && this.type != 1) {
            for (RemoteMenu rm : this.children) {
                rm.setInvoker(invoker);
            }
        }
    }

    public int getParentWindow() {
        return this.parentWindowId;
    }

    public void addMenu(int pos, int flags, String text, int id, int submenuId, boolean change, String exceptionvalues) {
        if (change) {
            RemoteMenu menuToChange = this.findMenu(pos);
            if (menuToChange == null) {
                return;
            }
            RemoteMenu par = menuToChange.parent;
            int idx = par.getMenuPosition(pos);
            if (idx < par.getItemCount()) {
                par.addMenu(pos, flags, text, id, submenuId, exceptionvalues);
                par.removeMenu(idx + 1);
                par.getMenuById(id).setParentWindow(this.parentWindowId, this.parentWindow);
            }
        } else {
            this.addMenu(pos, flags, text, id, submenuId, exceptionvalues);
        }
    }

    public int getType() {
        return this.type;
    }

    private RemoteMenu getMenuById(int id) {
        RemoteMenu Return2 = null;
        Enumeration<RemoteMenu> e = this.children.elements();
        while (e.hasMoreElements()) {
            Return2 = e.nextElement();
            if (Return2.menuId != id) continue;
        }
        return Return2;
    }

    public void setBlock(boolean b) {
        if (this.isMenuBar && this.hamburger != null) {
            MenuElement[] me = this.menuBar.getSubElements();
            for (int i = 0; i < me.length; ++i) {
                ((PicobolMenu)me[i]).setBlock(b);
            }
        }
    }

    public void debug() {
        if (this.type == 0) {
            System.out.println("RM:debug Text = " + this.menu.getText() + ", id = " + this.menuId + ", par = " + this.parent);
        } else if (this.type == 1) {
            System.out.println("RM:debug SEPARATOR, id = " + this.separatorId + ", par = " + this.parent);
        }
        for (RemoteMenu rm : this.children) {
            rm.debug();
        }
    }

    private void addMenu(int pos, int flags, String text, int id, int submenuId, String exceptionvalues) {
        switch (this.type) {
            case 2: 
            case 3: {
                this.addToMenuPopup(pos, flags, text, id, submenuId, exceptionvalues);
                break;
            }
            case 0: 
            case 4: {
                this.addToMenu(pos, flags, text, id, submenuId, exceptionvalues);
            }
        }
    }

    public void translateToMenuBar() {
        if (this.type == 0) {
            new SwingWorker(true, () -> this.showMenuBar()).start();
        } else if (this.type == 4) {
            this.showMenuHamburger();
        }
    }

    private void addMenuTreeItems(MenuTreeNode parent, FontMetrics fm, int[] constraints) {
        String t;
        if (this.menuIcon != null) {
            if (this.menuIcon.getIconWidth() > constraints[0]) {
                constraints[0] = this.menuIcon.getIconWidth();
            }
            if (this.menuIcon.getIconHeight() > constraints[1]) {
                constraints[1] = this.menuIcon.getIconHeight();
            }
        }
        if (this.menuChecked) {
            constraints[3] = 1;
        }
        if ((t = this.menuText) != null) {
            int sw;
            int idx = t.indexOf("\\t");
            if (idx >= 0) {
                t = idx > 0 && t.charAt(idx - 1) == '\\' ? t.substring(0, idx) + t.substring(idx + 1) : t.substring(0, idx);
            }
            if ((sw = fm.stringWidth(t)) > constraints[2]) {
                constraints[2] = sw;
            }
        }
        for (RemoteMenu rm : this.children) {
            if (rm.type != 0 && rm.type != 4) continue;
            MenuTreeNode node = rm.createMenuTreeNode();
            parent.add(node);
            rm.addMenuTreeItems(node, fm, constraints);
        }
    }

    private void updateConstraints(MenuTreeNode node, FontMetrics fm, int[] constraints) {
        String t;
        RemoteMenu rm = node.rm();
        if (rm.menuIcon != null) {
            if (rm.menuIcon.getIconWidth() > constraints[0]) {
                constraints[0] = rm.menuIcon.getIconWidth();
            }
            if (rm.menuIcon.getIconHeight() > constraints[1]) {
                constraints[1] = rm.menuIcon.getIconHeight();
            }
        }
        if (rm.menuChecked) {
            constraints[3] = 1;
        }
        if ((t = rm.menuText) != null) {
            int sw;
            int idx = t.indexOf("\\t");
            if (idx >= 0) {
                t = idx > 0 && t.charAt(idx - 1) == '\\' ? t.substring(0, idx) + t.substring(idx + 1) : t.substring(0, idx);
            }
            if ((sw = fm.stringWidth(t)) > constraints[2]) {
                constraints[2] = sw;
            }
        }
        int cc = node.getChildCount();
        for (int i = 0; i < cc; ++i) {
            this.updateConstraints((MenuTreeNode)node.getChildAt(i), fm, constraints);
        }
    }

    private MenuTreeNode createMenuTreeNode() {
        this.hamburgerItem = new MenuTreeNode();
        return this.hamburgerItem;
    }

    private void getConstraints(boolean update) {
        JLabel lbl = this.hamburger.treeCellRenderer.label;
        FontMetrics fm = lbl.getFontMetrics(this.hamburger.font);
        int[] constraints = new int[4];
        if (update) {
            this.updateConstraints(this.hamburger.treeRoot, fm, constraints);
        } else {
            this.addMenuTreeItems(this.hamburger.treeRoot, fm, constraints);
        }
        this.hamburger.rowHeight = constraints[1];
        this.hamburger.treeCellRenderer.maxWidth = constraints[0] + constraints[2] + lbl.getIconTextGap() + 2;
        this.hamburger.treeCellRenderer.hasChecked = constraints[3] > 0;
        if (constraints[0] > 0 && constraints[1] > 0) {
            this.hamburger.fakeIcon = new FakeIcon(constraints[0], constraints[1]);
        }
    }

    private void showMenuHamburger() {
        this.isMenuBar = true;
        this.hamburger = new Hamburger(this.gf.getHamburgerMenuAttrs());
        this.hamburger.rm = this;
        this.menuPopup = new PicobolPopupMenu(this.hamburger.webStyle);
        if (this.hamburger.webStyle) {
            this.hamburger.treeRoot = new MenuTreeRoot();
            this.hamburgerItem = this.hamburger.treeRoot;
            this.hamburger.treeCellRenderer = new MenuTreeCellRenderer();
            this.getConstraints(false);
            this.hamburger.treeModel = new FilterableTreeViewModel(this.hamburger.treeRoot);
            this.hamburger.tree = new JTree(this.hamburger.treeModel){
                FlatStyleUI fsui;

                @Override
                public void setUI(TreeUI ui) {
                    if (RemoteMenu.isWindowsLaf() && !((RemoteMenu)RemoteMenu.this).hamburger.showLines) {
                        if (this.fsui == null) {
                            this.fsui = new FlatStyleUI(((RemoteMenu)RemoteMenu.this).hamburger.dropDownOpenIcon, ((RemoteMenu)RemoteMenu.this).hamburger.dropDownIcon);
                        }
                        super.setUI(this.fsui);
                    } else {
                        super.setUI(ui);
                        if (ui instanceof BasicTreeUI) {
                            ((BasicTreeUI)ui).setExpandedIcon(((RemoteMenu)RemoteMenu.this).hamburger.dropDownOpenIcon);
                            ((BasicTreeUI)ui).setCollapsedIcon(((RemoteMenu)RemoteMenu.this).hamburger.dropDownIcon);
                        }
                    }
                }

                @Override
                public void setFont(Font f) {
                    super.setFont(f);
                    FontMetrics fm = this.getFontMetrics(f);
                    this.setRowHeight(Math.max(fm.getHeight(), ((RemoteMenu)RemoteMenu.this).hamburger.rowHeight));
                }
            };
            if (!this.hamburger.showLines) {
                this.hamburger.tree.putClientProperty("JTree.lineStyle", "None");
            }
            this.hamburger.tree.setShowsRootHandles(true);
            this.hamburger.tree.setRootVisible(false);
            this.hamburger.tree.getSelectionModel().setSelectionMode(1);
            this.hamburger.tree.setBackground(this.hamburger.background);
            this.hamburger.tree.setForeground(this.hamburger.foreground);
            this.hamburger.tree.setFont(this.hamburger.getFont());
            this.hamburger.tree.setCellRenderer(this.hamburger.treeCellRenderer);
            this.menuPopup.setLayout(new GridLayout(1, 1, 0, 0));
            this.hamburger.tvp = new TreeViewPanel(this.hamburger.tree, this.gf, true);
            this.hamburger.tvp.setScrollBarPolicies(20, 31);
            if (this.hamburger.searchPanel) {
                this.hamburger.tvp.setSearchPanelVisibility(TreeViewPanel.SearchPanelVisibility.ALWAYS);
                this.hamburger.origSpFont = this.hamburger.tvp.getSearchPanel().getSearchTextFont();
                this.hamburger.tvp.getSearchPanel().addSearchPanelNotifier(new SearchPanel.Notifier(){

                    @Override
                    public void filterTextChanged(String fs) {
                        ((RemoteMenu)RemoteMenu.this).hamburger.treeRoot.setFilterString(fs);
                        ((RemoteMenu)RemoteMenu.this).hamburger.treeModel.reload();
                        if (fs != null && fs.length() > 0) {
                            RemoteMenu.this.hamburger.expandAll(true);
                        }
                    }
                });
            } else {
                this.hamburger.tvp.setSearchPanelVisibility(TreeViewPanel.SearchPanelVisibility.NEVER);
            }
            this.menuPopup.add(this.hamburger.tvp);
        } else {
            if (this.menu instanceof JMenu) {
                JMenu mn = (JMenu)this.menu;
                int n = mn.getItemCount();
                for (int i = 0; i < n; ++i) {
                    JMenuItem it = mn.getItem(0);
                    if (it != null) {
                        this.menuPopup.add(it);
                        continue;
                    }
                    this.menuPopup.add(new JPopupMenu.Separator());
                }
            }
            this.menuPopup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    SwingUtilities.invokeLater(() -> {
                        RemoteMenu.this.hamburger.setIcon(((RemoteMenu)RemoteMenu.this).hamburger.hamburgerIcon);
                        ((RemoteMenu)RemoteMenu.this).hamburger.popupVisible = false;
                    });
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        this.menuBar = new JMenuBar();
        this.menuBar.setComponentOrientation(this.hamburger.right ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT);
        if (this.hamburger.webStyle) {
            JMenu m = new JMenu();
            this.hamburger.menu = m;
        } else {
            this.hamburger.menu = new JLabel();
        }
        this.hamburger.menu.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (((RemoteMenu)RemoteMenu.this).hamburger.popupVisible) {
                    RemoteMenu.this.hamburger.hide();
                } else {
                    int y;
                    BorderedFrame bf = null;
                    if (RemoteMenu.this.parentWindow != null) {
                        bf = ((RemoteDisplayWindow)RemoteMenu.this.parentWindow).getMainWindow();
                    }
                    if (bf != null) {
                        if (((RemoteMenu)RemoteMenu.this).hamburger.toolBarCovering) {
                            y = ((RemoteMenu)RemoteMenu.this).hamburger.menu.getSize().height;
                        } else {
                            int y1 = bf.getPanel().getLocationOnScreen().y;
                            int y2 = ((RemoteMenu)RemoteMenu.this).hamburger.menu.getLocationOnScreen().y;
                            y = y1 - y2;
                        }
                    } else {
                        y = ((RemoteMenu)RemoteMenu.this).hamburger.menu.getSize().height;
                    }
                    if (((RemoteMenu)RemoteMenu.this).hamburger.webStyle) {
                        int height;
                        ((RemoteMenu)RemoteMenu.this).hamburger.treeModel.reload();
                        if (bf != null) {
                            Insets i1 = bf.getWindow().getInsets();
                            Insets i2 = RemoteMenu.this.hamburger.getComponent().getInsets();
                            Insets i3 = RemoteMenu.this.menuPopup.getInsets();
                            if (((RemoteMenu)RemoteMenu.this).hamburger.menuHeight > 0) {
                                height = ((RemoteMenu)RemoteMenu.this).hamburger.menuHeight;
                                if (((RemoteMenu)RemoteMenu.this).hamburger.layoutManager != 0 && ((RemoteMenu)RemoteMenu.this).hamburger.heightDelta > 0.0f) {
                                    height = (int)((float)height * ((RemoteMenu)RemoteMenu.this).hamburger.heightDelta);
                                }
                                height = height - i2.top - i2.bottom - i3.top - i3.bottom;
                            } else {
                                int y1 = bf.getWindow().getLocation().y;
                                int y2 = ((RemoteMenu)RemoteMenu.this).hamburger.menu.getLocationOnScreen().y + y;
                                int h = bf.getWindow().getSize().height;
                                if (!((RemoteMenu)RemoteMenu.this).hamburger.statusBarCovering && bf.getStatusBar() != null) {
                                    h -= bf.getStatusBar().getSize().height;
                                }
                                height = h - y2 + y1 - i1.bottom - i2.top - i2.bottom - i3.top - i3.bottom;
                            }
                            if (((RemoteMenu)RemoteMenu.this).hamburger.layoutManager == 2 && ((RemoteMenu)RemoteMenu.this).hamburger.heightDelta > 0.0f) {
                                RemoteMenu.this.hamburger.adjustFont();
                            }
                        } else {
                            height = 300;
                        }
                        int width = ((RemoteMenu)RemoteMenu.this).hamburger.menuWidth;
                        if (((RemoteMenu)RemoteMenu.this).hamburger.layoutManager != 0 && ((RemoteMenu)RemoteMenu.this).hamburger.widthDelta > 0.0f) {
                            width = (int)((float)width * ((RemoteMenu)RemoteMenu.this).hamburger.widthDelta);
                        }
                        Dimension d = new Dimension(width, height);
                        RemoteMenu.this.hamburger.getComponent().setPreferredSize(d);
                        if (((RemoteMenu)RemoteMenu.this).hamburger.origSize == null) {
                            ((RemoteMenu)RemoteMenu.this).hamburger.origSize = d;
                        }
                    }
                    int x = ((RemoteMenu)RemoteMenu.this).hamburger.right ? -RemoteMenu.this.menuPopup.getPreferredSize().width + ((RemoteMenu)RemoteMenu.this).hamburger.menu.getSize().width : 0;
                    RemoteMenu.this.menuPopup.show(((RemoteMenu)RemoteMenu.this).hamburger.menu, x, y);
                    RemoteMenu.this.hamburger.setIcon(RemoteMenu.this.hamburger.getHamburgerOpenIcon());
                    if (((RemoteMenu)RemoteMenu.this).hamburger.webStyle) {
                        if (((RemoteMenu)RemoteMenu.this).hamburger.expanded) {
                            RemoteMenu.this.hamburger.expandAll(false);
                        } else if (((RemoteMenu)RemoteMenu.this).hamburger.pathToExpand instanceof ArrayList) {
                            ArrayList paths = (ArrayList)((RemoteMenu)RemoteMenu.this).hamburger.pathToExpand;
                            for (TreePath tp : paths) {
                                ((RemoteMenu)RemoteMenu.this).hamburger.tree.expandPath(tp);
                            }
                        }
                        if (((RemoteMenu)RemoteMenu.this).hamburger.searchPanel) {
                            ((RemoteMenu)RemoteMenu.this).hamburger.tvp.getSearchPanel().setFocus();
                        }
                    } else if (((RemoteMenu)RemoteMenu.this).hamburger.pathToExpand instanceof MenuElement[]) {
                        MenuElement[] me = (MenuElement[])((RemoteMenu)RemoteMenu.this).hamburger.pathToExpand;
                        me[0] = RemoteMenu.this.menuPopup;
                        MenuSelectionManager.defaultManager().setSelectedPath(me);
                    }
                    ((RemoteMenu)RemoteMenu.this).hamburger.popupVisible = true;
                }
            }
        });
        MenuSelectionManager.defaultManager().addChangeListener(e -> {
            if (!this.hamburger.keepOpen && MenuSelectionManager.defaultManager().getSelectedPath().length == 0) {
                this.hamburger.hide();
            }
        });
        this.menuBar.add(this.hamburger.menu);
        this.hamburger.setIcon(this.hamburger.hamburgerIcon);
        if (this.hamburger.webStyle) {
            this.hamburger.tree.addTreeExpansionListener(new TreeExpansionListener(){

                void updatePopupSize() {
                    if (((RemoteMenu)RemoteMenu.this).hamburger.layoutManager == 0) {
                        int n = ((RemoteMenu)RemoteMenu.this).hamburger.tree.getRowCount();
                        int maxX = ((RemoteMenu)RemoteMenu.this).hamburger.menuWidth;
                        for (int i = 0; i < n; ++i) {
                            Rectangle r = ((RemoteMenu)RemoteMenu.this).hamburger.tree.getRowBounds(i);
                            maxX = Math.max(maxX, r.x + r.width);
                        }
                        RemoteMenu.this.hamburger.resize(new Dimension(maxX, ((Hamburger)((RemoteMenu)RemoteMenu.this).hamburger).getComponent().getPreferredSize().height));
                    }
                }

                @Override
                public void treeExpanded(TreeExpansionEvent event) {
                    this.updatePopupSize();
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent event) {
                    this.updatePopupSize();
                }
            });
            this.hamburger.tree.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    TreePath path = ((RemoteMenu)RemoteMenu.this).hamburger.tree.getPathForLocation(e.getX(), e.getY());
                    MenuTreeNode newhn = path != null ? (MenuTreeNode)path.getLastPathComponent() : null;
                    if (((RemoteMenu)RemoteMenu.this).hamburger.hoveredItem != newhn) {
                        MenuTreeNode oldhn = ((RemoteMenu)RemoteMenu.this).hamburger.hoveredItem;
                        ((RemoteMenu)RemoteMenu.this).hamburger.hoveredItem = newhn;
                        if (oldhn != null) {
                            ((RemoteMenu)RemoteMenu.this).hamburger.treeModel.nodeChanged(oldhn);
                        }
                        if (((RemoteMenu)RemoteMenu.this).hamburger.hoveredItem != null) {
                            ((RemoteMenu)RemoteMenu.this).hamburger.treeModel.nodeChanged(((RemoteMenu)RemoteMenu.this).hamburger.hoveredItem);
                        }
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (((RemoteMenu)RemoteMenu.this).hamburger.hoveredItem != null) {
                        MenuTreeNode n = ((RemoteMenu)RemoteMenu.this).hamburger.hoveredItem;
                        ((RemoteMenu)RemoteMenu.this).hamburger.hoveredItem = null;
                        ((RemoteMenu)RemoteMenu.this).hamburger.treeModel.nodeChanged(n);
                    }
                }
            });
            this.hamburger.tree.addTreeSelectionListener(e -> {
                MenuTreeNode n;
                TreePath p = this.hamburger.tree.getSelectionPath();
                if (p != null && (n = (MenuTreeNode)p.getLastPathComponent()).getChildCount(false) == 0 && n.rm().menuEnabled) {
                    if (!this.hamburger.keepOpen) {
                        this.hamburger.hide();
                        MenuSelectionManager.defaultManager().clearSelectedPath();
                    }
                    n.rm().responseOnActionMenu(n.rm().menuId);
                }
            });
            this.hamburger.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                    TreePath p = event.getPath();
                    MenuTreeNode n = (MenuTreeNode)p.getLastPathComponent();
                    if (!n.rm().menuEnabled) {
                        throw new ExpandVetoException(event);
                    }
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                }
            });
        }
    }

    private void showMenuBar() {
        LookAndFeel laf;
        this.isMenuBar = true;
        this.menuBar = new PicobolMenuBar(this);
        if (flatLafCls == null || !flatLafCls.isInstance(laf = UIManager.getLookAndFeel()) || !laf.getDefaults().getBoolean("TitlePane.menuBarEmbedded")) {
            this.menuBar.setLayout(new JMenuBarLayout());
        }
        for (RemoteMenu child : this.children) {
            if (child.type != 0) continue;
            if (child.children.size() == 0) {
                JMenuItem jmi = child.menu;
                PicobolMenu newmenu = new PicobolMenu(child);
                child.menu = newmenu;
                newmenu.setEnabled(jmi.isEnabled());
                newmenu.setText(jmi.getText());
                newmenu.setIcon(jmi.getIcon());
                if (this.getNavigateSwingDefault()) {
                    newmenu.setMnemonic(jmi.getMnemonic());
                } else {
                    newmenu.setDisplayedMnemonicIndex(jmi.getDisplayedMnemonicIndex());
                }
                child.addListeners();
            } else if (this.getNavigateSwingDefault()) {
                child.removeListeners();
                child.addCDMListeners();
            }
            this.menuBar.add(child.menu);
        }
    }

    boolean getNavigateSwingDefault() {
        return this.navigateswingdefault;
    }

    boolean getAltDownPressed() {
        return this.altdownpressed;
    }

    void setAltDownPressed(boolean b) {
        this.altdownpressed = b;
    }

    private void removeListeners() {
        if (this.menumouselistener != null) {
            this.menu.removeMouseListener(this.menumouselistener);
        }
        if (this.menukeylistener != null) {
            this.menu.removeMenuKeyListener(this.menukeylistener);
        }
        this.menumouselistener = null;
        this.menukeylistener = null;
        if (this.menuCDMmouselistener != null) {
            this.menu.removeMouseListener(this.menuCDMmouselistener);
        }
        if (this.menuCDMkeylistener != null) {
            this.menu.removeMenuKeyListener(this.menuCDMkeylistener);
        }
        this.menuCDMmouselistener = null;
        this.menuCDMkeylistener = null;
    }

    private void addListeners() {
        this.menumouselistener = new MyMenuMouseListener();
        this.menu.addMouseListener(this.menumouselistener);
        this.menukeylistener = new MyMenuKeyListener();
        this.menu.addMenuKeyListener(this.menukeylistener);
    }

    private void addCDMListeners() {
        this.menuCDMmouselistener = new MyCDMMenuMouseListener();
        this.menu.addMouseListener(this.menuCDMmouselistener);
        this.menuCDMkeylistener = new MyCDMMenuKeyListener();
        this.menu.addMenuKeyListener(this.menuCDMkeylistener);
    }

    private void addToMenuPopup(int pos, int flags, String text, int id, int submenuId, String exceptionvalues) {
        pos = this.getMenuPosition(pos);
        RemoteMenu submenu = null;
        if (flags != 256) {
            submenu = (RemoteMenu)this.gf.getClient().getId(submenuId);
            if (submenu == null) {
                submenu = new RemoteMenu(this.gf, 0, this, this.getNewMenu(text, flags, null));
                submenu.menuChecked = ((PicobolMenuItem)submenu.menu).isChecked();
                submenu.setExceptionValues(exceptionvalues);
            } else {
                submenu.menu = this.getNewMenu(text, flags, submenu.menu);
            }
            submenu.menuId = id;
            submenu.parent = this;
            this.menuPopup.insert((JMenuItem)submenu.getComponent(), pos);
        } else {
            submenu = new RemoteMenu(this.gf, 1, this, null);
            submenu.separatorId = id;
            submenu.parent = this;
            this.menuPopup.insert(new JPopupMenu.Separator(), pos);
        }
        if (pos >= this.getItemCount()) {
            this.children.addElement(submenu);
        } else {
            this.children.add(pos, submenu);
        }
        submenu.setParentWindow(this.parentWindowId, this.parentWindow);
    }

    private void addToMenu(int pos, int flags, String text, int id, int submenuId, String exceptionvalues) {
        pos = this.getMenuPosition(pos);
        RemoteMenu submenu = null;
        if (flags != 256) {
            submenu = (RemoteMenu)this.gf.getClient().getId(submenuId);
            if (submenu == null) {
                submenu = new RemoteMenu(this.gf, 0, this, this.getNewMenu(text, flags, null));
                submenu.setExceptionValues(exceptionvalues);
            } else {
                submenu.menu = this.getNewMenu(text, flags, submenu.menu);
            }
            submenu.menuId = id;
            submenu.parent = this;
            submenu.menuText = text;
            submenu.menuChecked = (flags & 1) == 1;
            boolean bl = submenu.menuEnabled = (flags >> 4 & 1) != 1;
            if (this.isMenuBar && this.hamburger == null && this.hamburgerItem == null && submenu.getComponent() instanceof JMenu) {
                this.insertInMenuBar((JMenu)submenu.getComponent(), pos);
            } else {
                this.removeListeners();
                if (this.menuPopup != null) {
                    this.menuPopup.insert((JMenuItem)submenu.getComponent(), pos);
                } else {
                    ((JMenu)this.menu).insert((JMenuItem)submenu.getComponent(), pos);
                    if (this.hamburgerItem != null) {
                        this.hamburgerItem.insert(submenu.createMenuTreeNode(), pos);
                        DefaultTreeModel model = this.getHamburgerTreeModel();
                        if (model != null) {
                            model.nodesWereInserted(this.hamburgerItem, new int[]{pos});
                        }
                    }
                }
            }
        } else {
            submenu = new RemoteMenu(this.gf, 1, this, null);
            submenu.separatorId = id;
            submenu.parent = this;
            if (this.menuPopup != null) {
                this.menuPopup.insert(new JPopupMenu.Separator(), pos);
            } else {
                ((JMenu)this.menu).insertSeparator(pos);
            }
        }
        if (pos >= this.getItemCount()) {
            this.children.addElement(submenu);
        } else {
            this.children.add(pos, submenu);
        }
        submenu.setParentWindow(this.parentWindowId, this.parentWindow);
    }

    private void insertInMenuBar(JMenu m, int pos) {
        int n = this.menuBar.getMenuCount();
        if (pos >= n) {
            this.menuBar.add(m);
        } else {
            int i;
            JMenu[] tmp = new JMenu[n - pos];
            for (i = 0; i < tmp.length; ++i) {
                tmp[i] = this.menuBar.getMenu(pos);
                this.menuBar.remove(pos);
            }
            this.menuBar.add(m);
            for (i = 0; i < tmp.length; ++i) {
                this.menuBar.add(tmp[i]);
            }
        }
    }

    private int getMenuPosition(int id) {
        if (id == 0) {
            return this.children.size();
        }
        int Return2 = 0;
        for (RemoteMenu rm : this.children) {
            if (rm.menuId == id || rm.separatorId == id) break;
            ++Return2;
        }
        return Return2;
    }

    private JMenuItem getNewMenu(String text, int flags, JMenuItem submenu) {
        JMenuItem newMenu;
        if (submenu != null) {
            newMenu = submenu;
            newMenu.setText(text);
        } else {
            newMenu = new PicobolMenuItem();
            if ((flags & 1) == 1) {
                ((PicobolMenuItem)newMenu).setChecked(true);
            }
        }
        StringBuffer sb = new StringBuffer(text);
        int c = ScreenUtility.getMnemonicChar(sb);
        text = sb.toString();
        int i = text.indexOf("\\t");
        String rText = null;
        if (i >= 0) {
            if (i > 0 && text.charAt(i - 1) == '\\') {
                text = text.substring(0, i) + text.substring(i + 1);
            } else if (i < text.length() - 2) {
                rText = text.substring(i + 2);
                text = text.substring(0, i);
            } else {
                text = text.substring(0, i);
            }
        }
        if (rText != null) {
            if (newMenu instanceof PicobolMenuItem) {
                ((PicobolMenuItem)newMenu).setText(text, rText);
            } else if (newMenu instanceof PicobolMenu) {
                ((PicobolMenu)newMenu).setText(text, rText);
            }
        } else {
            newMenu.setText(text);
        }
        if ((flags >> 4 & 1) == 1) {
            newMenu.setEnabled(false);
        }
        if (c >= 0) {
            this.setMnemonic(newMenu, (char)c);
        }
        return newMenu;
    }

    private void setMnemonic(JMenuItem item, char c) {
        if (this.getNavigateSwingDefault()) {
            item.setMnemonic(c);
        } else {
            int index = item.getText().indexOf(c);
            if (index >= 0) {
                item.setDisplayedMnemonicIndex(index);
            }
        }
    }

    private int getItemCount() {
        return this.children.size();
    }

    private void removeMenuTreeNode(MenuTreeNode parent, MenuTreeNode child, int idx) {
        Hamburger h;
        parent.remove(idx);
        DefaultTreeModel model = this.getHamburgerTreeModel();
        if (model != null) {
            model.nodesWereRemoved(parent, new int[]{idx}, new Object[]{child});
        }
        if ((h = this.getHamburger()) != null && h.hoveredItem == child) {
            h.hoveredItem = null;
        }
    }

    private void removeMenu(int idx) {
        this.children.removeElementAt(idx);
        switch (this.type) {
            case 0: 
            case 4: {
                if (this.menuPopup != null) {
                    this.menuPopup.remove(idx);
                    break;
                }
                if (!this.isMenuBar) {
                    this.menu.remove(idx);
                }
                if (this.hamburgerItem == null) break;
                MenuTreeNode child = (MenuTreeNode)this.hamburgerItem.getChildAt(idx);
                this.removeMenuTreeNode(this.hamburgerItem, child, idx);
                break;
            }
            case 2: 
            case 3: {
                this.menuPopup.remove(idx);
            }
        }
    }

    private void removeMenu(RemoteMenu rm) {
        this.children.remove(rm);
        switch (this.type) {
            case 0: 
            case 4: {
                int idx;
                if (this.menuPopup != null) {
                    this.menuPopup.remove(rm.menu);
                    break;
                }
                if (!this.isMenuBar) {
                    this.menu.remove(rm.menu);
                }
                if (this.hamburgerItem == null || rm.hamburgerItem == null || (idx = this.hamburgerItem.getIndex(rm.hamburgerItem)) < 0) break;
                this.removeMenuTreeNode(this.hamburgerItem, rm.hamburgerItem, idx);
                break;
            }
            case 2: 
            case 3: {
                if (rm.menu == null) break;
                this.menuPopup.remove(rm.menu);
            }
        }
    }

    protected JMenuBar getMenuBar() {
        return this.menuBar;
    }

    private Component getComponent() {
        switch (this.type) {
            case 0: 
            case 4: {
                if (this.isMenuBar) {
                    return this.menuBar;
                }
                return this.menu;
            }
            case 2: 
            case 3: {
                return this.menuPopup;
            }
        }
        return null;
    }

    public void handleResponse(int eventAction, int eventId) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
        if (rra.getEventType() == 16398 && eventAction != 4 && this.invoker != null) {
            Component c = this.invoker instanceof RemoteDisplayWindow ? ((RemoteDisplayWindow)this.invoker).getMainWindow().getPanel() : (this.invoker instanceof RemoteDisplayToolBar ? (Component)((Object)((RemoteDisplayToolBar)this.invoker).getMainPanel()) : (Component)((Object)((RemoteBaseGUIControl)this.invoker).getComponent()));
            this.showPopup(c, this.xCoordinate, this.yCoordinate);
            this.menuPopup.repaint();
        }
    }

    @Override
    public Events getEvents() {
        return null;
    }

    @Override
    public boolean isInitialized() {
        return this.menu != null || this.menuBar != null || this.menuPopup != null;
    }

    private RemoteMenu findMenu(int id) {
        if (this.menuId == id) {
            return this;
        }
        for (RemoteMenu rm : this.children) {
            if ((rm = rm.findMenu(id)) == null) continue;
            return rm;
        }
        return null;
    }

    private RemoteMenu findSeparator(int id) {
        if (this.separatorId == id) {
            return this;
        }
        for (RemoteMenu rm : this.children) {
            if ((rm = rm.findSeparator(id)) == null) continue;
            return rm;
        }
        return null;
    }

    public void release() {
        if (this.isMenuBar && this.hamburger == null) {
            MenuElement[] me = this.menuBar.getSubElements();
            for (int i = 0; i < me.length; ++i) {
                ((PicobolMenu)me[i]).setReleased(true);
            }
        }
    }

    private void showPopup(Component parent, int x, int y) {
        KeyboardBuffer.setBufferOff();
        this.addMenuChangeListener();
        this.menuPopup.show(parent, x, y);
    }

    public void showPopup(Component parent) {
        if (this.menuPopup != null) {
            this.menuPopup.show(parent, 10, 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPopup(int x, int y) {
        if (this.type != 2 || this.parentWindow == null || ((RemoteDisplayWindow)this.parentWindow).getMainWindow() == null) {
            return;
        }
        if (x < 0) {
            x = KeyboardBuffer.getLastCursorX();
        }
        if (y < 0) {
            y = KeyboardBuffer.getLastCursorY();
        }
        BorderedFrame mw = ((RemoteDisplayWindow)this.parentWindow).getMainWindow();
        BaseRemoteObject invokerSave = this.invoker;
        this.setInvoker(null);
        Container window = mw.getWindow();
        Container contentPane = mw.getContentPane();
        Point windowLoc = window.getLocationOnScreen();
        Point contentPaneLoc = contentPane.getLocationOnScreen();
        this.showPopup(contentPane, x - 1 - contentPaneLoc.x + windowLoc.x, y - 1 - contentPaneLoc.y + windowLoc.y);
        this.menuPopup.repaint();
        if (mw.isActiveAccept() && IscobolSystem.get(RemoteJavaBean.ProcedureVar.class) == null) {
            RemoteMenu remoteMenu = this;
            synchronized (remoteMenu) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.setInvoker(invokerSave);
    }

    static void fireActionEvent(MenuElement elem) {
        PicobolMenuItem item;
        if (elem instanceof PicobolMenuItem && (item = (PicobolMenuItem)elem).isEnabled()) {
            item.fireActionPerformed(new ActionEvent(item, 1001, ""));
            MenuSelectionManager.defaultManager().setSelectedPath(null);
        }
    }

    void firePopupMenuEvents(BaseRemoteObject invoker, int x, int y) {
        this.setInvoker(invoker);
        this.xCoordinate = x;
        this.yCoordinate = y;
        if (invoker != null) {
            RemoteRecordAccept rra = new RemoteRecordAccept(3, 0, 16398, false, false, true);
            if (invoker instanceof RemoteBaseGUIControl) {
                ((RemoteBaseGUIControl)invoker).pushEvent(this.getCEC(invoker, rra), 16398);
            } else if (this.parentWindow != null && ((RemoteDisplayWindow)this.parentWindow).getMainWindow() != null) {
                ((RemoteDisplayWindow)this.parentWindow).getMainWindow().push(this.getCEC(invoker, rra));
            }
        } else if (this.parentWindow != null && ((RemoteDisplayWindow)this.parentWindow).getMainWindow() != null) {
            this.showPopup(((RemoteDisplayWindow)this.parentWindow).getMainWindow().getPanel(), x, y);
        }
    }

    private void removeListeners(JMenuItem mi) {
        ActionListener[] als = mi.getActionListeners();
        for (int i = 0; i < als.length; ++i) {
            mi.removeActionListener(als[i]);
        }
    }

    private Image getBrokenImage(Component c) {
        if (this.gf.getBrokenImage() == null) {
            if (c != null) {
                this.gf.setBrokenImage(c.getToolkit().getImage(this.getClass().getResource("broken.png")));
            } else {
                this.gf.setBrokenImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("broken.png")));
            }
        }
        return this.gf.getBrokenImage();
    }

    private Image getLocalImage(int imageId, Component c) {
        Image Return2 = null;
        LocalImage lim = null;
        try {
            lim = (LocalImage)this.gf.getClient().getId(imageId);
        }
        catch (ClassCastException cce) {
            lim = null;
        }
        if (lim != null) {
            Return2 = lim.getImage();
        } else if (imageId > 0) {
            Return2 = this.getBrokenImage(c);
        }
        return Return2;
    }

    public void setBitmap(int id, int imageId, int bitmapNumber, int bitmapWidth) {
        RemoteMenu rm = this.findMenu(id);
        if (rm == null) {
            return;
        }
        switch (rm.type) {
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                this.setIcon(imageId, bitmapNumber, bitmapWidth, rm);
            }
        }
    }

    private void setIcon(int imageId, int bitmapNumber, int bitmapWidth, RemoteMenu menu) {
        Image strip;
        ImageIcon icon = null;
        Image image = this.getLocalImage(imageId, menu.menu);
        if (image != null && (strip = ScreenUtility.getImage(bitmapWidth, -1, image, bitmapNumber)) != null) {
            icon = new ImageIcon(strip);
        }
        menu.menuIcon = icon;
        menu.menu.setIcon(icon);
        if (menu.hamburgerItem != null) {
            DefaultTreeModel model;
            if (this.getHamburger() != null) {
                this.getConstraints(true);
            }
            if ((model = menu.getHamburgerTreeModel()) != null) {
                model.nodeChanged(menu.hamburgerItem);
            }
        }
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra, boolean foo) {
    }

    public void ensureVisible(int elemid) {
        if (elemid > 0) {
            RemoteMenu menuToEnsureVisible = this.findMenu(elemid);
            if (menuToEnsureVisible == null || menuToEnsureVisible.parent == null) {
                return;
            }
            menuToEnsureVisible.parent.open();
        } else {
            this.open();
        }
    }

    private void open() {
        Hamburger h;
        Vector elems = new Vector();
        this.loadMenuElements(elems);
        if (elems.isEmpty()) {
            return;
        }
        if (elems.elementAt(0) instanceof MenuElement) {
            MenuElement[] me = new MenuElement[elems.size()];
            elems.toArray(me);
            Hamburger h2 = this.getHamburger();
            if (h2 != null && !h2.webStyle && me.length > 1) {
                h2.pathToExpand = me;
            } else {
                new SwingWorker(true, () -> {
                    try {
                        MenuSelectionManager.defaultManager().setSelectedPath(me);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }).start();
            }
        } else if (elems.elementAt(0) instanceof MenuTreeNode && (h = this.getHamburger()) != null) {
            Object[] me = new MenuTreeNode[elems.size()];
            elems.toArray(me);
            if (h.webStyle) {
                ArrayList<TreePath> paths;
                if (h.popupVisible) {
                    new SwingWorker(true, () -> RemoteMenu.lambda$open$4(h, (MenuTreeNode[])me)).start();
                }
                if (h.pathToExpand instanceof ArrayList) {
                    paths = (ArrayList<TreePath>)h.pathToExpand;
                } else {
                    h.pathToExpand = paths = new ArrayList<TreePath>();
                }
                paths.add(new TreePath(me));
            }
        }
    }

    private void loadMenuElements(Vector elems) {
        if (this.parent != null) {
            this.parent.loadMenuElements(elems);
        }
        switch (this.type) {
            case 0: 
            case 4: {
                if (this.hamburgerItem != null) {
                    elems.addElement(this.hamburgerItem);
                    break;
                }
                if (this.isMenuBar) {
                    elems.addElement(this.menuBar);
                    break;
                }
                if (this.menu != null && this.menu instanceof JMenu) {
                    elems.addElement(((JMenu)this.menu).getPopupMenu());
                }
                elems.addElement(this.menu);
                break;
            }
            case 2: 
            case 3: {
                elems.add(this.menuPopup);
            }
        }
    }

    void addMenuChangeListener() {
        if (!this.getNavigateSwingDefault()) {
            this.removeMenuChangeListener();
            this.menuChangeListener = new MenuChangeListener();
            MenuSelectionManager.defaultManager().addChangeListener(this.menuChangeListener);
        } else {
            this.menuCDMChangeListener = new MenuCDMChangeListener();
            MenuSelectionManager.defaultManager().addChangeListener(this.menuCDMChangeListener);
        }
    }

    void removeMenuChangeListener() {
        if (this.menuChangeListener != null) {
            MenuSelectionManager.defaultManager().removeChangeListener(this.menuChangeListener);
            this.menuChangeListener.clearMnemonics();
            this.menuChangeListener = null;
        }
        if (this.menuCDMChangeListener != null) {
            MenuSelectionManager.defaultManager().removeChangeListener(this.menuCDMChangeListener);
            this.menuCDMChangeListener = null;
        }
    }

    public void setScrollIndexes(int scrollitems, int fixedtopitems, int fixedbottomitems, int scrollinterval) {
        if (this.menuPopup != null) {
            this.ms = MenuScroller.setScrollerFor(this.menuPopup, scrollitems, scrollinterval, fixedtopitems, fixedbottomitems);
        }
        if (this.menu != null && ((JMenu)this.menu).getPopupMenu() != null) {
            this.ms = MenuScroller.setScrollerFor(((JMenu)this.menu).getPopupMenu(), scrollitems, scrollinterval, fixedtopitems, fixedbottomitems);
        }
    }

    public void setExceptionValues(String exceptionvaluestr) {
        block7: {
            if (exceptionvaluestr == null || exceptionvaluestr.length() <= 0) break block7;
            int numtok = 0;
            String strtmp = null;
            StringTokenizer st = new StringTokenizer(exceptionvaluestr, ";");
            numtok = st.countTokens();
            if (numtok > 0) {
                this.exceptionvalues = new int[numtok];
                for (int i = 0; i < numtok; ++i) {
                    strtmp = st.nextToken().trim();
                    if (strtmp == null || strtmp == null) continue;
                    try {
                        this.exceptionvalues[i] = Integer.parseInt(strtmp);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            } else {
                this.exceptionvalues = new int[1];
                try {
                    this.exceptionvalues[0] = Integer.parseInt(exceptionvaluestr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    Vector getChildren() {
        return this.children;
    }

    private static boolean isWindowsLaf() {
        return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName());
    }

    private void setMouseEntered(boolean b) {
        RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
        if (rdw != null) {
            rdw.setMenuEntered(b);
        }
    }

    private boolean getMouseEntered() {
        RemoteDisplayWindow rdw = (RemoteDisplayWindow)this.parentWindow;
        if (rdw != null) {
            return rdw.getMenuEntered();
        }
        return false;
    }

    static boolean isMenuAltKey(char c, MenuElement[] path, JMenuBar jmb) {
        boolean Return2 = false;
        int i = 0;
        boolean j = false;
        if (c >= '\u0000' && jmb != null && path != null && path.length == 0) {
            Character keyevt = new Character(Character.toUpperCase(c));
            Character keymnt = new Character((char)jmb.getMenu(i).getMnemonic());
            JMenu jmi = null;
            for (i = 0; !Return2 && i < jmb.getMenuCount(); ++i) {
                jmi = jmb.getMenu(i);
                if (jmi == null || jmi.getMnemonic() < 0 || !jmi.isVisible() || !jmi.isEnabled()) continue;
                keymnt = new Character((char)jmb.getMenu(i).getMnemonic());
                Return2 = keyevt.equals(keymnt);
            }
        }
        return Return2;
    }

    private static /* synthetic */ void lambda$open$4(Hamburger h, MenuTreeNode[] me) {
        h.tree.expandPath(new TreePath(me));
    }

    static {
        Class<?> c;
        try {
            c = Class.forName("com.formdev.flatlaf.FlatLaf");
        }
        catch (Throwable t) {
            c = null;
        }
        flatLafCls = c;
    }

    private class MenuTreeCellRenderer
    extends JComponent
    implements TreeCellRenderer {
        private JLabel label;
        private JLabel rightLabel;
        private boolean rightLabelAdded;
        private int maxWidth;
        private boolean hasChecked;

        MenuTreeCellRenderer() {
            this.setLayout(new BorderLayout());
            this.label = new JLabel();
            this.add((Component)this.label, "Center");
            this.rightLabel = new JLabel();
            this.rightLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.rightLabel.setHorizontalAlignment(2);
            this.rightLabel.setHorizontalTextPosition(4);
        }

        private void setLabelText(String text) {
            this.label.setText(text);
            Dimension d = this.label.getPreferredSize();
            if (d.width < this.maxWidth) {
                d.width = this.maxWidth;
                this.label.setPreferredSize(d);
            }
        }

        private void setText(String text, boolean checked) {
            this.setLabelText(text);
            this.rightLabel.setText(null);
            if (checked) {
                if (!this.rightLabelAdded) {
                    this.add((Component)this.rightLabel, "East");
                    this.rightLabelAdded = true;
                }
                this.rightLabel.setIcon(((RemoteMenu)RemoteMenu.this).hamburger.checkIcon);
            } else if (this.rightLabelAdded) {
                this.remove(this.rightLabel);
                this.rightLabelAdded = false;
            }
        }

        private void setText(String text, String rText, boolean checked) {
            this.setLabelText(text);
            if (!this.rightLabelAdded) {
                this.add((Component)this.rightLabel, "East");
                this.rightLabelAdded = true;
            }
            if (checked) {
                this.rightLabel.setIcon(((RemoteMenu)RemoteMenu.this).hamburger.checkIcon);
            } else if (this.hasChecked) {
                this.rightLabel.setIcon(new FakeIcon(((RemoteMenu)RemoteMenu.this).hamburger.checkIcon));
            } else {
                this.rightLabel.setIcon(null);
            }
            this.rightLabel.setText(rText);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            MenuTreeNode n = (MenuTreeNode)value;
            if (n instanceof MenuTreeRoot) {
                return this;
            }
            int childCount = n.getChildCount(false);
            String text = n.toString();
            boolean checked = n.rm().menuChecked;
            int idx = text.indexOf("\\t");
            if (idx >= 0) {
                if (idx > 0 && text.charAt(idx - 1) == '\\') {
                    this.setText(text.substring(0, idx) + text.substring(idx + 1), checked);
                } else if (idx < text.length() - 2) {
                    this.setText(text.substring(0, idx), text.substring(idx + 2), checked);
                } else {
                    this.setText(text.substring(0, idx), checked);
                }
            } else {
                this.setText(text, checked);
            }
            this.label.setOpaque(true);
            this.rightLabel.setOpaque(true);
            if (sel && n.rm().menuEnabled && childCount == 0) {
                this.label.setEnabled(true);
                this.label.setForeground(((RemoteMenu)RemoteMenu.this).hamburger.selectionForeground);
                this.label.setBackground(((RemoteMenu)RemoteMenu.this).hamburger.selectionBackground);
                this.label.setFont(RemoteMenu.this.hamburger.getFont());
                this.rightLabel.setEnabled(true);
                this.rightLabel.setForeground(((RemoteMenu)RemoteMenu.this).hamburger.selectionForeground);
                this.rightLabel.setBackground(((RemoteMenu)RemoteMenu.this).hamburger.selectionBackground);
                this.rightLabel.setFont(RemoteMenu.this.hamburger.getFont());
            } else if (n == ((RemoteMenu)RemoteMenu.this).hamburger.hoveredItem && n.rm().menuEnabled && childCount == 0) {
                this.label.setEnabled(true);
                this.label.setForeground(((RemoteMenu)RemoteMenu.this).hamburger.hoverForeground);
                this.label.setBackground(((RemoteMenu)RemoteMenu.this).hamburger.hoverBackground);
                this.label.setFont(RemoteMenu.this.hamburger.getHoverFont());
                this.rightLabel.setEnabled(true);
                this.rightLabel.setForeground(((RemoteMenu)RemoteMenu.this).hamburger.hoverForeground);
                this.rightLabel.setBackground(((RemoteMenu)RemoteMenu.this).hamburger.hoverBackground);
                this.rightLabel.setFont(RemoteMenu.this.hamburger.getHoverFont());
            } else if (!n.rm().menuEnabled) {
                this.label.setEnabled(false);
                this.label.setForeground(((RemoteMenu)RemoteMenu.this).hamburger.disabledForeground);
                this.label.setBackground(RemoteMenu.this.hamburger.getDisabledBackground());
                this.label.setFont(RemoteMenu.this.hamburger.getDisabledFont());
                this.rightLabel.setEnabled(false);
                this.rightLabel.setForeground(((RemoteMenu)RemoteMenu.this).hamburger.disabledForeground);
                this.rightLabel.setBackground(RemoteMenu.this.hamburger.getDisabledBackground());
                this.rightLabel.setFont(RemoteMenu.this.hamburger.getDisabledFont());
            } else {
                this.label.setEnabled(true);
                this.label.setForeground(((RemoteMenu)RemoteMenu.this).hamburger.foreground);
                this.label.setBackground(((RemoteMenu)RemoteMenu.this).hamburger.background);
                this.label.setFont(RemoteMenu.this.hamburger.getFont());
                this.rightLabel.setEnabled(true);
                this.rightLabel.setForeground(((RemoteMenu)RemoteMenu.this).hamburger.foreground);
                this.rightLabel.setBackground(((RemoteMenu)RemoteMenu.this).hamburger.background);
                this.rightLabel.setFont(RemoteMenu.this.hamburger.getFont());
            }
            if (n.rm().menuIcon != null) {
                this.label.setIcon(n.rm().menuIcon);
            } else {
                MenuTreeNode p = (MenuTreeNode)n.getParent();
                if (p != null && p.iconCount > 0) {
                    this.label.setIcon(((RemoteMenu)RemoteMenu.this).hamburger.fakeIcon);
                } else {
                    this.label.setIcon(null);
                }
            }
            this.doLayout();
            return this;
        }
    }

    private static class FakeIcon
    implements Icon {
        private final int iconWidth;
        private final int iconHeight;

        FakeIcon(int w, int h) {
            this.iconWidth = w;
            this.iconHeight = h;
        }

        FakeIcon(Icon model) {
            this.iconWidth = model.getIconWidth();
            this.iconHeight = model.getIconHeight();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return this.iconWidth;
        }

        @Override
        public int getIconHeight() {
            return this.iconHeight;
        }
    }

    private static class Hamburger
    extends HamburgerMenuAttrs {
        boolean popupVisible;
        JTree tree;
        TreeViewPanel tvp;
        Font origSpFont;
        FakeIcon fakeIcon;
        int rowHeight;
        MenuTreeCellRenderer treeCellRenderer;
        MenuTreeRoot treeRoot;
        MenuTreeNode hoveredItem;
        FilterableTreeViewModel treeModel;
        JComponent menu;
        RemoteMenu rm;
        Object pathToExpand;
        Dimension origWndSize;
        Dimension origSize;
        float widthDelta;
        float heightDelta;

        Hamburger(HamburgerMenuAttrs attrs) {
            this.hamburgerOpenIcon = attrs.hamburgerOpenIcon;
            this.hamburgerIcon = attrs.hamburgerIcon;
            this.checkIcon = attrs.checkIcon;
            this.dropDownOpenIcon = attrs.dropDownOpenIcon;
            this.dropDownIcon = attrs.dropDownIcon;
            this.menuWidth = attrs.menuWidth;
            this.selectionBackground = attrs.selectionBackground;
            this.selectionForeground = attrs.selectionForeground;
            this.background = attrs.background;
            this.foreground = attrs.foreground;
            this.disabledBackground = attrs.disabledBackground;
            this.disabledForeground = attrs.disabledForeground;
            this.hoverBackground = attrs.hoverBackground;
            this.hoverForeground = attrs.hoverForeground;
            this.disabledFont = attrs.disabledFont;
            this.hoverFont = attrs.hoverFont;
            this.font = attrs.font;
            this.right = attrs.right;
            this.webStyle = attrs.webStyle;
            this.toolBarCovering = attrs.toolBarCovering;
            this.searchPanel = attrs.searchPanel;
            this.menuHeight = attrs.menuHeight;
            this.statusBarCovering = attrs.statusBarCovering;
            this.showLines = attrs.showLines;
            this.expanded = attrs.expanded;
            this.keepOpen = attrs.keepOpen;
            this.layoutManager = attrs.layoutManager;
        }

        @Override
        protected Font getDisabledFont() {
            Font f;
            Font font = f = this.disabledFont != null ? this.disabledFont : this.font;
            if (this.layoutManager == 2 && this.heightDelta > 0.0f) {
                f = f.deriveFont(f.getSize2D() * this.heightDelta);
            }
            return f;
        }

        @Override
        protected Font getHoverFont() {
            Font f;
            Font font = f = this.hoverFont != null ? this.hoverFont : this.font;
            if (this.layoutManager == 2 && this.heightDelta > 0.0f) {
                f = f.deriveFont(f.getSize2D() * this.heightDelta);
            }
            return f;
        }

        @Override
        protected Font getFont() {
            Font f = this.font;
            if (this.layoutManager == 2 && this.heightDelta > 0.0f) {
                f = f.deriveFont(f.getSize2D() * this.heightDelta);
            }
            return f;
        }

        private JComponent getComponent() {
            return this.tvp;
        }

        void expandAll(boolean reqFocus) {
            this.expandAll(this.treeRoot);
            if (reqFocus) {
                this.tvp.getSearchPanel().setFocus();
            }
        }

        void expandAll(MenuTreeNode n) {
            int count = n.getChildCount();
            for (int i = 0; i < count; ++i) {
                MenuTreeNode child = (MenuTreeNode)n.getChildAt(i);
                TreePath path = new TreePath(child.getPath());
                if (this.tree.isExpanded(path)) continue;
                this.tree.expandPath(path);
                this.expandAll(child);
            }
        }

        void setIcon(Icon i) {
            if (this.webStyle) {
                ((JMenu)this.menu).setIcon(i);
            } else {
                ((JLabel)this.menu).setIcon(i);
            }
        }

        void hide() {
            if (this.webStyle) {
                this.rm.menuPopup.closeHamburger();
            } else {
                this.rm.menuPopup.setVisible(false);
            }
            this.setIcon(this.hamburgerIcon);
            this.tvp.getSearchPanel().resetSearchText();
            this.popupVisible = false;
        }

        void configureLayoutManager(final RemoteBaseGUIWindow parentWindow) {
            if (parentWindow instanceof RemoteDisplayWindow && this.layoutManager != 0) {
                final Container window = ((RemoteDisplayWindow)parentWindow).getMainWindow().getWindow();
                this.origWndSize = window.getSize();
                window.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        int height;
                        Dimension currSize = window.getSize();
                        widthDelta = (float)currSize.width / (float)origWndSize.width;
                        heightDelta = (float)currSize.height / (float)origWndSize.height;
                        this.adjustFont();
                        if (origSize == null || !menu.isDisplayable()) {
                            return;
                        }
                        if (menuHeight > 0 || parentWindow == null) {
                            height = Math.round(heightDelta * (float)origSize.height);
                        } else {
                            int y;
                            BorderedFrame bf = ((RemoteDisplayWindow)parentWindow).getMainWindow();
                            if (toolBarCovering) {
                                y = menu.getSize().height;
                            } else {
                                int y1 = bf.getPanel().getLocationOnScreen().y;
                                int y2 = menu.getLocationOnScreen().y;
                                y = y1 - y2;
                            }
                            Insets i1 = bf.getWindow().getInsets();
                            Insets i2 = this.getComponent().getInsets();
                            Insets i3 = rm.menuPopup.getInsets();
                            int y1 = bf.getWindow().getLocation().y;
                            int y2 = menu.getLocationOnScreen().y + y;
                            int h = bf.getWindow().getSize().height;
                            if (!statusBarCovering && bf.getStatusBar() != null) {
                                h -= bf.getStatusBar().getSize().height;
                            }
                            height = h - y2 + y1 - i1.bottom - i2.top - i2.bottom - i3.top - i3.bottom;
                        }
                        this.resize(new Dimension(Math.round(widthDelta * (float)origSize.width), height));
                    }
                });
            }
        }

        void adjustFont() {
            if (this.layoutManager == 2) {
                this.tree.setFont(this.getFont());
                if (this.searchPanel) {
                    this.tvp.getSearchPanel().setSearchTextFont(this.origSpFont.deriveFont(this.origSpFont.getSize2D() * this.heightDelta));
                }
            }
        }

        void resize(Dimension d) {
            this.getComponent().setPreferredSize(d);
            this.rm.menuPopup.invalidate();
            this.rm.menuPopup.pack();
        }
    }

    private class MenuTreeRoot
    extends MenuTreeNode
    implements Filterable {
        String filterString;

        MenuTreeRoot() {
            this.root = this;
        }

        @Override
        public String getFilterString() {
            return this.filterString;
        }

        @Override
        public void setFilterString(String filterString) {
            this.filterString = filterString;
        }
    }

    private class MenuTreeNode
    extends FilterableTreeViewNode {
        int iconCount;

        MenuTreeNode() {
        }

        public String toString() {
            String t = RemoteMenu.this.menuText;
            if (t == null) {
                return "";
            }
            int idx = t.indexOf(38);
            if (idx >= 0) {
                t = new StringBuffer(t).deleteCharAt(idx).toString();
            }
            return t;
        }

        @Override
        public void add(FilterableTreeViewNode newChild) {
            super.add(newChild);
            MenuTreeNode n = (MenuTreeNode)newChild;
            if (n.rm().menuIcon != null) {
                ++this.iconCount;
            }
        }

        @Override
        public void insert(FilterableTreeViewNode newChild, int childIndex) {
            super.insert(newChild, childIndex);
            MenuTreeNode n = (MenuTreeNode)newChild;
            if (n.rm().menuIcon != null) {
                ++this.iconCount;
            }
        }

        public void remove(int childIndex) {
            if (childIndex >= 0 && childIndex < this.getChildCount()) {
                MenuTreeNode n = (MenuTreeNode)this.getChildAt(childIndex);
                this.remove(n);
            }
        }

        @Override
        public void remove(FilterableTreeViewNode aChild) {
            MenuTreeNode n = (MenuTreeNode)aChild;
            if (n.rm().menuIcon != null) {
                --this.iconCount;
            }
            super.remove(aChild);
        }

        @Override
        public void removeAllChildren() {
            super.removeAllChildren();
            this.iconCount = 0;
        }

        RemoteMenu rm() {
            return RemoteMenu.this;
        }

        @Override
        protected boolean accept(FilterableTreeViewNode ftvn, String fs, boolean cs) {
            MenuTreeNode n = (MenuTreeNode)ftvn;
            String t = n.rm().menuText;
            return t != null && t.toLowerCase().indexOf(fs) >= 0;
        }
    }

    private class EndPopupMenuListener
    implements PopupMenuListener {
        private EndPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            KeyboardBuffer.setBufferOn();
            if (RemoteMenu.this.invoker != null) {
                RemoteRecordAccept rra = new RemoteRecordAccept(3, 0, 16399, false, false, true);
                if (RemoteMenu.this.invoker instanceof RemoteBaseGUIControl) {
                    ((RemoteBaseGUIControl)RemoteMenu.this.invoker).pushEvent(RemoteMenu.this.getCEC(RemoteMenu.this.invoker, rra), 16399);
                } else if (RemoteMenu.this.parentWindow != null && ((RemoteDisplayWindow)RemoteMenu.this.parentWindow).getMainWindow() != null) {
                    ((RemoteDisplayWindow)RemoteMenu.this.parentWindow).getMainWindow().push(RemoteMenu.this.getCEC(RemoteMenu.this.invoker, rra));
                }
            } else {
                RemoteMenu remoteMenu = RemoteMenu.this;
                synchronized (remoteMenu) {
                    RemoteMenu.this.notify();
                }
            }
            RemoteMenu.this.removeMenuChangeListener();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            if (RemoteMenu.this.parentWindow != null) {
                if (RemoteMenu.this.parentWindow.isAcceptOmitted()) {
                    SwingUtilities.invokeLater(() -> RemoteMenu.this.parentWindow.requestFocus());
                } else {
                    CobolFocusable fo = RemoteMenu.this.parentWindow.getFocusOwner();
                    if (fo instanceof RemoteTerminalAccept) {
                        SwingUtilities.invokeLater(() -> {
                            RemoteTerminalAccept rta = (RemoteTerminalAccept)fo;
                            TerminalAccept ta = (TerminalAccept)rta.getComponent();
                            ta.requestFocus();
                            ta.focusGained(null);
                        });
                    }
                }
            }
        }
    }

    private class MyCDMMenuKeyListener
    implements MenuKeyListener {
        private MyCDMMenuKeyListener() {
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent e) {
            RemoteDisplayWindow rdw = (RemoteDisplayWindow)RemoteMenu.this.parentWindow;
            if (e.getKeyCode() == 37 || e.getKeyCode() == 39 || e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                RemoteMenu.this.setMouseEntered(rdw.hasSelPathMenu());
            } else {
                RemoteMenu.this.setMouseEntered(false);
            }
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent e) {
        }

        @Override
        public void menuKeyTyped(MenuKeyEvent e) {
            RemoteMenu.this.setMouseEntered(true);
        }
    }

    private class MyCDMMenuMouseListener
    extends MouseAdapter {
        private MyCDMMenuMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            RemoteMenu.this.setMouseEntered(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
            if (me.length == 0) {
                RemoteMenu.this.setMouseEntered(false);
            }
        }
    }

    private class MyMenuKeyListener
    implements MenuKeyListener {
        private MyMenuKeyListener() {
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent e) {
            JMenu menu;
            MenuElement[] path = e.getPath();
            if (path.length == 2 && path[1] instanceof JMenu && (menu = (JMenu)path[1]).isSelected() && menu.getItemCount() == 0 && e.getKeyCode() == 10) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                RemoteMenu.this.responseOnAction();
            }
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent e) {
        }

        @Override
        public void menuKeyTyped(MenuKeyEvent e) {
        }
    }

    private class MyMenuMouseListener
    extends MouseAdapter {
        private MyMenuMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (((JComponent)e.getSource()).isEnabled()) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                RemoteMenu.this.responseOnAction();
            }
        }
    }

    private class MyMenuActionListener
    implements ActionListener {
        private MyMenuActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RemoteMenu.this.responseOnAction();
        }
    }

    private class MenuCDMChangeListener
    implements ChangeListener {
        private MenuCDMChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            if (!RemoteMenu.this.getMouseEntered()) {
                MenuSelectionManager msm = (MenuSelectionManager)evt.getSource();
                MenuElement[] path = msm.getSelectedPath();
                AbstractButton jmifirst = null;
                MenuElement metmp = null;
                int i = 0;
                int j = 0;
                j = path.length;
                for (i = 0; jmifirst == null && i < j; ++i) {
                    metmp = path[i];
                    if (!(metmp instanceof JMenuItem)) continue;
                    jmifirst = (JMenuItem)metmp;
                }
                if (jmifirst != null && jmifirst.getMnemonic() >= 0 && RemoteMenu.this.parentWindow != null && ((RemoteDisplayWindow)RemoteMenu.this.parentWindow).checkMnemonicMenuWithNewLocalFocusOwner(jmifirst.getMnemonic())) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
            }
        }
    }

    private class MenuChangeListener
    implements ChangeListener {
        ArrayList enabledMenus = new ArrayList();
        boolean initialState;

        MenuChangeListener() {
            this.setInitialState();
        }

        void setInitialState() {
            if (!this.initialState) {
                this.clearMnemonics();
                if (RemoteMenu.this.isMenuBar) {
                    this.setMnemonics(RemoteMenu.this.menuBar);
                } else {
                    this.setMnemonics(RemoteMenu.this.menuPopup);
                }
                this.initialState = true;
            }
        }

        void setMnemonics(JMenuBar menubar) {
            for (int i = 0; i < menubar.getMenuCount(); ++i) {
                this.setMnemonic(menubar.getMenu(i));
            }
            this.initialState = false;
        }

        void setMnemonics(JPopupMenu popup) {
            for (int i = 0; i < popup.getComponentCount(); ++i) {
                if (!(popup.getComponent(i) instanceof AbstractButton)) continue;
                this.setMnemonic((AbstractButton)popup.getComponent(i));
            }
            this.initialState = false;
        }

        void setMnemonic(AbstractButton menu) {
            int index = menu.getDisplayedMnemonicIndex();
            String text = menu.getText();
            if (index >= 0 && text != null && index < text.length()) {
                menu.setMnemonic(text.charAt(index));
            }
            this.enabledMenus.add(menu);
        }

        void clearMnemonics() {
            for (int i = 0; i < this.enabledMenus.size(); ++i) {
                AbstractButton menu = (AbstractButton)this.enabledMenus.get(i);
                int displayedIndex = menu.getDisplayedMnemonicIndex();
                menu.setMnemonic(-1);
                menu.setDisplayedMnemonicIndex(displayedIndex);
            }
            this.enabledMenus.clear();
            this.initialState = false;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
            if (me.length > 0) {
                JComponent menu = RemoteMenu.this.isMenuBar ? RemoteMenu.this.menuBar : RemoteMenu.this.menuPopup;
                if (MenuSelectionManager.defaultManager().isComponentPartOfCurrentMenu(menu)) {
                    MenuElement lastElement = me[me.length - 1];
                    if (lastElement instanceof JMenuItem) {
                        lastElement = me[me.length - 2];
                    }
                    if (lastElement instanceof JPopupMenu) {
                        if (me.length == 3 && me[0] instanceof JMenuBar && me[1] instanceof PicobolMenu && ((PicobolMenu)me[1]).getItemCount() == 0) {
                            RemoteMenu rm = ((PicobolMenu)me[1]).getParentMenu();
                            if (RemoteMenu.this.altdownpressed) {
                                rm.responseOnActionMenu(rm.menuId);
                                MenuSelectionManager.defaultManager().clearSelectedPath();
                                this.setInitialState();
                            }
                        } else {
                            this.clearMnemonics();
                            this.setMnemonics((JPopupMenu)lastElement);
                        }
                    } else if (lastElement instanceof JMenuBar) {
                        this.clearMnemonics();
                        this.setMnemonics((JMenuBar)lastElement);
                    }
                } else {
                    this.setInitialState();
                }
            } else {
                this.setInitialState();
            }
        }
    }

    private class JMenuBarLayout
    extends FlowLayout
    implements ComponentListener {
        private static final long serialVersionUID = 1L;

        public JMenuBarLayout() {
            super(0, 4, 2);
            RemoteMenu.this.menuBar.addComponentListener(this);
        }

        @Override
        public Dimension preferredLayoutSize(Container target) {
            Insets insets = target.getInsets();
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            int nmembers = target.getComponentCount();
            int xPos = 0;
            int maxHeight = 0;
            Dimension dim = new Dimension(0, 0);
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                if (xPos + d.width > RemoteMenu.this.maxWidth && xPos != 0) {
                    xPos = 0;
                    dim.height += maxHeight + vgap;
                    maxHeight = 0;
                }
                dim.width = Math.max(dim.width, xPos += d.width);
                xPos += hgap;
                maxHeight = Math.max(maxHeight, d.height);
            }
            dim.height += maxHeight + vgap;
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }

        @Override
        public Dimension minimumLayoutSize(Container target) {
            return this.preferredLayoutSize(target);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Rectangle r;
            RemoteDisplayWindow rdw = (RemoteDisplayWindow)RemoteMenu.this.parentWindow;
            if (rdw != null && (r = rdw.getMainBounds()) != null) {
                RemoteMenu.this.maxWidth = r.width;
            }
        }
    }
}

