/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class SplitPane
extends JSplitPane {
    private final MyPanel[] area = new MyPanel[2];
    private final GradientManager grMgr;
    private double dividerLocation;
    private int lastW = -1;

    public SplitPane(GradientManager grMgr) {
        super(1);
        this.area[0] = new MyPanel();
        this.setLeftComponent(this.area[0]);
        this.area[1] = new MyPanel();
        this.setRightComponent(this.area[1]);
        this.grMgr = grMgr;
    }

    @Override
    protected void paintComponent(Graphics g) {
        boolean b = this.grMgr.isPaintGradient();
        this.area[0].mySetOpaque(!b);
        this.area[1].mySetOpaque(!b);
        if (b) {
            Graphics2D g2d = (Graphics2D)g;
            this.grMgr.paint(g2d, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        }
        super.paintChildren(g);
    }

    public void setTransparent(boolean tr) {
        this.setOpaque(!tr);
    }

    public JPanel getPanel(int index) {
        if (index < 1) {
            index = 1;
        } else if (index > 2) {
            index = 2;
        }
        return this.area[index - 1].thePanel;
    }

    public void add(RemoteBaseGUIControl rbgc, int splitGroupValue, Hashtable childGraphics) {
        int i;
        JPanel panel = this.getPanel(splitGroupValue);
        Component c = (Component)((Object)rbgc.getComponent());
        RemoteBaseGUIControl crbgc = null;
        Component[] controls = panel.getComponents();
        for (i = 0; i < controls.length; ++i) {
            if (controls[i] == rbgc.getComponent()) {
                return;
            }
            crbgc = (RemoteBaseGUIControl)childGraphics.get(controls[i]);
            if (RemoteDisplayWindow.shouldInsertBefore(rbgc, crbgc)) break;
        }
        panel.add(c, i);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (this.getOrientation() == 1) {
            if (this.dividerLocation >= 0.0 && this.lastW != w) {
                this.setDividerLocation(this.dividerLocation);
            }
            this.lastW = w;
        } else {
            if (this.dividerLocation >= 0.0 && this.lastW != h) {
                this.setDividerLocation(this.dividerLocation);
            }
            this.lastW = h;
        }
    }

    @Override
    public void setDividerLocation(double proportionalLocation) {
        this.dividerLocation = proportionalLocation;
        super.setDividerLocation(proportionalLocation);
    }

    @Override
    public void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        if (this.area != null) {
            for (Component c : this.getComponents()) {
                c.addKeyListener(l);
            }
        }
    }

    @Override
    public void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        if (this.area != null) {
            for (Component c : this.getComponents()) {
                c.removeKeyListener(l);
            }
        }
    }

    @Override
    public void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        if (this.area != null) {
            for (Component c : this.getComponents()) {
                c.addMouseListener(l);
            }
        }
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        if (this.area != null) {
            for (Component c : this.getComponents()) {
                c.removeMouseListener(l);
            }
        }
    }

    private static class MyPanel
    extends JScrollPane {
        private JPanel thePanel = new JPanel(null){

            @Override
            public Dimension getPreferredSize() {
                int w = 0;
                int h = 0;
                for (Component c : this.getComponents()) {
                    Rectangle bds = c.getBounds();
                    int tmp = bds.x + bds.width;
                    if (tmp > w) {
                        w = tmp;
                    }
                    if ((tmp = bds.y + bds.height) <= h) continue;
                    h = tmp;
                }
                return new Dimension(w, h);
            }
        };

        MyPanel() {
            super(20, 30);
            this.getViewport().setView(this.thePanel);
            this.setBorder(null);
        }

        void mySetOpaque(boolean b) {
            if (this.isOpaque() != b) {
                this.setOpaque(b);
                this.thePanel.setOpaque(b);
                this.getViewport().setOpaque(b);
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }
    }
}

