/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.DockablePanel;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JDialog;
import javax.swing.WindowConstants;

public class UndockedDialog
extends JDialog
implements WindowConstants {
    private DockablePanel dockPanel;
    private String port;
    private Dimension paneSize;
    private boolean firstTime = true;

    public UndockedDialog(DockablePanel dp, Point p) {
        super(dp.getRootWindow());
        this.dockPanel = dp;
        this.setRootPane(dp.getRootPane());
        this.paneSize = dp.getRootPane().getSize();
        this.setTitle(this.dockPanel.getTitle());
        this.setDefaultCloseOperation(0);
        ScreenUtility.disableFocusTraversalKeys(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UndockedDialog.this.dockPanel.add(UndockedDialog.this.getRootPane());
                UndockedDialog.this.dockPanel.dock();
                UndockedDialog.this.dockPanel.setVisible(true);
                UndockedDialog.this.dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                UndockedDialog.this.dockPanel.setFocused(true);
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
        if (p != null) {
            this.setLocation(p.x, p.y);
        }
        this.setVisible(true);
    }

    @Override
    public void doLayout() {
        if (this.firstTime) {
            Insets ins = this.getInsets();
            this.setSize(ins.left + ins.right + this.paneSize.width, ins.top + ins.bottom + this.paneSize.height);
            this.firstTime = false;
        }
        super.doLayout();
    }
}

