/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlexporter.ss;

import com.iscobol.htmlexporter.HTMLParser;
import com.iscobol.htmlexporter.RptBorder;
import com.iscobol.htmlexporter.RptComponent;
import com.iscobol.htmlexporter.RptExporter;
import com.iscobol.htmlexporter.RptFont;
import com.iscobol.htmlexporter.RptStyle;
import com.iscobol.htmlrenderer.CheckBoxImage;
import com.iscobol.htmlrenderer.HTMLRenderer;
import com.iscobol.htmlrenderer.RadioButtonImage;
import com.iscobol.htmlrenderer.UncheckBoxImage;
import com.iscobol.htmlrenderer.UnradioButtonImage;
import com.iscobol.misc.export.UnitConverter;
import com.iscobol.misc.export.ss.SSExportHelper;
import com.iscobol.rts.Config;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public abstract class SSExporter
implements RptExporter {
    private static final String PROP_PREFIX = "iscobol.export.";
    private static final int MAX_ROW_BREAKS_PER_SHEET = 1024;
    private static final byte EMPTY = 0;
    private static final byte OCCUPIED_BY_COMPONENT = 1;
    private static final byte COLLAPSABLE = 2;
    private static final byte OCCUPIED_BY_BOX = 3;
    private static final int NONE = 0;
    private static final int COLLAPSE_BOX = 1;
    private static final int COLLAPSE_ALL = 2;
    private final Map<String, Integer> IMAGES = new HashMap<String, Integer>();
    private final Map<String, CellStyle> CELL_STYLES = new TreeMap<String, CellStyle>();
    private double topMargin;
    private double leftMargin;
    private double rightMargin;
    private double bottomMargin;
    private String paperSize;
    private boolean landscape;
    private List<Integer> columnOffsets = new ArrayList<Integer>();
    private Map<String, RptSection> sections = new LinkedHashMap<String, RptSection>();
    private Map<String, RptStyle> allStyles = new LinkedHashMap<String, RptStyle>();
    protected int pageCount;
    private HTMLParser hr;
    private String inputFile;
    protected String outputFile;
    private String reportName;
    protected CreationHelper creationHelper;
    protected List<Drawing> patriarchs = new ArrayList<Drawing>();
    private CellStyle defaultCellStyle;
    protected int currentRowIndex;
    protected Properties properties = new Properties();
    protected boolean cellWrap;
    protected boolean cellLock;
    protected boolean detectCellType;
    protected boolean ignoreCellBackground;
    protected boolean ignoreCellBorder;
    protected boolean ignoreImages;
    protected boolean collapseRowSpan;
    protected int removeRowsSpace;
    protected int removeColumnsSpace;
    protected boolean whitePageBackground;
    protected boolean freezePageHeader;
    protected boolean addPageBreaks;
    protected String cellNumericFormat;
    private boolean pageHeaderFound;
    private RptSection lastSection;
    private RptSection lastPageHeaderSection;
    private int currTopOffset;
    private StringBuilder visibleComponents;
    protected SSExportHelper exportHelper;
    protected List<Integer> sheetLastRowIndexes = new ArrayList<Integer>();

    public SSExporter(String reportName, String inputFile, String outFile) {
        this.reportName = reportName;
        this.inputFile = inputFile;
        this.outputFile = outFile;
    }

    @Override
    public double getTopMargin() {
        return this.topMargin;
    }

    @Override
    public double getLeftMargin() {
        return this.leftMargin;
    }

    @Override
    public double getBottomMargin() {
        return 0.0;
    }

    @Override
    public double getRightMargin() {
        return 0.0;
    }

    @Override
    public boolean isLandscape() {
        return false;
    }

    @Override
    public String getPaperSize() {
        return this.paperSize;
    }

    public int getSheetLineCount() {
        int lineCount = 0;
        Workbook workbook = this.exportHelper.getWorkbook();
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            lineCount += workbook.getSheetAt(i).getLastRowNum() + 1;
        }
        return lineCount;
    }

    public int getSheetColumnCount() {
        int ret = this.columnOffsets.size();
        if (ret > 0 && this.columnOffsets.get(0) == 0) {
            --ret;
        }
        return ret;
    }

    public int getSheetImageCount() {
        return this.IMAGES.size();
    }

    public int getSheetFontCount() {
        return this.exportHelper.getFontCount();
    }

    public int getSheetCellStyleCount() {
        return this.CELL_STYLES.size();
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public int getSheetColorCount() {
        return this.exportHelper.getSheetColorCount();
    }

    protected void log() {
        System.out.println("image count = " + this.getSheetImageCount() + ", font count = " + this.getSheetFontCount() + ", color count = " + this.getSheetColorCount() + ", cell style count = " + this.getSheetCellStyleCount() + ", column count = " + this.getSheetColumnCount() + ", line count = " + this.getSheetLineCount());
    }

    protected long log(String msg, long time) {
        long ret = System.currentTimeMillis();
        System.out.println(msg + " time = " + (ret - time));
        return ret;
    }

    protected abstract SSExportHelper createExportHelper();

    private void initializeReport() {
        this.currentRowIndex = 0;
        this.pageHeaderFound = false;
        this.lastSection = null;
        this.cellWrap = this.getExportProperty("excel.cell_wrap_text", true);
        this.cellLock = this.getExportProperty("excel.cell_locked", true);
        this.detectCellType = this.getExportProperty("excel.detect_cell_type", true);
        this.cellNumericFormat = this.getExportProperty("excel.cell_numeric_format", null);
        this.ignoreCellBackground = this.getExportProperty("excel.cell_ignore_background", false);
        this.ignoreCellBorder = this.getExportProperty("excel.cell_ignore_border", false);
        this.ignoreImages = this.getExportProperty("excel.ignore_images", false);
        this.collapseRowSpan = this.getExportProperty("excel.collapse_row_span", false);
        this.removeRowsSpace = this.getExportProperty("excel.remove_rows_space", 0);
        this.removeRowsSpace = Math.min(1, this.removeRowsSpace);
        this.removeColumnsSpace = this.getExportProperty("excel.remove_columns_space", 0);
        this.whitePageBackground = this.getExportProperty("excel.whitepage_background", true);
        this.freezePageHeader = this.getExportProperty("excel.freeze_page_header", false);
        this.addPageBreaks = this.getExportProperty("excel.force_page_breaks", true);
        this.exportHelper = this.createExportHelper();
        this.creationHelper = this.exportHelper.getWorkbook().getCreationHelper();
        this.defaultCellStyle = this.exportHelper.getWorkbook().createCellStyle();
        TreeSet<Integer> colOffs = new TreeSet<Integer>();
        for (RptSection section : this.sections.values()) {
            TreeSet<Integer> linOffs = new TreeSet<Integer>();
            this.initTables(section.styles.values(), colOffs, linOffs, false);
            section.lineOffsets = new ArrayList<Integer>(linOffs);
        }
        this.columnOffsets = new ArrayList<Integer>(colOffs);
        int colCount = this.columnOffsets.size();
        if (this.columnOffsets.size() > 0 && this.columnOffsets.get(0) == 0) {
            --colCount;
        }
        for (RptSection section : this.sections.values()) {
            int rowCount = section.lineOffsets.size();
            if (section.lineOffsets.size() > 0 && section.lineOffsets.get(0) == 0) {
                --rowCount;
            }
            section.occupiedCells = new byte[rowCount][colCount];
            if (!this.collapseRowSpan && this.removeRowsSpace == 0 && this.removeColumnsSpace == 0 && !this.whitePageBackground) continue;
            for (RptStyle style : section.styles.values()) {
                this.draw(null, true, style, section, this.columnOffsets, null);
            }
        }
        if (this.removeColumnsSpace != 0) {
            this.removeUnusedColumns(colCount);
        }
        this.createSheet(this.reportName);
    }

    protected Sheet createSheet(String reportName) {
        Sheet sheet = this.exportHelper.createSheet(reportName);
        if (this.sheetLastRowIndexes.size() == 0) {
            this.sheetLastRowIndexes.add(new Integer(this.exportHelper.getMaxRowsPerSheet() - 1));
        } else {
            this.sheetLastRowIndexes.add(new Integer(this.sheetLastRowIndexes.get(this.sheetLastRowIndexes.size() - 1) + this.exportHelper.getMaxRowsPerSheet()));
        }
        PrintSetup printSetup = sheet.getPrintSetup();
        this.setPaperSize(printSetup);
        printSetup.setLandscape(this.landscape);
        sheet.setMargin((short)1, this.rightMargin);
        sheet.setMargin((short)0, this.leftMargin);
        sheet.setMargin((short)2, this.topMargin);
        sheet.setMargin((short)3, this.bottomMargin);
        printSetup.setScale((short)75);
        Drawing patriarch = sheet.createDrawingPatriarch();
        this.patriarchs.add(patriarch);
        int columnIndex = 0;
        int prevOffset = 0;
        int columnCount = this.columnOffsets.size();
        for (int i = 0; i < columnCount; ++i) {
            int offset = this.columnOffsets.get(i);
            if (offset > prevOffset) {
                sheet.setColumnWidth(columnIndex, UnitConverter.pixel2ExcelWidthUnits(offset - prevOffset));
                ++columnIndex;
            }
            prevOffset = offset;
        }
        return sheet;
    }

    private void initSection(RptSection section, int topOffset) {
        section.topOffset = topOffset;
        section.pageIndex = this.pageCount;
        section.rowOffset = this.currentRowIndex;
        section.components = new ArrayList<RptComponent>();
    }

    @Override
    public void export() throws IOException {
        this.hr = new HTMLParser();
        InputStream in = HTMLRenderer.getInputStream(this.inputFile);
        this.hr.parseStream(in, this);
        if (this.lastSection != null) {
            this.drawSection(this.lastSection);
        }
        this.exportHelper.write(this.outputFile);
    }

    protected void setPaperSize(PrintSetup printSetup) {
        String psName = this.getPaperSize();
        int psValue = psName == null ? 0 : (psName.equals("Letter") ? 1 : (psName.equals("Letter small") ? 2 : (psName.equals("Tabloid") ? 3 : (psName.equals("Ledger") ? 4 : (psName.equals("Legal") ? 5 : (psName.equals("Statement") ? 6 : (psName.equals("Executive") ? 7 : (psName.equals("A3") ? 8 : (psName.equals("A4") ? 9 : (psName.equals("A4 small") ? 10 : (psName.equals("A5") ? 11 : (psName.equals("B4") ? 12 : (psName.equals("B5") ? 13 : (psName.equals("Folio") ? 14 : (psName.equals("Quarto") ? 15 : (psName.equals("10x14") ? 16 : (psName.equals("11x17") ? 17 : (psName.equals("Note") ? 18 : (psName.equals("Envelope #9") ? 19 : (psName.equals("Envelope #10") ? 20 : (psName.equals("Envelope C3") ? 29 : (psName.equals("Envelope C4") ? 30 : (psName.equals("Envelope C5") ? 28 : (psName.equals("Envelope C6") ? 31 : (psName.equals("Envelope C65") ? 28 : (psName.equals("Envelope Dl") ? 27 : (psName.equals("Envelope Monarch") ? 37 : 0)))))))))))))))))))))))))));
        printSetup.setPaperSize((short)psValue);
    }

    @Override
    public void dispose() {
        this.IMAGES.clear();
        this.CELL_STYLES.clear();
        this.sections.clear();
        this.topMargin = 0.0;
        this.leftMargin = 0.0;
        this.columnOffsets = new ArrayList<Integer>();
        this.hr = null;
        this.exportHelper.dispose();
        this.exportHelper = null;
        this.patriarchs.clear();
        this.defaultCellStyle = null;
        this.creationHelper = null;
        this.sheetLastRowIndexes = new ArrayList<Integer>();
        this.lastSection = null;
        this.lastPageHeaderSection = null;
    }

    private void setWhitePageBackground(RptSection section) {
        if (this.whitePageBackground) {
            for (int rIdx = 0; rIdx < section.occupiedCells.length; ++rIdx) {
                for (int cIdx = 0; cIdx < section.occupiedCells[rIdx].length; ++cIdx) {
                    if (section.occupiedCells[rIdx][cIdx] != 0) continue;
                    this.setBorderedCellStyle(rIdx + section.rowOffset, cIdx, false, false, false, false, 0, null, Color.white);
                }
            }
        }
    }

    private void adjustRowsHeights(RptSection section, TreeMap<Integer, Integer> collapsedRows) {
        for (Integer rIdx : collapsedRows.keySet()) {
            int offset = section.lineOffsets.get(rIdx);
            int origRowHeight = section.lineOffsets.get(rIdx + 1) - offset;
            int newRowHeight = collapsedRows.get(rIdx);
            int inc = newRowHeight - origRowHeight;
            for (RptStyle cmp : section.currStyles.values()) {
                if (cmp.y < offset) {
                    if (cmp.y + cmp.height <= offset) continue;
                    cmp.height += inc;
                    continue;
                }
                if (cmp.y == offset) {
                    cmp.height = newRowHeight;
                    continue;
                }
                cmp.y += inc;
            }
            for (int i = rIdx + 1; i < section.lineOffsets.size(); ++i) {
                section.lineOffsets.set(i, new Integer(section.lineOffsets.get(i) + inc));
            }
        }
    }

    private void removeUnusedColumns(int columnCount) {
        byte[] empty = new byte[columnCount];
        int emptyCount = 0;
        for (int c = 0; c < columnCount; ++c) {
            for (RptSection section : this.sections.values()) {
                block12: for (int r = 0; r < section.occupiedCells.length && empty[c] != 1; ++r) {
                    switch (section.occupiedCells[r][c]) {
                        case 0: {
                            continue block12;
                        }
                        case 2: {
                            if (empty[c] != 0) continue block12;
                            empty[c] = 2;
                            continue block12;
                        }
                        case 1: {
                            empty[c] = 1;
                        }
                    }
                }
            }
            if (empty[c] == 1) continue;
            ++emptyCount;
        }
        if (emptyCount > 0) {
            HashMap<RptSection, byte[][]> tmpMap = new HashMap<RptSection, byte[][]>();
            for (RptSection section : this.sections.values()) {
                tmpMap.put(section, section.occupiedCells);
                section.occupiedCells = new byte[section.occupiedCells.length][columnCount - emptyCount];
            }
            if (this.columnOffsets.get(0) == 0) {
                this.columnOffsets.remove(0);
            }
            int removed = 0;
            int prevOffs = 0;
            int removedX = 0;
            boolean add0Offs = false;
            for (int c = 0; c < columnCount; ++c) {
                int cIdx = c - removed;
                int offs = this.columnOffsets.get(cIdx);
                this.columnOffsets.set(cIdx, offs - removedX);
                switch (empty[c]) {
                    case 0: {
                        this.columnOffsets.remove(cIdx);
                        for (RptSection section : this.sections.values()) {
                            for (RptStyle cmp : section.styles.values()) {
                                if (cmp.x + removedX >= offs) {
                                    cmp.x -= offs - prevOffs;
                                }
                                if (cmp.x == 0) {
                                    add0Offs = true;
                                }
                                RptStyleInfo info = (RptStyleInfo)cmp.customData;
                                if (!info.isFrameOrLine || info.excelRC == null || c < info.excelRC.x || c > info.excelRC.width) continue;
                                cmp.width -= offs - prevOffs;
                            }
                        }
                        ++removed;
                        removedX += offs - prevOffs;
                        break;
                    }
                    case 2: {
                        this.columnOffsets.remove(cIdx);
                        for (RptSection section : this.sections.values()) {
                            for (RptStyle cmp : section.styles.values()) {
                                if (cmp.x + removedX == offs) {
                                    if (cmp.width > 0) {
                                        if (cIdx > 0) {
                                            int oldX = cmp.x;
                                            cmp.x = this.columnOffsets.get(cIdx - 1);
                                            cmp.width += oldX - cmp.x;
                                        }
                                    } else if (cIdx < this.columnOffsets.size()) {
                                        cmp.x = this.columnOffsets.get(cIdx) - removedX;
                                    }
                                }
                                if (cmp.x != 0) continue;
                                add0Offs = true;
                            }
                        }
                        ++removed;
                        break;
                    }
                    case 1: {
                        for (RptSection section : this.sections.values()) {
                            byte[][] tmp = (byte[][])tmpMap.get(section);
                            for (int r = 0; r < tmp.length; ++r) {
                                section.occupiedCells[r][cIdx] = tmp[r][c];
                            }
                        }
                        break;
                    }
                }
                prevOffs = offs;
            }
            if (add0Offs) {
                this.columnOffsets.add(0, 0);
            }
        }
    }

    private void removeUnusedRows(RptSection section) {
        byte[] empty = new byte[section.occupiedCells.length];
        int emptyCount = 0;
        for (int r = 0; r < section.occupiedCells.length; ++r) {
            block10: for (int c = 0; c < section.occupiedCells[r].length && empty[r] != 1; ++c) {
                switch (section.occupiedCells[r][c]) {
                    case 0: {
                        continue block10;
                    }
                    case 1: 
                    case 2: {
                        empty[r] = 1;
                    }
                }
            }
            if (empty[r] != 0) continue;
            ++emptyCount;
        }
        if (emptyCount > 0) {
            if (section.lineOffsets.get(0) == 0) {
                section.lineOffsets.remove(0);
            }
            byte[][] tmp = section.occupiedCells;
            int columnCount = tmp[0].length;
            section.occupiedCells = new byte[tmp.length - emptyCount][columnCount];
            int removed = 0;
            int prevOffs = 0;
            int removedY = 0;
            boolean add0Offs = false;
            int offsSize = section.lineOffsets.size();
            for (int r = 0; r < offsSize; ++r) {
                int rIdx = r - removed;
                int offs = section.lineOffsets.get(rIdx);
                section.lineOffsets.set(rIdx, offs - removedY);
                switch (empty[r]) {
                    case 0: {
                        section.lineOffsets.remove(rIdx);
                        for (RptStyle cmp : section.currStyles.values()) {
                            if (cmp.y + removedY >= offs) {
                                cmp.y -= offs - prevOffs;
                            }
                            if (cmp.y == 0) {
                                add0Offs = true;
                            }
                            RptStyleInfo info = (RptStyleInfo)cmp.customData;
                            if (!info.isFrameOrLine || info.excelRC == null || r < info.excelRC.y || r > info.excelRC.height) continue;
                            cmp.height -= offs - prevOffs;
                        }
                        ++removed;
                        removedY += offs - prevOffs;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 1: {
                        for (int c = 0; c < columnCount; ++c) {
                            section.occupiedCells[rIdx][c] = tmp[r][c];
                        }
                        break;
                    }
                }
                prevOffs = offs;
            }
            if (add0Offs) {
                section.lineOffsets.add(0, 0);
            }
        }
    }

    private boolean addMergedRegion(int firstRow, int lastRow, int firstCol, int lastCol) {
        int sIdx2;
        int sIdx1 = this.getSheetIndex(firstRow);
        if (sIdx1 < (sIdx2 = this.getSheetIndex(lastRow)) && firstRow == (lastRow = this.sheetLastRowIndexes.get(sIdx1).intValue()) && firstCol == lastCol) {
            return false;
        }
        this.exportHelper.addMergedRegion(this.getSheet(firstRow), this.getSheetRelativeRowIndex(firstRow, sIdx1), this.getSheetRelativeRowIndex(lastRow, sIdx1), firstCol, lastCol);
        return true;
    }

    private void initTables(Collection<RptStyle> styles, TreeSet<Integer> columnOffsets, TreeSet<Integer> lineOffsets, boolean adjustBounds) {
        for (RptStyle cmp : styles) {
            if (columnOffsets != null) {
                columnOffsets.add(cmp.x);
                columnOffsets.add(cmp.x + cmp.width);
            }
            if (lineOffsets == null) continue;
            RptStyleInfo info = (RptStyleInfo)cmp.customData;
            if (adjustBounds && info != null) {
                if (info.discarded) continue;
                if (!info.isFrame) {
                    cmp.x += info.adjustBounds.x;
                    cmp.y += info.adjustBounds.y;
                    cmp.width += info.adjustBounds.width;
                    cmp.height += info.adjustBounds.height;
                    if (!(cmp.width > 0 && cmp.height > 0 || cmp.isLineComponent())) {
                        info.discarded = true;
                        continue;
                    }
                }
            }
            lineOffsets.add(cmp.y);
            lineOffsets.add(cmp.y + cmp.height);
        }
    }

    private void checkComponentIntersections(RptStyle[] cmps) {
        for (int idx1 = 0; idx1 < cmps.length; ++idx1) {
            RptStyle cmp1 = cmps[idx1];
            RptStyleInfo ci1 = (RptStyleInfo)cmp1.customData;
            if (ci1.isFrameOrLine) continue;
            Rectangle r1 = new Rectangle(cmp1.x, cmp1.y, cmp1.width, cmp1.height);
            for (int idx2 = idx1 + 1; idx2 < cmps.length; ++idx2) {
                Rectangle r2;
                RptStyle cmp2 = cmps[idx2];
                RptStyleInfo ci2 = (RptStyleInfo)cmp2.customData;
                if (ci2.isFrameOrLine || r1.intersection(r2 = new Rectangle(cmp2.x, cmp2.y, cmp2.width, cmp2.height)).isEmpty()) continue;
                Rectangle adjustBounds = new Rectangle();
                if (r1.x <= r2.x) {
                    if (r1.x + r1.width - r2.x - r2.width > r2.x + r2.width - r1.x) {
                        adjustBounds.x = adjustBounds.width = r2.x + r2.width - r1.x;
                    } else {
                        adjustBounds.width = r1.x + r1.width - r2.x;
                    }
                } else {
                    adjustBounds.x = adjustBounds.width = r2.x + r2.width - r1.x;
                }
                if (r1.y <= r2.y) {
                    if (r1.y + r1.height - r2.y - r2.height > r2.y + r2.height - r1.y) {
                        adjustBounds.y = adjustBounds.height = r2.y + r2.height - r1.y;
                    } else {
                        adjustBounds.height = r1.y + r1.height - r2.y;
                    }
                } else {
                    adjustBounds.y = adjustBounds.height = r2.y + r2.height - r1.y;
                }
                if (adjustBounds.width >= r1.width || adjustBounds.width * r1.height > adjustBounds.height * r1.width) {
                    ci1.adjustBounds.height = Math.min(ci1.adjustBounds.height, -adjustBounds.height);
                    ci1.adjustBounds.y = Math.max(ci1.adjustBounds.y, adjustBounds.y);
                    continue;
                }
                ci1.adjustBounds.width = Math.min(ci1.adjustBounds.width, -adjustBounds.width);
                ci1.adjustBounds.x = Math.max(ci1.adjustBounds.x, adjustBounds.x);
            }
        }
    }

    protected Cell getCell(int rIdx, int cIdx) {
        return this.getRow(rIdx).getCell(cIdx);
    }

    protected Row getRow(int rIdx) {
        int[] sIdx = new int[1];
        Sheet sheet = this.getSheet(rIdx, sIdx);
        return sheet.getRow(this.getSheetRelativeRowIndex(rIdx, sIdx[0]));
    }

    private void draw(RptComponent cmp, boolean detectOccupiedCells, RptStyle style, RptSection section, List<Integer> columnOffsets, Map<Integer, Integer> collapsedRows) {
        int offset;
        int rowOffset = section.rowOffset;
        RptStyleInfo info = (RptStyleInfo)style.customData;
        if (info.discarded || detectOccupiedCells && info.discarded2 || collapsedRows != null && info.isFrameOrLine) {
            return;
        }
        int firstRowIndex = -1;
        int lastRowIndex = -1;
        int addLineIndex = section.lineOffsets.get(0) > 0 ? 1 : 0;
        int lineCount = section.lineOffsets.size();
        for (int i = 0; i < lineCount; ++i) {
            offset = section.lineOffsets.get(i);
            if (offset == style.y) {
                firstRowIndex = i + addLineIndex + rowOffset;
                if (!style.isLineComponent() || style.width <= style.height) continue;
                break;
            }
            if (offset != style.y + style.height) continue;
            lastRowIndex = i - 1 + addLineIndex + rowOffset;
            break;
        }
        if (collapsedRows != null) {
            Integer key;
            Integer rh;
            if (lastRowIndex > firstRowIndex && ((rh = collapsedRows.get(key = Integer.valueOf(firstRowIndex - addLineIndex))) == null || rh < style.height)) {
                collapsedRows.put(key, style.height);
            }
            return;
        }
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        int addColIndex = columnOffsets.get(0) > 0 ? 1 : 0;
        int columnCount = columnOffsets.size();
        for (int i = 0; i < columnCount; ++i) {
            offset = columnOffsets.get(i);
            if (offset == style.x) {
                firstColumnIndex = i + addColIndex;
                if (!style.isLineComponent() || style.height <= style.width) continue;
                break;
            }
            if (offset != style.x + style.width) continue;
            lastColumnIndex = i - 1 + addColIndex;
            break;
        }
        if (info != null && info.isFrameOrLine) {
            int borderWidth;
            if (detectOccupiedCells) {
                info.excelRC = new Rectangle(firstColumnIndex, firstRowIndex, lastColumnIndex, lastRowIndex);
            } else if (style.isLineComponent()) {
                if (style.border != null && !this.ignoreCellBorder) {
                    Color borderColor;
                    borderWidth = style.border.width;
                    Color color = borderColor = style.border.color != null ? style.border.color : cmp.foreground;
                    if (style.height > style.width) {
                        boolean right = true;
                        int cIdx = firstColumnIndex;
                        if (cIdx > 0) {
                            --cIdx;
                        } else {
                            right = false;
                        }
                        block14: for (int rIdx = firstRowIndex; rIdx <= lastRowIndex; ++rIdx) {
                            switch (section.occupiedCells[rIdx - rowOffset][cIdx]) {
                                case 0: {
                                    Color background = this.whitePageBackground ? Color.white : null;
                                    this.setBorderedCellStyle(rIdx, cIdx, false, false, !right, right, borderWidth, borderColor, background);
                                    section.occupiedCells[rIdx - rowOffset][cIdx] = 3;
                                    continue block14;
                                }
                                case 3: {
                                    Color background;
                                    Cell cell = this.getCell(rIdx, cIdx);
                                    CellStyle cellStyle = cell.getCellStyle();
                                    if (this.ignoreCellBackground) {
                                        background = this.whitePageBackground ? Color.white : null;
                                    } else {
                                        background = this.exportHelper.getBackgroundColor(cellStyle);
                                        if (background == null && this.whitePageBackground) {
                                            background = Color.white;
                                        }
                                    }
                                    this.setBorderedCellStyle(rIdx, cIdx, cellStyle.getBorderTopEnum() != BorderStyle.NONE, cellStyle.getBorderBottomEnum() != BorderStyle.NONE, !right || cellStyle.getBorderLeftEnum() != BorderStyle.NONE, right || cellStyle.getBorderRightEnum() != BorderStyle.NONE, borderWidth, borderColor, background);
                                }
                            }
                        }
                    } else {
                        boolean bottom = true;
                        int rIdx = firstRowIndex;
                        if (rIdx - rowOffset > 0) {
                            --rIdx;
                        } else {
                            bottom = false;
                        }
                        block15: for (int cIdx = firstColumnIndex; cIdx <= lastColumnIndex; ++cIdx) {
                            switch (section.occupiedCells[rIdx - rowOffset][cIdx]) {
                                case 0: {
                                    Color background = this.whitePageBackground ? Color.white : null;
                                    this.setBorderedCellStyle(rIdx, cIdx, !bottom, bottom, false, false, borderWidth, borderColor, background);
                                    section.occupiedCells[rIdx - rowOffset][cIdx] = 3;
                                    continue block15;
                                }
                                case 3: {
                                    Color background;
                                    Cell cell = this.getCell(rIdx, cIdx);
                                    CellStyle cellStyle = cell.getCellStyle();
                                    if (this.ignoreCellBackground) {
                                        background = this.whitePageBackground ? Color.white : null;
                                    } else {
                                        background = this.exportHelper.getBackgroundColor(cellStyle);
                                        if (background == null && this.whitePageBackground) {
                                            background = Color.white;
                                        }
                                    }
                                    this.setBorderedCellStyle(rIdx, cIdx, !bottom || cellStyle.getBorderTopEnum() != BorderStyle.NONE, bottom || cellStyle.getBorderBottomEnum() != BorderStyle.NONE, cellStyle.getBorderLeftEnum() != BorderStyle.NONE, cellStyle.getBorderRightEnum() != BorderStyle.NONE, borderWidth, borderColor, background);
                                }
                            }
                        }
                    }
                }
            } else {
                Color borderColor;
                if (style.border != null && !this.ignoreCellBorder) {
                    borderWidth = style.border.width;
                    borderColor = style.border.color != null ? style.border.color : cmp.foreground;
                } else {
                    borderWidth = 0;
                    borderColor = null;
                }
                Color background = this.ignoreCellBackground ? (this.whitePageBackground ? Color.white : null) : (cmp.background != null ? cmp.background : (this.whitePageBackground ? Color.white : null));
                if (borderColor != null || background != null) {
                    for (int rIdx = firstRowIndex; rIdx <= lastRowIndex; ++rIdx) {
                        block17: for (int cIdx = firstColumnIndex; cIdx <= lastColumnIndex; ++cIdx) {
                            switch (section.occupiedCells[rIdx - rowOffset][cIdx]) {
                                case 0: {
                                    this.setBorderedCellStyle(rIdx, cIdx, rIdx == firstRowIndex, rIdx == lastRowIndex, cIdx == firstColumnIndex, cIdx == lastColumnIndex, borderWidth, borderColor, background);
                                    section.occupiedCells[rIdx - rowOffset][cIdx] = 3;
                                    continue block17;
                                }
                                case 3: {
                                    Cell cell = this.getCell(rIdx, cIdx);
                                    CellStyle cellStyle = cell.getCellStyle();
                                    this.setBorderedCellStyle(rIdx, cIdx, cellStyle.getBorderTopEnum() != BorderStyle.NONE || rIdx == firstRowIndex, cellStyle.getBorderBottomEnum() != BorderStyle.NONE || rIdx == lastRowIndex, cellStyle.getBorderLeftEnum() != BorderStyle.NONE || cIdx == firstColumnIndex, cellStyle.getBorderRightEnum() != BorderStyle.NONE || cIdx == lastColumnIndex, borderWidth, borderColor, background);
                                }
                            }
                        }
                    }
                }
            }
        } else {
            if (detectOccupiedCells && (this.removeRowsSpace == 2 || this.removeColumnsSpace == 2)) {
                info.excelRC = new Rectangle(firstColumnIndex, firstRowIndex, lastColumnIndex, lastRowIndex);
            }
            if (detectOccupiedCells) {
                boolean collapseAllColumns = this.removeColumnsSpace == 2;
                for (int rIdx = firstRowIndex; rIdx <= lastRowIndex; ++rIdx) {
                    for (int cIdx = firstColumnIndex; cIdx <= lastColumnIndex; ++cIdx) {
                        section.occupiedCells[rIdx - rowOffset][cIdx] = cIdx > firstColumnIndex && cIdx < lastColumnIndex && collapseAllColumns ? 2 : 1;
                    }
                }
            } else {
                boolean mergedRegion;
                for (int rIdx = firstRowIndex; rIdx <= lastRowIndex; ++rIdx) {
                    for (int cIdx = firstColumnIndex; cIdx <= lastColumnIndex; ++cIdx) {
                        section.occupiedCells[rIdx - rowOffset][cIdx] = 1;
                    }
                }
                boolean bl = mergedRegion = lastRowIndex > firstRowIndex || lastColumnIndex > firstColumnIndex;
                if (mergedRegion) {
                    mergedRegion = this.addMergedRegion(firstRowIndex, lastRowIndex, firstColumnIndex, lastColumnIndex);
                }
                Row row = this.getRow(firstRowIndex);
                Cell cell = row.createCell(firstColumnIndex);
                int numericType = 0;
                Double numericValue = null;
                if (cmp.text != null && this.detectCellType && (numericValue = this.exportHelper.getNumericValue(cmp.text)) != null) {
                    numericType = this.exportHelper.getNumericType(cmp.text);
                }
                CellStyle cellStyle = this.getCellStyle(cmp, style, numericType);
                cell.setCellStyle(cellStyle);
                if (style.border != null && !this.ignoreCellBorder && mergedRegion) {
                    int borderWidth = style.border.width;
                    Color borderColor = style.border.color != null ? style.border.color : cmp.foreground;
                    for (int rIdx = firstRowIndex; rIdx <= lastRowIndex; ++rIdx) {
                        for (int cIdx = firstColumnIndex; cIdx <= lastColumnIndex; ++cIdx) {
                            if (rIdx <= firstRowIndex && cIdx <= firstColumnIndex) continue;
                            this.setBorderedCellStyle(rIdx, cIdx, style.border.top && rIdx == firstRowIndex, style.border.bottom && rIdx == lastRowIndex, style.border.left && cIdx == firstColumnIndex, style.border.right && cIdx == lastColumnIndex, borderWidth, borderColor, null);
                        }
                    }
                }
                if (!(cmp.image == null || this.ignoreImages && cmp.inputType == null)) {
                    this.drawBitmap(cmp, section, firstColumnIndex, firstRowIndex, addColIndex, addLineIndex);
                }
                if (cmp.text != null) {
                    if (numericValue != null) {
                        cell.setCellValue(numericValue.doubleValue());
                    } else {
                        cell.setCellValue(cmp.text);
                    }
                }
                if (cmp.hyperlink != null) {
                    cell.setHyperlink(this.getHyperlink(cmp.hyperlink));
                }
            }
        }
        if (detectOccupiedCells) {
            info.discarded2 = true;
        } else if (lastRowIndex > this.currentRowIndex) {
            this.currentRowIndex = lastRowIndex;
        }
    }

    private void drawBitmap(RptComponent cmp, RptSection section, int firstColumnIndex, int firstRowIndex, int addColIndex, int addLineIndex) {
        int pictureIndex = this.getImage(cmp.image.imageFile);
        if (pictureIndex >= 0) {
            int row2 = -1;
            int row1 = -1;
            int col2 = -1;
            int col1 = -1;
            int dy2 = -1;
            int dy1 = -1;
            int dx2 = -1;
            int dx1 = -1;
            int prevOffs = 0;
            int idx = firstColumnIndex - addColIndex;
            int startX = this.columnOffsets.get(idx++);
            int columnCount = this.columnOffsets.size();
            while (idx < columnCount) {
                int offs = this.columnOffsets.get(idx) - startX;
                if (cmp.image.x + cmp.image.width <= offs || idx == columnCount - 1) {
                    col2 = idx;
                    dx2 = this.exportHelper.computeAnchorX(offs - prevOffs, cmp.image.x + cmp.image.width - prevOffs);
                    if (dx1 >= 0) break;
                    col1 = idx;
                    dx1 = this.exportHelper.computeAnchorX(offs - prevOffs, cmp.image.x - prevOffs);
                    break;
                }
                if (dx1 < 0 && cmp.image.x <= offs) {
                    col1 = idx;
                    dx1 = this.exportHelper.computeAnchorX(offs - prevOffs, cmp.image.x - prevOffs);
                }
                prevOffs = offs;
                ++idx;
            }
            prevOffs = 0;
            int sIdx = this.getSheetIndex(firstRowIndex);
            int maxIdx = this.sheetLastRowIndexes.get(sIdx) - section.rowOffset;
            idx = firstRowIndex - addLineIndex - section.rowOffset;
            int startY = section.lineOffsets.get(idx++);
            int lineCount = section.lineOffsets.size();
            while (idx < lineCount) {
                int offs = section.lineOffsets.get(idx) - startY;
                if (cmp.image.y + cmp.image.height <= offs || idx == lineCount - 1 || idx == maxIdx) {
                    row2 = idx + section.rowOffset;
                    dy2 = this.exportHelper.computeAnchorY(offs - prevOffs, cmp.image.y + cmp.image.height - prevOffs);
                    if (dy1 >= 0) break;
                    row1 = idx + section.rowOffset;
                    dy1 = this.exportHelper.computeAnchorY(offs - prevOffs, cmp.image.y - prevOffs);
                    break;
                }
                if (dy1 < 0 && cmp.image.y <= offs) {
                    row1 = idx + section.rowOffset;
                    dy1 = this.exportHelper.computeAnchorY(offs - prevOffs, cmp.image.y - prevOffs);
                }
                prevOffs = offs;
                ++idx;
            }
            ClientAnchor a = this.createClientAnchor(dx1, dy1, dx2, dy2, col1 - 1 + addColIndex, row1 - 1 + addLineIndex, col2 - 1 + addColIndex, row2 - 1 + addLineIndex);
            a.setAnchorType(ClientAnchor.AnchorType.DONT_MOVE_AND_RESIZE);
            this.patriarchs.get(this.getSheetIndex(row1)).createPicture(a, pictureIndex);
        }
    }

    protected ClientAnchor createClientAnchor(int dx1, int dy1, int dx2, int dy2, int col1, int row1, int col2, int row2) {
        int sIdx = this.getSheetIndex(row1);
        return this.patriarchs.get(sIdx).createAnchor(dx1, dy1, dx2, dy2, col1, this.getSheetRelativeRowIndex(row1, sIdx), col2, this.getSheetRelativeRowIndex(row2, sIdx));
    }

    protected Sheet getSheet(int rowNum) {
        return this.getSheet(rowNum, null);
    }

    private Sheet newSheet() {
        Sheet sheet = this.createSheet(this.reportName + " " + String.valueOf(this.exportHelper.getSheetCount() + 1));
        return sheet;
    }

    protected Sheet getSheet(int rowNum, int[] sheetIdx) {
        int idx = this.getSheetIndex(rowNum);
        if (idx >= this.exportHelper.getSheetCount()) {
            this.newSheet();
        }
        if (sheetIdx != null) {
            sheetIdx[0] = idx;
        }
        return this.exportHelper.getSheetAt(idx);
    }

    protected int getSheetIndex(int rowNum) {
        for (int i = this.sheetLastRowIndexes.size() - 1; i >= 0; --i) {
            if (rowNum <= this.sheetLastRowIndexes.get(i)) continue;
            return i + 1;
        }
        return 0;
    }

    protected int getSheetRelativeRowIndex(int rowNum, int sheetIdx) {
        if (sheetIdx == 0) {
            return rowNum;
        }
        return rowNum - this.sheetLastRowIndexes.get(sheetIdx - 1) - 1;
    }

    private void setBorderedCellStyle(int rIdx, int cIdx, boolean top, boolean bottom, boolean left, boolean right, int borderWidth, Color borderColor, Color background) {
        Cell cell;
        int[] sIdx = new int[1];
        Sheet sheet = this.getSheet(rIdx, sIdx);
        Row row = sheet.getRow(rIdx = this.getSheetRelativeRowIndex(rIdx, sIdx[0]));
        if (row == null) {
            row = sheet.createRow(rIdx);
        }
        if ((cell = row.getCell(cIdx)) == null) {
            cell = row.createCell(cIdx);
        }
        StringBuilder styleName = new StringBuilder("brd[");
        if (borderColor != null) {
            styleName.append(borderWidth);
            styleName.append(",");
            styleName.append(borderColor.getRGB());
            if (top) {
                styleName.append(",t");
            }
            if (bottom) {
                styleName.append(",b");
            }
            if (left) {
                styleName.append(",l");
            }
            if (right) {
                styleName.append(",r");
            }
            if (background != null) {
                styleName.append(",u").append(background.getRGB());
            }
        } else if (background != null) {
            styleName.append("u").append(background.getRGB());
        }
        styleName.append("]");
        CellStyle cellStyle = this.CELL_STYLES.get(styleName.toString());
        if (cellStyle == null) {
            try {
                cellStyle = this.exportHelper.getWorkbook().createCellStyle();
            }
            catch (Exception ex) {
                return;
            }
            if (borderColor != null) {
                this.exportHelper.setBorderedCellStyleAttrs(cellStyle, top, bottom, left, right, borderWidth, borderColor);
            }
            if (background != null) {
                this.exportHelper.setBackgroundAttrs(cellStyle, background);
            }
            this.CELL_STYLES.put(styleName.toString(), cellStyle);
        }
        cell.setCellStyle(cellStyle);
    }

    protected abstract void setCellStyleAttrs(CellStyle var1, RptComponent var2, RptStyle var3, String var4);

    private CellStyle getCellStyle(RptComponent cmp, RptStyle style, int numericType) {
        CellStyle cellStyle;
        String key = cmp.cssClass;
        if (numericType != 0) {
            key = key + "-" + numericType;
        }
        if ((cellStyle = this.CELL_STYLES.get(key)) == null) {
            String format;
            try {
                cellStyle = this.exportHelper.getWorkbook().createCellStyle();
            }
            catch (Exception ex) {
                return this.defaultCellStyle;
            }
            if (numericType != 0) {
                if (this.cellNumericFormat != null) {
                    format = this.cellNumericFormat;
                } else {
                    switch (numericType) {
                        case 2: {
                            format = "#,###.##########";
                            break;
                        }
                        default: {
                            format = "#,###";
                            break;
                        }
                    }
                }
            } else {
                format = null;
            }
            this.setCellStyleAttrs(cellStyle, cmp, style, format);
            this.CELL_STYLES.put(key, cellStyle);
        }
        return cellStyle;
    }

    private Hyperlink getHyperlink(String url) {
        HyperlinkType type = HyperlinkType.URL;
        try {
            new URL(url);
        }
        catch (MalformedURLException ex) {
            type = HyperlinkType.DOCUMENT;
        }
        Hyperlink hl = this.createHyperlink(type);
        hl.setAddress(url);
        return hl;
    }

    protected Hyperlink createHyperlink(HyperlinkType type) {
        return this.creationHelper.createHyperlink(type);
    }

    protected Font getFont(RptFont f, Color foreground) {
        return this.exportHelper.getFont(f.family, f.size, f.bold, f.italic, f.underline, foreground);
    }

    private InputStream getStaticImage(String name) {
        byte[] b = null;
        if (name.equals("$CheckedCheckBox$")) {
            b = CheckBoxImage.getByteStream();
        } else if (name.equals("$CheckedRadioButton$")) {
            b = RadioButtonImage.getByteStream();
        } else if (name.equals("$UncheckedCheckBox$")) {
            b = UncheckBoxImage.getByteStream();
        } else if (name.equals("$UncheckedRadioButton$")) {
            b = UnradioButtonImage.getByteStream();
        }
        return b != null ? new ByteArrayInputStream(b) : null;
    }

    private int getImage(String path) {
        Integer Return2 = this.IMAGES.get(path);
        InputStream is = null;
        if (Return2 == null) {
            is = this.getStaticImage(path);
            if (is == null) {
                try {
                    URL u = new URL(path);
                    is = u.openStream();
                }
                catch (MalformedURLException u) {
                }
                catch (IOException u) {
                    // empty catch block
                }
            }
            if (is == null) {
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException u) {
                    // empty catch block
                }
            }
            if (is != null) {
                try {
                    byte[] b = new byte[is.available()];
                    is.read(b);
                    is.close();
                    Return2 = this.exportHelper.getWorkbook().addPicture(b, 6);
                    this.IMAGES.put(path, Return2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return Return2 != null ? Return2 : -1;
    }

    @Override
    public void addGroupComponent(RptComponent cmp) {
        if (cmp.isTableComponent()) {
            this.intAddComponent(cmp);
        } else if (cmp.parent != null && cmp.parent.isTableComponent()) {
            this.intAddComponent(cmp);
        }
    }

    @Override
    public void addComponent(RptComponent cmp) {
        if (cmp.name.equals("title") || cmp.name.equals("style") || cmp.position != null && !cmp.position.equals("absolute")) {
            return;
        }
        if (cmp.name.equals("img")) {
            RptComponent c = cmp.parent;
            while (c != null) {
                if (c.name.equals("div")) {
                    c.image = cmp;
                    c.hyperlink = cmp.hyperlink;
                    cmp = c;
                    break;
                }
                c = c.parent;
            }
        }
        this.intAddComponent(cmp);
    }

    @Override
    public void addStyle(RptStyle style) {
        if (style.getType().equals("imc") || style.getType().equals("tccc")) {
            return;
        }
        RptSection section = this.sections.get(style.getSectionId());
        if (style.getParentName() != null) {
            String parName = style.getParentName().toLowerCase();
            RptStyle par = this.allStyles.get(parName);
            style.x += par.x;
            style.y += par.y;
            if (style.width == 0) {
                style.width = par.width;
            }
            if (style.height == 0) {
                style.height = par.height;
            }
        }
        if (style.isTableComponent() || style.isTableCellComponent()) {
            style.border = null;
        } else if (style.isLineComponent()) {
            if (style.width > style.height) {
                style.height = 0;
            } else {
                style.width = 0;
            }
        }
        String name = style.getName().toLowerCase();
        if (section == null) {
            section = new RptSection(style.getSectionType());
            this.sections.put(style.getSectionId(), section);
        }
        style.customData = new RptStyleInfo(style);
        section.styles.put(name, style);
        this.allStyles.put(name, style);
    }

    @Override
    public void newPage() {
        if (this.pageCount == 0) {
            this.initializeReport();
        } else {
            int[] sIdx;
            Sheet sheet;
            if (this.lastSection != null) {
                this.drawSection(this.lastSection);
                this.lastSection = null;
            }
            if (this.addPageBreaks && (sheet = this.getSheet(this.currentRowIndex - 1, sIdx = new int[1])).getRowBreaks().length < 1024) {
                sheet.setRowBreak(this.getSheetRelativeRowIndex(this.currentRowIndex - 1, sIdx[0]));
            }
        }
        ++this.pageCount;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    private void intAddComponent(RptComponent cmp) {
        RptStyle style = this.allStyles.get(cmp.cssClass.toLowerCase());
        if (style == null) {
            return;
        }
        RptSection section = this.sections.get(style.getSectionId());
        if (cmp.inputType != null) {
            cmp.image = new RptComponent();
            cmp.image.imageFile = cmp.inputType;
            cmp.image.width = 17;
            cmp.image.height = 17;
            cmp.image.x = 2;
            cmp.image.y = Math.max(2, (cmp.height - 17) / 2);
        }
        int topOffset = 0;
        RptComponent par = cmp.parent;
        while (par != null) {
            if (par.isSection()) {
                topOffset = par.y;
                break;
            }
            par = par.parent;
        }
        if (section != this.lastSection || topOffset != section.topOffset) {
            if (this.lastSection != null) {
                this.drawSection(this.lastSection);
            }
            this.initSection(section, topOffset);
            this.lastSection = section;
            this.visibleComponents = new StringBuilder();
        }
        section.components.add(cmp);
        this.visibleComponents.append(" ").append(style.getBaseName());
    }

    private void drawSection(RptSection section) {
        RptStyle style;
        Sheet sheet;
        boolean createdNewSheet = false;
        if (this.freezePageHeader && section.isPageHeader()) {
            if (this.lastPageHeaderSection != null && !section.equalTo(this.lastPageHeaderSection)) {
                this.sheetLastRowIndexes.set(this.sheetLastRowIndexes.size() - 1, new Integer(this.currentRowIndex - 1));
                this.newSheet();
                this.pageHeaderFound = false;
                createdNewSheet = true;
            } else if (this.pageHeaderFound) {
                return;
            }
        }
        if (section.isPageHeader()) {
            this.lastPageHeaderSection = new RptSection(section.typeName);
            this.lastPageHeaderSection.components = section.components;
        }
        int colCount = this.getSheetColumnCount();
        String v = this.visibleComponents.toString();
        if (!section.visComponents.equals(v)) {
            section.currStyles = new LinkedHashMap<String, RptStyle>();
            for (RptComponent cmp : section.components) {
                String s = cmp.cssClass.toLowerCase();
                RptStyle newStyle = new RptStyle(section.styles.get(s));
                newStyle.customData = new RptStyleInfo(newStyle);
                section.currStyles.put(s, newStyle);
            }
            this.checkComponentIntersections(section.currStyles.values().toArray(new RptStyle[section.currStyles.size()]));
            TreeSet<Integer> linOffs = new TreeSet<Integer>();
            this.initTables(section.currStyles.values(), null, linOffs, true);
            section.lineOffsets = new ArrayList<Integer>(linOffs);
            int rowCount = section.lineOffsets.size();
            if (section.lineOffsets.size() > 0 && section.lineOffsets.get(0) == 0) {
                --rowCount;
            }
            if (this.collapseRowSpan) {
                TreeMap collapsedRows = new TreeMap();
                for (RptStyle style2 : section.currStyles.values()) {
                    this.draw(null, false, style2, section, this.columnOffsets, collapsedRows);
                }
                this.adjustRowsHeights(section, collapsedRows);
            }
            section.occupiedCells = new byte[rowCount][colCount];
            if (this.collapseRowSpan || this.removeRowsSpace != 0 || this.removeColumnsSpace != 0 || this.whitePageBackground) {
                for (RptStyle style3 : section.currStyles.values()) {
                    this.draw(null, true, style3, section, this.columnOffsets, null);
                }
            }
            if (this.collapseRowSpan || this.removeRowsSpace != 0) {
                this.removeUnusedRows(section);
            }
            section.visComponents = v;
        }
        int size = section.lineOffsets.size();
        int i = 0;
        int prevOffset = 0;
        int[] sIdx = new int[1];
        if (!createdNewSheet && section.topOffset > this.currTopOffset && this.removeRowsSpace == 0) {
            sheet = this.getSheet(this.currentRowIndex, sIdx);
            Row row = sheet.createRow(this.getSheetRelativeRowIndex(this.currentRowIndex, sIdx[0]));
            int rowHeight = section.topOffset - this.currTopOffset;
            if (size > 0 && (prevOffset = section.lineOffsets.get(0).intValue()) > 0) {
                rowHeight += prevOffset;
                ++i;
            } else {
                ++section.rowOffset;
            }
            row.setHeightInPoints((float)UnitConverter.pixel2ExcelHeightPoints(rowHeight));
            if (this.whitePageBackground) {
                for (int cIdx = 0; cIdx < colCount; ++cIdx) {
                    this.setBorderedCellStyle(this.currentRowIndex, cIdx, false, false, false, false, 0, null, Color.white);
                }
            }
            ++this.currentRowIndex;
        }
        int lineIndex = this.currentRowIndex;
        while (i < size) {
            int offset = section.lineOffsets.get(i);
            if (offset > prevOffset) {
                sheet = this.getSheet(lineIndex, sIdx);
                Row row = sheet.createRow(this.getSheetRelativeRowIndex(lineIndex, sIdx[0]));
                row.setHeightInPoints((float)UnitConverter.pixel2ExcelHeightPoints(offset - prevOffset));
                ++lineIndex;
            }
            prevOffset = offset;
            ++i;
        }
        section.occupiedCells = new byte[section.occupiedCells.length][colCount];
        Stack<RptComponent> deferred = new Stack<RptComponent>();
        for (RptComponent cmp : section.components) {
            style = section.currStyles.get(cmp.cssClass.toLowerCase());
            RptStyleInfo info = (RptStyleInfo)style.customData;
            if (info.isFrameOrLine) {
                if (style.border != null && !this.ignoreCellBorder) {
                    RptStyleInfo info2;
                    RptStyle style2;
                    if (info.isFrame) {
                        for (RptComponent cmp2 : section.components) {
                            if (cmp2 == cmp) continue;
                            style2 = section.currStyles.get(cmp2.cssClass.toLowerCase());
                            info2 = (RptStyleInfo)style2.customData;
                            if (info2.isFrameOrLine) continue;
                            this.checkFrameBorder(style, style2);
                        }
                    } else {
                        for (RptComponent cmp2 : section.components) {
                            if (cmp2 == cmp) continue;
                            style2 = section.currStyles.get(cmp2.cssClass.toLowerCase());
                            info2 = (RptStyleInfo)style2.customData;
                            if (info2.isFrameOrLine) continue;
                            if (style.height > style.width) {
                                this.checkVLineBorder(style, cmp.foreground, style2);
                                continue;
                            }
                            this.checkHLineBorder(style, cmp.foreground, style2);
                        }
                    }
                }
                deferred.push(cmp);
                continue;
            }
            this.draw(cmp, false, style, section, this.columnOffsets, null);
        }
        while (!deferred.isEmpty()) {
            RptComponent cmp = (RptComponent)deferred.pop();
            style = section.currStyles.get(cmp.cssClass.toLowerCase());
            this.draw(cmp, false, style, section, this.columnOffsets, null);
        }
        this.setWhitePageBackground(section);
        if (section.isPageHeader() && !this.pageHeaderFound) {
            this.pageHeaderFound = true;
            if (this.freezePageHeader) {
                sheet = this.getSheet(this.currentRowIndex, sIdx);
                int freezeStartRow = this.getSheetRelativeRowIndex(section.rowOffset, sIdx[0]);
                int freezeEndRow = this.getSheetRelativeRowIndex(this.currentRowIndex, sIdx[0]);
                if (freezeStartRow >= 0) {
                    if (freezeEndRow <= this.sheetLastRowIndexes.get(sIdx[0])) {
                        sheet.createFreezePane(0, freezeEndRow + 1);
                    }
                    sheet.setRepeatingRows(new CellRangeAddress(freezeStartRow, freezeEndRow, -1, -1));
                }
            }
        }
        if (section.pageIndex < this.pageCount && this.pageCount % 10 == 0) {
            this.flushRows();
        }
        ++this.currentRowIndex;
        this.currTopOffset = section.topOffset + section.lineOffsets.get(section.lineOffsets.size() - 1);
    }

    protected void flushRows() {
    }

    private void checkFrameBorder(RptStyle frame, RptStyle cmp) {
        if (cmp.y >= frame.y && cmp.y + cmp.height <= frame.y + frame.height) {
            if (cmp.x == frame.x || cmp.x == frame.x + frame.width) {
                if (cmp.border == null) {
                    cmp.border = new RptBorder(frame.border.width, frame.border.color, false, true, false, false);
                } else {
                    cmp.border.left = true;
                }
            }
            if (cmp.x + cmp.width == frame.x + frame.width || cmp.x + cmp.width == frame.x) {
                if (cmp.border == null) {
                    cmp.border = new RptBorder(frame.border.width, frame.border.color, false, false, false, true);
                } else {
                    cmp.border.right = true;
                }
            }
        }
        if (cmp.x >= frame.x && cmp.x + cmp.width <= frame.x + frame.width) {
            if (cmp.y == frame.y || cmp.y == frame.y + frame.height) {
                if (cmp.border == null) {
                    cmp.border = new RptBorder(frame.border.width, frame.border.color, true, false, false, false);
                } else {
                    cmp.border.top = true;
                }
            }
            if (cmp.y + cmp.height == frame.y + frame.height || cmp.y + cmp.height == frame.y) {
                if (cmp.border == null) {
                    cmp.border = new RptBorder(frame.border.width, frame.border.color, false, false, true, false);
                } else {
                    cmp.border.bottom = true;
                }
            }
        }
    }

    private void checkVLineBorder(RptStyle line, Color lineColor, RptStyle cmp) {
        if (cmp.y >= line.y && cmp.y + cmp.height <= line.y + line.height) {
            if (cmp.x == line.x) {
                if (cmp.border == null) {
                    cmp.border = new RptBorder(line.border.width, lineColor, false, true, false, false);
                } else {
                    cmp.border.left = true;
                }
            }
            if (cmp.x + cmp.width == line.x) {
                if (cmp.border == null) {
                    cmp.border = new RptBorder(line.border.width, lineColor, false, false, false, true);
                } else {
                    cmp.border.right = true;
                }
            }
        }
    }

    private void checkHLineBorder(RptStyle line, Color lineColor, RptStyle cmp) {
        if (cmp.x >= line.x && cmp.x + cmp.width <= line.x + line.width) {
            if (cmp.y == line.y) {
                if (cmp.border == null) {
                    cmp.border = new RptBorder(line.border.width, lineColor, true, false, false, false);
                } else {
                    cmp.border.top = true;
                }
            }
            if (cmp.y + cmp.height == line.y) {
                if (cmp.border == null) {
                    cmp.border = new RptBorder(line.border.width, lineColor, false, false, true, false);
                } else {
                    cmp.border.bottom = true;
                }
            }
        }
    }

    @Override
    public void setupPage(String paperSize, double top, double left, double bottom, double right, boolean landscape) {
        this.topMargin = top;
        this.leftMargin = left;
        this.rightMargin = right;
        this.bottomMargin = bottom;
        this.paperSize = paperSize;
        this.landscape = landscape;
    }

    protected void setupPage(String[] argv) {
        int idx = 0;
        double lm = 0.0;
        double rm = 0.0;
        double tm = 0.0;
        double bm = 0.0;
        String paper = "A4";
        boolean lnd = false;
        for (idx = 0; idx < argv.length; ++idx) {
            if ("-rm".equals(argv[idx])) {
                try {
                    rm = Double.parseDouble(argv[++idx]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-lm".equals(argv[idx])) {
                try {
                    lm = Double.parseDouble(argv[++idx]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-tm".equals(argv[idx])) {
                try {
                    tm = Double.parseDouble(argv[++idx]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-bm".equals(argv[idx])) {
                try {
                    bm = Double.parseDouble(argv[++idx]);
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-l".equals(argv[idx])) {
                lnd = true;
                continue;
            }
            if (!"-p".equals(argv[idx])) continue;
            paper = argv[++idx];
        }
        this.setupPage(paper, tm, lm, bm, rm, lnd);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected String getExportProperty(String propName, String def) {
        return this.properties.getProperty(propName, Config.getProperty(PROP_PREFIX + propName, def));
    }

    protected int getExportProperty(String propName, int def) {
        String str = this.properties.getProperty(propName);
        if (str != null) {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                return Boolean.parseBoolean(str) ? 1 : 0;
            }
        }
        return Config.getProperty(PROP_PREFIX + propName, Config.getProperty(PROP_PREFIX + propName, false) ? 1 : 0);
    }

    protected boolean getExportProperty(String propName, boolean def) {
        String str = this.properties.getProperty(propName);
        if (str != null) {
            try {
                return Integer.parseInt(str) != 0;
            }
            catch (NumberFormatException ex) {
                return Boolean.parseBoolean(str);
            }
        }
        return Config.getProperty(PROP_PREFIX + propName, def);
    }

    private static class RptStyleInfo {
        Rectangle adjustBounds = new Rectangle();
        boolean discarded;
        boolean discarded2;
        boolean isFrame;
        boolean isFrameOrLine;
        Rectangle excelRC;

        RptStyleInfo(RptStyle cmp) {
            this.isFrame = cmp.isBoxComponent() || cmp.isTableComponent() || cmp.getType().equals("tc");
            this.isFrameOrLine = this.isFrame || cmp.isLineComponent();
        }
    }

    private static class RptSection {
        String typeName;
        Map<String, RptStyle> styles = new LinkedHashMap<String, RptStyle>();
        Map<String, RptStyle> currStyles;
        List<RptComponent> components;
        List<Integer> lineOffsets = new ArrayList<Integer>();
        byte[][] occupiedCells;
        int rowOffset;
        int topOffset;
        int pageIndex;
        String visComponents = "";

        RptSection(String typeName) {
            this.typeName = typeName;
        }

        boolean isPageHeader() {
            return "ph".equals(this.typeName);
        }

        boolean equalTo(RptSection other) {
            int sz = this.components.size();
            if (sz != other.components.size()) {
                return false;
            }
            for (int i = 0; i < sz; ++i) {
                if (this.components.get(i).equalTo(other.components.get(i))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "Section: name='" + this.typeName + "', componentCount=" + this.styles.size();
        }
    }
}

