/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.htmlrenderer;

import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.RemoteIO;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.server.CobolGUIJavaBean;
import com.iscobol.gui.server.FontCmp;
import com.iscobol.htmlrenderer.CSSStyle;
import com.iscobol.htmlrenderer.Drawer;
import com.iscobol.htmlrenderer.SAHParser;
import com.iscobol.preview.PreviewEventsHandler;
import com.iscobol.preview.PreviewEventsImpl;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.print.SpoolPrinter;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HTMLRenderer
extends DefaultHandler {
    public static final int OR_PORTRAIT = 1;
    public static final int OR_LANDSCAPE = 2;
    private static final HashMap nodeTypes = new HashMap();
    private final HashMap styles = new HashMap();
    private final Stack nodeStack = new Stack();
    protected Drawer drawer;
    private String fileName;
    private PreviewEventsImpl events = new PreviewEventsImpl();
    static final String[] usage;

    public HTMLRenderer() {
        try {
            this.drawer = new Drawer(this.events);
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
    }

    public static InputStream getInputStream(String fileName) throws IOException {
        if (fileName.toUpperCase().startsWith("@[DISPLAY]:")) {
            RemoteIO rio = ScreenUtility.getGuiFactory().getRemoteIO();
            rio.openInputFile(fileName.substring(11));
            int BUF_LEN = 8192;
            byte[] bytes = new byte[8192];
            int length = 0;
            Object[] ret = rio.readFromInputFile(8192);
            while (true) {
                if (ret == null) {
                    throw new FileNotFoundException(fileName);
                }
                if (!(ret[0] instanceof byte[])) {
                    throw new IOException(ret[0].toString());
                }
                int read = Integer.parseInt(ret[1].toString());
                if (read < 0) break;
                byte[] buffer = (byte[])ret[0];
                if (length + read > bytes.length) {
                    byte[] tmp = bytes;
                    bytes = new byte[tmp.length * 2];
                    System.arraycopy(tmp, 0, bytes, 0, length);
                }
                System.arraycopy(buffer, 0, bytes, length, read);
                length += read;
                ret = rio.readFromInputFile(8192);
            }
            rio.closeFiles();
            return new ByteArrayInputStream(bytes, 0, length);
        }
        return new FileInputStream(fileName);
    }

    public int open() {
        try {
            InputStream in = this.fileName != null ? HTMLRenderer.getInputStream(this.fileName) : System.in;
            return this.readFromStream(in);
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
    }

    public int readFromStream(InputStream in) {
        try {
            new SAHParser(in, null).parse(this);
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        catch (SAXException _ex) {
            if (_ex.getException() != null) {
                throw new IscobolRuntimeException(_ex.getException());
            }
            throw new IscobolRuntimeException(_ex);
        }
        try {
            if (this.drawer != null) {
                this.drawer.close();
            }
            in.close();
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        return 0;
    }

    private void drawStartTag(Node n) throws SAXException {
        try {
            this.drawer.startTag(n.name, n.attrs, n.style);
        }
        catch (IOException _ex) {
            throw new SAXException(_ex);
        }
    }

    private void drawEndTag(Node n) throws SAXException {
        try {
            this.drawer.endTag();
        }
        catch (IOException _ex) {
            throw new SAXException(_ex);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Node p;
        Node n = (Node)nodeTypes.get(localName);
        n = n == null ? new Node() : (Node)n.clone();
        if (this.nodeStack.isEmpty()) {
            p = null;
        } else {
            p = (Node)this.nodeStack.peek();
            p.print(false);
            p.add(n);
        }
        n.init(this, localName, p, this.nodeStack.size(), attributes);
        this.nodeStack.push(n);
        this.drawStartTag(n);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.nodeStack.isEmpty()) {
            Node p = (Node)this.nodeStack.pop();
            if (!localName.equals(p.getName())) {
                int i;
                for (i = this.nodeStack.size() - 1; i >= 0 && !localName.equals(((Node)this.nodeStack.get(i)).getName()); --i) {
                }
                if (i >= 0) {
                    while (!localName.equals(p.getName())) {
                        p.print(true);
                        this.drawEndTag(p);
                        p = (Node)this.nodeStack.pop();
                    }
                    p.print(true);
                    this.drawEndTag(p);
                } else {
                    this.nodeStack.push(p);
                }
            } else {
                p.print(true);
                this.drawEndTag(p);
            }
        } else {
            throw new SAXException("Empty stack! " + localName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        Node p = (Node)this.nodeStack.peek();
        p.add(ch, start, length);
        this.drawer.characters(ch, start, length);
    }

    private void printString(StringBuffer s) {
    }

    public boolean setup() {
        try {
            return this.drawer.thePrinter.setup();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setPrinter(String name) {
        try {
            this.drawer.thePrinter.setPrinter(name);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setPDF(boolean pdf) {
        try {
            this.drawer.thePrinter.setPDF(pdf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setJobName(String jobName, String output) {
        try {
            this.drawer.thePrinter.setJobName(jobName, output);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setPreview(boolean prvw) {
        try {
            this.drawer.thePrinter.setPreview(prvw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setCopies(int nc) {
        try {
            this.drawer.thePrinter.setCurrCopies(nc);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getCopies() {
        try {
            return this.drawer.thePrinter.getCurrCopies();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public void setQuality(int q) {
        try {
            this.drawer.thePrinter.setQuality(q);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getQuality() {
        try {
            return this.drawer.thePrinter.getQuality();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public void setChromacity(int c) {
        try {
            this.drawer.thePrinter.setChromaticity(c);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getChromacity() {
        try {
            return this.drawer.thePrinter.getChromaticity();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public void setCollate(int c) {
        try {
            this.drawer.thePrinter.setCollate(c);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getCollate() {
        try {
            return this.drawer.thePrinter.getCollate();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public void setDuplexPrinting(int dp) {
        try {
            this.drawer.thePrinter.setDuplexPrinting(dp);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getDuplexPrinting() {
        try {
            return this.drawer.thePrinter.getDuplexPrinting();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public String getPrinterName() {
        try {
            return this.drawer.thePrinter.getPrinterName(this.drawer.thePrinter.getCurrPrinter());
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public void setBrowserParaOrientation(String para, int or) {
        para = para.trim();
        StringTokenizer st = new StringTokenizer(para, "|");
        int marginLeft = -1;
        int marginRight = -1;
        int marginTop = -1;
        int marginBottom = -1;
        if (st.hasMoreTokens()) {
            try {
                marginLeft = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (st.hasMoreTokens()) {
                try {
                    marginRight = Integer.parseInt(st.nextToken());
                }
                catch (NumberFormatException _ex) {
                    marginRight = 0;
                }
                if (st.hasMoreTokens()) {
                    try {
                        marginTop = Integer.parseInt(st.nextToken());
                    }
                    catch (NumberFormatException _ex) {
                        marginTop = 0;
                    }
                    if (st.hasMoreTokens()) {
                        try {
                            marginBottom = Integer.parseInt(st.nextToken());
                        }
                        catch (NumberFormatException _ex) {
                            marginBottom = 0;
                        }
                    }
                }
            }
        }
        switch (or) {
            case 1: {
                this.drawer.setLandscape(false);
                break;
            }
            case 2: {
                int saveTop = marginTop;
                marginTop = marginRight;
                marginRight = marginBottom;
                marginBottom = marginLeft;
                marginLeft = saveTop;
                this.drawer.setLandscape(true);
                break;
            }
        }
        if (marginBottom >= 0 && marginLeft >= 0) {
            this.drawer.setMargins((double)marginLeft / 100.0, (double)marginRight / 100.0, (double)marginTop / 100.0, (double)marginBottom / 100.0);
        }
    }

    public void setHeaderFooter(String h, String f) {
        try {
            this.drawer.setHeaderFooter(h, f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setPaperTitle(String w) {
        this.drawer.setTitle(w);
    }

    public void setPaperUrl(String u) {
        this.fileName = u;
        try {
            this.drawer.setUrl(u);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getPaperUrl() {
        return this.fileName;
    }

    public void setMargins(double left, double right, double top, double bottom) {
        this.drawer.setMargins(left, right, top, bottom);
    }

    public void setLandscape(boolean lndscp) {
        this.drawer.setLandscape(lndscp);
    }

    public void setCustomPaperSize(float width, float height) {
        this.drawer.setCustomPaperSize(width, height);
    }

    public void setPaperSize(String s) {
        this.drawer.setPaperSize(s);
    }

    public int getOrientation() {
        if (this.drawer.isLandscape()) {
            return 2;
        }
        return 1;
    }

    public void setPrinterName(String s) {
        try {
            this.drawer.thePrinter.setPrinter(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getPaperName() {
        return this.drawer.getPaperName();
    }

    public String getPaperSize(int unit) {
        return HTMLRenderer.getPaperSize(this.drawer.getPaperSize(unit));
    }

    private static String getPaperSize(float[] size) {
        String Return2 = "";
        Return2 = Return2 + HTMLRenderer.fillZero(Math.round(size[0] * 100.0f));
        Return2 = Return2 + "|";
        Return2 = Return2 + HTMLRenderer.fillZero(Math.round(size[1] * 100.0f));
        return Return2;
    }

    private static String fillZero(int val) {
        if (val <= 9) {
            return "00000" + val;
        }
        if (val <= 99) {
            return "0000" + val;
        }
        if (val <= 999) {
            return "000" + val;
        }
        if (val <= 9999) {
            return "00" + val;
        }
        if (val <= 99999) {
            return "0" + val;
        }
        return "" + val;
    }

    public String getMargins(int unit) {
        return HTMLRenderer.getMargins(this.drawer.getMargins(), this.getOrientation());
    }

    private static String getMargins(int[] margins, int orientation) {
        if (orientation == 1) {
            return HTMLRenderer.fillZero(margins[0]) + "|" + HTMLRenderer.fillZero(margins[1]) + "|" + HTMLRenderer.fillZero(margins[2]) + "|" + HTMLRenderer.fillZero(margins[3]);
        }
        return HTMLRenderer.fillZero(margins[3]) + "|" + HTMLRenderer.fillZero(margins[2]) + "|" + HTMLRenderer.fillZero(margins[0]) + "|" + HTMLRenderer.fillZero(margins[1]);
    }

    private static void showHelp() {
        System.out.println("usage: java " + HTMLRenderer.class.getName() + usage[0]);
        for (int i = 1; i < usage.length; ++i) {
            System.out.println(usage[i]);
        }
        System.exit(2);
    }

    private static void invOpt(String m) {
        System.out.println("invalid option: " + m);
        HTMLRenderer.showHelp();
    }

    private static void invPaper(String m) {
        String fill = "                          ";
        System.out.println("unsupported paper: " + m + ". Supported papers are:");
        for (int i = 1; i < Drawer.media.length; ++i) {
            if (i % 3 == 0) {
                System.out.println((Drawer.media[i] + "                          ").substring(0, 26));
                continue;
            }
            System.out.print((Drawer.media[i] + "                          ").substring(0, 26));
        }
        System.out.println("custom");
        System.exit(3);
    }

    public static void main(String[] argv) throws Exception {
        HTMLRenderer.run(argv, new HTMLRenderer());
    }

    public static void run(String[] argv, HTMLRenderer hr) throws Exception {
        String header = "&w&bPage &p of &P";
        String footer = "&u&b&d";
        hr.setPreview(true);
        int idx = 0;
        for (idx = 0; idx < argv.length && argv[idx].startsWith("-"); ++idx) {
            if ("-h".equals(argv[idx])) {
                HTMLRenderer.showHelp();
                continue;
            }
            if ("-q".equals(argv[idx])) {
                hr.setPreview(false);
                continue;
            }
            if ("-l".equals(argv[idx])) {
                hr.drawer.setLandscape(true);
                continue;
            }
            if (argv[idx].startsWith("-p")) {
                String paper = null;
                if (argv[idx].length() > 2) {
                    paper = argv[idx].substring(2);
                } else if (++idx < argv.length) {
                    paper = argv[idx];
                } else {
                    HTMLRenderer.invPaper("");
                }
                if (!hr.drawer.setPaperSize(paper)) {
                    HTMLRenderer.invPaper(paper);
                    continue;
                }
                System.out.println("paper size=" + hr.getPaperSize(0));
                continue;
            }
            if (argv[idx].startsWith("-H")) {
                if (argv[idx].length() > 2) {
                    header = argv[idx].substring(2);
                    continue;
                }
                if (++idx < argv.length) {
                    header = argv[idx];
                    continue;
                }
                HTMLRenderer.invOpt("-H");
                continue;
            }
            if (argv[idx].startsWith("-F")) {
                if (argv[idx].length() > 2) {
                    footer = argv[idx].substring(2);
                    continue;
                }
                if (++idx < argv.length) {
                    footer = argv[idx];
                    continue;
                }
                HTMLRenderer.invOpt("-F");
                continue;
            }
            if (argv[idx].startsWith("-w")) {
                String title = null;
                if (argv[idx].length() > 2) {
                    title = argv[idx].substring(2);
                } else if (++idx < argv.length) {
                    title = argv[idx];
                } else {
                    HTMLRenderer.invOpt("-F");
                }
                hr.setPaperTitle(title);
                continue;
            }
            HTMLRenderer.invOpt(argv[idx]);
        }
        if (idx < argv.length) {
            String fileName = argv[idx];
            hr.setPaperUrl(fileName);
        } else {
            Object fileName = null;
            hr.setPaperUrl("(stdin)");
        }
        hr.setHeaderFooter(header, footer);
        hr.open();
        System.exit(0);
    }

    public boolean setup(ICobolVar paperSizeVar, ICobolVar paperMarginVar) {
        double[] d = this.drawer.setupPrint();
        if (d != null && d.length == 7) {
            float[] size = new float[]{(float)d[1], (float)d[2]};
            paperSizeVar.set(HTMLRenderer.getPaperSize(size));
            int[] margins = new int[]{(int)Math.round(d[5] * 100.0), (int)Math.round(d[6] * 100.0), (int)Math.round(d[3] * 100.0), (int)Math.round(d[4] * 100.0)};
            boolean landscape = (int)d[0] != 1;
            paperMarginVar.set(HTMLRenderer.getMargins(margins, landscape ? 2 : 1));
            if (landscape) {
                this.setMargins(d[4], d[3], d[5], d[6]);
            } else {
                this.setMargins(d[5], d[6], d[3], d[4]);
            }
            this.setLandscape(landscape);
            return true;
        }
        return false;
    }

    public static void getFontValue(String fontName, ICobolVar font) {
        FontCmp fcmp = FontCmp.getStdFont(fontName, "iscobol.report.font.");
        StringBuffer sb = new StringBuffer();
        sb.append("font-size:");
        sb.append(Math.round(fcmp.getSize()));
        sb.append("pt; font-family:");
        sb.append(fcmp.getName());
        sb.append(";");
        font.set(sb.toString());
    }

    public static void escapeText(ICobolVar src, ICobolVar dst) {
        HTMLRenderer.escapeText(src, dst, false);
    }

    public static void escapeText(ICobolVar src, ICobolVar dst, boolean keepSpaces) {
        dst.set(HTMLRenderer.escapeText(src.toString(), keepSpaces));
    }

    private static String escapeText(String text, boolean keepSpaces) {
        StringBuffer sb = new StringBuffer();
        char[] c = text.toCharArray();
        block9: for (int i = 0; i < c.length; ++i) {
            switch (c[i]) {
                case '<': {
                    sb.append("&lt;");
                    continue block9;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block9;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block9;
                }
                case '\u20ac': {
                    sb.append("&euro;");
                    continue block9;
                }
                case '\u00a0': {
                    sb.append("&nbsp;");
                    continue block9;
                }
                case ' ': {
                    if (keepSpaces) {
                        sb.append("&nbsp;");
                        continue block9;
                    }
                    sb.append(c[i]);
                    continue block9;
                }
                default: {
                    sb.append(c[i]);
                }
            }
        }
        return sb.toString();
    }

    public static void getFontFlags(String fontName, ICobolVar fontFlags) {
        FontCmp fcmp = FontCmp.getStdFont(fontName, "iscobol.report.font.");
        String s = "";
        s = (fcmp.getStyle() & 1) == 1 ? s + "y" : s + "n";
        s = (fcmp.getStyle() & 2) == 2 ? s + "y" : s + "n";
        fontFlags.set(s);
    }

    public static void getRGBValues(ICobolVar colorVar, ICobolVar backgroundColorVar, ICobolVar foregroundColorVar, ICobolVar fg, ICobolVar bg) {
        GuiFactory gf = ScreenUtility.getGuiFactory();
        if (backgroundColorVar != null) {
            int backgroundColor = backgroundColorVar.toint();
            if (backgroundColor < 0) {
                bg.set(HTMLRenderer.getRgbString(-backgroundColor));
            } else {
                HTMLRenderer.getRGBValue(backgroundColor, gf, bg);
            }
        } else if (colorVar != null) {
            HTMLRenderer.getRGBValue(colorVar.toint() / 32 - 1, gf, bg);
        } else {
            bg.setSpace();
        }
        if (foregroundColorVar != null) {
            int foregroundColor = foregroundColorVar.toint();
            if (foregroundColor < 0) {
                fg.set(HTMLRenderer.getRgbString(-foregroundColor));
            } else {
                HTMLRenderer.getRGBValue(foregroundColor, gf, fg);
            }
        } else if (colorVar != null) {
            HTMLRenderer.getRGBValue(colorVar.toint() % 32 - 1, gf, fg);
        } else {
            fg.setSpace();
        }
    }

    public static void getRGBValues(ICobolVar colorVar, ICobolVar fg, ICobolVar bg) {
        GuiFactory gf = ScreenUtility.getGuiFactory();
        int color = colorVar.toint();
        HTMLRenderer.getRGBValue(color / 32 - 1, gf, bg);
        HTMLRenderer.getRGBValue(color % 32 - 1, gf, fg);
    }

    private static void getRGBValue(int colorIndex, GuiFactory gf, ICobolVar dest) {
        Color c = null;
        if (colorIndex >= 0) {
            try {
                c = gf.getColor(colorIndex);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (c != null) {
            dest.set(HTMLRenderer.getRgbString(c.getRGB()));
        } else {
            dest.setSpace();
        }
    }

    private static String getRgbString(int rgb) {
        String h = Integer.toHexString(rgb & 0xFFFFFF);
        StringBuffer sb = new StringBuffer("#");
        int n = 6 - h.length();
        for (int i = 0; i < n; ++i) {
            sb.append('0');
        }
        sb.append(h);
        return sb.toString();
    }

    public static void getCurrentDate(String format, ICobolVar dest) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        dest.set(sdf.format(Calendar.getInstance().getTime()));
    }

    public static int inchToPixel(float inch) {
        return Math.round(inch * 96.0f);
    }

    public void addMenu(String path, String title, ImageIcon icon, int id, PreviewEventsHandler handler) {
        CobolGUIJavaBean.callStaticMethod(SpoolPrinter.class.getName(), "addMenu", new Object[]{path, title, icon, new Integer(id)});
        this.events.addEventHandler(id, handler);
    }

    public void removeMenu(String path) {
        CobolGUIJavaBean.callStaticMethod(SpoolPrinter.class.getName(), "removeMenu", new Object[]{path});
    }

    static {
        nodeTypes.put("style", new NodeStyle());
        usage = new String[]{" [-h|-l|-q|-p papername] [filename]", "        -h   prints this help", "        -l   set the orientation landscape (default=portrait)", "        -p   set the paper sheet size (default=a4)", "        -q   prints directly without preview", "        -w   set the title", "        -H   set the header", "        -F   set the footer"};
    }

    private static class NodeStyle
    extends Node {
        private NodeStyle() {
        }

        @Override
        protected void print(boolean end) {
            this.printStart();
            int size = this.content.size();
            StringBuffer style = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                Object obj = this.content.get(i);
                if (obj instanceof Node) continue;
                style.append(obj.toString());
            }
            int len = style.length();
            for (int i = 0; i < len; ++i) {
                char c = style.charAt(i);
                if (c <= ' ') continue;
                CSSStyle sty = new CSSStyle(style, i);
                try {
                    i = sty.parse();
                    this.main.styles.put(sty.getName(), sty);
                    continue;
                }
                catch (CSSStyle.BadFormatException _ex) {
                    _ex.printStackTrace();
                }
            }
            this.content.clear();
            if (!this.ended) {
                StringBuffer sb = new StringBuffer("<!--debug-->");
                Iterator it = this.main.styles.keySet().iterator();
                while (it.hasNext()) {
                    sb.append(this.main.styles.get(it.next()).toString());
                    sb.append("\n");
                }
                this.main.printString(sb);
                this.printEnd(end);
            }
        }
    }

    private static class Node
    implements Cloneable {
        protected HTMLRenderer main;
        protected String name;
        protected int level;
        protected Attributes attrs;
        protected boolean started;
        protected boolean ended;
        protected boolean containsNode;
        protected ArrayList content;
        protected CSSStyle style;

        private Node() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException _ex) {
                return null;
            }
        }

        public String getName() {
            return this.name;
        }

        void init(HTMLRenderer m, String n, Node p, int l, Attributes a) {
            int len;
            this.content = new ArrayList();
            this.name = n;
            this.main = m;
            this.level = l;
            this.attrs = a;
            if (this.attrs != null && (len = this.attrs.getLength()) > 0) {
                String key;
                int i;
                for (i = 0; i < len; ++i) {
                    key = this.attrs.getLocalName(i);
                    if (!"style".equals(key)) continue;
                    String str = this.attrs.getValue(i);
                    this.style = new CSSStyle(str);
                    try {
                        this.style.parse();
                    }
                    catch (CSSStyle.BadFormatException _ex) {
                        _ex.printStackTrace();
                    }
                    break;
                }
                for (i = 0; i < len; ++i) {
                    key = this.attrs.getLocalName(i);
                    if (!"class".equals(key)) continue;
                    if (this.style == null) {
                        this.style = new CSSStyle("");
                    }
                    StringTokenizer st = new StringTokenizer(this.attrs.getValue(i));
                    while (st.hasMoreTokens()) {
                        this.style.mixUp((CSSStyle)this.main.styles.get(st.nextToken().toLowerCase()));
                    }
                    break;
                }
            }
        }

        final void add(Node n) {
            this.content.add(n);
            this.containsNode = true;
        }

        final void add(char[] c, int start, int length) {
            Object obj;
            int size = this.content.size();
            if (size > 0 && (obj = this.content.get(size - 1)) instanceof StringBuffer) {
                ((StringBuffer)obj).append(c, start, length);
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append(c, start, length);
                this.content.add(sb);
            }
        }

        protected void printIndent(StringBuffer sb) {
            for (int i = 0; i < this.level; ++i) {
                sb.append(' ');
            }
        }

        protected void printStart() {
            if (!this.started) {
                int len;
                StringBuffer sb = new StringBuffer();
                sb.append('\n');
                this.printIndent(sb);
                sb.append('<');
                sb.append(this.name);
                if (this.style != null) {
                    sb.append(' ');
                    sb.append("style=\"");
                    sb.append(this.style.getContent());
                    sb.append('\"');
                }
                if (this.attrs != null && (len = this.attrs.getLength()) > 0) {
                    for (int i = 0; i < len; ++i) {
                        String key = this.attrs.getLocalName(i);
                        if ("class".equals(key) || "style".equals(key)) continue;
                        sb.append(' ');
                        sb.append(this.attrs.getLocalName(i));
                        sb.append('=');
                        sb.append('\"');
                        sb.append(this.attrs.getValue(i));
                        sb.append('\"');
                    }
                }
                sb.append('>');
                this.main.printString(sb);
                this.started = true;
            }
        }

        protected final void printEnd(boolean end) {
            if (end && !this.ended) {
                StringBuffer sb = new StringBuffer();
                if (this.containsNode) {
                    sb.append('\n');
                    this.printIndent(sb);
                }
                sb.append('<');
                sb.append('/');
                sb.append(this.name);
                sb.append('>');
                sb.append('\n');
                this.main.printString(sb);
                this.ended = true;
            }
        }

        protected void print(boolean end) {
            this.printStart();
            int size = this.content.size();
            for (int i = 0; i < size; ++i) {
                Object obj = this.content.get(i);
                if (obj instanceof Node) {
                    ((Node)obj).print(true);
                    continue;
                }
                this.main.printString((StringBuffer)obj);
            }
            this.printEnd(end);
            this.content.clear();
        }

        public String toString() {
            return "<" + this.name + ">";
        }
    }
}

