/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.isam.FLock;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.OSFile;
import com.iscobol.io.BufferedOSFile;
import com.iscobol.io.DynamicRelative;
import com.iscobol.rts.Config;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.util.Enumeration;

public class DynamicLSeq8bit
extends DynamicRelative
implements RuntimeErrorsNumbers {
    protected static byte[] eol = System.getProperty("line.separator", "\n").getBytes();
    protected boolean stripTrailingSpace;
    protected long currPos;
    protected int currLen;
    protected byte[] buffer;

    @Override
    protected OSFile getOSFile(boolean xLock) {
        if (xLock) {
            return new BufferedOSFile();
        }
        return new OSFile();
    }

    public int tailTrim(byte[] buf, int offs, int maxLen) {
        int end;
        int Return2;
        for (Return2 = end = offs + maxLen - 1; Return2 >= offs && buf[Return2] == 32; --Return2) {
        }
        if (++Return2 < this.minRecordSize) {
            Return2 = this.minRecordSize;
        }
        return Return2;
    }

    protected void fillSpace(byte[] record, int offs, int end) {
        for (int j = offs; j < end; ++j) {
            record[j] = 32;
        }
    }

    @Override
    public long getNumRecords() {
        long Return2 = 0L;
        if (this.theFile != null && !this.stripTrailingSpace) {
            try {
                Return2 = this.theFile.length() / (long)(this.maxRecordSize + eol.length);
            }
            catch (IsamException isamException) {
                // empty catch block
            }
        }
        return Return2;
    }

    private synchronized void unlockAll() throws IsamException {
        Enumeration en = this.allLocks.elements();
        while (en.hasMoreElements()) {
            FLock lck = (FLock)en.nextElement();
            lck.l_type = (short)2;
            this.theFile.fcntl(6, lck);
        }
        this.allLocks.clear();
    }

    protected synchronized void lock(long pos, int len) throws IsamException {
        if (this.exclusiveLock) {
            return;
        }
        FLock lck = new FLock();
        try {
            lck.l_whence = 0;
            lck.l_start = pos;
            lck.l_len = len;
            lck.l_type = this.readLock || this.openMode == 1 ? (short)0 : 1;
            if (!this.multipleLock) {
                this.unlockAll();
            }
            this.theFile.fcntl(6, lck);
            this.allLocks.put(new Long(pos), lck);
        }
        catch (IsamException ex) {
            if (ex.getIserrno() == 113) {
                throw new IsamException(107);
            }
            throw ex;
        }
    }

    @Override
    public int open(String path, int openType, int lockType, KeyDescription[] k, int maxRec, int minRec, int nKeys, int accessMode, boolean optional, boolean assignExt) {
        this.stripTrailingSpace = Config.getProperty(".file.strip_trailing_spaces", ".strip_trailing_spaces", false);
        int Return2 = super.open(path, openType, lockType, k, maxRec, minRec, nKeys, accessMode, optional, assignExt);
        if (Return2 == 1) {
            if (this.stripTrailingSpace) {
                this.minRecordSize = Config.getProperty(".file.min_rec_size", ".min_rec_size", 1);
                if (this.minRecordSize < 0) {
                    this.minRecordSize = 0;
                }
            }
            this.buffer = new byte[this.maxRecordSize + eol.length];
        }
        return Return2;
    }

    @Override
    public long write(byte[] record, int offs, int len, boolean lock) {
        block6: {
            this.errno = 0;
            if (len > this.maxRecordSize) {
                len = this.maxRecordSize;
            }
            try {
                long fLen = this.theFile.length();
                if (this.openMode == 6 || this.currPos == fLen) {
                    this.theFile.seek(this.theFile.length());
                    if (this.stripTrailingSpace) {
                        this.currLen = this.tailTrim(record, offs, len);
                        this.theFile.write(record, offs, this.currLen);
                    } else {
                        this.currLen = len;
                        this.theFile.write(record, offs, this.currLen);
                    }
                    this.theFile.write(eol, 0, eol.length);
                    this.currPos += (long)(this.currLen + eol.length);
                    break block6;
                }
                this.errno = 101;
                return 0L;
            }
            catch (IsamException _ex) {
                this.currLen = 0;
                return this.mapError(_ex);
            }
        }
        return 1L;
    }

    @Override
    public long rewrite(byte[] record, int offs, int len, boolean lock) {
        this.errno = 0;
        if (len > this.maxRecordSize) {
            len = this.maxRecordSize;
        }
        if (this.currPos == 0L || this.currPos - (long)this.currLen - (long)eol.length < 0L) {
            this.errno = -2;
            return 0L;
        }
        try {
            int rlen;
            this.theFile.seek(this.currPos - (long)this.currLen - (long)eol.length);
            if (this.stripTrailingSpace && (rlen = this.tailTrim(record, offs, len)) > this.currLen) {
                this.errno = -1;
                return 0L;
            }
            this.theFile.write(record, offs, this.currLen);
            this.theFile.write(eol, 0, eol.length);
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return 1L;
    }

    @Override
    public long delete(byte[] record, int offs) {
        this.errno = -3;
        return 0L;
    }

    @Override
    public synchronized long next(byte[] record, int offs, int lock) {
        int len = record.length - offs;
        this.errno = 0;
        if (len > this.maxRecordSize) {
            len = this.maxRecordSize;
        }
        if (this.theFile == null) {
            return this.mapError(new IsamException(110));
        }
        try {
            int j;
            int i;
            boolean eolFound = false;
            this.theFile.seek(this.currPos);
            int rc = this.theFile.read(this.buffer, offs, len + eol.length);
            if (rc <= 0) {
                return this.mapError(new IsamException(110));
            }
            int toCheck = rc < len ? rc : len;
            for (i = 0; i < toCheck; ++i) {
                if (this.buffer[i] == eol[0]) {
                    eolFound = true;
                    for (j = 1; j < eol.length; ++j) {
                        if (this.buffer[i + j] == eol[j]) continue;
                        eolFound = false;
                        break;
                    }
                }
                if (eolFound) break;
            }
            if (!eolFound && i < rc && this.buffer[i] == eol[0]) {
                eolFound = true;
                for (j = 1; j < eol.length; ++j) {
                    if (this.buffer[i + j] == eol[j]) continue;
                    eolFound = false;
                    break;
                }
            }
            this.currLen = i;
            if (lock > 0) {
                this.lock(this.currPos, this.currLen);
            }
            this.currPos = eolFound ? (this.currPos += (long)(i + eol.length)) : (this.currPos += (long)i);
            System.arraycopy(this.buffer, 0, record, offs, i);
            this.fillSpace(record, offs + i, offs + len);
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return this.currLen;
    }

    @Override
    public synchronized long previous(byte[] record, int offs, int lock) {
        boolean eolFound = false;
        int len = record.length - offs;
        this.errno = 0;
        if (len > this.maxRecordSize) {
            len = this.maxRecordSize;
        }
        if (this.theFile == null) {
            return this.mapError(new IsamException(110));
        }
        if (this.currPos == 0L || this.currPos - (long)this.currLen - (long)eol.length - (long)eol.length < 0L) {
            return this.mapError(new IsamException(110));
        }
        try {
            int rl;
            long ppos = this.currPos - (long)this.currLen - (long)eol.length;
            if (ppos > (long)(this.maxRecordSize + eol.length)) {
                this.theFile.seek(ppos - (long)this.maxRecordSize - (long)eol.length);
                rl = this.maxRecordSize + eol.length;
            } else {
                rl = (int)ppos;
                this.theFile.seek(0L);
            }
            int rc = this.theFile.read(this.buffer, 0, rl);
            int i = eol.length - 1;
            int j = 1;
            while (i >= 0 && this.buffer[rc - j] == eol[i]) {
                --i;
                ++j;
            }
            if (i >= 0) {
                return this.mapError(new IsamException(105));
            }
            rc -= eol.length;
            while (--rc >= 0) {
                if (this.buffer[rc] == eol[eol.length - 1]) {
                    eolFound = true;
                    for (j = eol.length - 2; j >= 0; --j) {
                        if (this.buffer[rc - (eol.length - 1) + j] == eol[j]) continue;
                        eolFound = false;
                        break;
                    }
                }
                if (!eolFound) continue;
            }
            this.currPos -= (long)(this.currLen + eol.length);
            this.currLen = rl - ++rc - eol.length;
            System.arraycopy(this.buffer, rc, record, offs, this.currLen);
            this.fillSpace(record, offs + this.currLen, offs + len);
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return this.currLen;
    }

    @Override
    public long read(byte[] record, int offs, int keyNum, int lock) {
        this.errno = -3;
        return 0L;
    }

    @Override
    public long read(byte[] record, int offs, KeyDescription key, int lock) {
        this.errno = -3;
        return 0L;
    }

    private long start(byte[] record, int offs, int keyLen, int mode) {
        if (this.theFile == null) {
            return this.mapError(new IsamException(111));
        }
        if (mode == 0) {
            this.currPos = 0L;
            this.currLen = 0;
        } else if (mode == 1) {
            try {
                this.currPos = this.theFile.length() + (long)eol.length;
                this.currLen = 0;
            }
            catch (IsamException _ex) {
                return this.mapError(_ex);
            }
        } else {
            this.errno = -3;
            return 0L;
        }
        return 1L;
    }

    @Override
    public long start(byte[] record, int offs, int kNum, int kSize, int mode) {
        return this.start(record, offs, kSize, mode);
    }

    @Override
    public long start(byte[] record, int offs, KeyDescription k, int kSize, int mode) {
        return this.start(record, offs, kSize, mode);
    }

    @Override
    public int unlock() {
        try {
            this.unlockAll();
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return 1;
    }
}

