/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.DataStream;
import com.iscobol.io.FileStatusDefault;

public class FileStatusVax
extends FileStatusDefault {
    @Override
    public int map(int type, String extFs, DataStream cf, int op) {
        if (extFs != null && extFs.length() > 0) {
            cf.setExtendedStatus(extFs);
        }
        switch (type) {
            case 200: {
                cf.setFileStatus("00");
                cf.setStatusMessage("duplicate key detected");
                type = 0;
                break;
            }
            case 110: {
                cf.setFileStatus("13");
                cf.setStatusMessage("end/begin of file");
                break;
            }
            case 131: {
                cf.setFileStatus("39");
                cf.setStatusMessage("invalid permission");
                cf.setExtendedStatus("07");
                break;
            }
            case 101: {
                switch (op) {
                    default: {
                        cf.setFileStatus("42");
                        break;
                    }
                    case 10: {
                        cf.setFileStatus("94");
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 262: 
                    case 263: 
                    case 264: {
                        cf.setFileStatus("47");
                        cf.setExtendedStatus("02");
                        break;
                    }
                    case 3: {
                        cf.setFileStatus("48");
                        cf.setExtendedStatus("02");
                        break;
                    }
                    case 4: 
                    case 5: {
                        cf.setFileStatus("49");
                        cf.setExtendedStatus("02");
                    }
                }
                cf.setStatusMessage("file not open");
                break;
            }
            case 107: {
                cf.setFileStatus("92");
                cf.setStatusMessage("record locked");
                break;
            }
            case 129: {
                cf.setFileStatus("9C");
                cf.setStatusMessage("no more locks available");
                break;
            }
            case 113: {
                cf.setFileStatus("91");
                cf.setStatusMessage("file locked");
                break;
            }
            case 104: {
                cf.setFileStatus("97");
                cf.setStatusMessage("too many files open");
                break;
            }
            default: {
                type = super.map(type, extFs, cf, op);
            }
        }
        return type;
    }
}

