/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.report;

import com.iscobol.io.CobolFile;
import com.iscobol.io.CobolIOException;
import com.iscobol.report.ReportGroup;
import com.iscobol.report.ReportVariable;
import com.iscobol.rts.CobValue;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import java.util.Iterator;
import java.util.Vector;

public class ReportWriter
implements RuntimeErrorsNumbers {
    public static final int LINE_MASK = 0xFFFFFFF;
    public static final int LINE_PLUS = 0x10000000;
    public static final int LINE_PAGE = 0x20000000;
    private String name;
    private CobolFile file;
    private String fileName;
    private int fileOpt;
    private Vector controls = new Vector();
    private Object[][] cntrlsVal;
    private ReportGroup reportHeading;
    private ReportGroup pageHeading;
    private Vector controlHeadings = new Vector();
    private Vector details = new Vector();
    private Vector controlFootings = new Vector();
    private ReportGroup finalControlFooting;
    private ReportGroup pageFooting;
    private ReportGroup reportFooting;
    private Vector allDetailVar = new Vector();
    private Vector allControlFootingVar = new Vector();
    private ReportGroup lastVar;
    private ReportGroup lastDetail;
    private ReportGroup lastControlFooting;
    final int lineLimit;
    private int pageSize;
    private int headingLine;
    private int firstDetailLine;
    private int lastDetailLine;
    private int footingLine;
    private ICobolVar line_counter;
    private ICobolVar page_counter;
    private ICobolVar print_switch;
    private int afterAdv;
    private int colCounter;
    private int _lineCounter;
    private int pageCounter;
    private byte[] blanks;
    private ICobolVar buffer;

    public ReportWriter(int n) {
        this(n, 2);
    }

    public ReportWriter(int n, int fOpt) {
        this.fileOpt = fOpt;
        this.lineLimit = n;
        this.blanks = new byte[n];
        for (int i = n - 1; i >= 0; --i) {
            this.blanks[i] = 32;
        }
    }

    private int lineCounter() {
        return this._lineCounter;
    }

    private void lineCounterAdd(int i) {
        this._lineCounter += i;
    }

    private void lineCounterInit() {
        this._lineCounter = 0;
    }

    private void lineCounterReset() {
        this._lineCounter = 0;
    }

    public ReportWriter setPage(int n) {
        this.pageSize = n;
        return this;
    }

    public ReportWriter setHeading(int n) {
        this.headingLine = n;
        return this;
    }

    public ReportWriter setFirstDetail(int n) {
        this.firstDetailLine = n;
        return this;
    }

    public ReportWriter setLastDetail(int n) {
        this.lastDetailLine = n;
        return this;
    }

    public ReportWriter setFooting(int n) {
        this.footingLine = n;
        return this;
    }

    public ReportWriter setControl(ICobolVar v) {
        this.controls.add(v);
        return this;
    }

    public ReportWriter setFinalControl(ICobolVar v) {
        this.controls.add(0, v);
        return this;
    }

    public void setReportHeading(ReportGroup rv, int line, int nxtGrp) {
        this.lastVar = this.reportHeading = rv;
        rv.setGroupLine(line);
        rv.setNextGroup(nxtGrp);
    }

    public void setPageHeading(ReportGroup rv, int line, int nxtGrp) {
        this.lastVar = this.pageHeading = rv;
        rv.setGroupLine(line);
        rv.setNextGroup(nxtGrp);
    }

    public void setControlHeading(ReportGroup rv, int line, int nxtGrp, ICobolVar ctrlVar) {
        this.lastVar = rv;
        this.controlHeadings.add(this.lastVar);
        rv.setGroupLine(line);
        rv.setNextGroup(nxtGrp);
        rv.setControl(ctrlVar);
    }

    public void setDetail(ReportGroup rv, int line, int nxtGrp) {
        this.lastDetail = this.lastVar = rv;
        this.details.add(this.lastVar);
        rv.setGroupLine(line);
        rv.setNextGroup(nxtGrp);
    }

    public void setControlFooting(ReportGroup rv, int line, int nxtGrp, ICobolVar ctrlVar) {
        this.lastControlFooting = this.lastVar = rv;
        this.controlFootings.add(this.lastVar);
        rv.setGroupLine(line);
        rv.setNextGroup(nxtGrp);
        if (ctrlVar == null) {
            this.finalControlFooting = rv;
        } else {
            rv.setControl(ctrlVar);
        }
    }

    public void setPageFooting(ReportGroup rv, int line, int nxtGrp) {
        this.lastVar = this.pageFooting = rv;
        rv.setGroupLine(line);
        rv.setNextGroup(nxtGrp);
    }

    public void setReportFooting(ReportGroup rv, int line, int nxtGrp) {
        this.lastVar = this.reportFooting = rv;
        rv.setGroupLine(line);
        rv.setNextGroup(nxtGrp);
    }

    public void addVar(ReportVariable rv) {
        this.lastVar.addVar(rv);
        rv.parent = this.lastVar;
        if (this.lastVar == this.lastDetail) {
            this.allDetailVar.add(rv);
        } else if (this.lastVar == this.lastControlFooting) {
            this.allControlFootingVar.add(rv);
        }
    }

    private void newPage() throws CobolIOException {
        if (this.lineCounter() > 0) {
            this.file.writeAdvancing(2, this.pageSize - this.lineCounter() + 1, false, 0, 1);
        }
        this.lineCounterReset();
        this.afterAdv = 0;
        ++this.pageCounter;
        if (this.page_counter != null) {
            this.page_counter.set(this.pageCounter);
        }
    }

    private void bodyAdvance(int line, boolean doFlush) {
        this.advance(line, doFlush, this.footingLine);
    }

    private void advance(int line, boolean doFlush) {
        this.advance(line, doFlush, this.pageSize);
    }

    private void advance(int line, boolean doFlush, int maxLine) {
        if (line != 0) {
            if ((line & 0x20000000) != 0) {
                if (doFlush) {
                    this.flush();
                }
                this.newPage();
                this.afterAdv = line & 0xFFFFFFF;
            } else if ((line & 0x10000000) != 0) {
                int plus = line & 0xFFFFFFF;
                if (maxLine > 0 && plus + this.lineCounter() > maxLine) {
                    plus = maxLine - this.lineCounter();
                }
                if (plus >= 0) {
                    if (doFlush) {
                        this.flush();
                    }
                    this.afterAdv += plus;
                }
            } else if (line > this.lineCounter() + this.afterAdv) {
                if (doFlush) {
                    this.flush();
                }
                this.afterAdv = line - this.lineCounter();
            } else if (line < this.lineCounter() + this.afterAdv) {
                if (doFlush) {
                    this.flush();
                }
                this.newPage();
                this.afterAdv = line & 0xFFFFFFF;
            }
        }
        if (this.line_counter != null) {
            this.line_counter.set(this.lineCounter() + this.afterAdv);
        }
    }

    public void initiate(CobolFile f, CobValue v, CobValue lc, CobValue pc) {
        this.initiate(f, v, lc, pc, null);
    }

    public void initiate(CobolFile f, CobValue v, CobValue lc, CobValue pc, CobValue pw) {
        int i;
        this.file = f;
        this.fileName = v.toString();
        if (this.reportHeading != null) {
            this.reportHeading.init();
        }
        if (this.pageHeading != null) {
            this.pageHeading.init();
        }
        for (i = 0; i < this.controlHeadings.size(); ++i) {
            ((ReportGroup)this.controlHeadings.elementAt(i)).init();
        }
        for (i = 0; i < this.details.size(); ++i) {
            ((ReportGroup)this.details.elementAt(i)).init();
        }
        for (i = 0; i < this.controlFootings.size(); ++i) {
            ((ReportGroup)this.controlFootings.elementAt(i)).init();
        }
        if (this.pageFooting != null) {
            this.pageFooting.init();
        }
        if (this.reportFooting != null) {
            this.reportFooting.init();
        }
        if (lc != null) {
            this.line_counter = lc.ieval();
            this.line_counter.set(0);
        }
        if (pc != null) {
            this.page_counter = pc.ieval();
            this.page_counter.set(1);
        }
        if (pw != null) {
            this.print_switch = pw.ieval();
            this.print_switch.set(0);
        }
        this.colCounter = 0;
        this.lineCounterInit();
        this.pageCounter = 1;
        this.file.updateBuffer(this.blanks);
        if (this.controls.size() > 0) {
            this.cntrlsVal = new Object[this.controls.size()][4];
            new ControlsScanner(){

                @Override
                boolean element(int i) {
                    ICobolVar cv = (ICobolVar)ReportWriter.this.controls.elementAt(i);
                    ((ReportWriter)ReportWriter.this).cntrlsVal[i][0] = cv;
                    byte[] cb = cv.getBytes();
                    ((ReportWriter)ReportWriter.this).cntrlsVal[i][1] = new byte[cv.length()];
                    System.arraycopy(cb, 0, ReportWriter.this.cntrlsVal[i][1], 0, cv.length());
                    ((ReportWriter)ReportWriter.this).cntrlsVal[i][2] = new byte[cv.length()];
                    return true;
                }
            }.scan();
        }
        this.initiateSum();
    }

    private void lookForSource(CobValue cv, ReportVariable v) {
        int j;
        ReportGroup[] upon;
        ReportVariable rv;
        int i;
        ReportVariable found = null;
        for (i = 0; i < this.allDetailVar.size(); ++i) {
            rv = (ReportVariable)this.allDetailVar.elementAt(i);
            if (rv.source == null || rv.source.ieval() != cv.ieval()) continue;
            upon = v.getUpon();
            if (upon != null) {
                for (j = 0; j < upon.length; ++j) {
                    if (upon[j] != rv.parent) continue;
                    found = rv;
                    found.setToSum(v);
                }
                continue;
            }
            found = rv;
            found.setToSum(v);
        }
        if (found == null) {
            upon = v.getUpon();
            ReportGroup rg = null;
            for (int i2 = 0; i2 < this.allDetailVar.size(); ++i2) {
                rv = (ReportVariable)this.allDetailVar.elementAt(i2);
                if (rg == rv.parent) continue;
                rg = rv.parent;
                if (upon != null) {
                    for (int j2 = 0; j2 < upon.length; ++j2) {
                        if (upon[j2] != rg) continue;
                        rg.setSum(v, cv);
                    }
                    continue;
                }
                rg.setSum(v, cv);
            }
        }
        for (i = 0; i < this.allControlFootingVar.size() && (rv = (ReportVariable)this.allControlFootingVar.elementAt(i)) != v; ++i) {
            if (rv.data == null || rv.data.ieval() != cv.ieval()) continue;
            upon = v.getUpon();
            if (upon != null) {
                for (j = 0; j < upon.length; ++j) {
                    if (upon[j] != rv.parent) continue;
                    rv.setToSum(v);
                }
                continue;
            }
            rv.setToSum(v);
        }
    }

    private void initiateSum() {
        for (int i = 0; i < this.allControlFootingVar.size(); ++i) {
            int j;
            ReportVariable rv = (ReportVariable)this.allControlFootingVar.elementAt(i);
            CobValue[] cva = rv.getSum();
            if (cva != null) {
                for (j = 0; j < cva.length; ++j) {
                    this.lookForSource(cva[j], rv);
                }
            }
            if (rv.reset == null) continue;
            for (j = 0; j < this.cntrlsVal.length; ++j) {
                if (rv.reset != this.cntrlsVal[j][0]) continue;
                this.cntrlsVal[j][3] = rv;
            }
        }
    }

    private void pageStart() {
        this.afterAdv = 0;
        if (this.headingLine > 0) {
            this.afterAdv += this.headingLine - 1;
        }
        if (this.pageCounter == 1 && this.reportHeading != null) {
            this.print(this.reportHeading);
        }
        if (this.pageHeading != null) {
            this.print(this.pageHeading);
        }
        if (this.firstDetailLine != 0) {
            this.afterAdv = this.firstDetailLine - this.lineCounter() - 1;
        }
    }

    private void flush() throws CobolIOException {
        if (this.lineCounter() == 0) {
            this.lineCounterAdd(1);
            --this.afterAdv;
        }
        if (this.buffer != null) {
            this.file.updateBuffer(this.buffer.getBytes());
        }
        this.file.writeAdvancing(1, this.afterAdv, false, this.lineLimit, this.fileOpt);
        this.lineCounterAdd(this.afterAdv);
        this.afterAdv = 0;
        this.file.updateBuffer(this.blanks);
        if (this.buffer != null) {
            this.buffer.set(this.blanks);
        }
    }

    private void print(ReportGroup p) {
        this.print(p, true);
    }

    private void print(ReportGroup p, boolean advNxtGrp) {
        if (this.print_switch != null) {
            this.printNew(p, advNxtGrp);
        } else {
            this.printOld(p, advNxtGrp);
        }
    }

    private void printNew(ReportGroup p, boolean advNxtGrp) {
        ReportVariable rv;
        p.evalSums();
        Iterator it = p.iterator();
        while (it.hasNext()) {
            rv = (ReportVariable)it.next();
            rv.evalBefore();
        }
        this.print_switch.set(0);
        p.declaratives();
        if (this.print_switch.toint() != 1) {
            boolean doFlush = false;
            if (p.getGroupLine() > 0) {
                this.advance(p.getGroupLine(), doFlush);
                doFlush = true;
            }
            this.buffer = null;
            Iterator it2 = p.iterator();
            while (it2.hasNext()) {
                rv = (ReportVariable)it2.next();
                this.advance(rv.line, doFlush);
                if (rv.memory != null) {
                    this.buffer = rv.memory;
                }
                rv.evalAfter();
                doFlush = true;
            }
            if (advNxtGrp) {
                this.advance(p.nextGroup, true);
                if ((p.nextGroup & 0x20000000) == 0) {
                    this.flush();
                }
            }
        }
    }

    private void printOld(ReportGroup p, boolean advNxtGrp) {
        boolean doFlush = false;
        if (p.getGroupLine() > 0) {
            this.advance(p.getGroupLine(), doFlush);
            doFlush = true;
        }
        this.buffer = null;
        Iterator it = p.iterator();
        while (it.hasNext()) {
            ReportVariable rv = (ReportVariable)it.next();
            this.advance(rv.line, doFlush);
            if (rv.memory != null) {
                this.buffer = rv.memory;
            }
            rv.eval();
            doFlush = true;
        }
        if (advNxtGrp) {
            this.advance(p.nextGroup, true);
            this.flush();
        }
    }

    private static boolean differs(ICobolVar cv, byte[] vl) {
        byte[] cb = cv.getBytes();
        for (int i = vl.length - 1; i >= 0; --i) {
            if (cb[i] == vl[i]) continue;
            return true;
        }
        return false;
    }

    private int findControlBreak() {
        int Return2 = new ControlsScanner(){

            @Override
            boolean element(int i) {
                return !ReportWriter.differs((ICobolVar)ReportWriter.this.cntrlsVal[i][0], (byte[])ReportWriter.this.cntrlsVal[i][1]);
            }
        }.revScan();
        if (Return2 != -1) {
            for (int i = this.allDetailVar.size() - 1; i >= 0; --i) {
                ((ReportVariable)this.allDetailVar.elementAt(i)).ctrlBreak();
            }
        }
        return Return2;
    }

    private int printControlHeading() {
        int Return2 = this.findControlBreak();
        this.printControlHeading(Return2);
        return Return2;
    }

    private void printControlHeading(int ctBr) {
        if (ctBr != -1) {
            new ControlsScanner(){

                @Override
                boolean element(int i) {
                    for (int j = 0; j < ReportWriter.this.controlHeadings.size(); ++j) {
                        ReportGroup rv = (ReportGroup)ReportWriter.this.controlHeadings.elementAt(j);
                        if (rv.control != ReportWriter.this.cntrlsVal[i][0]) continue;
                        ReportWriter.this.print(rv);
                    }
                    return true;
                }
            }.scan(ctBr);
        }
    }

    private int updateControls() {
        int Return2 = this.findControlBreak();
        this.updateControls(Return2);
        return Return2;
    }

    private void updateControls(int ctBr) {
        if (ctBr != -1) {
            new ControlsScanner(){

                @Override
                boolean element(int i) {
                    System.arraycopy(((ICobolVar)ReportWriter.this.cntrlsVal[i][0]).getBytes(), 0, ReportWriter.this.cntrlsVal[i][1], 0, ((byte[])ReportWriter.this.cntrlsVal[i][1]).length);
                    return true;
                }
            }.scan(ctBr);
        }
    }

    private int printControlFooting() {
        int Return2 = this.findControlBreak();
        this.printControlFooting(Return2);
        return Return2;
    }

    private void printControlFooting(int ctBr) {
        if (ctBr != -1) {
            final int[] nextGroup = new int[]{0};
            new ControlsScanner(){

                @Override
                boolean element(int i) {
                    ICobolVar cv = (ICobolVar)ReportWriter.this.cntrlsVal[i][0];
                    byte[] cb = cv.getBytes();
                    System.arraycopy(cb, 0, ReportWriter.this.cntrlsVal[i][2], 0, cv.length());
                    cv.set((byte[])ReportWriter.this.cntrlsVal[i][1]);
                    return true;
                }
            }.scan(ctBr);
            new ControlsScanner(){

                @Override
                boolean element(int i) {
                    for (int j = 0; j < ReportWriter.this.controlFootings.size(); ++j) {
                        ReportGroup rv = (ReportGroup)ReportWriter.this.controlFootings.elementAt(j);
                        if (rv.control != ReportWriter.this.cntrlsVal[i][0]) continue;
                        ReportWriter.this.print(rv, false);
                        if (rv.nextGroup > nextGroup[0]) {
                            nextGroup[0] = rv.nextGroup;
                        }
                        ReportWriter.this.flush();
                    }
                    return true;
                }
            }.scan(ctBr);
            if (nextGroup[0] > 0) {
                this.bodyAdvance(nextGroup[0], false);
                this.flush();
            }
            new ControlsScanner(){

                @Override
                boolean element(int i) {
                    ICobolVar cv = (ICobolVar)ReportWriter.this.cntrlsVal[i][0];
                    cv.set((byte[])ReportWriter.this.cntrlsVal[i][2]);
                    return true;
                }
            }.scan(ctBr);
            if (this.cntrlsVal[ctBr][3] != null) {
                ((ReportVariable)this.cntrlsVal[ctBr][3]).resetSum();
            }
        }
    }

    private void printReportFooting() {
        if (this.pageFooting != null) {
            this.print(this.pageFooting);
        }
        if (this.reportFooting != null) {
            this.print(this.reportFooting);
        }
        this.newPage();
    }

    private void printPageFooting() {
        if (this.pageFooting != null) {
            this.print(this.pageFooting);
        }
        this.newPage();
    }

    private int beforePrint(ReportGroup p) {
        boolean doCtrlFoot = this.lineCounter() != 0 || this.pageCounter != 1;
        int endDetail = this.lineCounter() + p.getVSize() - 1;
        if (this.file == null) {
            throw new IscobolRuntimeException(29, "");
        }
        int ctBr = -2;
        if (this.lastDetailLine > 0 && endDetail >= this.lastDetailLine) {
            if (this.footingLine > this.lastDetailLine) {
                ctBr = this.printControlFooting();
            }
            this.printPageFooting();
        } else if (this.footingLine > 0 && endDetail >= this.footingLine) {
            this.printPageFooting();
        }
        if (this.lineCounter() == 0) {
            this.pageStart();
        }
        if (doCtrlFoot && ctBr == -2) {
            ctBr = this.printControlFooting();
            endDetail = this.lineCounter() + p.getVSize() - 1;
            if (this.lastDetailLine > 0 && endDetail >= this.lastDetailLine || this.footingLine > 0 && endDetail >= this.footingLine || endDetail >= this.pageSize) {
                this.printPageFooting();
                this.pageStart();
            }
        }
        ctBr = this.printControlHeading();
        return ctBr;
    }

    private void afterPrint(int ctBr) {
        this.updateControls(ctBr);
        this.line_counter.set(this.lineCounter());
        this.page_counter.set(this.pageCounter);
    }

    public void generate(ReportGroup p) {
        int ctBr = this.beforePrint(p);
        this.print(p);
        this.afterPrint(ctBr);
    }

    public void generate(ReportGroup p, int opt) {
        this.fileOpt = opt;
        this.generate(p);
    }

    public void generate() {
        if (this.file == null) {
            throw new IscobolRuntimeException(29, "");
        }
        if (this.details.size() == 0) {
            return;
        }
        ReportGroup p = (ReportGroup)this.details.elementAt(0);
        int ctBr = this.beforePrint(p);
        Iterator it = p.iterator();
        while (it.hasNext()) {
            ((ReportVariable)it.next()).eval();
        }
        this.file.updateBuffer(this.blanks);
        this.afterPrint(ctBr);
    }

    public void generate(int opt) {
        this.fileOpt = opt;
        this.generate();
    }

    public void terminate() {
        if (this.file == null) {
            throw new IscobolRuntimeException(29, "");
        }
        if (this.cntrlsVal != null) {
            new ControlsScanner(){

                @Override
                boolean element(int i) {
                    for (int j = 0; j < ReportWriter.this.controlFootings.size(); ++j) {
                        ReportGroup rv = (ReportGroup)ReportWriter.this.controlFootings.elementAt(j);
                        if (rv.control != ReportWriter.this.cntrlsVal[i][0]) continue;
                        ReportWriter.this.print(rv, false);
                        ReportWriter.this.flush();
                    }
                    return true;
                }
            }.scan();
        }
        if (this.finalControlFooting != null) {
            this.print(this.finalControlFooting, false);
            this.flush();
        }
        this.printReportFooting();
        this.line_counter.set(this.lineCounter());
        this.page_counter.set(this.pageCounter);
        this.file = null;
    }

    private abstract class ControlsScanner {
        static final int NO_CTRL = -1;
        static final int INVALID = -2;

        private ControlsScanner() {
        }

        int scan() {
            return this.scan(0);
        }

        int scan(int start) {
            int Return2 = -1;
            if (ReportWriter.this.cntrlsVal != null) {
                for (Return2 = ReportWriter.this.cntrlsVal.length - 1; Return2 >= start && this.element(Return2); --Return2) {
                }
            }
            return Return2;
        }

        int revScan() {
            int Return2 = -1;
            if (ReportWriter.this.cntrlsVal != null) {
                for (Return2 = 0; Return2 < ReportWriter.this.cntrlsVal.length && this.element(Return2); ++Return2) {
                }
                if (Return2 == ReportWriter.this.cntrlsVal.length) {
                    Return2 = -1;
                }
            }
            return Return2;
        }

        abstract boolean element(int var1);
    }
}

