/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rmi;

import com.iscobol.gui.ParamVector;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.logger.Logger;
import com.iscobol.rmi.IsExternalizable;
import com.iscobol.rmi.server.ServerRemoteObject;
import com.iscobol.rpc.dualrpc.common.RpcCallPayload;
import com.iscobol.rpc.dualrpc.common.RpcFaultPayload;
import com.iscobol.rpc.dualrpc.common.RpcResultPayload;
import com.iscobol.rpc.messageserver.common.IMessageSerializer;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.MessageSerializationException;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.print.RemotePrintCommand;
import com.iscobol.rts.print.RemotePrintResponse;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class IscobolMessageSerializer
implements IMessageSerializer {
    public static final byte TYPE_UNKNOWN = -1;
    public static final byte TYPE_UNKNOWN_COMPRESS = -2;
    public static final byte TYPE_NULL = 0;
    public static final byte TYPE_BOOLEAN = 1;
    public static final byte TYPE_INT = 2;
    public static final byte TYPE_FLOAT = 3;
    public static final byte TYPE_LONG = 4;
    public static final byte TYPE_BYTE = 5;
    public static final byte TYPE_CHAR = 6;
    public static final byte TYPE_SHORT = 7;
    public static final byte TYPE_DOUBLE = 8;
    public static final byte TYPE_STRING = 9;
    public static final byte TYPE_A_BOOLEAN = 10;
    public static final byte TYPE_A_INT = 11;
    public static final byte TYPE_A_FLOAT = 12;
    public static final byte TYPE_A_LONG = 13;
    public static final byte TYPE_A_BYTE = 14;
    public static final byte TYPE_A_CHAR = 15;
    public static final byte TYPE_A_SHORT = 16;
    public static final byte TYPE_A_DOUBLE = 17;
    public static final byte TYPE_A_STRING = 18;
    public static final byte TYPE_RECTANGLE = 19;
    public static final byte TYPE_INSETS = 20;
    public static final byte TYPE_DIMENSION = 21;
    public static final byte TYPE_POINT = 22;
    public static final byte TYPE_RRA = 23;
    public static final byte TYPE_REMOTE = 24;
    public static final byte TYPE_VECTOR_OF_PARAM_ELEMS = 25;
    public static final byte TYPE_JNIWRAPPER_PARAMETER = 26;
    public static final byte TYPE_VECTOR_OF_PARAM_ELEMS_COMPRESS = 27;
    public static final byte TYPE_A_BYTE_COMPRESS = 28;
    public static final byte TYPE_A_R_PRT_CMD = 29;
    public static final byte TYPE_A_R_PRT_CMD_COMPRESS = 30;
    public static final byte TYPE_R_PRT_RESP = 31;
    public static final byte TYPE_IS_EXT = 32;
    public static final byte NO_COMPRESS = 0;
    public static final byte BEST_COMPRESS = 1;
    public static final byte BEST_SPEED_COMPRESS = 2;
    public static Class parameterClass;

    @Override
    public Message deserialize(ObjectInputStream in, Logger log) throws MessageSerializationException {
        try {
            Serializable payload;
            byte payloadType = in.readByte();
            int id = in.readInt();
            switch (payloadType) {
                case 1: {
                    payload = this.deserializeCallPayload(in, log);
                    break;
                }
                case 2: {
                    payload = this.deserializeResultPayload(in, log);
                    break;
                }
                case 3: {
                    payload = this.deserializeFaultPayload(in);
                    break;
                }
                default: {
                    throw new MessageSerializationException("Unknown payload type: " + payloadType);
                }
            }
            return new Message(id, payloadType, payload);
        }
        catch (EOFException eofex) {
            throw new MessageSerializationException(eofex);
        }
        catch (SocketException sex) {
            throw new MessageSerializationException(sex);
        }
        catch (Exception ex) {
            if (log != null) {
                log.severe(IscobolMessageSerializer.stackTraceToString(ex));
            }
            throw new MessageSerializationException(ex);
        }
    }

    static String stackTraceToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    @Override
    public void serialize(Message message, ObjectOutputStream out, Logger log, int compressLevel, int minSizeCompress) throws MessageSerializationException {
        try {
            byte payloadType = message.getPayloadType();
            out.writeByte(payloadType);
            out.writeInt(message.getId());
            Object payload = message.getPayload();
            switch (payloadType) {
                case 1: {
                    this.serializeCallPayload((RpcCallPayload)payload, out, log, compressLevel, minSizeCompress);
                    break;
                }
                case 2: {
                    this.serializeResultPayload((RpcResultPayload)payload, out, log, compressLevel, minSizeCompress);
                    break;
                }
                case 3: {
                    this.serializeFaultPayload((RpcFaultPayload)payload, out);
                    break;
                }
                default: {
                    throw new MessageSerializationException("Unknown payload type: " + payloadType);
                }
            }
        }
        catch (EOFException eofex) {
            throw new MessageSerializationException(eofex);
        }
        catch (SocketException sex) {
            throw new MessageSerializationException(sex);
        }
        catch (Exception ex) {
            if (log != null) {
                log.severe(IscobolMessageSerializer.stackTraceToString(ex));
            }
            throw new MessageSerializationException(ex);
        }
    }

    private RpcCallPayload deserializeCallPayload(ObjectInputStream in, Logger log) throws Exception {
        boolean sendResults = in.readBoolean();
        int objectId = in.readInt();
        short methodId = in.readShort();
        ArrayList<Object> params = null;
        if (objectId < 0) {
            String handlerName = in.readUTF();
            String methodName = in.readUTF();
            byte paramCount = in.readByte();
            params = new ArrayList(paramCount);
            for (byte i = 0; i < paramCount; i = (byte)(i + 1)) {
                params.add(this.deserializeObject(in.readByte(), in, log));
            }
            return new RpcCallPayload(handlerName, methodName, params, sendResults);
        }
        byte paramCount = in.readByte();
        params = new ArrayList<Object>(paramCount);
        for (byte i = 0; i < paramCount; i = (byte)(i + 1)) {
            params.add(this.deserializeObject(in.readByte(), in, log));
        }
        return new RpcCallPayload(objectId, methodId, params, sendResults);
    }

    private RpcResultPayload deserializeResultPayload(ObjectInputStream in, Logger log) throws Exception {
        int callMessageId = in.readInt();
        Object obj = this.deserializeObject(in.readByte(), in, log);
        return new RpcResultPayload(obj, callMessageId);
    }

    private RpcFaultPayload deserializeFaultPayload(ObjectInputStream in) throws Exception {
        String faultCode = in.readUTF();
        String faultMessage = in.readUTF();
        int callMessageId = in.readInt();
        return new RpcFaultPayload(faultCode, faultMessage, callMessageId);
    }

    protected Object deserializeObject(byte type, ObjectInputStream in, Logger log) throws Exception {
        switch (type) {
            case 0: {
                return null;
            }
            case 2: {
                return new Integer(in.readInt());
            }
            case 3: {
                return new Float(in.readFloat());
            }
            case 1: {
                return new Boolean(in.readBoolean());
            }
            case 4: {
                return new Long(in.readLong());
            }
            case 5: {
                return new Byte(in.readByte());
            }
            case 6: {
                return new Character(in.readChar());
            }
            case 8: {
                return new Double(in.readDouble());
            }
            case 7: {
                return new Short(in.readShort());
            }
            case 11: {
                short len = in.readShort();
                int[] retInt = new int[len];
                for (short i = 0; i < len; i = (short)(i + 1)) {
                    retInt[i] = in.readInt();
                }
                return retInt;
            }
            case 28: {
                return IscobolMessageSerializer.readCompress(in);
            }
            case 14: {
                int lenint = in.readInt();
                byte[] retByte = new byte[lenint];
                for (int i = 0; i < lenint; ++i) {
                    retByte[i] = in.readByte();
                }
                return retByte;
            }
            case 12: {
                short len = in.readShort();
                float[] retFloat = new float[len];
                for (short i = 0; i < len; i = (short)(i + 1)) {
                    retFloat[i] = in.readFloat();
                }
                return retFloat;
            }
            case 17: {
                short len = in.readShort();
                double[] retDouble = new double[len];
                for (short i = 0; i < len; i = (short)(i + 1)) {
                    retDouble[i] = in.readDouble();
                }
                return retDouble;
            }
            case 13: {
                short len = in.readShort();
                long[] retLong = new long[len];
                for (short i = 0; i < len; i = (short)(i + 1)) {
                    retLong[i] = in.readLong();
                }
                return retLong;
            }
            case 10: {
                short len = in.readShort();
                boolean[] retBool = new boolean[len];
                for (short i = 0; i < len; i = (short)(i + 1)) {
                    retBool[i] = in.readBoolean();
                }
                return retBool;
            }
            case 16: {
                short len = in.readShort();
                short[] retShort = new short[len];
                for (short i = 0; i < len; i = (short)(i + 1)) {
                    retShort[i] = in.readShort();
                }
                return retShort;
            }
            case 15: {
                short len = in.readShort();
                char[] retChar = new char[len];
                for (short i = 0; i < len; i = (short)(i + 1)) {
                    retChar[i] = in.readChar();
                }
                return retChar;
            }
            case 9: {
                return RtsUtil.readUTF(in);
            }
            case 18: {
                short len = in.readShort();
                String[] retStr = new String[len];
                for (short i = 0; i < len; i = (short)(i + 1)) {
                    retStr[i] = RtsUtil.readUTF(in);
                }
                return retStr;
            }
            case 19: {
                return new Rectangle(in.readInt(), in.readInt(), in.readInt(), in.readInt());
            }
            case 20: {
                return new Insets(in.readInt(), in.readInt(), in.readInt(), in.readInt());
            }
            case 21: {
                return new Dimension(in.readInt(), in.readInt());
            }
            case 22: {
                return new Point(in.readInt(), in.readInt());
            }
            case 25: {
                ParamVector v = new ParamVector();
                v.readExternal(in);
                return v;
            }
            case 27: {
                return this.readCompress(in, new ParamVector());
            }
            case 23: {
                RemoteRecordAccept rra = (RemoteRecordAccept)Class.forName(in.readUTF()).newInstance();
                rra.readExternal(in);
                return rra;
            }
            case 24: {
                ServerRemoteObject sro = (ServerRemoteObject)Class.forName(in.readUTF()).newInstance();
                sro.readExternal(in);
                Object rr = sro.readResolve();
                return rr;
            }
            case 30: {
                final Object[] obj = new Object[1];
                this.readCompress(in, new Externalizable(){

                    @Override
                    public void writeExternal(ObjectOutput out) throws IOException {
                    }

                    @Override
                    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                        RemotePrintCommand[] cmds = new RemotePrintCommand[in.readInt()];
                        for (int i = 0; i < cmds.length; ++i) {
                            cmds[i] = new RemotePrintCommand();
                            cmds[i].readExternal(in);
                        }
                        obj[0] = cmds;
                    }
                });
                return (RemotePrintCommand[])obj[0];
            }
            case 29: {
                RemotePrintCommand[] cmds = new RemotePrintCommand[in.readInt()];
                for (int i = 0; i < cmds.length; ++i) {
                    cmds[i] = new RemotePrintCommand();
                    cmds[i].readExternal(in);
                }
                return cmds;
            }
            case 31: {
                RemotePrintResponse resp = new RemotePrintResponse();
                resp.readExternal(in);
                return resp;
            }
            case 32: {
                IsExternalizable isext = (IsExternalizable)Class.forName(in.readUTF()).newInstance();
                isext.readExternal(in);
                return isext;
            }
            case 26: {
                if (parameterClass != null) {
                    return this.deserializeParameter(in);
                }
            }
            case -2: {
                return IscobolMessageSerializer.readObjectCompress(in, log);
            }
        }
        return IscobolMessageSerializer.readObject(in, log);
    }

    private Object deserializeParameter(ObjectInputStream in) throws Exception {
        Object parameter = Class.forName(in.readUTF()).newInstance();
        int len = in.readInt();
        byte[] bytes = new byte[len];
        in.read(bytes, 0, len);
        parameterClass.getMethod("read", byte[].class, Integer.TYPE).invoke(parameter, bytes, new Integer(0));
        return parameter;
    }

    private void serializeCallPayload(RpcCallPayload payload, ObjectOutputStream out, Logger log, int compressLevel, int minSizeCompress) throws Exception {
        out.writeBoolean(payload.isSendResults());
        int objectId = payload.getObjectId();
        short methodId = payload.getMethodId();
        ArrayList params = payload.getParameters();
        int paramCount = params != null ? (int)params.size() : 0;
        out.writeInt(objectId);
        out.writeShort(methodId);
        if (objectId < 0) {
            out.writeUTF(payload.getHandlerName());
            out.writeUTF(payload.getMethodName());
        }
        out.writeByte(paramCount);
        if (paramCount > 0) {
            for (int i = 0; i < paramCount; i = (int)((byte)(i + 1))) {
                this.serializeObject(params.get(i), out, log, compressLevel, minSizeCompress);
            }
        }
    }

    private void serializeResultPayload(RpcResultPayload payload, ObjectOutputStream out, Logger log, int compressLevel, int minSizeCompress) throws Exception {
        out.writeInt(payload.getOriginatingRpcCallMessageId());
        if (payload.isOldStringTransmission()) {
            out.writeByte(9);
            out.writeUTF((String)payload.getResultObject());
        } else {
            this.serializeObject(payload.getResultObject(), out, log, compressLevel, minSizeCompress);
        }
    }

    private void serializeFaultPayload(RpcFaultPayload payload, ObjectOutputStream out) throws Exception {
        out.writeUTF(payload.getFaultCode());
        out.writeUTF(payload.getFaultMessage());
        out.writeInt(payload.getOriginatingRpcCallMessageId());
    }

    protected void serializeObject(Object obj, ObjectOutputStream out, Logger log, int compressLevel, int minSizeCompress) throws Exception {
        if (obj == null) {
            out.writeByte(0);
            return;
        }
        Class<?> type = obj.getClass();
        if (type == Integer.class) {
            out.writeByte(2);
            out.writeInt((Integer)obj);
        } else if (type == Float.class) {
            out.writeByte(3);
            out.writeFloat(((Float)obj).floatValue());
        } else if (type == Boolean.class) {
            out.writeByte(1);
            out.writeBoolean((Boolean)obj);
        } else if (type == Long.class) {
            out.writeByte(4);
            out.writeLong((Long)obj);
        } else if (type == Byte.class) {
            out.writeByte(5);
            out.writeByte(((Byte)obj).byteValue());
        } else if (type == Double.class) {
            out.writeByte(8);
            out.writeDouble((Double)obj);
        } else if (type == Short.class) {
            out.writeByte(7);
            out.writeShort(((Short)obj).shortValue());
        } else if (type == Character.class) {
            out.writeByte(6);
            out.writeChar(((Character)obj).charValue());
        } else if (type == String.class) {
            out.writeByte(9);
            RtsUtil.writeUTF((String)obj, out);
        } else if (type == int[].class) {
            out.writeByte(11);
            int[] aint = (int[])obj;
            out.writeShort((short)aint.length);
            for (int i = 0; i < aint.length; ++i) {
                out.writeInt(aint[i]);
            }
        } else if (type == byte[].class) {
            byte[] abyte = (byte[])obj;
            if (abyte.length > minSizeCompress && (compressLevel == 1 || compressLevel == 2)) {
                out.writeByte(28);
                IscobolMessageSerializer.writeCompress(abyte, compressLevel, out);
            } else {
                out.writeByte(14);
                out.writeInt(abyte.length);
                for (int i = 0; i < abyte.length; ++i) {
                    out.writeByte(abyte[i]);
                }
            }
        } else if (type == boolean[].class) {
            out.writeByte(10);
            boolean[] abool = (boolean[])obj;
            out.writeShort((short)abool.length);
            for (int i = 0; i < abool.length; ++i) {
                out.writeBoolean(abool[i]);
            }
        } else if (type == float[].class) {
            out.writeByte(12);
            float[] afloat = (float[])obj;
            out.writeShort((short)afloat.length);
            for (int i = 0; i < afloat.length; ++i) {
                out.writeFloat(afloat[i]);
            }
        } else if (type == long[].class) {
            out.writeByte(13);
            long[] along = (long[])obj;
            out.writeShort((short)along.length);
            for (int i = 0; i < along.length; ++i) {
                out.writeLong(along[i]);
            }
        } else if (type == double[].class) {
            out.writeByte(17);
            double[] adouble = (double[])obj;
            out.writeShort((short)adouble.length);
            for (int i = 0; i < adouble.length; ++i) {
                out.writeDouble(adouble[i]);
            }
        } else if (type == char[].class) {
            out.writeByte(15);
            char[] achar = (char[])obj;
            out.writeShort((short)achar.length);
            for (int i = 0; i < achar.length; ++i) {
                out.writeChar(achar[i]);
            }
        } else if (type == short[].class) {
            out.writeByte(16);
            short[] ashort = (short[])obj;
            out.writeShort((short)ashort.length);
            for (int i = 0; i < ashort.length; ++i) {
                out.writeShort(ashort[i]);
            }
        } else if (type == String[].class) {
            out.writeByte(18);
            String[] astr = (String[])obj;
            out.writeShort((short)astr.length);
            for (int i = 0; i < astr.length; ++i) {
                if (astr[i] != null) {
                    RtsUtil.writeUTF(astr[i], out);
                    continue;
                }
                RtsUtil.writeUTF("", out);
            }
        } else if (type == Rectangle.class) {
            out.writeByte(19);
            Rectangle r = (Rectangle)obj;
            out.writeInt(r.x);
            out.writeInt(r.y);
            out.writeInt(r.width);
            out.writeInt(r.height);
        } else if (type == Insets.class) {
            out.writeByte(20);
            Insets is = (Insets)obj;
            out.writeInt(is.top);
            out.writeInt(is.left);
            out.writeInt(is.bottom);
            out.writeInt(is.right);
        } else if (type == Dimension.class) {
            out.writeByte(21);
            Dimension d = (Dimension)obj;
            out.writeInt(d.width);
            out.writeInt(d.height);
        } else if (type == Point.class) {
            out.writeByte(22);
            Point p = (Point)obj;
            out.writeInt(p.x);
            out.writeInt(p.y);
        } else if (type == ParamVector.class) {
            if (compressLevel == 1 || compressLevel == 2) {
                byte[] pvarray = null;
                pvarray = this.object2Bytes((ParamVector)obj);
                if (pvarray != null && pvarray.length > minSizeCompress) {
                    out.writeByte(27);
                    IscobolMessageSerializer.writeCompress(pvarray, compressLevel, out);
                } else {
                    out.writeByte(25);
                    ((ParamVector)obj).writeExternal(out);
                }
            } else {
                out.writeByte(25);
                ((ParamVector)obj).writeExternal(out);
            }
        } else if (RemoteRecordAccept.class.isAssignableFrom(type)) {
            out.writeByte(23);
            out.writeUTF(type.getName());
            ((RemoteRecordAccept)obj).writeExternal(out);
        } else if (ServerRemoteObject.class.isAssignableFrom(type)) {
            out.writeByte(24);
            out.writeUTF(type.getName());
            ((ServerRemoteObject)obj).writeExternal(out);
        } else if (RemotePrintCommand[].class == type) {
            final RemotePrintCommand[] cmds = (RemotePrintCommand[])obj;
            byte[] a = null;
            if (compressLevel == 1 || compressLevel == 2) {
                a = this.object2Bytes(new Externalizable(){

                    @Override
                    public void writeExternal(ObjectOutput out) throws IOException {
                        out.writeInt(cmds.length);
                        for (RemotePrintCommand cmd : cmds) {
                            cmd.writeExternal(out);
                        }
                    }

                    @Override
                    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                    }
                });
                if (a != null && a.length > minSizeCompress) {
                    out.writeByte(30);
                    IscobolMessageSerializer.writeCompress(a, compressLevel, out);
                } else {
                    a = null;
                }
            }
            if (a == null) {
                out.writeByte(29);
                out.writeInt(cmds.length);
                for (RemotePrintCommand cmd : cmds) {
                    cmd.writeExternal(out);
                }
            }
        } else if (RemotePrintResponse.class == type) {
            out.writeByte(31);
            ((RemotePrintResponse)obj).writeExternal(out);
        } else if (IsExternalizable.class.isAssignableFrom(type)) {
            out.writeByte(32);
            out.writeUTF(obj.getClass().getName());
            ((IsExternalizable)obj).writeExternal(out);
        } else if (parameterClass != null && parameterClass.isAssignableFrom(type)) {
            out.writeByte(26);
            this.serializeParameter(obj, out);
        } else {
            IscobolMessageSerializer.writeObject(obj, out, log, compressLevel, minSizeCompress);
        }
    }

    private void serializeParameter(Object parameter, ObjectOutputStream out) throws Exception {
        out.writeUTF(parameter.getClass().getName());
        byte[] bytes = (byte[])parameterClass.getMethod("toByteArray", new Class[0]).invoke(parameter, new Object[0]);
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public static Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
        return IscobolMessageSerializer.readObject(in, null);
    }

    private static Object readObject(ObjectInput in, Logger log) throws IOException, ClassNotFoundException {
        int n = in.readInt();
        byte[] objStream = new byte[n];
        in.readFully(objStream, 0, n);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(objStream));
        Object Ret = ois.readObject();
        ois.close();
        if (log != null) {
            log.warning(IscobolMessageSerializer.class.getName() + ".deserializeObject: type UNKNOWN[" + Ret.getClass().getName() + "].");
        }
        return Ret;
    }

    private static Object readObjectCompress(ObjectInputStream in, Logger log) throws IOException, ClassNotFoundException {
        Object Ret = null;
        byte[] uncompbytes = IscobolMessageSerializer.readCompress(in);
        ByteArrayInputStream bis = new ByteArrayInputStream(uncompbytes);
        ObjectInputStream ois = new ObjectInputStream(bis);
        Ret = ois.readObject();
        ois.close();
        bis.close();
        if (log != null) {
            log.warning(IscobolMessageSerializer.class.getName() + ".deserializeObject: type UNKNOWN_COMPRESS[" + Ret.getClass().getName() + "].");
        }
        return Ret;
    }

    public static void writeObject(Object obj, ObjectOutput out) throws IOException {
        IscobolMessageSerializer.writeObject(obj, out, null, 0, 32768);
    }

    private static void writeObject(Object obj, ObjectOutput out, Logger log, int compressLevel, int minSizeCompress) throws IOException {
        if (log != null) {
            log.warning(IscobolMessageSerializer.class.getName() + ".serializeObject: type UNKNOWN [" + obj.getClass().getName() + "] minSizeCompress [" + minSizeCompress + "] compressLevel [" + compressLevel + "].");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.close();
        byte[] objStream = baos.toByteArray();
        if (objStream.length > minSizeCompress && (compressLevel == 1 || compressLevel == 2)) {
            out.writeByte(-2);
            IscobolMessageSerializer.writeCompress(objStream, compressLevel, (ObjectOutputStream)out);
        } else {
            out.writeByte(-1);
            out.writeInt(objStream.length);
            out.write(objStream, 0, objStream.length);
        }
    }

    @Override
    public Message deserialize(ObjectInputStream in) throws MessageSerializationException {
        return this.deserialize(in, null);
    }

    @Override
    public void serialize(Message message, ObjectOutputStream out) throws MessageSerializationException {
        this.serialize(message, out, null, 0, 32768);
    }

    private byte[] object2Bytes(Externalizable e) {
        byte[] Return2 = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            e.writeExternal(oos);
            oos.flush();
            oos.close();
            bos.close();
            if (bos != null) {
                Return2 = bos.toByteArray();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Return2;
    }

    private static void writeCompress(byte[] input, int compressionLevel, ObjectOutputStream out) throws IOException {
        Deflater deflater = null;
        deflater = compressionLevel == 1 ? new Deflater(9) : new Deflater(1);
        deflater.setInput(input, 0, input.length);
        deflater.finish();
        int compressedSize = 0;
        byte[] buff = new byte[input.length];
        while (true) {
            int subLen = buff.length - compressedSize;
            int len = deflater.deflate(buff, compressedSize, subLen);
            compressedSize += len;
            if (len != subLen) break;
            byte[] tmp = buff;
            buff = new byte[tmp.length * 2];
            System.arraycopy(tmp, 0, buff, 0, tmp.length);
        }
        out.writeInt(compressedSize);
        out.write(buff, 0, compressedSize);
    }

    private static byte[] readCompress(ObjectInputStream in) throws IOException {
        int compressedSize = in.readInt();
        byte[] input = new byte[compressedSize];
        in.readFully(input);
        Inflater inflater = new Inflater();
        inflater.setInput(input, 0, input.length);
        byte[] buff = new byte[input.length];
        int uncompressedSize = 0;
        while (true) {
            int subLen = buff.length - uncompressedSize;
            int len = 0;
            try {
                len = inflater.inflate(buff, uncompressedSize, subLen);
            }
            catch (DataFormatException e) {
                throw new IOException("Input Stream is corrupt: " + e);
            }
            uncompressedSize += len;
            if (inflater.finished()) break;
            byte[] tmp = buff;
            buff = new byte[tmp.length * 2];
            System.arraycopy(tmp, 0, buff, 0, tmp.length);
        }
        inflater.reset();
        if (uncompressedSize < buff.length) {
            byte[] tmp = buff;
            buff = new byte[uncompressedSize];
            System.arraycopy(tmp, 0, buff, 0, uncompressedSize);
        }
        return buff;
    }

    private <T extends Externalizable> T readCompress(ObjectInputStream in, T e) {
        try {
            byte[] uncompbytes = IscobolMessageSerializer.readCompress(in);
            ByteArrayInputStream bis = new ByteArrayInputStream(uncompbytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            e.readExternal(ois);
            ois.close();
            bis.close();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return e;
    }

    static {
        try {
            parameterClass = Class.forName("com.jniwrapper.Parameter");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

