/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.dualrpc.server;

import com.iscobol.rpc.dualrpc.common.CallException;
import com.iscobol.rpc.dualrpc.common.IDualRpcCaller;
import com.iscobol.rpc.dualrpc.common.IDualRpcMessageConstants;
import com.iscobol.rpc.dualrpc.common.IRpcHandler;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.RpcCallPayload;
import com.iscobol.rpc.dualrpc.common.RpcFaultPayload;
import com.iscobol.rpc.dualrpc.common.RpcResultPayload;
import com.iscobol.rpc.dualrpc.common.RpcResultPayloadContainer;
import com.iscobol.rpc.dualrpc.server.AbstractServerRpcHandler;
import com.iscobol.rpc.dualrpc.server.DualRpcServer;
import com.iscobol.rpc.dualrpc.server.IMimetic;
import com.iscobol.rpc.dualrpc.server.IServerCallbackHandler;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rpc.messageserver.common.SessionException;
import com.iscobol.rpc.messageserver.server.AbstractServerApplication;
import com.iscobol.rpc.messageserver.server.MessageServer;
import com.iscobol.rts.ArrayTable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;

public class DualRpcServerDispatcher
extends AbstractServerApplication
implements IDualRpcCaller,
IRpcMessageDispatcher,
IDualRpcMessageConstants {
    private int defaultCallTimeoutInSeconds = 60;
    private DualRpcServer dualRpcServer = null;
    private HashMap serverHandlers = new HashMap();
    private ArrayTable callWaitingRegistry = new ArrayTable();
    private IServerCallbackHandler callbackHandler = null;

    public DualRpcServerDispatcher(MessageServer messageServer, Session session, Object serverHandlerConfigurationObject) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        super(messageServer, session, serverHandlerConfigurationObject);
        this.dualRpcServer = (DualRpcServer)this.getConfigurationObject();
        ArrayList listServerSideHandlerClassnames = this.getDualRpcServer().getListServerSideHandlerClassnames();
        for (String handlerClassname : listServerSideHandlerClassnames) {
            Class<?> handlerClass = Class.forName(handlerClassname);
            Constructor<?> constructor = handlerClass.getConstructor(DualRpcServerDispatcher.class);
            AbstractServerRpcHandler serverSideHandler = (AbstractServerRpcHandler)constructor.newInstance(this);
            if (serverSideHandler instanceof IMimetic) {
                handlerClassname = ((IMimetic)((Object)serverSideHandler)).getFakeName();
            }
            this.serverHandlers.put(handlerClassname, serverSideHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long sessionId = this.getSession().getSessionId();
        try {
            Thread.currentThread().setName(this.getClass().getName() + ":hashcode=" + this.hashCode() + ":sessionId=" + sessionId);
            while (true) {
                try {
                    Message message = this.getSession().getMessage(true);
                    Thread worker = this.getDualRpcServer().getRpcWorkerFactory().getRpcWorkerThread(this, message);
                    worker.setDaemon(true);
                    worker.start();
                }
                catch (SessionException sessex) {
                    ArrayTable containers = this.getCallWaitingRegistry();
                    int length = containers.length();
                    for (int i = 1; i < length; ++i) {
                        Object obj = containers.getObject(i);
                        if (obj == null) continue;
                        Object object = obj;
                        synchronized (object) {
                            try {
                                obj.notifyAll();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    if (this.callbackHandler != null) {
                        this.callbackHandler.brokenConnection();
                    }
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Thread.yield();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object call(String handlerClassName, String methodName) throws CallException {
        ArrayList parameters = new ArrayList();
        return this.call(handlerClassName, methodName, true, this.defaultCallTimeoutInSeconds, parameters);
    }

    public Object call(String handlerClassName, String methodName, Object p1) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        return this.call(handlerClassName, methodName, true, this.defaultCallTimeoutInSeconds, parameters);
    }

    public Object call(String handlerClassName, String methodName, Object p1, Object p2) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        parameters.add(p2);
        return this.call(handlerClassName, methodName, true, this.defaultCallTimeoutInSeconds, parameters);
    }

    public Object call(String handlerClassName, String methodName, Object p1, Object p2, Object p3) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p3);
        return this.call(handlerClassName, methodName, true, this.defaultCallTimeoutInSeconds, parameters);
    }

    public Object call(String handlerClassName, String methodName, Object p1, Object p2, Object p3, Object p4) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p3);
        parameters.add(p4);
        return this.call(handlerClassName, methodName, true, this.defaultCallTimeoutInSeconds, parameters);
    }

    public Object call(String handlerClassName, String methodName, Object p1, Object p2, Object p3, Object p4, Object p5) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p3);
        parameters.add(p4);
        parameters.add(p5);
        return this.call(handlerClassName, methodName, true, this.defaultCallTimeoutInSeconds, parameters);
    }

    public void callAsync(String handlerClassName, String methodName) throws CallException {
        ArrayList parameters = new ArrayList();
        this.call(handlerClassName, methodName, false, this.defaultCallTimeoutInSeconds, parameters);
    }

    public void callAsync(String handlerClassName, String methodName, Object p1) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        this.call(handlerClassName, methodName, false, this.defaultCallTimeoutInSeconds, parameters);
    }

    public void callAsync(String handlerClassName, String methodName, Object p1, Object p2) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        parameters.add(p2);
        this.call(handlerClassName, methodName, false, this.defaultCallTimeoutInSeconds, parameters);
    }

    public void callAsync(String handlerClassName, String methodName, Object p1, Object p2, Object p3) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p3);
        this.call(handlerClassName, methodName, false, this.defaultCallTimeoutInSeconds, parameters);
    }

    public void callAsync(String handlerClassName, String methodName, Object p1, Object p2, Object p3, Object p4) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p3);
        parameters.add(p4);
        this.call(handlerClassName, methodName, false, this.defaultCallTimeoutInSeconds, parameters);
    }

    public void callAsync(String handlerClassName, String methodName, Object p1, Object p2, Object p3, Object p4, Object p5) throws CallException {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p3);
        parameters.add(p4);
        parameters.add(p5);
        this.call(handlerClassName, methodName, false, this.defaultCallTimeoutInSeconds, parameters);
    }

    public void callAsync(String handlerClassName, String methodName, ArrayList parameters) throws CallException {
        this.call(handlerClassName, methodName, false, this.defaultCallTimeoutInSeconds, parameters);
    }

    public Object call(String handlerClassName, String methodName, ArrayList parameters) throws CallException {
        return this.call(handlerClassName, methodName, true, this.defaultCallTimeoutInSeconds, parameters);
    }

    public Object call(String handlerClassName, String methodName, int callTimeoutInSeconds, ArrayList parameters) throws CallException {
        return this.call(handlerClassName, methodName, true, callTimeoutInSeconds, parameters);
    }

    public Object call(String handlerClassName, String methodName, boolean hasResults, int callTimeoutInSeconds, ArrayList parameters) throws CallException {
        return this.call(new RpcCallPayload(handlerClassName, methodName, parameters, hasResults), callTimeoutInSeconds);
    }

    @Override
    public Object call(int objectId, short methodId, ArrayList parameters, boolean hasResults, int timeout) throws CallException {
        return this.call(new RpcCallPayload(objectId, methodId, parameters, hasResults), timeout);
    }

    @Override
    public Object call(int objectId, short methodId, ArrayList parameters, boolean hasResults) throws CallException {
        return this.call(new RpcCallPayload(objectId, methodId, parameters, hasResults), this.defaultCallTimeoutInSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object call(RpcCallPayload payload, int callTimeoutInSeconds) throws CallException {
        Object result;
        block17: {
            result = null;
            try {
                int messageId = 0;
                Message message = new Message(messageId, 1, payload);
                if (payload.isSendResults()) {
                    RpcResultPayloadContainer container = new RpcResultPayloadContainer();
                    messageId = this.getCallWaitingRegistry().put(container);
                    message.setId(messageId);
                    boolean isFault = false;
                    String faultExceptionMessage = null;
                    try {
                        RpcResultPayloadContainer rpcResultPayloadContainer = container;
                        synchronized (rpcResultPayloadContainer) {
                            this.sendMessage(message);
                            if (callTimeoutInSeconds <= 0) {
                                container.wait();
                            } else {
                                container.wait(callTimeoutInSeconds * 1000);
                            }
                        }
                        int rpcResultPayloadType = container.getRpcResultPayloadType();
                        switch (rpcResultPayloadType) {
                            case 2: {
                                RpcResultPayload rpcResultMessage = (RpcResultPayload)container.getRpcMessagePayload();
                                result = rpcResultMessage.getResultObject();
                                break;
                            }
                            case 3: {
                                RpcFaultPayload rpcFaultMessage = (RpcFaultPayload)container.getRpcMessagePayload();
                                isFault = true;
                                faultExceptionMessage = rpcFaultMessage.getFaultMessage();
                                break;
                            }
                            default: {
                                isFault = true;
                                if (payload.getException() != null) {
                                    faultExceptionMessage = payload.getException().toString();
                                    break;
                                }
                                faultExceptionMessage = "Call timed out. Current timeout=" + callTimeoutInSeconds;
                                break;
                            }
                        }
                    }
                    catch (InterruptedException inex) {
                        isFault = true;
                        faultExceptionMessage = "Thread was interrupted. " + inex.toString();
                    }
                    this.getCallWaitingRegistry().remove(messageId);
                    if (isFault) {
                        throw new CallException(faultExceptionMessage);
                    }
                    break block17;
                }
                this.sendMessage(message);
            }
            catch (CallException ce) {
                throw ce;
            }
            catch (Throwable t) {
                throw new CallException(t);
            }
        }
        return result;
    }

    @Override
    public IRpcHandler getHandler(String handlerClassname) {
        return (IRpcHandler)this.serverHandlers.get(handlerClassname);
    }

    public void disconnect() {
        this.getSession().closeSession();
    }

    public DualRpcServer getDualRpcServer() {
        return this.dualRpcServer;
    }

    @Override
    public ArrayTable getCallWaitingRegistry() {
        return this.callWaitingRegistry;
    }

    public void setCallbackHandler(IServerCallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public void setDefaultCallTimeoutInSeconds(int defaultCallTimeoutInSeconds) {
        this.defaultCallTimeoutInSeconds = defaultCallTimeoutInSeconds;
    }
}

