/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rpc.messageserver.server;

import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rpc.messageserver.common.SessionException;
import com.iscobol.rpc.messageserver.server.MessageServer;

public abstract class AbstractServerApplication
extends Thread {
    private MessageServer messageServer = null;
    private Session session = null;
    private Object configurationObject = null;

    public AbstractServerApplication(MessageServer messageServer, Session psession, Object pconfigurationObject) {
        this.setMessageServer(messageServer);
        this.setSession(psession);
        this.setConfigurationObject(pconfigurationObject);
    }

    @Override
    public abstract void run();

    public void sendMessage(Message msg) throws SessionException {
        this.getSession().sendMessage(msg);
    }

    public Message getMessage(boolean blockUntilMessage) throws SessionException {
        return this.getSession().getMessage(blockUntilMessage);
    }

    private void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    private void setConfigurationObject(Object configurationObject) {
        this.configurationObject = configurationObject;
    }

    public Object getConfigurationObject() {
        return this.configurationObject;
    }

    public MessageServer getMessageServer() {
        return this.messageServer;
    }

    private void setMessageServer(MessageServer server) {
        this.messageServer = server;
    }
}

