/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Config;
import com.iscobol.rts.HTTPClient;
import com.iscobol.rts.HTTPData;
import com.iscobol.rts.ICobolVar;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HTTPClientHelper
implements HTTPClient.IHTTPClientHelper {
    private int connectTimeout = Integer.MAX_VALUE;
    private String user;
    private String password;
    private String proxyHost;
    private int proxyPort;
    private HTTPData.Params parameters;
    private int debugFlg = Config.getProperty("iscobol.tracelevel", -1);
    private static final String eol = System.getProperty("line.separator", "\n");
    private ArrayList headerProperties;
    private int responseCode;
    private HttpClient httpConn;
    private HttpRequest request;
    private HttpResponse<String> response;
    private static final Map<Integer, String> STATUS_CODES = new HashMap<Integer, String>();

    public String decodeHttpStatusCode(int code) {
        String res = STATUS_CODES.get(code);
        if (res == null) {
            return "Unknown Status Code";
        }
        return res;
    }

    @Override
    public void test() {
        System.out.println("HTTPClientHelper.test");
    }

    @Override
    public void setConnectionTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public void setAuth(ICobolVar usr, ICobolVar pwd) {
        this.user = usr.toString();
        this.password = pwd == null ? null : pwd.toString();
    }

    @Override
    public void setProxy(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
        if (this.proxyHost != null) {
            ProxySelector proxy = ProxySelector.of(new InetSocketAddress(this.proxyHost, this.proxyPort));
            ProxySelector.setDefault(proxy);
        } else {
            ProxySelector proxy = ProxySelector.getDefault();
        }
    }

    @Override
    public void setParameters(HTTPData.Params parameters) {
        this.parameters = parameters;
    }

    @Override
    public void setHeaderProperties(ArrayList headerProperties) {
        this.headerProperties = headerProperties;
    }

    private synchronized void setConnection(String strUrl, String type, String content) throws MalformedURLException, IOException {
        try {
            ProxySelector proxy;
            String lcu = ((String)strUrl).toLowerCase();
            HashMap<String, String> headers = new HashMap<String, String>();
            this.logString(null, "===============================");
            this.logString(null, "Connection requested at " + new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss.ms").format(new Date()));
            this.logString(null, "Connecting to: " + lcu);
            if (lcu.startsWith("https://")) {
                String prop = Config.getProperty(".net.ssl.trust_store", null);
                if (prop != null && prop.length() > 0 && !"*".equals(prop)) {
                    System.setProperty("javax.net.ssl.trustStore", prop);
                    prop = Config.getProperty(".net.ssl.trust_store_password", null);
                    if (prop != null) {
                        System.setProperty("javax.net.ssl.trustStorePassword", prop);
                    }
                }
            } else if (!((String)strUrl).toLowerCase().startsWith("http://")) {
                strUrl = "http://" + (String)strUrl;
            }
            URL url = new URL((String)strUrl);
            if (this.proxyHost != null) {
                proxy = ProxySelector.of(new InetSocketAddress(this.proxyHost, this.proxyPort));
                ProxySelector.setDefault(proxy);
            } else {
                proxy = ProxySelector.getDefault();
            }
            if (type != null) {
                headers.put("Content-Type", type);
            }
            if (this.headerProperties != null) {
                int num = this.headerProperties.size();
                for (int i = 0; i < num; ++i) {
                    HTTPData.Pair cp = (HTTPData.Pair)this.headerProperties.get(i);
                    headers.put(cp.key, cp.value);
                }
            }
            HttpRequest.BodyPublisher payload = content != null ? HttpRequest.BodyPublishers.ofString(content) : HttpRequest.BodyPublishers.noBody();
            Authenticator authenticator = this.user != null ? new UsernamePasswordAuthenticator(this.user, this.password) : Authenticator.getDefault();
            Duration timeoutDuration = this.connectTimeout > 0 ? Duration.ofSeconds(this.connectTimeout) : Duration.ofSeconds(60L);
            this.httpConn = HttpClient.newHttpClient();
            try {
                HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(((String)strUrl).trim())).timeout(timeoutDuration).method("PATCH", payload);
                if (this.headerProperties != null) {
                    int num = this.headerProperties.size();
                    for (int i = 0; i < num; ++i) {
                        HTTPData.Pair cp = (HTTPData.Pair)this.headerProperties.get(i);
                        headers.put(cp.key, cp.value);
                    }
                }
                for (Map.Entry entry : headers.entrySet()) {
                    requestBuilder.header((String)entry.getKey(), (String)entry.getValue());
                }
                this.request = requestBuilder.build();
            }
            catch (Exception ex) {
                throw new MalformedURLException(ex.getMessage());
            }
        }
        catch (Exception ex) {
            this.logString(null, "An exception occurred opening connection:");
            this.logString(null, ex.getMessage());
            throw ex;
        }
    }

    @Override
    public void doPatchEx(String strUrl, String type, String content, ICobolVar hasDummyRoot) throws IOException, InterruptedException {
        this.setConnection(strUrl, type != null ? type.toString() : null, content != null ? content.toString() : null);
        this.response = this.httpConn.send(this.request, HttpResponse.BodyHandlers.ofString());
    }

    @Override
    public int getResponseCode() {
        this.logString(null, "Reading response code");
        return this.response.statusCode();
    }

    @Override
    public byte[] getResponse() {
        return this.response.body().getBytes();
    }

    @Override
    public String getResponseMessage() {
        this.logString(null, String.format("Reading response message: %s", this.response != null ? this.response.statusCode() + " " + this.decodeHttpStatusCode(this.response.statusCode()) : "response is null"));
        this.logString(null, "Response message: " + this.decodeHttpStatusCode(this.response.statusCode()));
        return this.decodeHttpStatusCode(this.response.statusCode());
    }

    @Override
    public String getContentType() {
        return this.response.headers().firstValue("Content-Type").get();
    }

    private void logString(HttpClient connection, String string) {
        block7: {
            if (Config.getProperty("iscobol.httpclient.logging", false) && Config.getProperty("iscobol.httpclient.logfile", null) != null) {
                String logFileName = Config.getProperty("iscobol.httpclient.logfile", null);
                try {
                    File file = new File(logFileName);
                    if (!file.exists()) {
                        File parent = file.getParentFile();
                        if (parent != null && !parent.exists() && !parent.mkdirs()) {
                            parent.mkdirs();
                        }
                        try {
                            file.createNewFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    FileWriter fw = new FileWriter(file, true);
                    BufferedWriter out = new BufferedWriter(fw);
                    out.write(string);
                    out.newLine();
                    out.close();
                }
                catch (IOException ex) {
                    if (this.debugFlg <= 10) break block7;
                    System.out.print(String.format("An error occurred creating HTTPClient logfile '%s'%sMessage: %s%s", logFileName, eol, ex.getMessage(), eol));
                }
            }
        }
    }

    @Override
    public String buildLastRequest(String content) {
        Object res = null;
        URI requestUri = this.request.uri();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(eol);
            sb.append("URL: " + requestUri.toString());
            sb.append(eol);
            sb.append(eol);
            sb.append("Method: " + this.request.method());
            sb.append(eol);
            this.appendHeaderFields(sb);
            res = this.safeGetResponseCode();
            if (res != null) {
                sb.append((String)res);
            }
            res = sb.toString() + eol + eol + (String)(content != null ? "Content:" + eol + content : "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    private void generateHeaderEntry(StringBuilder sb, Map<String, List<String>> headers) {
        try {
            for (String key : headers.keySet()) {
                sb.append(String.format("%s%s", key != null ? key + " = " : "", headers.get(key)));
                sb.append(eol);
            }
            if (headers.size() > 0) {
                sb.append(eol);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void appendHeaderFields(StringBuilder sb) {
        try {
            Map<String, List<String>> headers = this.request.headers().map();
            if (headers.size() > 0) {
                sb.append("Request Headers:");
                sb.append(eol);
            }
            this.generateHeaderEntry(sb, headers);
            Map<String, List<String>> responseHeaders = this.response.headers().map();
            if (responseHeaders.size() > 0) {
                sb.append("Response Headers:");
                sb.append(eol);
            }
            this.generateHeaderEntry(sb, responseHeaders);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String safeGetResponseCode() {
        try {
            return String.format("Response code: %d - %s", this.response.statusCode(), this.decodeHttpStatusCode(this.response.statusCode()));
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        STATUS_CODES.put(100, "Continue");
        STATUS_CODES.put(101, "Switching Protocols");
        STATUS_CODES.put(102, "Processing");
        STATUS_CODES.put(200, "OK");
        STATUS_CODES.put(201, "Created");
        STATUS_CODES.put(202, "Accepted");
        STATUS_CODES.put(203, "Non-Authoritative Information");
        STATUS_CODES.put(204, "No Content");
        STATUS_CODES.put(205, "Reset Content");
        STATUS_CODES.put(206, "Partial Content");
        STATUS_CODES.put(207, "Multi-Status");
        STATUS_CODES.put(208, "Already Reported");
        STATUS_CODES.put(226, "IM Used");
        STATUS_CODES.put(300, "Multiple Choices");
        STATUS_CODES.put(301, "Moved Permanently");
        STATUS_CODES.put(302, "Found");
        STATUS_CODES.put(303, "See Other");
        STATUS_CODES.put(304, "Not Modified");
        STATUS_CODES.put(305, "Use Proxy");
        STATUS_CODES.put(307, "Temporary Redirect");
        STATUS_CODES.put(308, "Permanent Redirect");
        STATUS_CODES.put(400, "Bad Request");
        STATUS_CODES.put(401, "Unauthorized");
        STATUS_CODES.put(402, "Payment Required");
        STATUS_CODES.put(403, "Forbidden");
        STATUS_CODES.put(404, "Not Found");
        STATUS_CODES.put(405, "Method Not Allowed");
        STATUS_CODES.put(406, "Not Acceptable");
        STATUS_CODES.put(407, "Proxy Authentication Required");
        STATUS_CODES.put(408, "Request Timeout");
        STATUS_CODES.put(409, "Conflict");
        STATUS_CODES.put(410, "Gone");
        STATUS_CODES.put(411, "Length Required");
        STATUS_CODES.put(412, "Precondition Failed");
        STATUS_CODES.put(413, "Payload Too Large");
        STATUS_CODES.put(414, "URI Too Long");
        STATUS_CODES.put(415, "Unsupported Media Type");
        STATUS_CODES.put(416, "Range Not Satisfiable");
        STATUS_CODES.put(417, "Expectation Failed");
        STATUS_CODES.put(418, "I'm a teapot");
        STATUS_CODES.put(421, "Misdirected Request");
        STATUS_CODES.put(422, "Unprocessable Entity");
        STATUS_CODES.put(423, "Locked");
        STATUS_CODES.put(424, "Failed Dependency");
        STATUS_CODES.put(426, "Upgrade Required");
        STATUS_CODES.put(428, "Precondition Required");
        STATUS_CODES.put(429, "Too Many Requests");
        STATUS_CODES.put(431, "Request Header Fields Too Large");
        STATUS_CODES.put(451, "Unavailable For Legal Reasons");
        STATUS_CODES.put(500, "Internal Server Error");
        STATUS_CODES.put(501, "Not Implemented");
        STATUS_CODES.put(502, "Bad Gateway");
        STATUS_CODES.put(503, "Service Unavailable");
        STATUS_CODES.put(504, "Gateway Timeout");
        STATUS_CODES.put(505, "HTTP Version Not Supported");
        STATUS_CODES.put(506, "Variant Also Negotiates");
        STATUS_CODES.put(507, "Insufficient Storage");
        STATUS_CODES.put(508, "Loop Detected");
        STATUS_CODES.put(510, "Not Extended");
        STATUS_CODES.put(511, "Network Authentication Required");
    }

    public static class UsernamePasswordAuthenticator
    extends Authenticator {
        private String username;
        private String password;

        public UsernamePasswordAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            String prompt = this.getRequestingPrompt();
            String hostname = this.getRequestingHost();
            InetAddress ipaddr = this.getRequestingSite();
            int port = this.getRequestingPort();
            return new PasswordAuthentication(this.username, this.password.toCharArray());
        }
    }
}

