/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Factory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Console;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class LoginUI {
    public static final int MINPASSLEN = 1;
    public static final int MANDATORY = 1;
    public static final int CHECKWEAKNESS = 2;

    public static LoginResult consoleLogin() {
        Console console = System.console();
        if (console != null) {
            LoginResult result = new LoginResult();
            result.user = console.readLine(Factory.getSysMsg("username") + ": ", new Object[0]);
            result.pwd = console.readPassword(Factory.getSysMsg("password") + ": ", new Object[0]);
            result.newPwd = new char[0];
            return result;
        }
        System.out.println("command line login unsupported!");
        return null;
    }

    public static LoginResult graphicalLogin(final int flags, final int minPassLen, final int[] callReturn) {
        final JFrame f = new JFrame(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVisible(boolean b) {
                super.setVisible(b);
                if (b) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException _e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
        };
        Image img = Toolkit.getDefaultToolkit().createImage(LoginUI.class.getResource("keyring.png"));
        final SpringLayout layout = new SpringLayout();
        final JPanel textPanel = new JPanel(layout);
        JPanel buttonPanel = new JPanel();
        JPanel bottomPanel = new JPanel();
        f.setTitle(Factory.getSysMsg("login"));
        f.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent evt) {
                JFrame jFrame = f;
                synchronized (jFrame) {
                    f.notify();
                }
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                callReturn[0] = -1;
                f.dispose();
            }
        });
        final JLabel userLbl = new JLabel(Factory.getSysMsg("username"), 2);
        textPanel.add(userLbl);
        int columns = 20;
        JTextField user = new JTextField("", 20);
        textPanel.add(user);
        JLabel passwdLbl = new JLabel(Factory.getSysMsg("password"), 2);
        textPanel.add(passwdLbl);
        JPasswordField passwd = new JPasswordField("", 20);
        textPanel.add(passwd);
        final JCheckBox changePasswd = new JCheckBox(Factory.getSysMsg("change_password"));
        textPanel.add(changePasswd);
        final JLabel npl1 = new JLabel(Factory.getSysMsg("new_password"), 2);
        final JPasswordField newPasswd1 = new JPasswordField("", 20);
        final JLabel npl2 = new JLabel(Factory.getSysMsg("retype_password"), 2);
        final JPasswordField newPasswd2 = new JPasswordField("", 20);
        npl1.setEnabled(false);
        npl2.setEnabled(false);
        newPasswd1.setEnabled(false);
        newPasswd2.setEnabled(false);
        buttonPanel.setLayout(new FlowLayout(4));
        JButton okButton = new JButton(Factory.getSysMsg("login"));
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(Factory.getSysMsg("msg_cancel"));
        buttonPanel.add(cancelButton);
        Dimension d1 = okButton.getPreferredSize();
        Dimension d2 = cancelButton.getPreferredSize();
        if (d1.width > d2.width) {
            cancelButton.setPreferredSize(new Dimension(d1.width, d2.height));
        } else {
            okButton.setPreferredSize(new Dimension(d2.width, d1.height));
        }
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)buttonPanel, "Center");
        final JLabel message = new JLabel("               ");
        message.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        bottomPanel.add((Component)message, "South");
        message.setForeground(Color.red);
        if ((flags & 1) != 0) {
            message.setText("msg_change_password");
        }
        int maxWidth = 0;
        for (JComponent cmp : new JComponent[]{userLbl, passwdLbl, npl1, npl2}) {
            int prefWidth = cmp.getPreferredSize().width;
            if (prefWidth <= maxWidth) continue;
            maxWidth = prefWidth;
        }
        final int fMaxWidth = maxWidth += 5;
        changePasswd.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    textPanel.remove(npl1);
                    textPanel.remove(npl2);
                    textPanel.remove(newPasswd1);
                    textPanel.remove(newPasswd2);
                    npl1.setEnabled(false);
                    npl2.setEnabled(false);
                    newPasswd1.setText("");
                    newPasswd2.setText("");
                    newPasswd1.setEnabled(false);
                    newPasswd2.setEnabled(false);
                    layout.removeLayoutComponent(npl1);
                    layout.removeLayoutComponent(npl2);
                    layout.removeLayoutComponent(newPasswd1);
                    layout.removeLayoutComponent(newPasswd2);
                    layout.putConstraint("South", (Component)textPanel, 8, "South", (Component)changePasswd);
                    message.setText("               ");
                } else {
                    textPanel.add(npl1);
                    textPanel.add(npl2);
                    textPanel.add(newPasswd1);
                    textPanel.add(newPasswd2);
                    npl1.setEnabled(true);
                    npl2.setEnabled(true);
                    newPasswd1.setEnabled(true);
                    newPasswd2.setEnabled(true);
                    layout.putConstraint("West", (Component)npl1, 0, "West", (Component)userLbl);
                    layout.putConstraint("North", (Component)npl1, 10, "South", (Component)changePasswd);
                    layout.putConstraint("North", (Component)newPasswd1, -2, "North", (Component)npl1);
                    layout.putConstraint("West", (Component)newPasswd1, fMaxWidth, "West", (Component)npl1);
                    layout.putConstraint("West", (Component)npl2, 0, "West", (Component)userLbl);
                    layout.putConstraint("North", (Component)npl2, 10, "South", (Component)npl1);
                    layout.putConstraint("North", (Component)newPasswd2, -2, "North", (Component)npl2);
                    layout.putConstraint("West", (Component)newPasswd2, fMaxWidth, "West", (Component)npl2);
                    layout.putConstraint("South", (Component)textPanel, 8, "South", (Component)newPasswd2);
                }
                f.pack();
            }
        });
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LoginUI.check(newPasswd1, newPasswd2, message, flags, minPassLen)) {
                    f.dispose();
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                callReturn[0] = -1;
                f.dispose();
            }
        });
        layout.putConstraint("North", (Component)userLbl, 10, "North", (Component)textPanel);
        layout.putConstraint("West", (Component)userLbl, 8, "West", (Component)textPanel);
        layout.putConstraint("North", (Component)user, -2, "North", (Component)userLbl);
        layout.putConstraint("West", (Component)user, maxWidth, "West", (Component)userLbl);
        layout.putConstraint("West", (Component)passwdLbl, 0, "West", (Component)userLbl);
        layout.putConstraint("North", (Component)passwdLbl, 10, "South", (Component)userLbl);
        layout.putConstraint("North", (Component)passwd, -2, "North", (Component)passwdLbl);
        layout.putConstraint("West", (Component)passwd, maxWidth, "West", (Component)passwdLbl);
        layout.putConstraint("West", (Component)changePasswd, 0, "West", (Component)userLbl);
        layout.putConstraint("North", (Component)changePasswd, 10, "South", (Component)passwdLbl);
        layout.putConstraint("East", (Component)textPanel, 8, "East", (Component)user);
        layout.putConstraint("South", (Component)textPanel, 8, "South", (Component)changePasswd);
        JPanel headerPanel = new JPanel(new BorderLayout());
        JLabel l = new JLabel(new ImageIcon(img));
        l.setBorder(BorderFactory.createEmptyBorder(10, 15, 5, 15));
        headerPanel.add((Component)l, "East");
        l = new JLabel(Factory.getSysMsg("authentication"));
        l.setBorder(BorderFactory.createEmptyBorder(10, 15, 5, 15));
        l.setFont(l.getFont().deriveFont(18.0f));
        headerPanel.add((Component)l, "Center");
        headerPanel.setBackground(Color.white);
        headerPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.darkGray));
        f.getContentPane().add((Component)headerPanel, "North");
        f.getContentPane().add((Component)textPanel, "Center");
        f.getContentPane().add((Component)bottomPanel, "South");
        f.getRootPane().setDefaultButton(okButton);
        f.setResizable(false);
        f.pack();
        Dimension d = f.getSize();
        Dimension screen = f.getToolkit().getScreenSize();
        int x = (screen.width - d.width) / 2;
        int y = (screen.height - d.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        f.setLocation(x, y);
        f.setVisible(true);
        if (callReturn[0] == 0) {
            LoginResult result = new LoginResult();
            result.pwd = passwd.getPassword();
            result.user = user.getText();
            result.newPwd = newPasswd1.getPassword();
            return result;
        }
        return null;
    }

    private static boolean check(JPasswordField newPasswd1, JPasswordField newPasswd2, JLabel message, int flags, int minPassLen) {
        int j;
        char[] p1 = newPasswd1.getPassword();
        char[] p2 = newPasswd2.getPassword();
        int i = -1;
        if (p1.length == p2.length) {
            for (i = 0; i < p1.length && p1[i] == p2[i]; ++i) {
            }
        }
        for (j = 0; j < p1.length; ++j) {
            p1[j] = 32;
        }
        for (j = 0; j < p2.length; ++j) {
            p2[j] = 32;
        }
        if (i != p1.length) {
            message.setText(Factory.getSysMsg("msg_password_not_match"));
            return false;
        }
        if ((flags & 1) != 0 && p1.length == 0) {
            message.setText("msg_password_mandatory");
            return false;
        }
        if (p1.length > 0 && p1.length < minPassLen) {
            message.setText("msg_password_too_short");
            return false;
        }
        return true;
    }

    public static class LoginResult {
        public char[] pwd;
        public String user;
        public char[] newPwd;
    }
}

