/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class XMLStreamConstants {
    public static final String NS_XMLSCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String NS_XMLSCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final Map<String, String> xsdSimpleTypes;
    public static final String STRING = "S";
    public static final String FLOAT = "F";
    public static final String DOUBLE = "D";
    public static final String LONG = "I64";
    public static final String INT = "I32";
    public static final String SHORT = "I16";
    public static final String BYTE = "I8";

    private XMLStreamConstants() {
    }

    public static boolean isSimpleType(String type) {
        return xsdSimpleTypes.containsKey(type);
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("duration", STRING);
        map.put("dateTime", STRING);
        map.put("time", STRING);
        map.put("date", STRING);
        map.put("gYearMonth", STRING);
        map.put("gYear", STRING);
        map.put("gMonthDay", STRING);
        map.put("gDay", STRING);
        map.put("gMonth", STRING);
        map.put("boolean", STRING);
        map.put("base64Binary", STRING);
        map.put("hexBinary", STRING);
        map.put("float", FLOAT);
        map.put("double", DOUBLE);
        map.put("anyURI", STRING);
        map.put("QName", STRING);
        map.put("NOTATION", STRING);
        map.put("string", STRING);
        map.put("decimal", DOUBLE);
        map.put("normalizedString", STRING);
        map.put("integer", LONG);
        map.put("token", STRING);
        map.put("nonPositiveInteger", LONG);
        map.put("long", LONG);
        map.put("nonNegativeInteger", LONG);
        map.put("language", STRING);
        map.put("Name", STRING);
        map.put("NMTOKEN", STRING);
        map.put("negativeInteger", STRING);
        map.put("int", INT);
        map.put("unsignedLong", LONG);
        map.put("positiveInteger", LONG);
        map.put("NCName", STRING);
        map.put("NMTOKENS", STRING);
        map.put("short", SHORT);
        map.put("unsignedInt", INT);
        map.put("ID", STRING);
        map.put("IDREF", STRING);
        map.put("ENTITY", STRING);
        map.put("byte", BYTE);
        map.put("unsignedShort", SHORT);
        map.put("IDREFS", STRING);
        map.put("ENTITIES", STRING);
        map.put("unsignedByte", BYTE);
        xsdSimpleTypes = Collections.unmodifiableMap(map);
    }
}

