/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DrawGraph
extends PrintCommand {
    public static final double ARC_COEFF = (double)0.1f;
    public static final int RECTANGLE = 1;
    public static final int ROUND_RECTANGLE = 2;
    public static final int LINE = 3;
    public static final int SHAPE_MASK = 15;
    public static final int FILL_ONLY = 16;
    public static final int SHADE_NO = 1;
    public static final int SHADE_YES = 2;
    private final int shape;
    private final double startX;
    private final double startY;
    private final double stopX;
    private final double stopY;
    private final byte shade;
    private final boolean cells;

    public DrawGraph(GuiFactory gf, int shape, double startX, double startY, double stopX, double stopY, boolean cells, String shade) {
        super(gf, 5);
        this.shape = shape;
        if (shape == 3) {
            this.startX = startX;
            this.stopX = stopX;
            this.startY = startY;
            this.stopY = stopY;
        } else {
            if (startX <= stopX) {
                this.startX = startX;
                this.stopX = stopX;
            } else {
                this.startX = stopX;
                this.stopX = startX;
            }
            if (startY <= stopY) {
                this.startY = startY;
                this.stopY = stopY;
            } else {
                this.startY = stopY;
                this.stopY = startY;
            }
        }
        this.cells = cells;
        this.shade = shade == null || shade.trim().length() == 0 ? (byte)0 : ("YES".equals(shade) ? (byte)2 : (byte)1);
    }

    DrawGraph(GuiFactory gf, RandomAccessFile inOut) throws IOException {
        super(gf, 5);
        this.shape = inOut.readInt();
        this.startX = inOut.readDouble();
        this.startY = inOut.readDouble();
        this.stopX = inOut.readDouble();
        this.stopY = inOut.readDouble();
        this.cells = inOut.readBoolean();
        this.shade = inOut.readByte();
    }

    @Override
    void toFile(RandomAccessFile inOut) throws IOException {
        inOut.writeInt(this.shape);
        inOut.writeDouble(this.startX);
        inOut.writeDouble(this.startY);
        inOut.writeDouble(this.stopX);
        inOut.writeDouble(this.stopY);
        inOut.writeBoolean(this.cells);
        inOut.writeByte(this.shade);
    }

    @Override
    public boolean testPrint(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        return this.print(pc, null, pf);
    }

    @Override
    public boolean print(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        if (g2d != null) {
            if (this.cells) {
                FontRenderContext frc = g2d.getFontRenderContext();
                TextLayout layout = new TextLayout("0", g2d.getFont(), frc);
                float fh = DrawGraph.getCellHeight(pc, layout);
                float fw = layout.getAdvance();
                double arcR = Math.min((this.stopX - this.startX) * (double)fw, (this.stopY - this.startY) * (double)fh) * (double)0.1f;
                DrawGraph.draw(g2d, this.shape, this.startX * (double)fw, this.startY * (double)fh, this.stopX * (double)fw, this.stopY * (double)fh, arcR, arcR, this.shade, pc);
            } else {
                double arcR = Math.min(this.stopX - this.startX, this.stopY - this.startY) * (double)0.1f;
                DrawGraph.draw(g2d, this.shape, this.startX, this.startY, this.stopX, this.stopY, arcR, arcR, this.shade, pc);
            }
        }
        return true;
    }

    private static void draw(Graphics2D g2d, int shape, double x1, double y1, double x2, double y2, double arcW, double arcH, byte shade, PrintContext pc) {
        Shape rect = null;
        Color saveColor = g2d.getColor();
        boolean drawBorder = (shape & 0x10) == 0;
        switch (shape &= 0xF) {
            case 1: {
                rect = new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
                break;
            }
            case 2: {
                rect = new RoundRectangle2D.Double(x1, y1, x2 - x1, y2 - y1, arcW, arcH);
                break;
            }
            case 3: {
                rect = new Line2D.Double(x1, y1, x2, y2);
                break;
            }
        }
        if (rect != null) {
            if (shade != 1) {
                Paint p;
                if (shade == 2 && pc.boxShade != null) {
                    g2d.setPaint(pc.boxShade);
                    g2d.fill(rect);
                } else if (!(pc.graphBrush == null || pc.graphBrush.getPaint() == null || (p = pc.graphBrush.getPaint()) instanceof Color && ((Color)p).getAlpha() <= 0)) {
                    g2d.setPaint(pc.graphBrush.getPaint());
                    g2d.fill(rect);
                }
            }
            if (drawBorder) {
                if (pc.graphPen != null) {
                    if (pc.graphPen.getStroke() != null) {
                        g2d.setStroke(pc.graphPen.getStroke());
                        g2d.setColor(pc.graphPen.getColor());
                        g2d.draw(rect);
                    }
                } else {
                    g2d.setColor(new Color(0, 0, 0));
                    g2d.draw(rect);
                }
            }
        }
        g2d.setColor(saveColor);
    }
}

