/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.Serializable;

public class GraphBrush
implements Cloneable,
Serializable {
    public static final int SOLID = 0;
    public static final int NULL = 1;
    public static final int BDIAGONAL = 2;
    public static final int CROSS = 3;
    public static final int DIAGCROSS = 4;
    public static final int FDIAGONAL = 5;
    public static final int HORIZONTAL = 6;
    public static final int VERTICAL = 7;
    public static final int DKGRAY = 8;
    public static final int GRAY = 9;
    public static final int LTGRAY = 10;
    private Paint brush;
    private Color color;

    public GraphBrush(int style, Color color) {
        switch (style) {
            default: {
                break;
            }
            case 0: {
                this.brush = color;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                Rectangle r = new Rectangle(0, 0, 5, 5);
                BufferedImage i = new BufferedImage(5, 5, 1);
                Graphics2D g = i.createGraphics();
                g.setColor(Color.white);
                g.fill(r);
                g.setColor(color);
                switch (style) {
                    case 2: {
                        g.drawLine(0, 4, 4, 0);
                        break;
                    }
                    case 3: {
                        g.drawLine(0, 2, 4, 2);
                        g.drawLine(2, 0, 2, 4);
                        break;
                    }
                    case 4: {
                        g.drawLine(0, 0, 4, 4);
                        g.drawLine(0, 4, 4, 0);
                        break;
                    }
                    case 5: {
                        g.drawLine(0, 0, 4, 4);
                        break;
                    }
                    case 6: {
                        g.drawLine(0, 2, 4, 2);
                        break;
                    }
                    case 7: {
                        g.drawLine(2, 0, 2, 4);
                    }
                }
                this.brush = new TexturePaint(i, r);
                break;
            }
            case 8: {
                this.brush = Color.darkGray;
                break;
            }
            case 9: {
                this.brush = Color.gray;
                break;
            }
            case 10: {
                this.brush = Color.lightGray;
            }
        }
    }

    public Paint getPaint() {
        return this.brush;
    }
}

