/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.rts.File;
import com.iscobol.rts.OSValidator;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.print.AttrTable;
import com.iscobol.rts.print.PDFFontMapper;
import com.iscobol.rts.print.RTL;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.MappedRandomAccessFile;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPrinterGraphics2D;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PageRanges;

public class PDF {
    public static final int PDFCRYPT_NO = 0;
    public static final int PDFCRYPT_STD_40 = 1;
    public static final int PDFCRYPT_STD_128 = 2;
    public static final int PDFCRYPT_AES_128 = 3;
    public static final int PDFCRYPT_TYPE_MASK = 7;
    public static final int PDFCRYPT_NO_METADATA = 8;
    public static final int PDFCRYPT_EMBEDDED_FILES_ONLY = 16;
    public static final int PDFCRYPT_MODE_MASK = 255;
    public static final int PDFCRYPT_ALLOW_PRINTING = 256;
    public static final int PDFCRYPT_ALLOW_MODIFY_CONTENT = 512;
    public static final int PDFCRYPT_ALLOW_COPY = 1024;
    public static final int PDFCRYPT_ALLOW_MODIFY_ANNOT = 2048;
    public static final int PDFCRYPT_ALLOW_FILL_IN = 4096;
    public static final int PDFCRYPT_ALLOW_SCREENREADERS = 8192;
    public static final int PDFCRYPT_ALLOW_ASSEMBLY = 16384;
    public static final int PDFCRYPT_DEGRADED_PRINTING = 32768;
    private Printable prn;
    private Pageable pg;
    private PrinterJob pj;
    private String fileName;
    private int nPages;

    public PDF(Printable prn, Pageable pg, PrinterJob pj, String fileName, int nPages) {
        this.prn = prn;
        this.pg = pg;
        this.pj = pj;
        this.fileName = fileName;
        this.nPages = nPages;
    }

    public boolean doPrint(PrintRequestAttributeSet aset, AttrTable genericAttrs, MediaSize custMediaSize) throws IOException {
        float pageHeight;
        float pageWidth;
        int or;
        MediaPrintableArea mpa = (MediaPrintableArea)aset.get(MediaPrintableArea.class);
        Media msn = (Media)aset.get(Media.class);
        MediaSize ms = custMediaSize != null ? custMediaSize : (msn != null && msn instanceof MediaSizeName ? MediaSize.getMediaSizeForName((MediaSizeName)msn) : new MediaSize(PageSize.A4.getWidth() / 72.0f, PageSize.A4.getHeight() / 72.0f, 25400));
        float width = ms.getX(25400) * 72.0f;
        float height = ms.getY(25400) * 72.0f;
        float leftMargin = mpa.getX(25400) * 72.0f;
        float topMargin = mpa.getY(25400) * 72.0f;
        float rightMargin = width - mpa.getWidth(25400) * 72.0f - leftMargin;
        float bottomMargin = height - mpa.getHeight(25400) * 72.0f - topMargin;
        PDFFontMapper mapper = new PDFFontMapper(genericAttrs.get("FONT_DEFAULT"));
        FontFactory.registerDirectories();
        Set<java.io.File> fontFolder = PDF.getFolders(genericAttrs.get("FONT_FOLDER"));
        Set<java.io.File> fontFolderEmbed = PDF.getFolders(genericAttrs.get("FONT_FOLDER_EMBED"));
        if (fontFolder != null) {
            if (fontFolderEmbed != null) {
                fontFolder.removeAll(fontFolderEmbed);
            }
        } else if (fontFolderEmbed == null) {
            if (OSValidator.isMac()) {
                fontFolderEmbed = PDF.getFolders("/Library/Fonts");
            } else if (OSValidator.isLinux()) {
                fontFolderEmbed = PDF.getFolders("/usr/shared/fonts");
            } else if (OSValidator.isWindows()) {
                fontFolderEmbed = PDF.getFolders("C:\\Windows\\Fonts");
            }
        }
        if (fontFolder != null) {
            String currEncoding = Charset.defaultCharset().name();
            for (java.io.File dir : fontFolder) {
                if (!dir.exists() || !dir.isDirectory()) continue;
                PDF.insertDirectory(mapper, dir);
            }
            Iterator i = mapper.getMapper().keySet().iterator();
            while (i.hasNext()) {
                DefaultFontMapper.BaseFontParameters fontIn = mapper.getBaseFontParameters((String)i.next());
                if (fontIn == null) continue;
                fontIn.embedded = false;
                fontIn.encoding = currEncoding;
            }
        }
        if (fontFolderEmbed != null) {
            for (java.io.File dir : fontFolderEmbed) {
                if (!dir.exists() || !dir.isDirectory()) continue;
                PDF.insertDirectory(mapper, dir);
            }
        }
        if ((or = this.pg.getPageFormat(0).getOrientation()) == 0 || or == 2) {
            pageWidth = height;
            pageHeight = width;
        } else {
            pageWidth = width;
            pageHeight = height;
        }
        Document document = new Document(new Rectangle(pageWidth, pageHeight), leftMargin, rightMargin, topMargin, bottomMargin);
        PageRanges pages = (PageRanges)aset.get(PageRanges.class);
        if (pages == null) {
            pages = new PageRanges(1, this.nPages > 0 ? this.nPages : 1);
        }
        int jpegQuality = 0;
        TreeMap imageMap = null;
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(File.get(this.fileName)));
            String value = genericAttrs.get("PRODUCER");
            if (value != null) {
                document.addProducer(value);
            } else {
                document.addProducer("");
            }
            value = genericAttrs.get("TITLE");
            if (value != null) {
                document.addTitle(value);
            }
            if ((value = genericAttrs.get("SUBJECT")) != null) {
                document.addSubject(value);
            }
            if ((value = genericAttrs.get("KEYWORDS")) != null) {
                document.addKeywords(value);
            }
            if ((value = genericAttrs.get("AUTHOR")) != null) {
                document.addAuthor(value);
            }
            if ((value = genericAttrs.get("EXPIRES")) != null) {
                document.addHeader("Expires", value);
            }
            if ((value = genericAttrs.get("JPEG")) != null) {
                try {
                    jpegQuality = Integer.parseInt(value);
                    if (jpegQuality < 0) {
                        jpegQuality = 0;
                    } else if (jpegQuality > 100) {
                        jpegQuality = 100;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((value = genericAttrs.get("ENCRYPTION")) != null) {
                int tmpencr;
                try {
                    tmpencr = Integer.parseInt(value);
                }
                catch (NumberFormatException _ex) {
                    tmpencr = 0;
                }
                int encrypt = tmpencr;
                if (encrypt != 0) {
                    int encryptType;
                    switch (encrypt & 7) {
                        default: {
                            encryptType = 0;
                            break;
                        }
                        case 1: {
                            encryptType = 0;
                            break;
                        }
                        case 2: {
                            encryptType = 1;
                            break;
                        }
                        case 3: {
                            encryptType = 2;
                        }
                    }
                    if (encryptType != 0) {
                        byte[] ownerPass;
                        String uObj = genericAttrs.get("USER_PASSWORD");
                        String oObj = genericAttrs.get("OWNER_PASSWORD");
                        byte[] userPass = uObj != null ? uObj.toString().getBytes() : null;
                        byte[] byArray = ownerPass = oObj != null ? oObj.toString().getBytes() : null;
                        if ((encrypt & 8) != 0) {
                            encryptType |= 8;
                        }
                        if ((encrypt & 0x10) != 0) {
                            encryptType |= 0x18;
                        }
                        int perms = 0;
                        if ((encrypt & 0x100) != 0) {
                            perms |= 0x804;
                        }
                        if ((encrypt & 0x200) != 0) {
                            perms |= 8;
                        }
                        if ((encrypt & 0x400) != 0) {
                            perms |= 0x10;
                        }
                        if ((encrypt & 0x800) != 0) {
                            perms |= 0x20;
                        }
                        if ((encrypt & 0x1000) != 0) {
                            perms |= 0x100;
                        }
                        if ((encrypt & 0x2000) != 0) {
                            perms |= 0x200;
                        }
                        if ((encrypt & 0x4000) != 0) {
                            perms |= 0x400;
                        }
                        if ((encrypt & 0x8000) != 0) {
                            perms |= 4;
                        }
                        writer.setEncryption(userPass, ownerPass, perms, encryptType);
                    }
                }
            }
            if ((value = genericAttrs.get("PDFA")) != null) {
                if ("PDF/A-1A".equals(value.toUpperCase())) {
                    writer.setPDFXConformance(3);
                } else if ("PDF/A-1B".equals(value.toUpperCase())) {
                    writer.setPDFXConformance(4);
                }
                writer.createXmpMetadata();
            }
            document.open();
            imageMap = new TreeMap(new Comparator(){

                public int compare(Object o1, Object o2) {
                    return PDF.compare((Image[])o1, (Image[])o2);
                }
            });
            int i = pages.next(-1);
            while (i >= 0) {
                PageFormat pf = this.pg.getPageFormat(i - 1);
                or = pf.getOrientation();
                if (or == 0 || or == 2) {
                    pageWidth = height;
                    pageHeight = width;
                } else {
                    pageWidth = width;
                    pageHeight = height;
                }
                PdfContentByte cb = writer.getDirectContent();
                MyPdfPrinterGraphics2D g2d = jpegQuality > 0 ? new MyPdfPrinterGraphics2D(cb, pageWidth, pageHeight, (FontMapper)mapper, true, (float)jpegQuality / 100.0f, this.pj) : new MyPdfPrinterGraphics2D(cb, pageWidth, pageHeight, (FontMapper)mapper, false, 0.0f, this.pj);
                g2d.setImageMap(imageMap);
                try {
                    this.prn.print((Graphics)((Object)g2d), this.pg.getPageFormat(i - 1), i - 1);
                }
                catch (PrinterException e) {
                    g2d.drawString("" + e, 0, 0);
                }
                g2d.dispose();
                int next = pages.next(i);
                if (next >= 0) {
                    pf = this.pg.getPageFormat(i);
                    or = pf.getOrientation();
                    if (or == 0 || or == 2) {
                        pageWidth = height;
                        pageHeight = width;
                    } else {
                        pageWidth = width;
                        pageHeight = height;
                    }
                    document.setPageSize(new Rectangle(pageWidth, pageHeight));
                }
                document.newPage();
                i = pages.next(i);
            }
        }
        catch (DocumentException e) {
            throw new IOException("" + (Object)((Object)e));
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
        }
        return true;
    }

    private static Set<java.io.File> getFolders(String list) {
        if (list == null) {
            return null;
        }
        if ((list = list.trim()).length() == 0) {
            return null;
        }
        LinkedHashSet<java.io.File> set = new LinkedHashSet<java.io.File>();
        StringTokenizer st = new StringTokenizer(list, "|");
        while (st.hasMoreTokens()) {
            set.add(new java.io.File(st.nextToken()));
        }
        return set;
    }

    private static void insertDirectory(PDFFontMapper mapper, java.io.File dir) {
        mapper.insertDirectory(dir.getAbsolutePath());
        for (java.io.File subdir : dir.listFiles(f0 -> f0.isDirectory())) {
            PDF.insertDirectory(mapper, subdir);
        }
    }

    private static int compare(Image[] img1, Image[] img2) {
        if (img1[0] != null) {
            if (img2[0] != null) {
                int r = img1[0].hashCode() - img2[0].hashCode();
                if (r != 0) {
                    return r;
                }
                if (img1[1] != null) {
                    if (img2[1] != null) {
                        return img1[1].hashCode() - img2[1].hashCode();
                    }
                    return 1;
                }
                if (img2[1] != null) {
                    return -1;
                }
                return 0;
            }
            return 1;
        }
        if (img2[0] != null) {
            return -1;
        }
        return 0;
    }

    static {
        try {
            Class<?> c = Class.forName("java.nio.DirectByteBuffer");
            RtsUtil.openModule(c, MappedRandomAccessFile.class, "java.nio");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static class MyPdfPrinterGraphics2D
    extends PdfPrinterGraphics2D {
        MyPdfPrinterGraphics2D(PdfContentByte cb, float width, float height, FontMapper fontMapper, boolean convertImagesToJPEG, float quality, PrinterJob printerJob) {
            super(cb, width, height, fontMapper, false, convertImagesToJPEG, quality, printerJob);
        }

        public void drawString(String s, float x, float y) {
            super.drawString(RTL.checkRTL(s), x, y);
        }
    }
}

