/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.rts.Config;
import com.iscobol.rts.HandlesManager;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.print.PageColumn;
import com.iscobol.rts.print.PrintCommand;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class PrintCommandList
implements RuntimeErrorsNumbers {
    private long nextIdx = 0L;
    private Vector vec;
    private int numElem = 0;
    private File file;
    RandomAccessFile inOut;
    private boolean onFile;
    AbstractGuiFactoryImpl gf;
    final HandlesManager locHandles = new HandlesManager();
    PageColumn[] classPageCols;
    int[] classDataCols;

    public PrintCommandList(GuiFactory gf, boolean onFile) {
        this.gf = (AbstractGuiFactoryImpl)gf;
        this.onFile = onFile;
        if (this.onFile) {
            try {
                this.file = File.createTempFile("picobol_prn", null);
                this.file.deleteOnExit();
                this.inOut = new RandomAccessFile(this.file, "rw");
            }
            catch (IOException e) {
                throw new IscobolRuntimeException(8, e.toString());
            }
        } else {
            this.vec = new Vector();
        }
    }

    public PrintCommandList(GuiFactory gf) {
        this(gf, !Config.getProperty("iscobol.print.memory", false));
    }

    long addItem(PrintCommand t) {
        long Return2 = 0L;
        if (this.onFile) {
            try {
                Return2 = this.inOut.length();
                this.inOut.seek(Return2);
                PrintCommand.write(t, this.inOut);
                this.nextIdx = this.inOut.getFilePointer();
            }
            catch (IOException e) {
                throw new IscobolRuntimeException(8, this.file.getPath() + ": " + e.toString());
            }
        } else {
            this.vec.addElement(t);
            ++this.nextIdx;
            Return2 = this.numElem;
        }
        ++this.numElem;
        return Return2;
    }

    PrintCommand getNext() {
        PrintCommand Return2 = null;
        if (this.onFile) {
            try {
                Return2 = PrintCommand.read(this);
                this.nextIdx = this.inOut.getFilePointer();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException e) {
                throw new IscobolRuntimeException(8, this.file.getPath() + ": " + e.toString());
            }
        } else {
            try {
                Return2 = (PrintCommand)this.vec.elementAt((int)this.nextIdx++);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                --this.nextIdx;
            }
        }
        return Return2;
    }

    int getItemNum() {
        return this.numElem;
    }

    public void finalize() {
        if (this.onFile) {
            try {
                this.inOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.file.delete();
        }
    }

    PrintCommand getFirst() {
        return this.getAt(0L);
    }

    PrintCommand getAt(long at) {
        PrintCommand Return2 = null;
        if (this.onFile) {
            try {
                this.inOut.seek(at);
            }
            catch (IOException e) {
                throw new IscobolRuntimeException(8, this.file.getPath() + ": " + e.toString());
            }
        }
        try {
            this.nextIdx = at;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        Return2 = this.getNext();
        return Return2;
    }

    long getNextIdx() {
        return this.nextIdx;
    }
}

