/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.IPicAnyLength;
import com.iscobol.rts.Memory;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.LiteralAll;
import com.iscobol.types_n.MemoryFast;
import com.iscobol.types_n.NumericVar;
import com.iscobol.types_n.PicBinary;
import com.iscobol.types_n.PicN;
import com.iscobol.types_n.PicX;
import java.io.UnsupportedEncodingException;

public class NumericLiteralAll
extends PicBinary {
    private Memory pseudoBuffer;
    private int origLen = super.getLen();
    private boolean national;
    private static final long serialVersionUID = 123L;

    public NumericLiteralAll(long lit, int nInt, int nDec, boolean pComma) {
        super(lit, 8, true, nInt, nDec, pComma);
        this.resetAll();
    }

    public static NumericLiteralAll numericLiteralAll(long lit, int nInt, int nDec, boolean pComma) {
        return new NumericLiteralAll(lit, nInt, nDec, pComma);
    }

    @Override
    public Memory getMemory() {
        return this.pseudoBuffer;
    }

    private byte[] longToBytes(long l) {
        byte[] Return2;
        String s = Long.toString(l);
        if (this.national) {
            char[] c = s.toCharArray();
            Return2 = new byte[c.length];
            for (int i = 0; i < Return2.length; ++i) {
                Return2[i] = (byte)c[i];
            }
        } else {
            try {
                Return2 = s.getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                Return2 = s.getBytes();
            }
        }
        return Return2;
    }

    private void setAll(PicN dest) {
        this.national = true;
        byte[] value = this.longToBytes(this.getLong());
        this.end = this.len = dest.getLen();
        this.pseudoBuffer = new MemoryFast(this.len);
        if (this.pseudoBuffer.length < value.length) {
            int i = 0;
            while (i < this.pseudoBuffer.length) {
                this.pseudoBuffer.put(i++, (byte)0);
                this.pseudoBuffer.put(i++, value[i]);
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < this.pseudoBuffer.length) {
                this.pseudoBuffer.put(i++, (byte)0);
                this.pseudoBuffer.put(i++, value[j % value.length]);
                ++j;
            }
        }
    }

    private void setAll(CobolVar dest) {
        byte[] value = this.longToBytes(this.getLong());
        this.end = this.len = dest.getLen();
        this.pseudoBuffer = Memory.getMemory(this.len);
        if (this.pseudoBuffer.length < value.length) {
            for (int i = 0; i < this.pseudoBuffer.length; ++i) {
                this.pseudoBuffer.put(i, value[i]);
            }
        } else {
            for (int i = 0; i < this.pseudoBuffer.length; ++i) {
                this.pseudoBuffer.put(i, value[i % value.length]);
            }
        }
    }

    @Override
    int getLen() {
        return this.len;
    }

    @Override
    int getEnd() {
        return this.end;
    }

    private synchronized void resetAll() {
        this.len = this.origLen;
        this.national = false;
        byte[] data = this.longToBytes(this.num().longValue());
        this.end = this.len = data.length;
        this.pseudoBuffer = new MemoryFast(data);
    }

    @Override
    public synchronized CobolVar moveTo(PicN dest) {
        this.setAll(dest);
        dest.set(this.pseudoBuffer, 0, this.pseudoBuffer.length, true);
        this.resetAll();
        return this;
    }

    @Override
    public synchronized CobolVar moveTo(PicX dest) {
        this.setAll(dest);
        dest.set(this.pseudoBuffer, 0, this.pseudoBuffer.length, true);
        this.resetAll();
        return this;
    }

    @Override
    public synchronized CobolVar moveTo(NumericVar dest) {
        return super.moveTo(dest);
    }

    @Override
    public synchronized CobolVar moveTo(CobolVar dest) {
        this.setAll(dest);
        dest.set(this.pseudoBuffer, 0, this.pseudoBuffer.length, true);
        this.resetAll();
        return this;
    }

    @Override
    public synchronized CobolVar moveToDepOnGroupItem(CobolVar dest) {
        this.setAll(dest);
        super.moveToDepOnGroupItem(dest);
        this.resetAll();
        return this;
    }

    @Override
    public synchronized int compareTo(PicN cfrt) {
        if (cfrt instanceof IPicAnyLength && cfrt.getLength() == 0) {
            return 1;
        }
        this.setAll(cfrt);
        int Return2 = super.compareTo(cfrt);
        this.resetAll();
        return Return2;
    }

    public synchronized int compareTo(PicX cfrt) {
        if (cfrt instanceof IPicAnyLength && cfrt.getLength() == 0) {
            return 1;
        }
        return LiteralAll.compareTo(this, cfrt);
    }

    @Override
    public synchronized int compareTo(CobolVar cfrt) {
        if (cfrt instanceof IPicAnyLength && cfrt.getLength() == 0) {
            return 1;
        }
        return LiteralAll.compareTo(this, cfrt);
    }

    @Override
    public synchronized int compareTo(PicN cfrt, int[] collSeq) {
        if (cfrt instanceof IPicAnyLength && cfrt.getLength() == 0) {
            return 1;
        }
        this.setAll(cfrt);
        int Return2 = super.compareTo(cfrt, collSeq);
        this.resetAll();
        return Return2;
    }

    public synchronized int compareTo(PicX cfrt, int[] collSeq) {
        if (cfrt instanceof IPicAnyLength && cfrt.getLength() == 0) {
            return 1;
        }
        return LiteralAll.compareTo(this, cfrt, collSeq);
    }

    @Override
    public synchronized int compareTo(CobolVar cfrt, int[] collSeq) {
        if (cfrt instanceof IPicAnyLength && cfrt.getLength() == 0) {
            return 1;
        }
        return LiteralAll.compareTo(this, cfrt, collSeq);
    }

    @Override
    public String toString() {
        return this.toString(this.isDecPointComma);
    }

    @Override
    public String toString(boolean decPointComma) {
        String Return2;
        Memory mem = this.getMemory();
        if (this.national) {
            Return2 = new String(PicN.byteToChar(mem, 0, mem.length));
            if (decPointComma) {
                Return2 = Return2.replace('.', ',');
            }
        } else {
            Return2 = super.toString(decPointComma);
        }
        return Return2;
    }

    @Override
    public byte[] getBytes() {
        byte[] Return2 = new byte[this.pseudoBuffer.length];
        for (int i = 0; i < Return2.length; ++i) {
            Return2[i] = this.pseudoBuffer.get(i);
        }
        return Return2;
    }

    @Override
    public CobolNum num() {
        return this.theValue;
    }

    @Override
    public boolean isAll() {
        return true;
    }
}

