/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.Memory;
import com.iscobol.rts.SignEncOpt;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.EncBytes;
import com.iscobol.types_n.NumericVar;
import com.iscobol.types_n.PicNumEdit;

public class PicDisplay
extends NumericVar
implements EncBytes,
SignEncOpt {
    private static final long serialVersionUID = 123L;
    private boolean signSeparated = false;
    private boolean signLeading = false;
    private final byte[][] encoded_sign;

    private byte[][] init(int opt, boolean sSeparated, boolean sLeading) {
        this.signSeparated = sSeparated;
        this.signLeading = sLeading;
        switch (opt) {
            default: {
                return dca_encoded_sign;
            }
            case 1: {
                return dci_encoded_sign;
            }
            case 2: {
                return dcm_encoded_sign;
            }
            case 3: {
                return dcb_encoded_sign;
            }
            case 4: 
        }
        return dcr_encoded_sign;
    }

    public PicDisplay(Memory m, int i, int il, int dl, boolean signed, int[] dimSize, int[] dim, String name, int opt, boolean sSeparated, boolean sLeading, boolean pComma) {
        super(m, i, il, dl, signed, il + dl + (sSeparated && signed ? 1 : 0), dimSize, dim, name, pComma);
        this.encoded_sign = this.init(opt, sSeparated, sLeading);
    }

    public PicDisplay(CobolVar par, int i, int il, int dl, boolean signed, int[] dimSize, int[] dim, String name, int opt, boolean sSeparated, boolean sLeading, boolean pComma) {
        super(par, i, il, dl, signed, il + dl + (sSeparated && signed ? 1 : 0), dimSize, dim, name, pComma);
        this.encoded_sign = this.init(opt, sSeparated, sLeading);
    }

    private void putBDToMem(Memory mem, BigCobolDec _bcd) {
        BigCobolDec val = new BigCobolDec(_bcd);
        int i = this.end - 1;
        int loffs = this.curOffset;
        boolean minus = val.isNegative() ? this.signed : false;
        byte digit = encoded_digits[val.getDecDigit(0)];
        val.shift(-1);
        if (this.signed) {
            if (this.signSeparated) {
                if (this.signLeading) {
                    ++loffs;
                } else {
                    mem.put(i--, minus ? C_MINUS : C_PLUS);
                }
                mem.put(i--, digit);
            } else if (this.signLeading) {
                mem.put(i--, digit);
            } else {
                mem.put(i--, this.encodeSign(minus, digit));
            }
        } else {
            mem.put(i--, digit);
        }
        while (i >= loffs) {
            digit = encoded_digits[val.getDecDigit(0)];
            val.shift(-1);
            mem.put(i--, digit);
        }
        if (this.signed) {
            if (this.signSeparated) {
                if (this.signLeading) {
                    mem.put(this.curOffset, minus ? C_MINUS : C_PLUS);
                }
            } else if (this.signLeading) {
                mem.put(this.curOffset, this.encodeSign(minus, digit));
            }
        }
    }

    private void putLongToMem(Memory mem, long val) {
        int loffs = this.curOffset;
        if (this.signed) {
            if (this.signSeparated) {
                if (this.signLeading) {
                    int i = this.end - 1;
                    if (val < 0L) {
                        val = -val;
                        mem.put(loffs++, C_MINUS);
                    } else {
                        mem.put(loffs++, C_PLUS);
                    }
                    while (val != 0L && i >= loffs) {
                        mem.put(i, encoded_digits[(int)(val % 10L)]);
                        --i;
                        val /= 10L;
                    }
                    while (i >= loffs) {
                        mem.put(i, encoded_digits[0]);
                        --i;
                    }
                } else {
                    int i = this.end - 1;
                    if (val < 0L) {
                        val = -val;
                        mem.put(i--, C_MINUS);
                    } else {
                        mem.put(i--, C_PLUS);
                    }
                    while (val != 0L && i >= loffs) {
                        mem.put(i, encoded_digits[(int)(val % 10L)]);
                        --i;
                        val /= 10L;
                    }
                    while (i >= loffs) {
                        mem.put(i, encoded_digits[0]);
                        --i;
                    }
                }
            } else if (this.signLeading) {
                int minus;
                int i = this.end - 1;
                if (val < 0L) {
                    val = -val;
                    minus = 1;
                } else {
                    minus = 0;
                }
                while (val != 0L && i > loffs) {
                    mem.put(i, encoded_digits[(int)(val % 10L)]);
                    --i;
                    val /= 10L;
                }
                while (i > loffs) {
                    mem.put(i, encoded_digits[0]);
                    --i;
                }
                mem.put(loffs, this.encoded_sign[(int)(val % 10L)][minus]);
            } else {
                int i = this.end - 1;
                if (val < 0L) {
                    val = -val;
                    mem.put(i--, this.encoded_sign[(int)(val % 10L)][1]);
                } else {
                    mem.put(i--, this.encoded_sign[(int)(val % 10L)][0]);
                }
                val /= 10L;
                while (val != 0L && i >= loffs) {
                    mem.put(i, encoded_digits[(int)(val % 10L)]);
                    --i;
                    val /= 10L;
                }
                while (i >= loffs) {
                    mem.put(i, encoded_digits[0]);
                    --i;
                }
            }
        } else {
            int i = this.end - 1;
            if (val < 0L) {
                val = -val;
            }
            while (val != 0L && i >= loffs) {
                mem.put(i, encoded_digits[(int)(val % 10L)]);
                --i;
                val /= 10L;
            }
            while (i >= loffs) {
                mem.put(i, encoded_digits[0]);
                --i;
            }
        }
    }

    @Override
    void updateMemory(Memory mem, CobolNum cn) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(mem, cn.getUnscaledLong());
        } else {
            this.putBDToMem(mem, cn.bigCobDecValue());
        }
    }

    @Override
    void updateMemory(Memory mem) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(mem, this.num().getUnscaledLong());
        } else {
            this.putBDToMem(mem, this.num().bigCobDecValue());
        }
    }

    @Override
    public void defaultInitialize() {
        this.theValue.lnUnscValue = 0L;
        Memory mem = this.getMemory();
        mem.fill(this.curOffset, this.end, C_0);
        if (this.signed) {
            if (this.signLeading) {
                if (this.signSeparated) {
                    mem.put(this.curOffset, C_PLUS);
                } else {
                    mem.put(this.curOffset, this.encoded_sign[0][0]);
                }
            } else if (this.signSeparated) {
                mem.put(this.end - 1, C_PLUS);
            } else {
                mem.put(this.end - 1, this.encoded_sign[0][0]);
            }
        }
    }

    @Override
    public boolean isNumeric() {
        Memory mem = this.getMemory();
        for (int i = this.curOffset; i < this.end; ++i) {
            byte c = mem.get(i);
            if (i == this.curOffset && this.signed && this.signLeading && !this.signSeparated) {
                c = (byte)(this.decodeSign(this.myIsNegative(mem), c) + C_0);
            }
            if (i == this.end - 1 && this.signed && !this.signLeading && !this.signSeparated) {
                c = (byte)(this.decodeSign(this.myIsNegative(mem), c) + C_0);
            }
            if (c >= C_0 && c <= C_9) continue;
            if (c == C_PLUS || c == C_MINUS) {
                if (this.signed) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isNegative() {
        return this.isNumeric() && this.num().isNegative();
    }

    @Override
    public void subFromMe(long n) {
        this.addToMe(-n);
    }

    @Override
    public void addToMe(long n) {
        if (this.signed || n > 9L || n < -9L || this.decLen > 0 || this.intLen > 18) {
            super.addToMe(n);
        } else {
            int i;
            if (this.isFinal) {
                return;
            }
            long result = 0L;
            Memory mem = this.memory.getMemory();
            byte mask = 0;
            int digit = 0;
            int carry = (int)n;
            int k = 0;
            for (i = this.end - 1; i >= this.curOffset; --i) {
                mask = mem.get(i);
                digit = (mask & 0xF) + carry;
                mask = C_0;
                if (digit > 9) {
                    carry = 1;
                    mem.put(i, (byte)((digit -= 10) | mask));
                    result += (long)digit * CobolNum.fact[k];
                } else if (digit < 0) {
                    carry = -1;
                    mem.put(i, (byte)((digit += 10) | mask));
                    result += (long)digit * CobolNum.fact[k];
                } else {
                    carry = 0;
                    mem.put(i, (byte)(digit | mask));
                    result += (long)digit * CobolNum.fact[k];
                    --i;
                    break;
                }
                ++k;
            }
            if (carry < 0) {
                i = this.end - 1;
                mask = mem.get(this.end - 1);
                digit = mask & 0xF;
                result = 10 - digit;
                mask = (byte)(mask & 0xF0);
                mem.put(i, (byte)(result | (long)mask));
                --i;
                while (i >= this.curOffset) {
                    mem.put(i, mask);
                    --i;
                }
            } else {
                ++k;
                while (i >= this.curOffset) {
                    digit = mem.get(i) & 0xF;
                    result += (long)digit * CobolNum.fact[k];
                    mem.put(i, (byte)(digit | mask));
                    ++k;
                    --i;
                }
            }
            this.theValue.set(result, 0, false);
        }
    }

    @Override
    void updateCache(Memory mem, CobolNum cn) {
        if (checkNC != 0) {
            this.checkNumericContent();
        }
        if (this.intLen + this.decLen <= 18) {
            cn.set(this.getLongFromMem(mem), this.decLen);
        } else {
            cn.set(this.getBDFromMem(mem));
        }
    }

    private long getLongFromMem(Memory mem) {
        long Return2;
        block15: {
            block12: {
                block13: {
                    block14: {
                        Return2 = 0L;
                        if (!this.signed) break block12;
                        if (!this.signSeparated) break block13;
                        if (!this.signLeading) break block14;
                        int i = this.end - 1;
                        int k = 0;
                        while (i > this.curOffset) {
                            Return2 += (long)(mem.get(i) & 0xF) * CobolNum.fact[k];
                            --i;
                            ++k;
                        }
                        if (mem.get(this.curOffset) == C_MINUS) {
                            Return2 = -Return2;
                        }
                        break block15;
                    }
                    int i = this.end - 2;
                    int k = 0;
                    while (i >= this.curOffset) {
                        Return2 += (long)(mem.get(i) & 0xF) * CobolNum.fact[k];
                        --i;
                        ++k;
                    }
                    if (mem.get(this.end - 1) != C_MINUS) break block15;
                    Return2 = -Return2;
                    break block15;
                }
                if (this.signLeading) {
                    int i = this.end - 1;
                    int k = 0;
                    while (i > this.curOffset) {
                        Return2 += (long)(mem.get(i) & 0xF) * CobolNum.fact[k];
                        --i;
                        ++k;
                    }
                    i = this.getInternalSignDigit(mem.get(this.curOffset));
                    if (i < 0) {
                        Return2 = -Return2;
                        Return2 += (long)(++i) * CobolNum.fact[k];
                    } else {
                        Return2 += (long)i * CobolNum.fact[k];
                    }
                } else {
                    int i = this.end - 2;
                    int k = 1;
                    while (i >= this.curOffset) {
                        Return2 += (long)(mem.get(i) & 0xF) * CobolNum.fact[k];
                        --i;
                        ++k;
                    }
                    i = this.getInternalSignDigit(mem.get(this.end - 1));
                    if (i < 0) {
                        Return2 = -Return2;
                        Return2 += (long)(++i);
                    } else {
                        Return2 += (long)i;
                    }
                }
                break block15;
            }
            int i = this.end - 1;
            int k = 0;
            while (i >= this.curOffset) {
                Return2 += (long)(mem.get(i) & 0xF) * CobolNum.fact[k];
                --i;
                ++k;
            }
        }
        return Return2;
    }

    private BigCobolDec getBDFromMem(Memory mem) {
        int i = this.end - 1;
        boolean negative = this.myIsNegative(mem);
        char[] cNum = new char[this.intLen + this.decLen + 2];
        int cnIdx = cNum.length;
        if (this.signed) {
            if (this.signLeading) {
                cNum[--cnIdx] = (char)(mem.get(i--) & 0xF);
            } else if (this.signSeparated) {
                int n = --i;
                --i;
                cNum[--cnIdx] = (char)(mem.get(n) & 0xF);
            } else {
                cNum[--cnIdx] = (char)this.decodeSign(negative, mem.get(this.end - 1));
                --i;
            }
        } else {
            cNum[--cnIdx] = (char)(mem.get(i--) & 0xF);
        }
        while (i > this.curOffset) {
            cNum[--cnIdx] = (char)(mem.get(i) & 0xF);
            --i;
        }
        if (this.signed) {
            if (this.signLeading) {
                if (!this.signSeparated) {
                    cNum[--cnIdx] = (char)this.decodeSign(negative, mem.get(this.curOffset));
                }
            } else {
                cNum[--cnIdx] = (char)(mem.get(i) & 0xF);
            }
        } else {
            cNum[--cnIdx] = (char)(mem.get(i) & 0xF);
        }
        return PicDisplay.getBD(cNum, cnIdx, negative, this.decLen);
    }

    private byte encodeSign(boolean m, byte c) {
        int j = m ? 1 : 0;
        int i = c & 0xF;
        return this.encoded_sign[i][j];
    }

    private byte decodeSign(boolean m, byte d) {
        int j = m ? 1 : 0;
        for (int i = 0; i < this.encoded_sign.length; ++i) {
            if (this.encoded_sign[i][j] != d) continue;
            return (byte)i;
        }
        return (byte)(d & 0xF);
    }

    private boolean myIsNegative(Memory mem) {
        if (this.signed) {
            if (this.signSeparated) {
                if (this.signLeading) {
                    return mem.get(this.curOffset) == C_MINUS;
                }
                return mem.get(this.end - 1) == C_MINUS;
            }
            if (this.signLeading) {
                return this.myIsNegative(mem.get(this.curOffset));
            }
            return this.myIsNegative(mem.get(this.end - 1));
        }
        return false;
    }

    private boolean myIsNegative(byte d) {
        return this.getInternalSignDigit(d) < 0;
    }

    private int getInternalSignDigit(byte d) {
        byte neg0 = this.encoded_sign[0][1];
        byte neg1 = this.encoded_sign[1][1];
        byte neg9 = this.encoded_sign[9][1];
        byte pos0 = this.encoded_sign[0][0];
        byte pos1 = this.encoded_sign[1][0];
        byte pos9 = this.encoded_sign[9][0];
        if (d >= neg1 && d <= neg9) {
            return -(d - neg1 + 2);
        }
        if (d >= pos1 && d <= pos9) {
            return d - pos1 + 1;
        }
        if (d == neg0) {
            return -1;
        }
        if (d == pos0) {
            return 0;
        }
        return d & 0xF;
    }

    @Override
    public boolean isSignLeading() {
        return this.signLeading;
    }

    @Override
    public boolean isSignSeparated() {
        return this.signSeparated;
    }

    @Override
    protected void encodeSign(StringBuffer sb, boolean neg) {
        int signIdx = this.isSignLeading() ? 0 : sb.length() - 1;
        int i = sb.charAt(signIdx) - 48;
        if (i < dci_encoded_sign_ascii.length) {
            sb.setCharAt(signIdx, dci_encoded_sign_ascii[i][neg ? 1 : 0]);
        }
    }

    @Override
    public CobolVar moveTo92UD(PicNumEdit dest) {
        if (!this.isNumeric()) {
            dest.setBytes(this.getMemory(), this.getOffset(), this.getLen());
        } else {
            dest.set(this);
        }
        return this;
    }
}

