/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.Config;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IPicG;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.Memory;
import com.iscobol.rts_n.Factory;
import com.iscobol.types.Dbcs;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.LiteralAll;
import com.iscobol.types_n.MemMan;
import com.iscobol.types_n.NumericLiteralAll;
import com.iscobol.types_n.NumericVar;
import com.iscobol.types_n.PicGAnyLength;
import com.iscobol.types_n.PicN;
import com.iscobol.types_n.PicX;
import java.io.UnsupportedEncodingException;

public class PicG
extends PicX
implements IPicG {
    private static final boolean acuCompat = Config.getProperty("iscobol.national.acu_compatibility", false);

    public PicG(Memory m, int i, int l, int[] dimSize, int[] dim, String n, boolean pComma, boolean isJust) {
        super(m, i, l, dimSize, dim, n, pComma, isJust);
    }

    public PicG(CobolVar par, int i, int l, int[] dimSize, int[] dim, String n, boolean pComma, boolean isJust) {
        super(par, i, l, dimSize, dim, n, pComma, isJust);
    }

    @Override
    public boolean set(byte[] src, int srcStart, int srcLen, boolean filling) {
        int end = this.getEnd();
        int len = this.getLen();
        int diff = len - srcLen;
        Memory mem = this.getMemory();
        int offs = this.getOffset();
        if (this.isFinal) {
            return false;
        }
        if (diff <= 0) {
            if (this.isJustified) {
                mem.set(offs, src, srcStart - diff, len);
            } else {
                mem.set(offs, src, srcStart, len);
            }
        } else if (this.isJustified) {
            mem.set(offs + diff, src, srcStart, srcLen);
            if (filling) {
                mem.fill(offs, end - srcLen, Dbcs.fillBA);
            }
        } else {
            mem.set(offs, src, srcStart, srcLen);
            if (filling) {
                mem.fill(offs + srcLen, end, Dbcs.fillBA);
            }
        }
        return false;
    }

    @Override
    void internalSet(CobolVar cv) {
        switch (cv.getFigurativeType()) {
            default: {
                cv.moveTo(this);
                break;
            }
            case -2: {
                this.setSpace();
                break;
            }
            case -3: {
                this.setAllZero();
                break;
            }
            case -4: {
                this.setAll(Dbcs.quoteBA);
            }
        }
    }

    @Override
    protected void set(PicX px) {
        if (px.getFigurativeType() == -4) {
            this.setAll(Dbcs.quoteBA);
        } else if (acuCompat) {
            byte[] b;
            StringBuffer sb = new StringBuffer();
            for (char c : px.basicToString().toCharArray()) {
                if (c < '\u0100') {
                    sb.append(Dbcs.dbcs_str[c]);
                    continue;
                }
                sb.append(c);
            }
            String str = sb.toString();
            try {
                b = str.getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                b = str.getBytes();
            }
            this.set(b, 0, b.length, true);
        } else {
            super.set(px);
        }
    }

    @Override
    public boolean set(Memory src, int srcStart, int srcLen, boolean filling) {
        int destLen = this.getLen();
        Memory mem = this.getMemory();
        int offs = this.getOffset();
        int end = offs + destLen;
        int diff = destLen - srcLen;
        if (this.isFinal) {
            return false;
        }
        if (diff <= 0) {
            if (this.isJustified) {
                src.copy(srcStart - diff, mem, offs, destLen);
            } else {
                src.copy(srcStart, mem, offs, destLen);
            }
        } else if (this.isJustified) {
            src.copy(srcStart, mem, offs + diff, srcLen);
            if (filling) {
                int to = end - srcLen;
                int from = offs;
                if ((to - from & 1) != 0) {
                    mem.put(to - 1, Factory.SPACE);
                    --to;
                }
                mem.fill(from, to, Dbcs.fillBA);
            }
        } else {
            src.copy(srcStart, mem, offs, srcLen);
            if (filling) {
                int to = end;
                int from = offs + srcLen;
                if ((to - from & 1) != 0) {
                    mem.put(to - 1, Factory.SPACE);
                    --to;
                }
                mem.fill(from, to, Dbcs.fillBA);
            }
        }
        return false;
    }

    protected void setAll(byte[] b) {
        this.getMemory().fill(this.getOffset(), this.getEnd(), b);
    }

    @Override
    public void setSpace() {
        this.setAll(Dbcs.fillBA);
    }

    @Override
    public void setAllZero() {
        this.setAll(Dbcs.zeroBA);
    }

    @Override
    public int getLength() {
        if (this.getMemory() == null) {
            return 0;
        }
        return this.getLen() / 2;
    }

    @Override
    public int compareTo(LiteralAll cfrt) {
        return -cfrt.compareTo(this);
    }

    @Override
    public int compareTo(NumericLiteralAll cfrt) {
        return -cfrt.compareTo(this);
    }

    private int compareToAll(byte[] b) {
        Memory mem = this.getMemory();
        int offs = this.getOffset();
        int end = offs + this.getLen();
        for (int i = offs; i < end; ++i) {
            if (i == end - 1) {
                return -((char)b[0]);
            }
            if (mem.get(i) != b[0]) {
                return (char)mem.get(i) - (char)b[0];
            }
            if (mem.get(++i) == b[1]) continue;
            return (char)mem.get(i) - (char)b[1];
        }
        return 0;
    }

    @Override
    public int compareTo(CobolVar val) {
        switch (val.getFigurativeType()) {
            case -2: {
                return this.compareToAll(Dbcs.fillBA);
            }
            case -3: {
                return this.compareToAll(Dbcs.zeroBA);
            }
            case -4: {
                return this.compareToAll(Dbcs.quoteBA);
            }
        }
        Memory val_mem = val.getMemory();
        int val_len = val.getLen();
        int c2 = val.getOffset();
        int len = this.getLen();
        int minLen = len < val_len ? len : val_len;
        int c1 = this.getOffset();
        Memory mem = this.getMemory();
        int i = 0;
        while (i < minLen) {
            if (mem.get(c1) != val_mem.get(c2)) {
                return (char)mem.get(c1) - (char)val_mem.get(c2);
            }
            ++i;
            ++c1;
            ++c2;
        }
        if (len < val_len) {
            while (i < val_len) {
                if (c2 == val_mem.length - 1) {
                    return -((char)val_mem.get(c2));
                }
                if (Dbcs.fillBA[0] != val_mem.get(c2)) {
                    return (char)Dbcs.fillBA[0] - (char)val_mem.get(c2);
                }
                ++i;
                if (Dbcs.fillBA[1] != val_mem.get(++c2)) {
                    return (char)Dbcs.fillBA[1] - (char)val_mem.get(c2);
                }
                ++i;
                ++c2;
            }
        } else {
            while (i < len) {
                if (i == len - 1) {
                    return -((char)Dbcs.fillBA[0]);
                }
                if (mem.get(c1) != Dbcs.fillBA[0]) {
                    return (char)mem.get(c1) - (char)Dbcs.fillBA[0];
                }
                ++i;
                if (mem.get(++c1) != Dbcs.fillBA[1]) {
                    return (char)mem.get(c1) - (char)Dbcs.fillBA[1];
                }
                ++i;
                ++c1;
            }
        }
        return 0;
    }

    @Override
    public int compareTo(NumericVar nv) {
        return super.compareTo(new PicN(nv.basicToString()));
    }

    @Override
    public int compareTo(NumericLiteralAll cfrt, int[] collSeq) {
        return -cfrt.compareTo(this, collSeq);
    }

    @Override
    public int compareTo(CobolVar val, int[] collSeq) {
        return this.compareTo(val);
    }

    @Override
    public int compareTo(NumericVar nv, int[] collSeq) {
        return super.compareTo(new PicN(nv.basicToString()), collSeq);
    }

    @Override
    public PicX sub(int start) {
        return this.subG(start);
    }

    @Override
    public PicX sub(int start, int subLen) {
        return this.subG(start, subLen);
    }

    @Override
    public ICobolVar intISub(int start) {
        return this.subG(start);
    }

    @Override
    public ICobolVar intISub(int start, int subLen) {
        return this.subG(start, subLen);
    }

    protected PicG subG(int start) {
        return this.subG(start, this.getLen() / 2 - start + 1);
    }

    protected PicG subG(int start, int subLen) {
        int len = this.getLength();
        if (this.checkSubLen(start, subLen, len) <= 0) {
            switch (substringCheck) {
                case 1: {
                    throw new IscobolRuntimeException(1, this.name + "(" + start + ":" + subLen + ") [" + len + "]");
                }
                case -1: {
                    Factory.log("CHECK SUBSTRING: detected index out of bound " + this.name + "(" + start + ":" + subLen + ") [" + len + "]");
                }
            }
        }
        if (start < 1) {
            start = 1;
        }
        if (subLen <= 0) {
            subLen = substr0lenAll ? len - (start - 1) : 0;
        } else if (!(this instanceof PicGAnyLength)) {
            int maxLen = com.iscobol.rts.Factory.substrUnbound ? (this.getMemory().length - this.getOffset()) / 2 : len;
            subLen = Math.max(0, Math.min(subLen, maxLen - start + 1));
        }
        int offs = this.getOffset();
        PicG Return2 = new PicG(this.getMemory(), offs + start * 2 - 2, subLen * 2, null, null, this.name, this.isDecPointComma, this.isJustified);
        if (this.memory.isDynamic()) {
            Return2.memory = new MemMan(this.getMemory());
        }
        return Return2;
    }

    @Override
    String myToString(CobolVar delim) {
        if (delim == null) {
            return null;
        }
        switch (delim.getFigurativeType()) {
            default: {
                return super.myToString(delim);
            }
            case -2: {
                return String.valueOf('\u3000');
            }
            case -3: {
                return String.valueOf('\uff10');
            }
            case -4: 
        }
        return String.valueOf('\u201d');
    }
}

