/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import com.veryant.cobol.compiler.Codepage;
import java.io.File;
import java.lang.reflect.Array;
import java.math.BigInteger;

public class Utils {
    public static final boolean DEBUG = false;
    public static final char CHAR_SIGNATURE = '$';
    public static final char SEPARATOR = File.separatorChar;
    public static final char PATHSEPARATOR = File.pathSeparatorChar;
    public static final String PATHSEPARATORSTRING = File.pathSeparator;
    private static String os;
    private static boolean windows;

    public static boolean isWindows() {
        if (os == null) {
            os = System.getProperty("os.name");
            windows = os.toLowerCase().contains("win");
        }
        return windows;
    }

    public static boolean badJavaIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        char[] cArray = string.toCharArray();
        if (cArray[0] == '$' || !Character.isJavaIdentifierStart(cArray[0])) {
            return true;
        }
        for (int i = 1; i < cArray.length; ++i) {
            if (Character.isJavaIdentifierPart(cArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidFile(String string) {
        return Utils.isValidFile(new File(string));
    }

    public static boolean isValidFile(File file) {
        return file.exists() && !file.isDirectory() && file.canRead();
    }

    public static boolean isValidDirectory(String string) {
        return string != null && string.length() > 0 && Utils.isValidDirectory(new File(string));
    }

    public static boolean isValidDirectory(File file) {
        return file.isDirectory();
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n > Math.max(string.lastIndexOf(92), string.lastIndexOf(47))) {
            return string.substring(n + 1);
        }
        return "";
    }

    public static String basename(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String pathMerge(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (string == null || string.length() <= 0) continue;
            stringBuilder.append(string);
            char c = string.charAt(string.length() - 1);
            if (c == SEPARATOR || Utils.isWindows() && c == '/') continue;
            stringBuilder.append(SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public static String[] splitPaths(String string) {
        string = string.trim();
        String[] stringArray = string.split(PATHSEPARATORSTRING + "+");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("$") || stringArray[i].endsWith(PATHSEPARATORSTRING)) continue;
            int n = i;
            stringArray[n] = stringArray[n] + SEPARATOR;
        }
        return stringArray;
    }

    public static String hexToDec(String string) throws NumberFormatException {
        return new BigInteger(string, 16).toString();
    }

    public static int hexToInt(char c) throws NumberFormatException {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        throw new NumberFormatException();
    }

    public static byte[] hexToByteArray(String string) throws NumberFormatException {
        int n = string.length();
        if (n > 0) {
            if (n % 2 != 0) {
                string = "0" + string;
            }
            byte[] byArray = new byte[n / 2];
            for (int i = 0; i < n; i += 2) {
                byArray[i / 2] = (byte)(Utils.hexToInt(string.charAt(i)) * 16 + Utils.hexToInt(string.charAt(i + 1)));
            }
            return byArray;
        }
        throw new NumberFormatException();
    }

    public static int hexToInt(String string) {
        return Integer.parseInt(string, 16);
    }

    public static String intToHex(int n) {
        return Integer.toHexString(n);
    }

    public static int toInt(String string) {
        return Integer.parseInt(string);
    }

    public static byte[] getBytes(String string, Codepage codepage) {
        return string.getBytes(codepage.getCharset());
    }

    public static <T> T[] join(T[] TArray, T[] TArray2) {
        if (TArray == null || TArray.length == 0) {
            return TArray2;
        }
        if (TArray2 == null || TArray2.length == 0) {
            return TArray;
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray[0].getClass(), TArray.length + TArray2.length);
        System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
        System.arraycopy(TArray2, 0, objectArray, TArray.length, TArray2.length);
        return objectArray;
    }

    public static String quoteString(String string) {
        return '\"' + string.replace("\\", "\\\\").replace("\"", "\\\"") + '\"';
    }

    public static String unquoteString(String string) {
        String string2 = string.substring(0, 1);
        return string.substring(1, string.length() - 1).replace(string2 + string2, string2);
    }

    public static <T> T as(Class<T> clazz, Object object) {
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        return null;
    }

    static {
        windows = false;
    }
}

