/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.DataUsage;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.frontend.Token;

public class AstDataUsage
extends AstNode {
    private final boolean signedClause;

    public AstDataUsage(Collector collector, Token token) {
        this(collector, token, false);
    }

    public AstDataUsage(Collector collector, Token token, boolean bl) {
        super(collector, token);
        this.signedClause = bl;
    }

    @Override
    public boolean isUniqueNode() {
        return true;
    }

    public DataUsage getDataUsage() {
        switch (this.getToken().kind) {
            case 74: {
                return DataUsage.BIT;
            }
            case 70: {
                return this.signedClause ? DataUsage.BINARY_CHAR_SIGNED : DataUsage.BINARY_CHAR_UNSIGNED;
            }
            case 73: {
                return this.signedClause ? DataUsage.BINARY_SHORT_SIGNED : DataUsage.BINARY_SHORT_UNSIGNED;
            }
            case 72: {
                return this.signedClause ? DataUsage.BINARY_LONG_SIGNED : DataUsage.BINARY_LONG_UNSIGNED;
            }
            case 71: {
                return this.signedClause ? DataUsage.BINARY_DOUBLE_SIGNED : DataUsage.BINARY_DOUBLE_UNSIGNED;
            }
            case 69: 
            case 140: 
            case 150: {
                return DataUsage.COMP;
            }
            case 142: 
            case 152: {
                return DataUsage.COMP_1;
            }
            case 143: 
            case 153: {
                return DataUsage.COMP_2;
            }
            case 144: 
            case 154: 
            case 528: {
                return DataUsage.COMP_3;
            }
            case 145: 
            case 155: {
                return DataUsage.COMP_4;
            }
            case 146: 
            case 156: {
                return DataUsage.COMP_5;
            }
            case 147: 
            case 157: {
                return DataUsage.COMP_6;
            }
            case 148: 
            case 158: {
                return DataUsage.COMP_X;
            }
            case 236: 
            case 237: {
                return DataUsage.DISPLAY;
            }
            case 345: {
                return DataUsage.FLOAT_SHORT;
            }
            case 344: {
                return DataUsage.FLOAT_LONG;
            }
            case 384: {
                return DataUsage.INDEX;
            }
            case 476: {
                return DataUsage.NATIONAL;
            }
            case 542: {
                return this.getContext().getP64().isSet() ? DataUsage.POINTER : DataUsage.POINTER_32;
            }
            case 543: {
                return DataUsage.POINTER_32;
            }
            case 113: {
                return DataUsage.CHARACTER;
            }
            case 160: {
                return DataUsage.CONDITION_VALUE;
            }
            case 215: {
                return DataUsage.DECIMAL;
            }
            case 502: {
                return DataUsage.OBJECT;
            }
            case 708: {
                return DataUsage.STRING;
            }
        }
        this.unsupportedFeature(this.getToken());
        return DataUsage.DISPLAY;
    }
}

