/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast.statements;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.ast.AstFileKeyReference;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstSymbol;
import com.veryant.cobol.compiler.ast.common.AstFileReference;
import com.veryant.cobol.compiler.ast.common.AstInvalidKey;
import com.veryant.cobol.compiler.ast.common.AstNotInvalidKey;
import com.veryant.cobol.compiler.ast.common.AstSize;
import com.veryant.cobol.compiler.ast.statements.AstAbstractFileIOStatement;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.stmts.Start;

public class AstStartStatement
extends AstAbstractFileIOStatement {
    public AstStartStatement(Collector collector, Token token) {
        super(collector, token);
    }

    @Override
    public void validate() {
        AstFileReference astFileReference = this.findChild(AstFileReference.class);
        switch (astFileReference.getFile().getOrganization()) {
            case Relative: 
            case Indexed: {
                AstFileKeyReference astFileKeyReference = this.findChild(AstFileKeyReference.class);
                if (astFileKeyReference == null) break;
                astFileKeyReference.validate(astFileReference.getFile());
                break;
            }
            default: {
                this.consoleWrite(72, this.getToken(), astFileReference.getFile().getOrganization().getDescription());
            }
        }
    }

    @Override
    public void walk() {
        Start start = new Start(this.getToken());
        for (AstNode astNode : this.getChildren()) {
            AstNode astNode2;
            if (astNode instanceof AstSymbol) {
                switch (astNode.getToken().kind) {
                    case 491: {
                        start.getData().setPartialNot();
                        break;
                    }
                    case 298: 
                    case 852: {
                        start.getData().setPartialEqual();
                        break;
                    }
                    case 365: 
                    case 851: {
                        start.getData().setPartialGreater();
                        break;
                    }
                    case 437: 
                    case 849: {
                        start.getData().setPartialLess();
                        break;
                    }
                    case 850: {
                        start.getData().setPartialGreaterOrEqualTo();
                        break;
                    }
                    case 848: {
                        start.getData().setPartialLessOrEqualTo();
                        break;
                    }
                    case 519: {
                        start.getData().setPartialOrEqualTo();
                    }
                }
                continue;
            }
            if (astNode instanceof AstFileReference) {
                astNode2 = (AstFileReference)astNode;
                start.getData().setFile(((AstFileReference)astNode2).getFile());
                continue;
            }
            if (astNode instanceof AstFileKeyReference) {
                astNode.walk();
                astNode2 = (AstFileKeyReference)astNode;
                start.getData().setKey(((AstFileKeyReference)astNode2).getKey());
                continue;
            }
            if (astNode instanceof AstSize) {
                start.getData().setSize(astNode.getChildOperand(0));
                continue;
            }
            if (astNode instanceof AstInvalidKey) {
                start.getData().setFailBody(this.walkAsBranch(astNode));
                continue;
            }
            if (!(astNode instanceof AstNotInvalidKey)) continue;
            start.getData().setSuccessBody(this.walkAsBranch(astNode));
        }
        this.getCode().addStatement(start);
    }
}

