/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CONSTANT
extends BaseDirective {
    private static final Pattern constantName = Pattern.compile("^[^ (\"]+");
    public static final String NAME = "CONSTANT";
    private HashMap<String, Object> constants;

    @Override
    protected void initialize() {
        this.constants = new HashMap();
    }

    @Override
    protected String parseTokensImpl(String string) throws InvalidDirectiveException {
        Matcher matcher = constantName.matcher(string);
        if (matcher.find()) {
            this.tokens.add(string.substring(matcher.start(), matcher.end()));
            string = string.substring(matcher.end()).trim();
        }
        return super.parseTokensImpl(string);
    }

    @Override
    public void setValues() throws InvalidDirectiveException {
        if (this.getTokenCount() == 0) {
            throw Directives.invalidDirectiveException("Directive %s: You must specify a name for this constant.", NAME);
        }
        String string = ((String)this.tokens.get(0)).toUpperCase();
        if (string.startsWith("\"") || string.startsWith("(")) {
            throw Directives.invalidDirectiveException("Directive %s: Invalid constant name '%s'.", NAME, string);
        }
        switch (this.getTokenCount()) {
            case 1: {
                this.addConstant(string, null);
                break;
            }
            case 2: {
                String string2 = (String)this.tokens.get(1);
                if (string2.startsWith("\"")) {
                    this.addConstant(string, this.getTokenValue(1));
                    break;
                }
                if (string2.startsWith("(")) {
                    this.addConstant(string, this.getTokenIntegerValue(1));
                    break;
                }
                throw Directives.invalidDirectiveException("Directive %s: Invalid constant value '%s'.", NAME, string2);
            }
            default: {
                throw Directives.invalidDirectiveException("Directive %s: Only one value is allowed.", NAME);
            }
        }
    }

    public void addConstant(String string, Object object) {
        this.constants.put(string, object);
    }

    @Override
    protected boolean merge(BaseDirective.Phase phase, BaseDirective baseDirective) {
        this.constants.putAll(((CONSTANT)baseDirective).getConstants());
        return true;
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return false;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.Any;
    }

    public HashMap<String, Object> getConstants() {
        return this.constants;
    }

    public CONSTANT(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 60;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

