/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm;

import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.emitters.IVMType;
import com.veryant.cobol.data.CobolBigDecimal;
import com.veryant.cobol.data.CobolDataReference;
import com.veryant.cobol.exceptions.COBOLCompilerException;
import java.util.HashMap;

public class VMType
implements IVMType {
    private static final HashMap<Class<?>, VMType> cache = new HashMap();
    public static final VMType VOID = new VMType(Void.TYPE, "Void");
    public static final VMType INT8 = new VMType(Byte.TYPE, "Byte", 2);
    public static final VMType INT16 = new VMType(Short.TYPE, "Short", 4);
    public static final VMType INT32 = new VMType(Integer.TYPE, "Int", 9);
    public static final VMType INT64 = new VMType(Long.TYPE, "Long", 18);
    public static final VMType FLOAT32 = new VMType(Float.TYPE, "Float", -1);
    public static final VMType FLOAT64 = new VMType(Double.TYPE, "Double", -2);
    public static final VMType BOOLEAN = new VMType(Boolean.TYPE, "Bool");
    public static final VMType CHAR = new VMType(Character.TYPE, "Char");
    public static final VMType INT128 = new VMType(CobolBigDecimal.class, "BigDecimal", 38);
    public static final VMType ADDRESS = new VMType(CobolDataReference.class, "DataReference");
    public static final VMType STRING = new VMType(String.class, "String");
    public static final VMType OBJECT = new VMType(Object.class, "Object");
    private static final VMType[] vmTypeByDigits = new VMType[]{null, INT32, INT32, INT32, INT32, INT32, INT32, INT32, INT32, INT32, INT64, INT64, INT64, INT64, INT64, INT64, INT64, INT64, INT64, INT128, INT128, INT128, INT128, INT128, INT128, INT128, INT128, INT128, INT128, INT128, INT128, INT128, INT128, INT128, INT128, INT128, INT128, INT128, INT128};
    private static final HashMap<Class<?>, VMType> boxingClasses = new HashMap();
    protected final Class<?> vmType;
    private final String name;
    private final Magnitude defaultMagnitude;

    public Magnitude getDefaultMagnitude() {
        return this.defaultMagnitude;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCanonicalName() {
        return this.vmType.getCanonicalName();
    }

    @Override
    public String getClassName() {
        return this.vmType.getSimpleName();
    }

    @Override
    public boolean isAssignableFrom(IVMType iVMType) {
        return this.vmType.isAssignableFrom(((VMType)iVMType).vmType);
    }

    @Override
    public boolean isPrimitive() {
        return this.vmType.isPrimitive();
    }

    @Override
    public boolean isArray() {
        return this.vmType.isArray();
    }

    @Override
    public VMType getComponentType() {
        return VMType.from(this.vmType.getComponentType());
    }

    public boolean isBoxed() {
        return boxingClasses.containsKey(this.vmType);
    }

    public VMType unbox() {
        return boxingClasses.get(this.vmType);
    }

    public boolean isNumber() {
        return this.isPrimitiveNumber() || this.vmType == CobolBigDecimal.class;
    }

    public boolean isPrimitiveNumber() {
        return this.isPrimitiveInteger() || this.isPrimitiveFloat();
    }

    public boolean isPrimitiveInteger() {
        return this.vmType == Short.TYPE || this.vmType == Integer.TYPE || this.vmType == Long.TYPE;
    }

    public boolean isPrimitiveFloat() {
        return this.vmType == Float.TYPE || this.vmType == Double.TYPE;
    }

    protected VMType(Class<?> clazz, String string) {
        this(clazz, string, null);
    }

    protected VMType(Class<?> clazz, String string, int n) {
        this(clazz, string, new Magnitude(true, n, 0));
    }

    protected VMType(Class<?> clazz, String string, Magnitude magnitude) {
        this.vmType = clazz;
        this.name = string;
        this.defaultMagnitude = magnitude;
        if (cache.put(clazz, this) != null) {
            throw new COBOLCompilerException("Internal error, invalid types cache usage");
        }
    }

    public boolean is(VMType ... vMTypeArray) {
        for (VMType vMType : vMTypeArray) {
            if (this != vMType) continue;
            return true;
        }
        return false;
    }

    public static VMType from(Class<?> clazz) {
        if (cache.containsKey(clazz)) {
            return cache.get(clazz);
        }
        return new VMType(clazz, clazz.getCanonicalName());
    }

    public static VMType from(Magnitude magnitude) {
        if (magnitude == null) {
            return OBJECT;
        }
        int n = magnitude.getDigits();
        switch (n) {
            case -1: {
                return FLOAT32;
            }
            case -2: {
                return FLOAT64;
            }
        }
        if (n < 1) {
            return INT32;
        }
        if (n >= vmTypeByDigits.length) {
            return INT128;
        }
        return vmTypeByDigits[n];
    }

    static {
        boxingClasses.put(Void.class, VOID);
        boxingClasses.put(Byte.class, INT8);
        boxingClasses.put(Short.class, INT16);
        boxingClasses.put(Integer.class, INT32);
        boxingClasses.put(Long.class, INT64);
        boxingClasses.put(Float.class, FLOAT32);
        boxingClasses.put(Double.class, FLOAT64);
        boxingClasses.put(Boolean.class, BOOLEAN);
        boxingClasses.put(Character.class, CHAR);
    }
}

