/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.emitters.jvm.builtin;

import com.veryant.cobol.compiler.BuiltIn;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.TruncConvention;
import com.veryant.cobol.compiler.emitters.jvm.BuiltInEmitter;
import com.veryant.cobol.compiler.emitters.jvm.JvmCodeSnippet;
import com.veryant.cobol.compiler.emitters.jvm.VMType;
import com.veryant.cobol.compiler.emitters.jvm.builtin.Opcodes;
import com.veryant.cobol.compiler.emitters.jvm.core.Errors;
import com.veryant.cobol.compiler.emitters.jvm.core.Functions;
import com.veryant.cobol.converters.Decimal;
import com.veryant.cobol.converters.PackedDecimal;

public abstract class NumericBinary {
    static final BuiltInEmitter LOAD = (jvmCode, abstractOperand) -> {
        BuiltIn builtIn = abstractOperand.getBuiltIn();
        Magnitude magnitude = abstractOperand.getMagnitude();
        VMType vMType = VMType.from(magnitude);
        Opcodes.LOAD_ADDR(jvmCode, abstractOperand, true);
        Class<?> clazz = builtIn.getStoreConvention();
        if (PackedDecimal.class.isAssignableFrom(clazz) || Decimal.class.isAssignableFrom(clazz)) {
            jvmCode.pop();
            com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.LOAD_CONST(jvmCode, magnitude.getDigits());
        }
        Functions.f_wrap_as_address(jvmCode);
        if (vMType == VMType.INT128) {
            jvmCode.push(abstractOperand, vMType, builtIn.getLoadConvention().getSimpleName() + ".load" + vMType.getName() + '(' + jvmCode.pop() + ',' + magnitude.getScale() + ')', magnitude);
        } else {
            jvmCode.push(abstractOperand, vMType, builtIn.getLoadConvention().getSimpleName() + ".load" + vMType.getName() + '(' + jvmCode.pop() + ')', magnitude);
        }
    };
    static final BuiltInEmitter STORE = (jvmCode, abstractOperand) -> {
        Magnitude magnitude = abstractOperand.getMagnitude();
        VMType vMType = (VMType)((JvmCodeSnippet)jvmCode.peek()).getVmType();
        BuiltIn builtIn = abstractOperand.getBuiltIn();
        TruncConvention truncConvention = builtIn.getTruncConvention();
        int n = 0;
        switch (truncConvention) {
            case YES: {
                n = magnitude.getDigits();
                break;
            }
            case CONFIGURABLE: {
                switch (jvmCode.getTruncation()) {
                    case ENFORCED: 
                    case ANSI: {
                        n = magnitude.getDigits();
                    }
                }
            }
        }
        if (vMType == VMType.INT32 || vMType == VMType.INT64) {
            if (n > 0) {
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.TRUNC(jvmCode, n, magnitude.getScale());
            } else {
                com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.SCALE(jvmCode, magnitude.getScale());
            }
        }
        JvmCodeSnippet jvmCodeSnippet = (JvmCodeSnippet)jvmCode.pop();
        Opcodes.LOAD_ADDR(jvmCode, abstractOperand, true);
        Class<?> clazz = builtIn.getStoreConvention();
        if (PackedDecimal.class.isAssignableFrom(clazz) || Decimal.class.isAssignableFrom(clazz)) {
            jvmCode.pop();
            com.veryant.cobol.compiler.emitters.jvm.core.Opcodes.LOAD_CONST(jvmCode, magnitude.getDigits());
        }
        Functions.f_wrap_as_address(jvmCode);
        if (vMType == VMType.INT128) {
            jvmCode.push(abstractOperand, VMType.VOID, clazz.getSimpleName() + ".store(" + jvmCodeSnippet + ',' + jvmCode.pop() + ',' + n + ',' + magnitude.getScale() + ");");
            return;
        }
        if (vMType == VMType.INT32 || vMType == VMType.INT64) {
            jvmCode.push(abstractOperand, VMType.VOID, clazz.getSimpleName() + ".store(" + jvmCodeSnippet + ',' + jvmCode.pop() + ");");
            return;
        }
        throw Errors.e_should_be_numeric(jvmCode.pop());
    };
}

