/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.filehandler;

import com.veryant.cobol.exceptions.COBOLFileHandlingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class FileLockData {
    private final File file;
    private final Path path;
    private final String fileName;
    private RandomAccessFile randomAccessFile = null;
    private int fileLockCount = 0;
    private FileLock fileLock = null;
    private final List<FileLock> sectionLocks = new ArrayList<FileLock>(16);
    private int sectionLockCount = 0;
    private boolean exclusiveLock = false;

    public Path getPath() {
        return this.path;
    }

    public FileLockData(File file) {
        this.file = file;
        this.path = file.toPath();
        this.fileName = this.path.toString();
    }

    public boolean hasNoLocks() {
        return this.fileLockCount == 0 && this.sectionLockCount == 0;
    }

    private RandomAccessFile getRandomAccessFile() throws FileNotFoundException {
        if (this.randomAccessFile != null) {
            return this.randomAccessFile;
        }
        return new RandomAccessFile(this.fileName, "rw");
    }

    public boolean tryLockFile() {
        if (this.exclusiveLock) {
            return false;
        }
        if (this.fileLockCount > 0) {
            ++this.fileLockCount;
            return true;
        }
        try {
            this.randomAccessFile = this.getRandomAccessFile();
            this.fileLock = this.randomAccessFile.getChannel().tryLock(0L, Long.MAX_VALUE, true);
            if (this.fileLock == null) {
                this.randomAccessFile.close();
                this.randomAccessFile = null;
                return false;
            }
            ++this.fileLockCount;
        }
        catch (IOException iOException) {
            throw COBOLFileHandlingException.getPermanentErrorException(this.fileName);
        }
        return true;
    }

    public FileLock tryLockSection(RandomAccessFile randomAccessFile, long l, long l2) {
        boolean bl = l == 0L && l2 == Long.MAX_VALUE;
        FileLock fileLock = null;
        try {
            if (this.fileLockCount > 0) {
                if (bl) {
                    return null;
                }
                if (this.fileLock != null) {
                    this.fileLock.close();
                    this.fileLock = null;
                }
            }
            if (bl) {
                fileLock = randomAccessFile.getChannel().tryLock(l, l2, false);
            }
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
        }
        catch (IOException iOException) {
            throw COBOLFileHandlingException.getPermanentErrorException(this.fileName);
        }
        if (bl && fileLock != null) {
            this.sectionLocks.add(fileLock);
            ++this.sectionLockCount;
            if (bl) {
                this.exclusiveLock = true;
            }
            return fileLock;
        }
        if (!bl) {
            ++this.sectionLockCount;
            return null;
        }
        this.restoreFileLock();
        return null;
    }

    public void unlockSection(FileLock fileLock) {
        if (fileLock != null) {
            try {
                fileLock.close();
            }
            catch (IOException iOException) {
                throw COBOLFileHandlingException.getPermanentErrorException(this.fileName);
            }
            this.sectionLocks.remove(fileLock);
            --this.sectionLockCount;
            if (fileLock.position() == 0L && fileLock.size() == Long.MAX_VALUE) {
                this.exclusiveLock = false;
            }
            this.restoreFileLock();
        } else {
            --this.sectionLockCount;
            this.restoreFileLock();
        }
    }

    private void restoreFileLock() {
        if (this.sectionLockCount == 0 && this.fileLockCount > 0) {
            try {
                this.fileLock = this.randomAccessFile.getChannel().tryLock(0L, Long.MAX_VALUE, true);
                if (this.fileLock == null) {
                    throw COBOLFileHandlingException.getPermanentErrorException(this.fileName);
                }
            }
            catch (IOException iOException) {
                throw COBOLFileHandlingException.getPermanentErrorException(this.fileName);
            }
        }
    }

    public void unlockFile() {
        if (this.fileLockCount == 1 && this.fileLock != null) {
            try {
                this.fileLock.close();
                this.randomAccessFile.close();
                this.randomAccessFile = null;
            }
            catch (IOException iOException) {
                throw COBOLFileHandlingException.getPermanentErrorException(this.fileName);
            }
        }
        --this.fileLockCount;
        if (this.hasNoLocks()) {
            this.dispose();
        }
    }

    public void dispose() {
        if (this.randomAccessFile != null && this.randomAccessFile.getChannel().isOpen()) {
            try {
                this.randomAccessFile.close();
                this.randomAccessFile = null;
            }
            catch (IOException iOException) {
                throw COBOLFileHandlingException.getPermanentErrorException(this.fileName);
            }
        }
    }
}

