
##### isCOBOL release 2025 R2 build#1158.10-20251128-41083 ######
##### Copyright (c) 2005 - 2025 Veryant. ######

----------
**The isCOBOL Server provides the ability to define a hook.**

**A hook is a program that is automatically executed when a Client starts**
**and when it exits.**

**This feature provides entry points to define additional operations that**
**should be done for each client session, for example a custom logging of**
**thin client activity.**

**The hook program is defined through the iscobol.as.hook property.**

**The hook program must be found in the server Classpath, it's never loaded**
**from iscobol.code_prefix paths.**

**Detailed information on the hook functionality can be found in the**
**isCOBOL documentation:**
**User's Guide : isCOBOL Server (Thin Client and Distributed Processing) : Hook program**
 
**This sample shows two common useful usages of this feature:**

 - Creating a custom log that traces login time and logout time of each client 
   session.

 - Performing an automatic shutdown of the Application Server after a specific 
   time-out if no client is still connected. 
   The "iscserver_hook.sh" perform an automatic reboot of the Application 
   Server after a specific time-out if no client is still connected.
   The time-out is specified into the MYHOOK.cbl source file by the variable 
   "RUNNINGHOURS"

**This document assumes the $ISCOBOL environment variable exists and points**
**to the isCOBOL SDK installation folder.**

**When talking about a "command prompt window" it means an isCOBOL Shell**
**on the Windows OS and a standard shell on Linux/Unix**

----------
 - 1 Using a command prompt window go to the "$ISCOBOL/sample/as/hook" folder

 - 2 Compile the MYHOOKTIMER.cbl and MYHOOK.cbl programs

        iscc MYHOOKTIMER.cbl

        iscc MYHOOK.cbl

 - 3 Make sure this property is set in iscobol.properties file 

        iscobol.as.hook MYHOOK

 - 4 Start the Application Server

        iscserver -hostname <hostname | IP address> -port <port-number>

 **NOTE:**

        If you have already started an instance of the Application Server,
        you can start a new instance of it on a different port
 
 **NOTE:**

        This will start the Application Server, reading the iscobol.properties
        file stored in the same directory, that contains the as.hook setting.**

 **NOTE:**

        If you want to provide an automatic restart of the Application Server when nobody was 
        connected, use the "iscserver_hook.sh".
        iscserver_hook.sh -port <port-number>
        or 
        iscserver_hook.sh -port <port-number> > status_server.log &

 - 5 From another command prompt start a client session

       iscclient -port <port-number> -panel 
      
 **NOTE:**

        if you use another PC use the following command

        iscclient -hostname <ip-address> -port <port-number> -panel

        Where ip-address is the IP address of the machine on which you started 
        the Application Server.

 - 6 Close the panel

 - 7 Look the contents of the file access.log comparing with the contents shown in
    the bottom of this file

 - 8 If you wait for three hours without connecting anymore, the Application Server 
    will automatically shut down, with an exit status of 1.

----------
#### The correct output should be:

 If you open with a text editor, you'll see something similar to this:

    [001 ENTER - 31/03/2010 11:01:10] 00000 - admin - ASA$GPANEL - 127.0.0.1
    [001 EXIT  - 01/03/2010 11:03:24] 00000 - admin - ASA$GPANEL - 127.0.0.1 

