#!/bin/sh
@echo off
clear

echo Start elaboration `date`

export FILENAME=DataFile.txt
echo Create the data file using the cobol program using the TRUN
../../../bin/trun CREATE_DATA

echo
echo Sort the data file using the isSort utility
echo Ascending key sr-artist, ascending key sr-year

../../../bin/issort "sort fields (36, 20, ch, a, 131, 4, nu, a) use $FILENAME org ls record f 135 give SortFile.txt org ls record f 135"

echo
echo Read the data file using the cobol program using the TRUN
../../../bin/trun READ_DATA

echo
echo Descending key sr-year, ascending key sr-artist
../../../bin/issort take sort.cmd

echo
echo Read the data file using the cobol program using the TRUN
../../../bin/trun READ_DATA

echo
echo End elaboration `date`
