import java.util.Vector;

import com.iscobol.compiler.custpreproc.LinePreProcessor;
import com.iscobol.compiler.custpreproc.ProcessException;
import com.iscobol.compiler.custpreproc.ProcessResult;

public class Db2ToOraclePreProc implements LinePreProcessor {
   private static interface Rule {
      boolean apply(int endExceSqlIndex);
   }
   private static class Tokenizer {
      
      private static final int NUM_INT = 1;
      private static final int NUM_FLT = 2;
      private static final int STRING = 3;
      private static final int USERNAME = 4;
      private static final int COMMENT = 5;
      private static final int SEPARATOR = 6;
      
      Vector<String> tokens = new Vector<String>();
      boolean noFormat;
      Tokenizer(String origLine, boolean noFormat) {
         this.noFormat = noFormat;
         addLine(origLine);
      }
      
      public void removeTokens(int fromIdx, int n) {
         for(int i = 0; i < n; i++) {
            tokens.removeElementAt(fromIdx);
         }
      }
      
      public String getToken(int idx) {
         return tokens.elementAt(idx);
      }
      
      public void setToken(int idx, String tk) {
         tokens.setElementAt(tk, idx);
      }
      public int findToken(String str, int fromIdx) {
         final int size = tokens.size();
         for(int i = fromIdx; i < size; i++) {
            if(tokens.elementAt(i).equalsIgnoreCase(str)) {
               return i;
            }
         }
         return -1;
      }
      
      public int findExecSql() {
         int Return = findToken("EXEC", 0);
         int idx;
         if(Return >= 0 && (idx = findNextTokenNoSpace(Return + 1)) > 0 &&
               tokens.elementAt(idx).equalsIgnoreCase("SQL")) {
            return Return;
         } else {
            return -1;
         }
      }
      
      public boolean isSpace(String tk) {
         return tk.trim().length() == 0;
      }

      public void addNL() {
         tokens.addElement("\n");
      }
      
      public int findNextTokenNoSpace(int fromIdx) {
         final int size = tokens.size();
         for(int i = fromIdx; i < size; i++) {
            if(!isSpace(tokens.elementAt(i))) {
               return i;
            }
         }
         return -1;
      }
      
      public int findPrevTokenNoSpace(int fromIdx) {
         for(int i = fromIdx; i >= 0; i--) {
            if(!isSpace(tokens.elementAt(i))) {
               return i;
            }
         }
         return -1;
      }
      
      public void addLine(String line) {
         int length = line.length();
         for(; length > 0 && line.charAt(length - 1) == ' '; length--)
            ;
         char[] chars = line.toCharArray();
         int i = 0;
         int fullLength = length;
         if(!noFormat) {
            i = 7;
            length = Math.min(length, 72);
            if(length > 5) {
               tokens.addElement(new String(chars, 0, 6));
               if(length > 6 && chars[6] == '*') {
                  tokens.addElement(new String(chars, 6, length - 6)); 
                  if(fullLength > length) {
                     tokens.addElement(new String(chars, length, fullLength - length));
                  }
                  return;
               }
            } else {
               tokens.addElement(new String(chars, 0, length));
               return;
            }
         }
         String tkWord = "";
         int tkId = SEPARATOR;
         char openString = 0; 
         char c;
         for1: 
            for(; i < length; i++) {
               c = chars[i];
               if(openString != 0) {
                  tkWord += c;
                  if(c == openString) {
                     tokens.add(tkWord);
                     tkWord = "";
                     openString = 0;
                  }
               } else {
                  switch(c) {
                  case '\'':
                  case '"':
                     if(tkWord.length() > 0) {
                        tokens.add(tkWord);
                     }
                     openString = c;
                     tkWord = "" + c;
                     tkId = STRING;
                     break;
                  case '*':
                     if(tkWord.length() > 0) {
                        tokens.add(tkWord);
                     }
                     tkWord = "" + c;
                     tkId = SEPARATOR;
                     break;
                  case '>':
                     if(tkWord.equals("*")) {
                        tkId = COMMENT;
                        tkWord += new String(chars, i, length - i);
                        tokens.add(tkWord);
                        tkWord = "";
                        break for1;
                     } else {
                        if(tkWord.length() > 0) {
                           tokens.add(tkWord);
                        }
                        tkWord = "" + c;
                        tkId = SEPARATOR;
                     }
                     break;
                  case ':':
                     if(tkId == SEPARATOR) {
                        if(tkWord.length() > 0) {
                           tokens.add(tkWord);
                        }
                        tkWord = "" + c;
                        tkId = USERNAME;
                     } else {
                        tkWord += c;
                     }
                     break;
                  case '-':
                     if(tkId == USERNAME) {
                        tkWord += c;
                     } else {
                        if(tkWord.length() > 0) {
                           tokens.add(tkWord);
                        }
                        tkWord = "" + c;
                        tkId = SEPARATOR;
                     }
                     break;
                  case '.':
                     if(tkId == NUM_INT && i < length - 1 && 
                     Character.isDigit(chars[i + 1])) {
                        tkWord += c;
                        tkId = NUM_FLT;
                     } else {
                        if(tkWord.length() > 0) {
                           tokens.add(tkWord);
                        }
                        tkWord = "" + c;
                        tkId = SEPARATOR;
                     }
                     break;
                  case '0':
                  case '1':
                  case '2':
                  case '3':
                  case '4':
                  case '5':
                  case '6':
                  case '7':
                  case '8':
                  case '9':
                     if(tkId == SEPARATOR) {
                        if(tkWord.length() > 0) {
                           tokens.add(tkWord);
                        }
                        tkWord = "" + c;
                        tkId = NUM_INT;
                     } else {
                        tkWord += c;
                     }
                     break;
                  case ' ':
                     if(tkWord.trim().length() > 0) {
                        tokens.add(tkWord);
                        tkWord = "";
                     }
                     tkWord += c;
                     tkId = SEPARATOR;
                     break;
                  default:
                     if(c == '_' || Character.isLetter(c)) {
                        if(tkId == SEPARATOR) {
                           if(tkWord.length() > 0) {
                              tokens.add(tkWord);
                           }
                           tkWord = "" + c;
                           tkId = USERNAME;
                        } else {
                           tkWord += c;
                        }
                     } else {
                        if(tkWord.length() > 0) {
                           tokens.add(tkWord);
                        }
                        tkWord = "" + c;
                        tkId = SEPARATOR;
                     }
                     break;
                  }
               }
            }
         if(tkWord.length() > 0) {
            tokens.add(tkWord);
         }
         if(fullLength > length) {
            tokens.addElement(new String(chars, length, fullLength - length));
         }
      }
   }
   
   private Tokenizer tokenizer;
   private Vector<String> originalLines = new Vector<String>();
   private int execSqlIndex = -1;
   private Vector<Rule> rules = new Vector<Rule>();
   
   public Db2ToOraclePreProc() {
      rules.addElement((int endExcIdx) -> { 
         return CURRENT_SPACE_RULE(endExcIdx);
      });
      rules.addElement((int endExecIdx) -> {
         return SELECT_FROM_SYSIBM_RULE(endExecIdx);
      });
      rules.addElement((int endExcIdx) -> { 
         return CHAR_FUNCTION_RULE(endExcIdx);
      });
   }
   
   public String getVersion() {
      return "1.1";
   }
   
   @Override
   public void process(String originalLine, 
                       int format, 
                       String fileName,
                       int lineNumber, 
                       String[] compOpts, 
                       ProcessResult result) throws ProcessException {
      if(originalLine == null) {
         result.setComment(true);
         result.setReplace(
               "       This source was preprocessed by Db2ToOracle v" + getVersion());
         return;
      }
      if(tokenizer == null) {
         tokenizer = new Tokenizer(originalLine, false);
         originalLines = new Vector<String>();
         int execIdx = tokenizer.findExecSql();
         if(execIdx >= 0) {
            originalLines.addElement(originalLine);
            int endExecIdx = tokenizer.findToken("END-EXEC", execIdx + 1);
            execSqlIndex = execIdx;
            if(endExecIdx >= 0) {
               analyzeExecSql(endExecIdx, format, result);
            } else {
               result.setReplace(null);
            }
         } else {
            tokenizer = null;
            originalLines = null;
         }
      } else {
         tokenizer.addNL();
         tokenizer.addLine(originalLine);
         originalLines.addElement(originalLine);
         int endExecIdx = tokenizer.findToken("END-EXEC", execSqlIndex + 1);
         if(endExecIdx >= 0) {
            analyzeExecSql(endExecIdx, format, result);
         } else {
            result.setReplace(null);
         }
      }
   }
   
   private void analyzeExecSql(int endExecIdx, int format, ProcessResult result) {
      boolean changed = false;
      for(Rule r : rules) {
         boolean c = r.apply(endExecIdx);
         if(c) {
            endExecIdx = tokenizer.findToken("END-EXEC", execSqlIndex + 1);
            changed = true;
         }
      }
      String replace = "";
      if(changed) {
         for(String t : tokenizer.tokens) {
            replace += t;
         }
      } else {
         for(String s : originalLines) {
            replace += s;
            replace += "\n";
         }
      }
      result.setReplace(replace);
      originalLines = null;
      execSqlIndex = -1;
      tokenizer = null;
   }
   
   private boolean CURRENT_SPACE_RULE(int endExecIdx) {
      boolean changed = false;
      int ti;
      for(int idx = execSqlIndex + 2; ; idx++) {
         ti = tokenizer.findNextTokenNoSpace(idx);
         if(ti > 0) {
            idx = ti;
            if(tokenizer.getToken(ti).equalsIgnoreCase("CURRENT")) {
               int idx2 = idx + 1;
               String tk0 = null;
               for(; idx2 < endExecIdx; idx2++) {
                  tk0 = tokenizer.getToken(idx2);
                  if(!tokenizer.isSpace(tk0)) {
                     break;
                  }
               }
               if(idx2 > idx + 1) {
                  if(tk0.equalsIgnoreCase("DATE")) {
                     changed = true;
                     tokenizer.setToken(ti, "CURRENT_" + tk0);
                     tokenizer.removeTokens(idx + 1, idx2 - idx);
                  } 
               }
            }
         } else {
            break;
         }
      }
      return changed;
   }
   
   private boolean SELECT_FROM_SYSIBM_RULE(int endExecIdx) {
      int idx = tokenizer.findToken("SELECT", execSqlIndex + 2);
      int ti2;
      boolean changed = false;
      if(idx > 0) {
         idx += 2;
         for( ; ; idx++) {
            if((idx = tokenizer.findToken("FROM", idx)) > 0) {
               if((ti2 = tokenizer.findNextTokenNoSpace(idx + 1)) > 0 && 
                     tokenizer.getToken(ti2).equalsIgnoreCase("SYSIBM") &&
                     ti2 < endExecIdx - 2 && 
                     tokenizer.getToken(ti2 + 1).equals(".") &&
                     tokenizer.getToken(ti2 + 2).equalsIgnoreCase("SYSDUMMY1")) {
                  tokenizer.removeTokens(ti2 + 1, 2);
                  tokenizer.setToken(ti2, "DUAL");
                  changed = true;
               }
            } else {
               break;
            }
         }
      }
      return changed;
   }
   
   private boolean CHAR_FUNCTION_RULE(int endExecIdx) {
      boolean changed = false;
      for1:
      for(int startIdx = execSqlIndex + 2; ; ) {
         int idx = tokenizer.findToken("CHAR", startIdx);
         int ti2;
         String tk;
         if(idx > 0 && (ti2 = tokenizer.findNextTokenNoSpace(idx + 1)) > 0 && 
               tokenizer.getToken(ti2).equals("(")) {
            int openPar = 1;
            int startParamIdx = -1;
            for( ; ; ) {
               ti2 = tokenizer.findNextTokenNoSpace(ti2 + 1);
               if(ti2 <= 0) {
                  break for1;
               }
               if(startParamIdx == -1) {
                  startParamIdx = ti2;
               }
               tk = tokenizer.getToken(ti2);
               switch(tk) {
               case "(":
                  openPar++;
                  break;
               case ")":
                  openPar--;
                  if(openPar == 0) {
                     if(tokenizer.findPrevTokenNoSpace(ti2 - 1) == startParamIdx) {
                        tk = tokenizer.getToken(startParamIdx);
                        if(tk.equalsIgnoreCase("ISO")) {
                           tokenizer.setToken(startParamIdx, "'YYYY-MM-DD'");
                           tokenizer.setToken(idx, "TO_CHAR");
                           changed = true;
                        } 
                     }
                     startIdx = startParamIdx + 1;
                     continue for1;
                  }
                  break;
               case ",":
                  if(openPar == 1) {
                     if(tokenizer.findPrevTokenNoSpace(ti2 - 1) == startParamIdx && 
                           (tk = tokenizer.getToken(startParamIdx)).equalsIgnoreCase("ISO")) {
                        tokenizer.setToken(startParamIdx, "'YYYY-MM-DD'");
                        tokenizer.setToken(idx, "TO_CHAR");
                        changed = true;
                     }
                     startParamIdx = -1;
                  }
                  break;
               }
            }
         } else {
            break;
         }
      }
      return changed;
   }
   
   public static String translateForOracle(String query) {
      Db2ToOraclePreProc db2or = new Db2ToOraclePreProc();
      Tokenizer tknzr = new Tokenizer(query, true);
      db2or.tokenizer = tknzr;
      tknzr.tokens.add(0, "EXEC");
      tknzr.tokens.add(1, "SQL");
      tknzr.tokens.addElement("END-EXEC");
      boolean changed = false;
      for(Rule r : db2or.rules) {
         boolean c = r.apply(tknzr.tokens.size());
         if(c) {
            changed = true;
         }
      }
      if(changed) {
         String line = "";
         int start = 2;
         int end = tknzr.tokens.size()- 1;
         for(int i = end - 1; i >= start; i--, end--) {
            if(!tknzr.isSpace(tknzr.getToken(i))) {
               break;
            }
         }
         for(int i = start; i < end; i++) {
            line += tknzr.getToken(i);
         }
         return line;
      } else {
         return query;
      }
   }
   
   public static void main(String[] args) {
      System.out.println(translateForOracle("EXEC SQL " +
              "SELECT CHAR(CURRENT DATE, ISO) " +
                  "INTO :WRK-DATE " +
                  "FROM SYSIBM.SYSDUMMY1 " +
           "END-EXEC."));
   }
}
