
##### isCOBOL release 2025 R2 build#1158.10-20251128-41083 ######
##### Copyright (c) 2005 - 2025 Veryant. ######

----------
**This Example shows how to call isCOBOL from Java using the EasyLinkage feature of isCOBOL.**

**The Java program calls isCOBOL by passing some parameters.**

**This document assumes the $ISCOBOL environment variable exists and points**
**to the isCOBOL SDK installation folder, and the $ISCOBOL_JDK_ROOT environment**
**variable exists and points to the JDK installation folder**

**When talking about a "command prompt window" it means an isCOBOL Shell**
**on the Windows OS and a standard shell on Linux/Unix**

**When running this on Unix/Linux make sure to have iscobol.jar in CLASSPATH**

----------
 - 1 Using a command prompt window go to the 
     "$ISCOBOL/sample/is-java/java-call-iscobol/easylinkage" folder.

 - 2 Compile the COBOL programs

        iscc -c=compiler.properties -jj -jc MYPROG.cbl 

 **NOTE:**

        The -c option is used to pass the name of the configuration file to the compiler
             This file contains the property to activate the easylinkage feature.
        The -jj option will leave the .java file generated by the compiler, instead of 
             deleting it
        The -jc option will generate the ".class" file when -jj option is used.

 **NOTE:**

        -jj and -jc options are optional and are required only to generate the javadoc**

 - 3 Add the generated easylinkage folder to the CLASSPATH

        export CLASSPATH=$CLASSPATH:easylinkage

 - 4 Compile the Java program

        "$ISCOBOL_JDK_ROOT/bin/javac" main.java 

 - 5 Run the java program

        "$ISCOBOL_JDK_ROOT/bin/java" main 

 - 6 Compare the output with the correct output shown in the bottom of the file

 **Optional:**

 to generate the javadoc for the bridge program, run the the javadoc command

    "$ISCOBOL_JDK_ROOT/bin/javadoc" -d javadoc linkMYPROG.java 


 **NOTE:**

    To run in debug the cobol part of this sample make these steps
    - add the option "-d" or "-dx" during compilation
    - create a new iscobol.properties file
    - add iscobol.rundebug=2 to iscobol.properties file
    - optionally add iscobol.debug.port=<port-number> 
    - execute the remote debugger with the following command
      iscrun -d -r <host-name> <port-number>
      from sample/is-c/easylinkage folder before execute the java program

 **NOTE:**

    If you need to compile the COBOL program with the -cp option, modify the java source code
    in order to import classes from com.iscobol.types_n.* instead of com.iscobol.types.*

----------
### The correct output should be:

    Inside JAVA PROGRAM 'main'
    Calling cobol program 'MYPROG'

    Inside COBOL PROGRAM 'MYPROG'

    Linkage variables received from the java program
    lnk-p1[hello     ]
    lnk-desc[desc]
    lnk-num[1.78]
    lnk-price[77]
    lnk-tel(1)[occurs1        ]
    lnk-tel(2)[occurs2        ]
    lnk-tel(3)[occurs3        ]

    Returned inside JAVA PROGRAM

    Value received from cobol program
    return-code = 3
    lnkP1 =[HELLO     ]
    lnkDesc =[ABC ]
    lnkNum =[4.67]
    lnkPrice =[12345]
    lnkTel(1) =[111            ]
    lnkTel(2) =[222            ]
    lnkTel(3) =[333            ]

    End of test
