      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.     HTML-EDITOR.

       configuration section.
       repository.
           class ijb        as "com.iscobol.gui.server.CobolGUIJavaBean"
           class FInputStream   as "java.io.FileInputStream"
           class FOutputStream  as "java.io.FileOutputStream"
           class j-array-byte   as "byte[]"
           class J-string       as "java.lang.String"
           .

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isopensave.def".
       copy "isresize.def".

       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0. 

       77  html-path               pic x any length.
       77  client-path             pic x any length.

       77  html-editor-obj         object reference ijb.
       77  html-stream             object reference FInputStream.
       77  save-html-stream        object reference FOutputStream.
       77  html-string             pic x any length.

       77  wrk-array               object reference j-array-byte.
       77  wrk-string              object reference j-string.
       77  w-bytes-read            pic 9(12).

       01  fileInfo.
           03 fileSize             pic x(8) comp-x.
           03 fileDate             pic 9(8) comp-x.
           03 fileTime             pic 9(8) comp-x.
           
       77  v-remote                pic 9.

       77  rb-value                pic 9.
       01  execution-type          pic X.
           88 standalone-execution value "A".
           88 client-execution     value "C".
           88 server-execution     value "S".
       77  e-client                pic 9 value 1.
      
       SCREEN SECTION.
       01  Mask.
           03 html-editor
              java-bean
              clsid "              javafx.scene.web.HTMLEditor"
              layout-data          rlm-resize-both-any
              vscroll
              use-return
              use-tab
              boxed
              color                513
              line                 2
              col                  2 
              size                 100 cells
              lines                22 cells
              object               html-editor-obj
              .
           03 label
              title                "HTML file location:"
              line                 25
              col                  2
              label-offset         0
              visible              v-remote
              . 
           03 radio-button 
              line                 25
              col                  20
              title                "on Client"
              group                1
              group-value          1
              visible              v-remote
              value                rb-value
              exception-value      103
              . 
           03 radio-button 
              line                 25
              col                  34
              title                "on Server"
              group                1
              group-value          2
              visible              v-remote
              value                rb-value
              exception-value      103
              . 
           03 ef-path
              entry-field 
              line                 27 
              col                  2 
              size                 86.5 cells
              hint                "choose a HTML document"
              placeholder         "choose a HTML document"
              .
           03 pb-choose
              push-button
              line                 27 
              col                  89
              size                 3 cells
              title                "..." 
              exception-value      101
              enabled              e-client
              .
           03 push-button
              line                 27 
              col                  92 
              size                 10 cells
              title                "Load HTML" 
              exception-value      104
              .
           03 push-button
              line                 29
              col                  2 
              size                 10 cells
              title                "Save" 
              exception-value      102
              .
           03 push-button
              line                 29 
              col                  92 
              size                 10 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1                     to v-remote
                                            rb-value
              set client-execution       to true
           else
              move 0                     to v-remote
              set standalone-execution   to true
           end-if
           
           call client "C$FORNAME" using 
                                   "javafx.application.Application"
                                   giving return-Code

           if return-Code = 1
              display message "This sample required javaFX"
                      icon mb-warning-icon
              goback
           end-if.

           initialize html-path.

           display standard graphical window
                   color  65793
                   with   system menu
                   title  "HTML Editor JAVABEAN Control"
                   resizable
                   layout-manager lm-scale
                   size 102
                   lines 30
                   handle hWin
                   event  WIN-EVT
           display Mask
      
           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue
              end-accept
              evaluate crt-status 
              when 101
                   perform CHOOSE-HTML
              when 102
                   perform SAVE-HTML
              when 103
                   if rb-value = 1
                      set client-execution   to true
                      move 1                 to e-client
                   else
                      set server-execution   to true
                      move zero              to e-client
                   end-if
                   modify pb-choose enabled e-client

              when 104
                   perform READ-HTML
              end-evaluate
           end-perform.

           destroy Mask
           destroy hWin
           goback
           .

       CHOOSE-HTML.
           initialize opensave-data

           string "HTML Files (*.html)|*.html|"
                  delimited by size
                  into opnsav-filters.

           call "C$OPENSAVEBOX" using opensave-open-box, opensave-data.

           if opnsav-basename not = spaces
              modify ef-path value opnsav-filename  
              move opnsav-filename   to html-path
              perform READ-HTML
           end-if
           .

       READ-HTML.
           inquire ef-path value html-path

           if client-execution
              perform COPY-TO-SERVER
           end-if

           initialize fileInfo
           call "C$FILEINFO" USING html-path, fileInfo
           if fileSize > 0
              try
                 set html-stream to FInputStream:>new(html-path)
                 set wrk-array to j-array-byte:>new(fileSize as int)
                 set w-bytes-read to html-stream:>read(wrk-array)
                 if w-bytes-read = fileSize
                    set html-string to wrk-array
                 end-if
                 html-stream:>close()
              catch exception
                 display exception-object:>toString
              end-try
           else
              display message "File not found"
              initialize html-string
           end-if

           html-editor-obj:>callMethod("setHtmlText", 
                                       html-string)
           .

       SAVE-HTML.
           initialize html-string.
           set html-string to html-editor-obj:>callMethod("getHtmlText")

           try
              set save-html-stream to FOutputStream:>new ( html-path )

              set wrk-string  to j-string:>new ( html-string )

              save-html-stream:>write ( wrk-string:>getBytes() )
              if client-execution
                 perform COPY-TO-CLIENT
              end-if
           catch exception
               display exception-object:>toString
           end-try
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win
           end-if
           .

       COPY-TO-SERVER.
           move html-path to client-path
           initialize html-path
           call client "C$GETENV" USING "user.home"
                                        html-path
           string html-path  delimited by trailing space
                  "/tmp-html.html" delimited by size
                  into html-path 

           string "@[DISPLAY]:" delimited by size
                  client-path   delimited by trailing space
                  into client-path

           call "C$COPY" using client-path 
                               html-path
                               "S"
                        giving return-code.
           .

       COPY-TO-CLIENT.
           call "C$COPY" using html-path 
                               client-path
                               "S"
                        giving return-code.
       