import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.Dimension;

import javax.swing.JButton;
import javax.swing.JFrame;

import com.iscobol.java.IsCobol;

public class CallCobol {

   public static void main(String[] args) throws Exception {
      JFrame f = new JFrame("Call Cobol");
      f.setSize(300, 300);
      f.setLocationRelativeTo(null);
      f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      f.getContentPane().setLayout(new FlowLayout(FlowLayout.LEADING, 30, 30));
      JButton btn1 = new JButton("Display Independent Window");
      btn1.setPreferredSize(new Dimension(220, 40));
      f.getContentPane().add(btn1);
      btn1.addActionListener(new ActionListener() {
         
         @Override
         public void actionPerformed(ActionEvent e) {
            callCobol("1");
         }
      });
      JButton btn2 = new JButton("Display Floating Window modal");
      btn2.setPreferredSize(new Dimension(220, 40));
      f.getContentPane().add(btn2);
      btn2.addActionListener(new ActionListener() {
         
         @Override
         public void actionPerformed(ActionEvent e) {
            callCobol("2");
         }
      });
      f.setVisible(true);
   }
   
   private static void callCobol(final String arg) {
      Thread t = new Thread(new Runnable() {
         @Override
         public void run() {
            IsCobol.call("COBOLPROG", new Object[] { arg });
         }
      });
      t.start();
   }

}
