      *    Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *   may freely modify and redistribute this program.
      
       PROGRAM-ID. CHECKFILE.
       configuration section.
       special-names.   
      
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "users.sl".
           copy "customer.sl".
           copy "favrec.sl".
           copy "invoice.sl".
           copy "invoicedetail.sl".
           copy "product.sl".
           copy "prog.sl".

           copy "auditfilesettings.sl".
           copy "auditlogsettings.sl".

       DATA DIVISION.
       FILE SECTION.
           COPY "users.fd".
           copy "customer.fd".
           copy "favrec.fd".
           copy "invoice.fd".
           copy "invoicedetail.fd".
           copy "product.fd".
           copy "prog.fd".

           copy "auditfilesettings.fd".
           copy "auditlogsettings.fd".

       WORKING-STORAGE SECTION.
      
           copy "common.wrk".
        
       77  status-users               pic xx.
       77  status-customer            pic xx.
       77  status-favrec              pic xx.
       77  status-invoice             pic xx.
       77  status-invoicedetail       pic xx.
       77  status-product             pic xx.
       77  status-prog                pic xx.
       77  status-auditfilesettings   pic x(2).
       77  status-auditlogsettings    pic x(2).
       77  status-auditlog            pic x(2).

       01  audit                      pic 9 external.
           88 audit-enabled           value 1 false zero.

       78  num-users value 2.
       01  table-users.
           03 filler.
              05 filler         pic x(20)  value R"default_user".
              05 filler         pic x(50)  value R"default_user_descr".
              05 filler         pic 9      value 1.
              05 filler         pic x(100) value R"default_user".
              05 filler         pic x(10)  value space.

              05 filler         pic x(20)  value R"default_std_user".
              05 filler         pic x(50)  
                                      value R"default_std_user_descr".
              05 filler         pic 9      value 0.
              05 filler         pic x(100) value R"default_std_user".
              05 filler         pic x(10)  value space.

        01 record-users         redefines  table-users.
           03 rec-users                           occurs num-users.
              05 rec-users-id   pic  x(20).
              05 rec-users-name pic  x(50).
              05 rec-users-type pic  9.
              05 rec-users-pass pic  x(100).
              05 filler         pic  x(10).
       
       78  num-menu             value 35.
       01  table-menu.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0100000000".
              05 filler pic x(15)     value "menu".
              05 filler pic 9         value 0.
              05 filler pic x(30)     value R"IsApplication".
              05 filler pic x(100)    value R"default_menu_descr_1".
              05 filler pic 9         value 0.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0101000000".
              05 filler pic x(15)     value "data".
              05 filler pic 9         value 0.
              05 filler pic x(30)     value R"Data_Maintenance".
              05 filler pic x(100)    value R"default_menu_descr_2".
              05 filler pic 9         value 0.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0101010000".
              05 filler pic x(15)     value "iscustomer".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_3".
              05 filler pic x(100)    value R"default_menu_descr_3".
              05 filler pic 9         value 1.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0101020000".
              05 filler pic x(15)     value "isproduct".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_4".
              05 filler pic x(100)    value R"default_menu_descr_4".
              05 filler pic 9         value 1.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0101030000".
              05 filler pic x(15)     value "adminfunc".
              05 filler pic 9         value 0.
              05 filler pic x(30)     value R"default_menu_5".
              05 filler pic x(100)    value R"default_menu_descr_5".
              05 filler pic 9         value 0.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0101030100".
              05 filler pic x(15)     value "ismenu".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_6".
              05 filler pic x(100)    value R"default_menu_descr_6".
              05 filler pic 9         value 1.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0101030200".
              05 filler pic x(15)     value "isuser".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_7".
              05 filler pic x(100)    value R"default_menu_descr_7".
              05 filler pic 9         value 1.
              05 filler pic  x(10)    value space.

           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0101030300".
              05 filler pic x(15)     value "isresetfile".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_16".
              05 filler pic x(100)    value R"default_menu_descr_16".
              05 filler pic 9         value 0.
              05 filler pic  x(10)    value space.

           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0102000000".
              05 filler pic x(15)     value "Headerdet".
              05 filler pic 9         value 0.
              05 filler pic x(30)     value R"default_menu_8".
              05 filler pic x(100)    value R"default_menu_descr_8".
              05 filler pic 9         value 0.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0102010000".
              05 filler pic x(15)     value "isinvoice".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_9".
              05 filler pic x(100)    value R"default_menu_descr_9".
              05 filler pic 9         value 1.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0102020000".
              05 filler pic x(15)     value "isinvoicelist".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_10".
              05 filler pic x(100)    value R"default_menu_descr_10".
              05 filler pic 9         value 1.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0103000000".
              05 filler pic x(15)     value "character".
              05 filler pic 9         value 0.
              05 filler pic x(30)     value R"default_menu_11".
              05 filler pic x(100)    value R"default_menu_11".
              05 filler pic 9         value 0.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0103010000".
              05 filler pic x(15)     value "ischarprog".
              05 filler pic 9         value 2.
              05 filler pic x(30)     value R"default_menu_11".
              05 filler pic x(100)    value R"default_menu_descr_11".
              05 filler pic 9         value 0.
              05 filler pic  x(10)    value space.

           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0104000000".
              05 filler pic x(15)     value "reports".
              05 filler pic 9         value 0.
              05 filler pic x(30)     value R"default_menu_14".
              05 filler pic x(100)    value R"default_menu_descr_14".
              05 filler pic 9         value 0.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0104010000".
              05 filler pic x(15)     value "isinvoicelist".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_10".
              05 filler pic x(100)    value R"default_menu_descr_10".
              05 filler pic 9         value 1.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0104020000".
              05 filler pic x(15)     value "isprintprod".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_15".
              05 filler pic x(100)    value R"default_menu_descr_15".
              05 filler pic 9         value 1.
              05 filler pic  x(10)    value space.

           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0200000000".
              05 filler pic x(15)     value "audit".
              05 filler pic 9         value 0.
              05 filler pic x(30)     value R"default_menu_17".
              05 filler pic x(100)    value R"default_menu_descr_17".
              05 filler pic 9         value 0.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0201000000".
              05 filler pic x(15)     value "auditsettings".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_18".
              05 filler pic x(100)    value R"default_menu_descr_18".
              05 filler pic 9         value 1.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0203000000".
              05 filler pic x(15)     value "auditanalysis".
              05 filler pic 9         value 1.
              05 filler pic x(30)     value R"default_menu_19".
              05 filler pic x(100)    value R"default_menu_descr_19".
              05 filler pic 9         value 1.
              05 filler pic  x(10)    value space.

           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0300000000".
              05 filler pic x(15)     value "otherfunc".
              05 filler pic 9         value 0.
              05 filler pic x(30)     value R"default_menu_12".
              05 filler pic x(100)    value R"default_menu_descr_12".
              05 filler pic 9         value 0.
              05 filler pic  x(10)    value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)     value "0301000000".
              05 filler pic x(15)     value "ismenu".
              05 filler pic 9            value 1.
              05 filler pic x(30)        value R"default_menu_6".
              05 filler pic x(100)       value R"default_menu_descr_6".
              05 filler pic 9            value 1.
              05 filler pic  x(10)       value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)        value "0302000000".
              05 filler pic x(15)        value "isuser".
              05 filler pic 9            value 1.
              05 filler pic x(30)        value R"default_menu_7".
              05 filler pic x(100)       value R"default_menu_descr_7".
              05 filler pic 9            value 1.
              05 filler pic  x(10)       value space.
           03 filler.
              05 filler               pic x(20)  value R"default_user".
              05 filler pic x(10)        value "0303000000".
              05 filler pic x(15)        value "iscallrun".
              05 filler pic 9            value 1.
              05 filler pic x(30)        value R"default_menu_13".
              05 filler pic x(100)       value R"default_menu_descr_13".
              05 filler pic 9            value 2.
              05 filler pic  x(10)       value space.

           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0100000000".
              05 filler pic x(15)        value "menu".
              05 filler pic 9            value 0.
              05 filler pic x(30)        value R"IsApplication".
              05 filler pic x(100)       value R"default_menu_descr_1".
              05 filler pic 9            value 0.
              05 filler pic  x(10)       value space.
           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0101000000".
              05 filler pic x(15)        value "data".
              05 filler pic 9            value 0.
              05 filler pic x(30)        value R"Data_Maintenance".
              05 filler pic x(100)       value R"default_menu_descr_2".
              05 filler pic 9            value 0.
              05 filler pic  x(10)       value space.
           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0101010000".
              05 filler pic x(15)        value "iscustomer".
              05 filler pic 9            value 1.
              05 filler pic x(30)        value R"default_menu_3".
              05 filler pic x(100)       value R"default_menu_descr_3".
              05 filler pic 9            value 1.
              05 filler pic  x(10)       value space.
           03 filler.
              05 filler                  pic x(20)
                                            value R"default_std_user".
              05 filler pic x(10)        value "0101020000".
              05 filler pic x(15)        value "isproduct".
              05 filler pic 9            value 1.
              05 filler pic x(30)        value R"default_menu_4".
              05 filler pic x(100)       value R"default_menu_descr_4".
              05 filler pic 9            value 1.
              05 filler pic  x(10)       value space.
      
           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0102000000".
              05 filler pic x(15)        value "Headerdet".
              05 filler pic 9            value 0.
              05 filler pic x(30)        value R"default_menu_8".
              05 filler pic x(100)       value R"default_menu_descr_8".
              05 filler pic 9            value 0.
              05 filler pic  x(10)       value space.
           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0102010000".
              05 filler pic x(15)        value "isinvoice".
              05 filler pic 9            value 1.
              05 filler pic x(30)        value R"default_menu_9".
              05 filler pic x(100)       value R"default_menu_descr_9".
              05 filler pic 9            value 1.
              05 filler pic  x(10)       value space.
           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0102020000".
              05 filler pic x(15)        value "isinvoicelist".
              05 filler pic 9            value 1.
              05 filler pic x(30)        value R"default_menu_10".
              05 filler pic x(100)       value R"default_menu_descr_10".
              05 filler pic 9            value 1.
              05 filler pic  x(10)       value space.
           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0103000000".
              05 filler pic x(15)        value "character".
              05 filler pic 9            value 0.
              05 filler pic x(30)        value R"default_menu_11".
              05 filler pic x(100)       value R"default_menu_11".
              05 filler pic 9            value 0.
              05 filler pic  x(10)       value space.
           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0103010000".
              05 filler pic x(15)        value "ischarprog".
              05 filler pic 9            value 2.
              05 filler pic x(30)        value R"default_menu_11".
              05 filler pic x(100)       value R"default_menu_descr_11".
              05 filler pic 9            value 0.
              05 filler pic  x(10)       value space.

           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0104000000".
              05 filler pic x(15)        value "reports".
              05 filler pic 9            value 0.
              05 filler pic x(30)        value R"default_menu_14".
              05 filler pic x(100)       value R"default_menu_descr_14".
              05 filler pic 9            value 0.
              05 filler pic  x(10)       value space.
           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0104010000".
              05 filler pic x(15)        value "isinvoicelist".
              05 filler pic 9            value 1.
              05 filler pic x(30)        value R"default_menu_10".
              05 filler pic x(100)       value R"default_menu_descr_10".
              05 filler pic 9            value 1.
              05 filler pic  x(10)       value space.
           03 filler.
              05 filler                  pic x(20)  
                                            value R"default_std_user".
              05 filler pic x(10)        value "0104020000".
              05 filler pic x(15)        value "isprintprod".
              05 filler pic 9            value 1.
              05 filler pic x(30)        value R"default_menu_15".
              05 filler pic x(100)       value R"default_menu_descr_15".
              05 filler pic 9            value 1.
              05 filler pic  x(10)       value space.

       01 record-menu                    redefines table-menu.
           03 rec-menu                    occurs num-menu.
              05 rec-menu-prog-user       pic x(20).
              05 rec-menu-prog-menu-level pic  x(10).
              05 rec-menu-prog-id         pic  x(15).
              05 rec-menu-prog-type       pic  9(01).
              05 rec-menu-prog-s-desc     pic  x(30).
              05 rec-menu-prog-l-desc     pic  x(100).
              05 rec-menu-prog-call-metod pic  9(01).
              05 filler                   pic  x(10).
      
       78 num-customer value 2.
       01 table-customer.
           03 filler.
              05 filler  pic x(10) value "Veryant".
              05 filler  pic x(20) value "".
              05 filler  pic X(50) value R"default_customer_1".
              05 filler  pic x(15) value R"def_cust_tel_1".
              05 filler  pic x(15) value "".
              05 filler  pic x(15) value R"def_cust_fax_1".
              05 filler  pic x(50) value R"default_customer_addr_1".
              05 filler  pic x(20) value "".
              05 filler  pic x(30) value R"default_customer_mail_1".
              05 filler  pic x(10) value space.
           03 filler.
              05 filler  pic x(10) value "JS".
              05 filler  pic x(20) value R"def_customer_name_2".
              05 filler  pic X(50) value R"default_customer_2".
              05 filler  pic x(15) value "".
              05 filler  pic x(15) value "".
              05 filler  pic x(15) value "".
              05 filler  pic x(50) value "".
              05 filler  pic x(20) value "".
              05 filler  pic x(30) value "".
              05 filler  pic x(10) value space.
       01 record-customer                redefines table-customer.
           03 rec-customer                occurs num-customer.
              05 rec-cust-id              pic  x(10).
              05 rec-cust-fname           pic  x(20).
              05 rec-cust-lname           pic  x(50).
              05 rec-cust-tel1            pic  x(15).
              05 rec-cust-tel2            pic  x(15).
              05 rec-cust-fax             pic  x(15).
              05 rec-cust-addr            pic  x(50).
              05 rec-cust-contact         pic  x(20).
              05 rec-cust-email           pic  x(30).
              05 filler                   pic  x(10).
      
       78  num-product value 20.
       01  table-product.
           03 filler.
              05 filler pic  x(10)      value "W01".
              05 filler pic  x(20)      value R"defualt_art_1".
              05 filler pic  x(150)     value R"defualt_art_descr_1".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W02".
              05 filler pic  x(20)      value R"defualt_art_2". 
              05 filler pic  x(150)     value R"defualt_art_descr_2".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W03".
              05 filler pic  x(20)      value R"defualt_art_3". 
              05 filler pic  x(150)     value R"defualt_art_descr_3".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W04".
              05 filler pic  x(20)      value R"defualt_art_4".
              05 filler pic  x(150)     value R"defualt_art_descr_4".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W05".
              05 filler pic  x(20)      value R"defualt_art_5".
              05 filler pic  x(150)     value R"defualt_art_descr_5".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W06".
              05 filler pic  x(20)      value R"defualt_art_6".
              05 filler pic  x(150)     value R"defualt_art_descr_6".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W07".
              05 filler pic  x(20)      value R"defualt_art_7".
              05 filler pic  x(150)     value R"defualt_art_descr_7".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W08".
              05 filler pic  x(20)      value R"defualt_art_8".
              05 filler pic  x(150)     value R"defualt_art_descr_8".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W09".
              05 filler pic  x(20)      value R"defualt_art_9".
              05 filler pic  x(150)     value R"defualt_art_descr_9".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W10".
              05 filler pic  x(20)      value R"defualt_art_10".
              05 filler pic  x(150)     value R"defualt_art_descr_10".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W11".
              05 filler pic  x(20)      value R"defualt_art_11". 
              05 filler pic  x(150)     value R"defualt_art_descr_11".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "W12".
              05 filler pic  x(20)      value R"defualt_art_12".
              05 filler pic  x(150)     value R"defualt_art_descr_12".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "NGS01".
              05 filler pic  x(20)      value R"defualt_art_13".
              05 filler pic  x(150)     value R"defualt_art_descr_13".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "NGS02".
              05 filler pic  x(20)      value R"defualt_art_14".
              05 filler pic  x(150)     value R"defualt_art_descr_14".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "COREL1".
              05 filler pic  x(20)      value R"defualt_art_15".  
              05 filler pic  x(150)     value R"defualt_art_descr_15".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "COREL2".
              05 filler pic  x(20)      value R"defualt_art_16". 
              05 filler pic  x(150)     value R"defualt_art_descr_16".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "COREL3".
              05 filler pic  x(20)      value R"defualt_art_17". 
              05 filler pic  x(150)     value R"defualt_art_descr_17".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "CUB".
              05 filler pic  x(20)      value R"defualt_art_18".
              05 filler pic  x(150)     value R"defualt_art_descr_18".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "AcdSee".
              05 filler pic  x(20)      value R"defualt_art_19".
              05 filler pic  x(150)     value R"defualt_art_descr_19".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
           03 filler.
              05 filler pic  x(10)      value "SONY01".
              05 filler pic  x(20)      value R"defualt_art_20".
              05 filler pic  x(150)     value R"defualt_art_descr_20".
              05 filler pic  9(06)v99   value 10.50.
              05 filler pic x(10)       value space.
      
       01 record-product                 redefines table-product.
           03 rec-product                 occurs num-product.
              05 rec-prod-id              pic  x(10).
              05 rec-prod-name            pic  x(20).
              05 rec-prod-description     pic  x(150).
              05 rec-prod-price           pic  9(06)v99.
              05 filler                   pic x(10).

       78  num-auditfilesettings value 2.
       01  table-auditfilesettings.
           03 filler.
              05 filler         pic x(20)  value R"default_user".
              05 filler         pic x(20) value "ALL".
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.
              05 filler         pic 9(3) value 100.
              05 filler         pic 9(10) value 1.
           03 filler.
              05 filler         pic x(20)  value R"default_std_user".
              05 filler         pic x(20) value "ALL".
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.
              05 filler         pic 9(3) value 100.
              05 filler         pic 9(10) value 1.

       01  record-auditfilesettings   redefines table-auditfilesettings.
           03 rec-auditfilesettings    occurs num-auditfilesettings.
              05 rec-afs-users-id           pic x(20).
              05 afs-file                   pic x(20).
              05 afs-open                   pic 9.
              05 afs-close                  pic 9.
              05 afs-delete-record          pic 9.
              05 afs-delete-file            pic 9.
              05 afs-read                   pic 9.
              05 afs-write                  pic 9.
              05 afs-rewrite                pic 9.
              05 afs-key-size               pic 9(3).
              05 afs-key-offset             pic 9(10).

       78  num-auditlogsettings value 2.
       01  table-auditlogsettings.
           03 filler.
              05 filler         pic x(20)  value R"default_user".
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.
           03 filler.
              05 filler         pic x(20)  value R"default_std_user".
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.
              05 filler         pic 9 value 1.

       01  record-auditlogsettings    redefines table-auditlogsettings.
           03 rec-auditlogsettings    occurs num-auditlogsettings.
              05 rec-als-users-id     pic x(20).
              05 rec-als-login        pic 9.
              05 rec-als-logout       pic 9.
              05 rec-als-pgm-start    pic 9.
              05 rec-als-pgm-end      pic 9.

       77  calling-prg                pic x any length.

       PROCEDURE DIVISION. 

       DECLARATIVES.
       USER-ERR section.
           use after standard error procedure on users.
           evaluate status-users 
           when 35
                continue
           when other
                perform ERROR-FILE
           end-evaluate.

       CUSTOMER-ERR section.
           use after standard error procedure on customer.
           evaluate status-customer 
           when 35
                continue
           when other
                perform ERROR-FILE
           end-evaluate.

       FAVREC-ERR section.
           use after standard error procedure on favrec.
           evaluate status-favrec
           when 35
               continue
           when other
                perform ERROR-FILE
           end-evaluate.

       INVOICE-ERR section.
           use after standard error procedure on invoice.
           evaluate status-invoice
           when 35
                continue
           when other
                perform ERROR-FILE
           end-evaluate.

       INVOICEDETAIL-ERR section.
           use after standard error procedure on invoicedetail.
           evaluate status-invoicedetail
           when 35
               continue
           when other
                perform ERROR-FILE
           end-evaluate.

       PRODUCT-ERR section.
           use after standard error procedure on product.
           evaluate status-product
           when 35
               continue
           when other
                perform ERROR-FILE
           end-evaluate.

       PROG-ERR section.
           use after standard error procedure on prog.
           evaluate status-prog
           when 35
                continue
           when other
                perform ERROR-FILE
           end-evaluate.

       AUDITFILESETTINGS-ERR section.
           use after standard error procedure on auditfilesettings.
           evaluate status-auditfilesettings
           when 35
                continue
           when other
                perform ERROR-FILE
           end-evaluate.

       AUDITLOGSETTINGS-ERR section.
           use after standard error procedure on auditlogsettings.
           evaluate status-auditlogsettings
           when 35
                continue
           when other
                perform ERROR-FILE
           end-evaluate.

       END DECLARATIVES.

       MAIN.
           call "C$CALLEDBY" using calling-prg
           evaluate calling-prg 
           when "ISAPPLICATION"
                perform CREATE-NEW-FILE
           when "ISRESETFILE"
                perform RESET-FILE
           end-evaluate.
           goback.

       CREATE-NEW-FILE.

           if audit-enabled
              perform AUDIT-FILE
           end-if.

           open input users.
           if status-users = 35
              perform VAL-STD-USERS
           end-if.
           close users.
           
           open input prog.
           evaluate status-prog 
           when 35
                perform VAL-STD-MENU
           end-evaluate.
           close prog
           
           open input favrec.
           if status-favrec = 35
              open output favrec
           end-if.
           close favrec.
           
           open input invoice.
           if status-invoice = 35
              open output invoice
           end-if.
           close invoice.
           
           open input invoicedetail.
           if status-invoicedetail = 35
              open output invoicedetail
           end-if.
           close invoicedetail.
           
           open input customer.
           if status-customer = 35
              perform VAL-STD-CUSTOMER
           end-if.
           close customer.
           
           open input product.
           if status-product = 35
             perform VAL-STD-PRODUCT
           end-if.
           close product.
       

       RESET-FILE.
           perform VAL-STD-USERS
           close users.
           
           perform VAL-STD-MENU
           close prog
           
           open output favrec
           close favrec.
           
           open output invoice
           close invoice.
           
           open output invoicedetail
           close invoicedetail.
           
           perform VAL-STD-CUSTOMER
           close customer.
           
           perform VAL-STD-PRODUCT
           close product.
 
       VAL-STD-USERS.
           open output users.
           if status-users not = "00" 
              perform ERROR-FILE
           end-if.
           perform varying idx from 1 by 1 until idx > num-users
              move rec-users(idx)   to users-r
              move users-pass to password
              call "C$ENCRYPT" using function trimr(password), 
                                     "Veryant" , 
                                     encrypted-data1
              call "ASCII2HEX" using encrypted-data1, encrypted-data2
              move encrypted-data2   to users-pass
              write users-r
           end-perform.

       VAL-STD-MENU.
           open output prog.
           if status-prog not = "00" 
              perform ERROR-FILE
           end-if.
           perform varying idx from 1 by 1 until idx > num-menu
              move rec-menu(idx)   to prog-r
              write prog-r
           end-perform.
           
       VAL-STD-CUSTOMER.
           open output customer.
           if status-customer not = "00" 
              perform ERROR-FILE
           end-if.
           perform varying idx from 1 by 1 until idx > num-customer
              move rec-customer(idx)   to cust-record
              write cust-record
           end-perform.
 
       AUDIT-FILE.
           open input auditfilesettings.
           if status-auditfilesettings = 35
              perform VAL-STD-AUDITFILESETTINGS
           end-if.
           close auditfilesettings.

           open input auditlogsettings.
           if status-auditlogsettings = 35
              perform VAL-STD-AUDITLOGSETTINGS
           end-if.
           close auditlogsettings.

       VAL-STD-PRODUCT.
           open output product.
           if status-product not = "00" 
              perform ERROR-FILE
           end-if.
           perform varying idx from 1 by 1 until idx > num-product
              move rec-product(idx)   to prod-record
              write prod-record
           end-perform.

       VAL-STD-AUDITFILESETTINGS.
           open output auditfilesettings.
           if status-auditfilesettings not = "00" 
              perform ERROR-FILE
           end-if.
           perform varying idx from 1 by 1 
                                      until idx > num-auditfilesettings
              move rec-auditfilesettings(idx)   to auditfilesettings-r
              write auditfilesettings-r
           end-perform.

       VAL-STD-AUDITLOGSETTINGS.
           open output auditlogsettings.
           if status-auditlogsettings not = "00" 
              perform ERROR-FILE
           end-if.
           perform varying idx from 1 by 1 
                                      until idx > num-auditlogsettings
              move rec-auditlogsettings(idx)   to auditlogsettings-r
              write auditlogsettings-r
           end-perform.

       ERROR-FILE.
           call "C$RERR"     using crerr-status
           call "C$RERRNAME" using rerrname
           display message "Error " file-status "-" 
                           ext-status " on " rerrname  
                   title "ISAPPLICATION"
                   icon 2.
           stop run.


       