*> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
*> may freely modify and redistribute this program.

 PROGRAM-ID. NOTIFPROG is initial.
 configuration section.
 special-names.

 INPUT-OUTPUT SECTION.
 FILE-CONTROL.
 DATA DIVISION.
 FILE SECTION.

 WORKING-STORAGE SECTION.
 77 h-notification     handle of window.

 77 wrk-delay          pic 9(3)v9(3).
 
 77 notif-lines        pic 9(2).
 77 notif-size         pic 9(2).
 
 77 notif-label        pic x(50) occurs 5.
 
 77 notif-v            pic 9 occurs 5.
 77 idx                PIC 9.
 77 h-notificon        pic s9(9) comp-4 is external.
 
 LINKAGE SECTION.
 copy "notifprog-link.wrk". 
 screen section.
 01  mask-notification.
     03 Bitmap
        line              2.2
        column            2
        size              32 pixels 
        lines             32 pixels 
        bitmap-handle     notif-bmp-handle
        bitmap-number     2
        .
     03 Label
        line              1.8
        column            7.2
        size              35 
        foreground-color  rgb x#CFCFCF
        title             "<HTML><b>isCOBOL ControlSet - 2025R2</b></HTML>"
        transparent
        .

     03 Label
        line              2.8
        column            7.2
        size              50 
        title             notif-label(1)
        visible           notif-v(1)
        foreground-color  rgb x#939392
        .
     03 Label
        line              3.8
        column            7.2
        size              50 
        title             notif-label(2)
        visible           notif-v(2)
        foreground-color  rgb x#939392
        .
     03 Label
        line              4.8
        column            7.2
        size              50 
        title             notif-label(3)
        visible           notif-v(3)
        foreground-color  rgb x#939392
        .
     03 Label
        line              5.8
        column            7.2
        size              50 
        title             notif-label(4)
        visible           notif-v(4)
        foreground-color  rgb x#939392
        .
     03 Label
        line              6.8
        column            7.2
        size              50 
        title             notif-label(5)
        visible           notif-v(5)
        foreground-color  rgb x#939392
        .

 PROCEDURE DIVISION using  notifprog-lnk
                           notif-text.
 MAIN.

   if notif-delay not = zero
      compute wrk-delay = notif-delay / 100
      call "C$SLEEP" using wrk-delay
   end-if
   
   unstring notif-text delimited by x"0A"
     into notif-label(1)
          notif-label(2)
          notif-label(3)
          notif-label(4)
          notif-label(5).

   move 3  to notif-lines
   
   perform varying idx from 1 by 1 until idx > 5
     if notif-label(idx) not = space
        move 1   to notif-v(idx)
        add 1    to notif-lines
     end-if
   end-perform

   move 40 to notif-size

   if notif-before-time = zero
      evaluate true
      when notif-top-right
           display notification window
                   top right
                   lines notif-lines
                   size  notif-size
                   visible 0
                   background-color rgb x#343332
                   handle h-notification
      when notif-bottom-right
           display notification window
                   bottom right
                   lines notif-lines
                   size  notif-size
                   visible 0
                   background-color rgb x#343332
                   handle h-notification
      when notif-top-left
           display notification window
                   top left
                   lines notif-lines
                   size  notif-size
                   visible 0
                   background-color rgb x#343332
                   handle h-notification
      when notif-bottom-left
           display notification window
                   bottom left
                   lines notif-lines
                   size  notif-size
                   visible 0
                   background-color rgb x#343332
                   handle h-notification
      end-evaluate
   else
      evaluate true
      when notif-top-right
           display notification window
                   top right
                   before time notif-before-time
                   lines notif-lines
                   size  notif-size
                   visible 0
                   background-color rgb x#343332
                   handle h-notification
      when notif-bottom-right
           display notification window
                   bottom right
                   before time notif-before-time
                   lines notif-lines
                   size  notif-size
                   visible 0
                   background-color rgb x#343332
                   handle h-notification
      when notif-top-left
           display notification window
                   top left
                   before time notif-before-time
                   lines notif-lines
                   size  notif-size
                   visible 0
                   background-color rgb x#343332
                   handle h-notification
      when notif-bottom-left
           display notification window
                   bottom left
                   before time notif-before-time
                   lines notif-lines
                   size  notif-size
                   visible 0
                   background-color rgb x#343332
                   handle h-notification
      end-evaluate
   end-if.

   display mask-notification upon h-notification.
   modify h-notification visible 1

   goback
   .


