      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       >> IMP OPTION "-sddp"

       program-id. printprog.
       input-output section.
       file-control.
       select print-f assign to print print-env
           organization is line sequential
           file status print-f-status.

       file section.
       fd print-f.
       01 p-row pic x(80).

       working-storage section.
       copy "isprint.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".
       77  pic-company      pic s9(9) comp-4.
       77  call-result      signed-int.
       77  h-font-5         usage handle of font.
       77  h-font-6         usage handle of font.
       77  h-font-7         usage handle of font.
       77  h-font-8         usage handle of font.
       77  h-font-10        usage handle of font.
       77  flag             pic 9 value 0.
       77  print-f-status   pic xx.

       01  p-row-cutomer    pic x(11).

       01  p-row1.
           03 field1-p-row1 pic x(11) value "CUSTOMER.N.".
           03 field2-p-row1 pic x(14) value "DOCUMENT".
           03 field3-p-row1 pic x(9)  value "PAGE".

       01  p-row2.
           03 field1-p-row2 pic x(13) value "NUMBER".
           03 field2-p-row2 pic x(7)  value "INVOICE".
           03 field3-p-row2 pic x(12) value "INVOICE DATE".

       01  p-row3.
           03 field1-p-row3 pic x(5).
           03 field2-p-row3 pic x(18).
           03 field3-p-row3 pic x(4).

       01  p-row4.
           03 field1-p-row4 pic x.
           03 field2-p-row4 pic x(8).
           03 field3-p-row4 pic x(10).

       01  p-row5.
           03 field1-p-row5 pic x(19) value "CUSTOMER".
           03 field2-p-row5 pic x(16) value "ORDER N/DATE".
           03 field3-p-row5 pic x(15) value "DELIVERY N/DATE".

       01  p-row6.
           03 field1-p-row6 pic x(8)  value "PAY.NO.".
           03 field2-p-row6 pic x(21) value "PAYMENT DESCRIPTION".
           03 field3-p-row6 pic x(16) value "BANK".
           03 field4-p-row6 pic x(16) value "PAYMENT DATE".

       01  p-row7.
           03 field1-p-row7 pic x(3).
           03 field2-p-row7 pic x(21).
           03 field3-p-row7 pic x(48).
           03 field4-p-row7 pic x(10).

       01  p-row8.
           03 field1-p-row8 pic x(20) value "SEND TO".

       01  p-row9.
           03 field1-p-row9 pic x(4) value "IDEM".

       01  p-row10.
           03 field1-p-row10 pic x(12) value "ART.NO.".
           03 field2-p-row10 pic x(11) value "DESCRIPTION".
           03 field3-p-row10 pic x(4) value "U.M.".
           03 field4-p-row10 pic x(9) value "QTY.ORDER".
           03 field5-p-row10 pic x(6) value "PRICE".
           03 field6-p-row10 pic x(3) value "RP%".
           03 field7-p-row10 pic x(13) value "AMOUNT".
           03 field8-p-row10 pic x(4) value "VAT".

       01  p-row11.
           03 field1-p-row11 pic x(32).
           03 field2-p-row11 pic x.

       01  p-row12.
           03 field1-p-row12 pic x(23).
           03 field2-p-row12 pic x(35).
      *-    "eme".
           03 field3-p-row12 pic x(2).
           03 field4-p-row12 pic x(4).
           03 field5-p-row12 pic x(6).
           03 field6-p-row12 pic x.
           03 field7-p-row12 pic x(6).
           03 field8-p-row12 pic x(2).

       01  p-row13.
           03 field1-p-row13 pic x(15) value "SUBTOTAL".
           03 field2-p-row13 pic x(8)  value "% RP".
           03 field3-p-row13 pic x(14) value "NEW SUBTOTAL".
           03 field4-p-row13 pic x(9)  value "DELIVERY".
           03 field5-p-row13 pic x(18) value "NET AMOUNT".
           03 field6-p-row13 pic x(7)  value "PACK".
           03 field7-p-row13 pic x(5)  value "MISC.".

       01  p-row14.
           03 field1-p-row14 pic x(6).
           03 field2-p-row14 pic x.
           03 field3-p-row14 pic x.
           03 field4-p-row14 pic x.
           03 field5-p-row14 pic x(6).
           03 field6-p-row14 pic x.
           03 field7-p-row14 pic x(4).

       01  p-row15.
           03 field1-p-row15 pic x(9)  value "DELIVERY".
           03 field2-p-row15 pic x(7)  value "PACK".
           03 field3-p-row15 pic x(5)  value "MISC".
           03 field4-p-row15 pic x(4)  value "VAT%".
           03 field5-p-row15 pic x(15) value "VAT DESCRIPTION".
           03 field6-p-row15 pic x(10) value "NET TOTAL".
           03 field7-p-row15 pic x(3)  value "VAT".

       01 p-row16.
           03 field1-p-row16 pic x.
           03 field2-p-row16 pic x.
           03 field3-p-row16 pic x(4).
           03 field4-p-row16 pic x(2).
           03 field5-p-row16 pic x(10).
           03 field6-p-row16 pic x(8).
           03 field7-p-row16 pic x(6).
    
       01  p-row17.
           03 field1-p-row17 pic x(17) value "NET AMOUNT".
           03 field2-p-row17 pic x(10) value "VAT AMOUNT".
           03 field3-p-row17 pic x(14) value "INVOICE TOTAL".

       01  p-row18.
           03 field1-p-row18 pic x(8).
           03 field2-p-row18 pic x(6).
           03 field3-p-row18 pic x(8). 

       01  p-row19.
           03 field1-p-row19 pic x(11) value "NOTE".
           03 field2-p-row19 pic x.
       
       77  print-env                 pic x(256).
       77  env-code                  pic 9.

       77  customer-name             pic x(80).
       77  customer-adress           pic x(80).
       77  customer-city             pic x(80).

       77  statement-name            pic x any length.
       
       77  wrk-arial                 pic x any length.
       77  wrk-arial-black           pic x any length.

       linkage section.
       77  print-mode                pic 9 value 1.
           88 pm-preview             value 1.
           88 pm-pdf                 value 2.
           88 pm-spooler             value 3.
       77  pdf-name                  pic x(256).
       77  pdf-creation-side         pic 9.
           88 pdf-on-client          value 1.
           88 pdf-on-server          value 2.
           copy "pdf-attributes.wrk".
       77  spooler-elaboration-side  pic 9.
           88 spool-on-client        value 1.
           88 spool-on-server        value 2.

       procedure division using print-mode 
                                pdf-name 
                                pdf-creation-side 
                                pdf-attributes
                                spooler-elaboration-side.
       declaratives.
       PRINT-F-ERR section.
           use after standard error procedure on print-f.
           if print-f-status = "35"
              display message "cannot open file: " pdf-name
              call "WIN$PRINTER" using winprint-cancel-job
           end-if
           goback.
       end declaratives.
       MAIN.
           call "C$GETRUNENV" GIVING env-code

           evaluate true
           when pm-preview
                move "-P PREVIEW" to print-env
                perform SET-ATTRIBUTE
           when pm-pdf
                if pdf-on-server
                   set wprt-as-server to true
                   call "WIN$PRINTER" using winprint-set-printer-as 
                                             winprint-as
                end-if
                initialize print-env
                string "-P PDF " delimited by size
                       pdf-name  delimited by trailing space
                       into print-env
                end-string
                perform SET-ATTRIBUTE
           when pm-spooler
                move "-P SPOOLER" to print-env
                if spool-on-server
                   set wprt-as-server to true
                   call "WIN$PRINTER" using winprint-set-printer-as 
                                             winprint-as
                end-if
                if env-code = runenv-web-client
                   if spool-on-server
                      call "WIN$PRINTER" using winprint-setup 
                                        giving call-result 
                      if call-result < 0
                         goback
                      end-if
                   end-if
                else
                   call "WIN$PRINTER" using winprint-setup 
                                     giving call-result 
                   if call-result < 0
                      goback
                   end-if
                end-if
           end-evaluate

           copy resource "../resources/arial.ttf".
           copy resource "../resources/ariblk.ttf".

           call "w$createfont" using "arial.ttf" wrk-arial
           call "w$createfont" using "ariblk.ttf" wrk-arial-black

           perform SET-MARGINS.
           perform LOAD-FONTS.
           perform LOAD-BMP.
           open output print-f.

           perform PRINT-INVOICES.

           call "win$printer" using  WINPRINT-SET-HEADER-FOOTER
                                     "&b Printed on date &D"
                                     "&b Page &p of &P"
                                     h-font-10
           close print-f.

           if pdf-on-server or spool-on-server 
              set wprt-as-client to true
              call "WIN$PRINTER" using winprint-set-printer-as 
                                       winprint-as
           end-if.

           perform DESTROY-HANDLE.
           goback.

       PRINT-INVOICES.
           perform PRINT-INVOICE-1.
           perform CANGHE-PAGE.
           perform PRINT-INVOICE-2.
       
       PRINT-INVOICE.
           perform ST-LAYOUT.
           perform ST-DATA.

       PRINT-INVOICE-1.
           move "ARITMETIC  S.p.A"                to customer-name.
           move "6390 Greenwich Drive"            to customer-adress.
           move "San Diego, CA 92122"             to customer-city
           move "13057"                           to field1-p-row3.
           move "SELL INVOICE"                    to field2-p-row3.
           move "1/ 1"                            to field3-p-row3.
           move "1066/002"                        to field2-p-row4.
           move "07/25/2020"                      to field3-p-row4. 
           move "007"                             to field1-p-row7.
           move "30 days after invoice"           to field2-p-row7.
           move "BANK OF AMERICA"                 to field3-p-row7.
           move "08/25/20"                        to field4-p-row7.
           move "00654920011"                     to p-row-cutomer
           move "ORDER NO. 5107247 OF 07/25/20"   to field1-p-row11.
           move "Identity Creation"               to field1-p-row12
           move "3 Logos based on color scheme"   to field2-p-row12
           move "N."                              to field3-p-row12
           move "1.00"                            to field4-p-row12
           move "992.00"                          to field5-p-row12
           move "992.00"                          to field7-p-row12
           move "20"                              to field8-p-row12
           move "992.00"                          to field1-p-row14
           move "992.00"                          to field5-p-row14
           move "2.59"                            to field7-p-row14
           move "2.59"                            to field3-p-row16 
           move "20"                              to field4-p-row16 
           move "VAT. 20%"                        to field5-p-row16 
           move "994.59"                          to field6-p-row16 
           move "198.92"                          to field7-p-row16 
           move "994.59"                          to field1-p-row18
           move "198.92"                          to field2-p-row18
           move "1,193.51"                        to field3-p-row18
           perform PRINT-INVOICE.

       PRINT-INVOICE-2.
           move "COBOL  S.p.A"                    to customer-name.
           move "5390 Greenwich Drive"            to customer-adress.
           move "Los Angels, CA 92122"            to customer-city
           move "13058"                           to field1-p-row3
           move "SELL INVOICE"                    to field2-p-row3
           move "1/ 1"                            to field3-p-row3.
           move "1067/002"                        to field2-p-row4.
           move "07/25/2020"                      to field3-p-row4. 
           move "008"                             to field1-p-row7.
           move "30 days after invoice"           to field2-p-row7.
           move "BANK OF AMERICA"                 to field3-p-row7.
           move "08/25/20"                        to field4-p-row7.
           move "00654920012"                     to p-row-cutomer
           move "ORDER NO. 5107248 OF 07/25/20"   to field1-p-row11.
           move "isCobol"                         to field1-p-row12
           move "isCOBOL SDK"                     to field2-p-row12
           move "N."                              to field3-p-row12
           move "1.00"                            to field4-p-row12
           move "499.00"                          to field5-p-row12
           move "998.00"                          to field7-p-row12
           move "20"                              to field8-p-row12
           move "998.00"                          to field1-p-row14
           move "998.00"                          to field5-p-row14
           move "2.59"                            to field7-p-row14
           move "2.59"                            to field3-p-row16 
           move "20"                              to field4-p-row16 
           move "VAT. 20%"                        to field5-p-row16 
           move "1,000.59"                        to field6-p-row16 
           move "200.12"                          to field7-p-row16 
           move "1,000.59"                        to field1-p-row18
           move "200.12"                          to field2-p-row18
           move "1,200.71"                        to field3-p-row18
           perform PRINT-INVOICE.

       CANGHE-PAGE.
           write p-row from space after page.

       SET-ATTRIBUTE.
           call "win$printer" using winprint-set-attribute
                                    "FONT_FOLDER_EMBED" 
                                    "fonts".
           call "win$printer" using winprint-set-attribute 
                                    "TITLE"
                                    attributes-title.
           call "win$printer" using winprint-set-attribute
                                    "SUBJECT"
                                    attributes-subject.
           call "win$printer" using winprint-set-attribute 
                                    "KEYWORDS"
                                    attributes-keywords.
           call "win$printer" using winprint-set-attribute 
                                    "AUTHOR"
                                    attributes-author.
           if attributes-image-jpeg
              call "win$printer" using winprint-set-attribute 
                                       "JPEG"
                                       attributes-jpeg-quality
           end-if
           if not attributes-pdf-default
              call "win$printer" using winprint-set-attribute
                                       "PDFA" 
                                       attributes-pdf-type
           end-if.

           if attributes-encryption-on
              move pdfcrypt-no to pdfcrypt-type
              evaluate true
              when attributes-encrypt-std40
                   add pdfcrypt-std-40               to pdfcrypt-type
              when attributes-encrypt-st128
                   add pdfcrypt-std-128              to pdfcrypt-type
              when attributes-encrypt-aes128
                   add pdfcrypt-aes-128              to pdfcrypt-type
              when attributes-encrypt-no-meta
                   add pdfcrypt-no-metadata          to pdfcrypt-type
              when attributes-encrypt-embeded-only
                   add pdfcrypt-embedded-files-only  to pdfcrypt-type
              end-evaluate

              if attributes-encrypt-all-permission = 1
                 add pdfcrypt-all-permissions  to pdfcrypt-type
              end-if
              if attributes-encrypt-print = 1
                 add pdfcrypt-allow-printing to pdfcrypt-type
              end-if
              if attributes-encrypt-copy = 1
                 add pdfcrypt-allow-copy to pdfcrypt-type
              end-if
              if attributes-encrypt-modify-annotation = 1
                 add pdfcrypt-allow-modify-annotations  to pdfcrypt-type
              end-if

              call "win$printer" using winprint-set-attribute
                                       "ENCRYPTION" 
                                       pdfcrypt-type
              call "win$printer" using winprint-set-attribute
                                       "USER_PASSWORD" 
                                       attributes-encrypt-pwd
           end-if.
           .

       LOAD-BMP.
           copy resource "../resources/veryant.png".
           call "W$BITMAP" using wbitmap-load, "veryant.png"
                          giving pic-company.

       SET-MARGINS.
           initialize winprint-selection
           set wprterr-no-printers       to true

           move 1                        to winprint-copies
           move wprtsel-orient-portrait  to winprint-orientation
           move wprtsel-quality-default  to winprint-quality
           move wprtsel-orient-portrait  to winprint-curr-orientation
           move 1                        to winprint-curr-copies
           set wprt-simplex              to true
           set wprt-a4                   to true
           call "WIN$PRINTER" using winprint-set-printer-ex
                                    winprint-selection
                             giving call-result.
           move "SET-MARGINS-1" to statement-name
           perform TEST-GIVING.

           move wprtmargin-inches   to wprtdata-margin-units
           move 0.3 to wprtdata-top-margin
           move 0.1 to wprtdata-bottom-margin
           move 0.2 to wprtdata-left-margin
                       wprtdata-right-margin
           CALL "WIN$PRINTER" USING WINPRINT-SET-MARGINS
                                    WINPRINT-DATA
                             giving call-result.
           move "SET-MARGINS-2" to statement-name
           perform TEST-GIVING.

       LOAD-FONTS.
           initialize wfont-data.
           set wfdevice-win-printer to true.
           move wrk-arial-black to wfont-name.
           move 7 to wfont-size.
           call   "W$FONT" using wfont-get-font,
                                 h-font-7, 
                                 wfont-data
                          giving call-result.
           move "LOAD-FONTS-1" to statement-name
           perform TEST-GIVING.

           initialize wfont-data.
           set wfdevice-win-printer to true.
           move wrk-arial to wfont-name.
           move 10 to wfont-size.
           call "W$FONT" using wfont-get-font,
                               h-font-10,
                               wfont-data
                        giving call-result.
           move "LOAD-FONTS-2" to statement-name
           perform TEST-GIVING.

           initialize wfont-data.
           set wfdevice-win-printer to true.
           move wrk-arial to wfont-name.
           move 8 to wfont-size.
           call "W$FONT" using wfont-get-font,
                               h-font-8, 
                               wfont-data
                        giving call-result.
           move "LOAD-FONTS-3" to statement-name
           perform TEST-GIVING.

           initialize wfont-data.
           set wfdevice-win-printer to true.
           move wrk-arial to wfont-name.
           move 6 to wfont-size.
           set wfont-bold to true.
           call "W$FONT" using wfont-get-font,
                               h-font-6, 
                               wfont-data
                        giving call-result.
           move "LOAD-FONTS-4" to statement-name
           perform TEST-GIVING.

           initialize wfont-data.
           set wfdevice-win-printer to true.
           move wrk-arial to wfont-name.
           move 5 to wfont-size.
           call "W$FONT" using wfont-get-font,
                               h-font-5, 
                               wfont-data
                        giving call-result.
           move "LOAD-FONTS-5" to statement-name
           perform TEST-GIVING.

       SET-FONT-7.
           initialize wprtdata-set-font.
           move h-font-7 to wprtdata-font.
           call "WIN$PRINTER" using winprint-set-font,
                                    winprint-data
                             giving call-result.
           move "SET-FONT-7" to statement-name
           perform TEST-GIVING.

       SET-FONT-10.
           initialize wprtdata-set-font
           move h-font-10 to wprtdata-font
           call "WIN$PRINTER" using winprint-set-font,
                                    winprint-data
                              giving call-result
           move "SET-FONT-10" to statement-name
           perform TEST-GIVING.

       SET-FONT-8.
           initialize wprtdata-set-font
           move h-font-8 to wprtdata-font
           call "WIN$PRINTER" using winprint-set-font,
                                    winprint-data
                             giving call-result
           move "SET-FONTS-8" to statement-name
           perform TEST-GIVING.

       SET-FONT-5.
           initialize wprtdata-set-font
           move h-font-5 to wprtdata-font
           call "WIN$PRINTER" using winprint-set-font,
                                    winprint-data
                             giving call-result
           move "SET-FONTS-5" to statement-name
           perform TEST-GIVING.

       ST-LAYOUT.
           perform ST-DIVIDERS.
           perform ST-LABEL.

       ST-LABEL.
           perform SET-FONT-7.
           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 1.3 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor
                                    winprint-data
                             giving call-result.
           move "ST-LABEL-1" to statement-name
           perform TEST-GIVING.
           move "http://www.veryant.com - e-mail: info@veryant.com"
                to p-row.
           write p-row before 1 lines.

           initialize wprtdata-draw.
           move 4.575 to wprtdata-draw-start-x.
           move 0.6 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           move "ST-LABEL-2" to statement-name
           perform TEST-GIVING.      
           move "Company" to p-row.
           write p-row before 1 lines.

           perform SET-FONT-5.
           initialize wprtdata-draw.
           move 4.5 to wprtdata-draw-start-x.
           move 1.65 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           move "ST-LABEL-3" to statement-name
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row1
                record-position of field2-p-row1
                record-position of field3-p-row1.
           move wprtunits-inches to winprint-col-units.
           move 4.5 to winprint-col-start.
           move 0.070 to winprint-col-indent.
           move h-font-5 to winprint-col-font. 
           move wprtalign-left to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-3" to statement-name
           perform TEST-GIVING.
           move 5.4 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-4" to statement-name
           perform TEST-GIVING.
           move 6.7 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-4" to statement-name
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-6" to statement-name
           perform TEST-GIVING.
           move p-row1 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

           initialize wprtdata-draw.
           move 4.5 to wprtdata-draw-start-x.
           move 1.975 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row2
                record-position of field2-p-row2
                record-position of field3-p-row2.
           move wprtunits-inches to winprint-col-units.
           move 4.5 to winprint-col-start.
           move 0.070 to winprint-col-indent.
           move h-font-5 to winprint-col-font. 
           move wprtalign-left to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-7" to statement-name
           perform TEST-GIVING.
           move 5.4 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-8" to statement-name
           perform TEST-GIVING.
           move 6.7 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-9" to statement-name
           perform TEST-GIVING.

           move p-row2 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.
      
           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 2.55 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           move "ST-LABEL-10" to statement-name
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row5
                record-position of field2-p-row5
                record-position of field3-p-row5.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.
           move 0.050 to winprint-col-indent.
           move h-font-5 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-11" to statement-name
           perform TEST-GIVING.
           move 2.3 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-12" to statement-name
           perform TEST-GIVING.
           move 5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-13" to statement-name
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-14" to statement-name
           perform TEST-GIVING.
           move p-row5 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 2.90 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                             giving call-result.
           move "ST-LABEL-15" to statement-name
           perform TEST-GIVING.

           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row6
                record-position of field2-p-row6
                record-position of field3-p-row6
                record-position of field4-p-row6.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.
           move 0.050 to winprint-col-indent.
           move h-font-5 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-16" to statement-name
           perform TEST-GIVING.

           move 0.95 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-17" to statement-name
           perform TEST-GIVING.

           move 3 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-18" to statement-name
           perform TEST-GIVING.

           move 6.8 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
               winprint-column,
               giving call-result.
           move "ST-LABEL-19" to statement-name
           perform TEST-GIVING.
           move p-row6 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 3 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           move "ST-LABEL-20" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 3.25 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           move "ST-LABEL-21" to statement-name
           perform TEST-GIVING.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row8.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.
           move 0.050 to winprint-col-indent.
           move h-font-5 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-21" to statement-name
           perform TEST-GIVING.
           move p-row8 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

      **---
           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 3.35 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           move "ST-LABEL-22" to statement-name
           perform TEST-GIVING.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row9.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.
           move 0.050 to winprint-col-indent.
           move h-font-10 to winprint-col-font.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-23" to statement-name
           perform TEST-GIVING.
           move p-row9 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

           initialize wprtdata-draw.
           move 0.55 to wprtdata-draw-start-x.
           move 3.65 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           move "ST-LABEL-24" to statement-name
           perform TEST-GIVING.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row10
                record-position of field2-p-row10
                record-position of field3-p-row10
                record-position of field4-p-row10
                record-position of field5-p-row10
                record-position of field6-p-row10
                record-position of field7-p-row10
                record-position of field8-p-row10.
           move "ST-LABEL-25" to statement-name
           perform TEST-GIVING.

           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.           
           move h-font-8 to winprint-col-font. 
           move wprtalign-center to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-26" to statement-name
           perform TEST-GIVING.
           move 1.5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-27" to statement-name
           perform TEST-GIVING.
           move 4 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
               winprint-column,
               giving call-result.
           move "ST-LABEL-28" to statement-name
           perform TEST-GIVING.
           move 4.3 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-29" to statement-name
           perform TEST-GIVING.
           move 5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-30" to statement-name
           perform TEST-GIVING.      
           move 5.9 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-31" to statement-name
           perform TEST-GIVING.
           move 6.4 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-32" to statement-name
           perform TEST-GIVING.
           move 7.5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-33" to statement-name
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move p-row10 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 9.030 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           move "ST-LABEL-34" to statement-name
           perform TEST-GIVING.

           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row13
                record-position of field2-p-row13
                record-position of field3-p-row13
                record-position of field4-p-row13
                record-position of field5-p-row13
                record-position of field6-p-row13
                record-position of field7-p-row13.

           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.         
           move 0.050 to winprint-col-indent.
           move h-font-5 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-36" to statement-name
           perform TEST-GIVING.
           move 1.5 to winprint-col-start.
           move 0 to winprint-col-indent.
           move wprtalign-center to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-37" to statement-name
           perform TEST-GIVING.
           move 2.1 to winprint-col-start.
           move 0.050 to winprint-col-indent.
           move wprtalign-left to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-38" to statement-name
           perform TEST-GIVING.
           move 3.2 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-39" to statement-name
           perform TEST-GIVING.
           move 4.2 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-40" to statement-name
           perform TEST-GIVING.
           move 5.7 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-41" to statement-name
           perform TEST-GIVING.
           move 6.7 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                                    winprint-column,
                             giving call-result.
           move "ST-LABEL-42" to statement-name
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                                    winprint-column,
                             giving call-result.
           move "ST-LABEL-43" to statement-name
           perform TEST-GIVING.
           move p-row13 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 9.330 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           move "ST-LABEL-44" to statement-name
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row15
                record-position of field2-p-row15
                record-position of field3-p-row15
                record-position of field4-p-row15
                record-position of field5-p-row15
                record-position of field6-p-row15
                record-position of field7-p-row15.
      ***---
           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.         
           move 0.050 to winprint-col-indent.
           move h-font-5 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-45" to statement-name
           perform TEST-GIVING.
           move 1.3 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-46" to statement-name
           perform TEST-GIVING.
           move 2.2 to winprint-col-start.
           move 0.050 to winprint-col-indent.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-47" to statement-name
           perform TEST-GIVING.
           move 3.2 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-48" to statement-name
           perform TEST-GIVING.
           move 3.6 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-49" to statement-name
           perform TEST-GIVING.
           move 5.5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-50" to statement-name
           perform TEST-GIVING.
           move 6.5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-51" to statement-name
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-52" to statement-name
           perform TEST-GIVING.
           move p-row15 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 10.150 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           move "ST-LABEL-53" to statement-name
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row17
                record-position of field2-p-row17
                record-position of field3-p-row17.
           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.         
           move 0.050 to winprint-col-indent.
           move h-font-5 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-54" to statement-name
           perform TEST-GIVING.
           move 3.2 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-55" to statement-name
           perform TEST-GIVING.
           move 5.5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-56" to statement-name
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-57" to statement-name
           perform TEST-GIVING.
           move p-row17 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 10.725 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           move "ST-LABEL-58" to statement-name
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row19
                record-position of field2-p-row19.
           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.         
           move 0.050 to winprint-col-indent.
           move h-font-5 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-59" to statement-name
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-LABEL-60" to statement-name
           perform TEST-GIVING.
           move p-row19 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

       ST-DIVIDERS.
      *    Image
           initialize wprtdata-print-bitmap.
           move pic-company to wprtdata-bitmap.
           move 0.4 to wprtdata-bitmap-row.
           move 0.8 to wprtdata-bitmap-col.
           move 1.7 to wprtdata-bitmap-width.
           move 0.8 to wprtdata-bitmap-height.
           move wprtbitmap-scale-inches to wprtdata-bitmap-flags.
           add  wprtbitmap-units-inches to wprtdata-bitmap-flags.  
           call "WIN$PRINTER" using winprint-print-bitmap,
                                    winprint-data.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.771 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 0.5 to wprtdata-draw-start-y.
           move 0.7 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, 
                                    winprint-data
                             giving call-result.
           move "ST-DIVIDERS-1" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.572 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 0.5 to wprtdata-draw-start-y.
           move 0.5 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, 
                                    winprint-data
                             giving call-result.
           move "ST-DIVIDERS-2" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.771 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 1.3 to wprtdata-draw-start-y.
           move 1.5 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, 
                                    winprint-data
                             giving call-result.
           move "ST-DIVIDERS-3" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.572 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 1.5 to wprtdata-draw-start-y.
           move 1.5 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, 
                                    winprint-data
                             giving call-result.
           move "ST-DIVIDERS-4" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.5 to wprtdata-draw-start-x.
           move 4.7 to wprtdata-draw-stop-x.
           move 0.5 to wprtdata-draw-start-y.
           move 0.5 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, 
                                    winprint-data
                             giving call-result.
           move "ST-DIVIDERS-5" to statement-name
           perform TEST-GIVING.
      
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.5 to wprtdata-draw-start-x.
           move 4.5 to wprtdata-draw-stop-x.
           move 0.5 to wprtdata-draw-start-y.
           move 0.7 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, 
                                    winprint-data
                             giving call-result.
           move "ST-DIVIDERS-6" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.5 to wprtdata-draw-start-x.
           move 4.5 to wprtdata-draw-stop-x.
           move 1.3 to wprtdata-draw-start-y.
           move 1.5 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, 
                                    winprint-data
                giving call-result.
           move "ST-DIVIDERS-7" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.5 to wprtdata-draw-start-x.
           move 4.7 to wprtdata-draw-stop-x.
           move 1.5 to wprtdata-draw-start-y.
           move 1.5 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-8" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move 4.575 to wprtdata-draw-start-x.
           move 1.2 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           move "ST-DIVIDERS-9" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-pen.
           move wprt-pen-solid to wprtdata-pen-style.
           move 2 to wprtdata-pen-width.
           call "WIN$PRINTER" using winprint-graph-pen, winprint-data
                giving call-result.
           move "ST-DIVIDERS-10" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 1.6 to wprtdata-draw-start-y.
           move 1.6 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-11" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.5 to wprtdata-draw-start-x.
           move 4.5 to wprtdata-draw-stop-x.
           move 1.6 to wprtdata-draw-start-y.
           move 2.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
               giving call-result.
           move "ST-DIVIDERS-12" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 1.95 to wprtdata-draw-start-y.
           move 1.95 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-13" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 2.3 to wprtdata-draw-start-y.
           move 2.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-14" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.771 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 1.6 to wprtdata-draw-start-y.
           move 2.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
               giving call-result.
           move "ST-DIVIDERS-15" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 5.4 to wprtdata-draw-start-x.
           move 5.4 to wprtdata-draw-stop-x.
           move 1.6 to wprtdata-draw-start-y.
           move 2.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-16" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 6.7 to wprtdata-draw-start-x.
           move 6.7 to wprtdata-draw-stop-x.           
           move 1.6 to wprtdata-draw-start-y.
           move 2.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-17" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move 4.5 to wprtdata-draw-start-x.
           move 1.975 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           move "ST-DIVIDERS-18" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 2.5 to wprtdata-draw-start-y.
           move 2.5 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-19" to statement-name
           perform TEST-GIVING.
           
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 2.85 to wprtdata-draw-start-y.
           move 2.85 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-20" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 3.2 to wprtdata-draw-start-y.
           move 3.2 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-21" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 3.55 to wprtdata-draw-start-y.
           move 3.55 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-22" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 0.5 to wprtdata-draw-stop-x.
           move 2.5 to wprtdata-draw-start-y.
           move 3.55 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-23" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.771 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 2.5 to wprtdata-draw-start-y.
           move 3.55 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-24" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move 2.3 to wprtdata-draw-start-x.
           move 2.3 to wprtdata-draw-stop-x.
           move 2.5 to wprtdata-draw-start-y.
           move 2.85 to wprtdata-draw-stop-y.
           move wprt-draw-line to wprtdata-draw-shape.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-25" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move 5 to wprtdata-draw-start-x.
           move 5 to wprtdata-draw-stop-x.
           move 2.5 to wprtdata-draw-start-y.
           move 2.85 to wprtdata-draw-stop-y.
           move wprt-draw-line to wprtdata-draw-shape.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-26" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move 0.95 to wprtdata-draw-start-x.
           move 0.95 to wprtdata-draw-stop-x.
           move 2.85 to wprtdata-draw-start-y.
           move 3.2 to wprtdata-draw-stop-y.
           move wprt-draw-line to wprtdata-draw-shape.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-27" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move 3 to wprtdata-draw-start-x.
           move 3 to wprtdata-draw-stop-x.
           move 2.85 to wprtdata-draw-start-y.
           move 3.2 to wprtdata-draw-stop-y.
           move wprt-draw-line to wprtdata-draw-shape.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-28" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move 6.8 to wprtdata-draw-start-x.
           move 6.8 to wprtdata-draw-stop-x.
           move 2.85 to wprtdata-draw-start-y.
           move 3.2 to wprtdata-draw-stop-y.
           move wprt-draw-line to wprtdata-draw-shape.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-29" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 3.8 to wprtdata-draw-start-y.
           move 3.8 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-30" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 0.5 to wprtdata-draw-stop-x.
           move 3.3 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-31" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.771 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 3.3 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-32" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-34" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 1.5 to wprtdata-draw-start-x.
           move 1.5 to wprtdata-draw-stop-x.
           move 3.55 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-35" to statement-name
           perform TEST-GIVING.       

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4 to wprtdata-draw-start-x.
           move 4 to wprtdata-draw-stop-x.
           move 3.55 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-36" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.3 to wprtdata-draw-start-x.
           move 4.3 to wprtdata-draw-stop-x.
           move 3.55 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-37" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 5 to wprtdata-draw-start-x.
           move 5 to wprtdata-draw-stop-x.
           move 3.55 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-38" to statement-name
           perform TEST-GIVING.       

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 5.9 to wprtdata-draw-start-x.
           move 5.9 to wprtdata-draw-stop-x.
           move 3.55 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-39" to statement-name
           perform TEST-GIVING.       

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 6.4 to wprtdata-draw-start-x.
           move 6.4 to wprtdata-draw-stop-x.
           move 3.55 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-40" to statement-name
           perform TEST-GIVING.       

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.5 to wprtdata-draw-start-x.
           move 7.5 to wprtdata-draw-stop-x.
           move 3.55 to wprtdata-draw-start-y.
           move 9 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-41" to statement-name
           perform TEST-GIVING.       

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 9.3 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-42" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 0.5 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-43" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 1.5 to wprtdata-draw-start-x.
           move 1.5 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-44" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 2.1 to wprtdata-draw-start-x.
           move 2.1 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-45" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 3.2 to wprtdata-draw-start-x.
           move 3.2 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-46" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 4.2 to wprtdata-draw-start-x.
           move 4.2 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-47" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 5.7 to wprtdata-draw-start-x.
           move 5.7 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-48" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 6.7 to wprtdata-draw-start-x.
           move 6.7 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-49" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.771 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 9.3 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-50" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-pen.
           move wprt-pen-solid  to  wprtdata-pen-style.
           move 2 to  wprtdata-pen-width.
           call "WIN$PRINTER"  
                using  winprint-graph-pen, winprint-data
                giving  call-result.
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 10.1 to wprtdata-draw-start-y.
           move 10.1 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-51" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-pen.
           move wprt-pen-solid  to  wprtdata-pen-style.
           move 1 to  wprtdata-pen-width.
           call "WIN$PRINTER"  
                using  winprint-graph-pen, winprint-data
                giving  call-result.
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 5.5 to wprtdata-draw-stop-x.
           move 10.7 to wprtdata-draw-start-y.
           move 10.7 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-52" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 11 to wprtdata-draw-start-y.
           move 11 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-53" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 0.5 to wprtdata-draw-start-x.
           move 0.5 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 11 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-54" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 7.771 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 9 to wprtdata-draw-start-y.
           move 11 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-55" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 1.3 to wprtdata-draw-start-x.
           move 1.3 to wprtdata-draw-stop-x.
           move 9.3 to wprtdata-draw-start-y.
           move 10.1 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-56" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 2.2 to wprtdata-draw-start-x.
           move 2.2 to wprtdata-draw-stop-x.
           move 9.3 to wprtdata-draw-start-y.
           move 10.1 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-57" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 3.2 to wprtdata-draw-start-x.
           move 3.2 to wprtdata-draw-stop-x.
           move 9.3 to wprtdata-draw-start-y.
           move 10.1 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-58" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-pen.
           move wprt-pen-solid  to  wprtdata-pen-style.
           move 1 to  wprtdata-pen-width.
           call "WIN$PRINTER"  
                using  winprint-graph-pen, winprint-data
                giving  call-result.
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 3.6 to wprtdata-draw-start-x.
           move 3.6 to wprtdata-draw-stop-x.
           move 9.3 to wprtdata-draw-start-y.
           move 10.1 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-59" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-pen.
           move 1 to wprtdata-pen-width.
           call "WIN$PRINTER"  
                using  winprint-graph-pen, winprint-data
                giving  call-result.
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 5.5 to wprtdata-draw-start-x.
           move 5.5 to wprtdata-draw-stop-x.
           move 9.3 to wprtdata-draw-start-y.
           move 10.1 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-60" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 6.5 to wprtdata-draw-start-x.
           move 6.5 to wprtdata-draw-stop-x.
           move 9.3 to wprtdata-draw-start-y.
           move 10.1 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-61" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 3.2 to wprtdata-draw-start-x.
           move 3.2 to wprtdata-draw-stop-x.
           move 10.1 to wprtdata-draw-start-y.
           move 10.7 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-62" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-pen.
           move 2 to wprtdata-pen-width.
           call "WIN$PRINTER"  
                using  winprint-graph-pen, winprint-data
                giving  call-result.
           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 5.5 to wprtdata-draw-start-x.
           move 5.5 to wprtdata-draw-stop-x.
           move 10.1 to wprtdata-draw-start-y.
           move 10.7 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-63" to statement-name
           perform TEST-GIVING.

           initialize wprtdata-draw.
           move wprt-draw-line to wprtdata-draw-shape.
           move 5.5 to wprtdata-draw-start-x.
           move 7.771 to wprtdata-draw-stop-x.
           move 10.7 to wprtdata-draw-start-y.
           move 10.7 to wprtdata-draw-stop-y.
           move wprtunits-inches to wprtdata-draw-units.           
           call "WIN$PRINTER" using winprint-graph-draw, winprint-data
                giving call-result.
           move "ST-DIVIDERS-64" to statement-name
           perform TEST-GIVING.

       ST-DATA.
           initialize wprtdata-draw.
           move 4.575 to wprtdata-draw-start-x.
           move 0.85 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           move "ST-DATA-1" to statement-name
           perform TEST-GIVING.

           perform SET-FONT-10.
           move customer-name   to p-row.
           write p-row before 1 lines.

           initialize wprtdata-draw.
           move 4.575 to wprtdata-draw-start-x.
           move 1 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           move "ST-DATA-2" to statement-name
           perform TEST-GIVING.
           move customer-adress to p-row.
           write p-row before 1 lines.

           initialize wprtdata-draw.
           move 4.575 to wprtdata-draw-start-x.
           move 1.15 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           move "ST-DATA-3" to statement-name
           perform TEST-GIVING.
           move customer-city to p-row.
           write p-row before 1 lines.

           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 3.9 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           move "ST-DATA-4" to statement-name
           perform TEST-GIVING.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row11
                record-position of field2-p-row11.

           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 1.5 to winprint-col-start.         
           move 0.050 to winprint-col-indent.
           move h-font-8 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-5" to statement-name
           perform TEST-GIVING.
           move 4 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-6" to statement-name
           perform TEST-GIVING.
           move p-row11 to p-row.
           write p-row before 1 lines.
           perform reset-column.

           initialize wprtdata-draw.
           move 0.7 to wprtdata-draw-start-x.
           move 2.65 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           move "ST-DATA-7" to statement-name
           perform TEST-GIVING.
           move p-row-cutomer    to p-row
           perform SET-FONT-10.
           write p-row before 1 lines.

           perform SET-FONT-8.
           initialize wprtdata-draw.
           move 4.5 to wprtdata-draw-start-x.
           move 1.75 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           move "ST-DATA-8" to statement-name
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row3
                record-position of field2-p-row3
                record-position of field3-p-row3.
           move wprtunits-inches to winprint-col-units.
           move 4.5 to winprint-col-start.
           move h-font-8 to winprint-col-font. 
           move wprtalign-center to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-9" to statement-name
           perform TEST-GIVING.
           move 5.4 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-10" to statement-name
           perform TEST-GIVING.
           move 6.7 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-11" to statement-name
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-12" to statement-name
           perform TEST-GIVING.
           move p-row3 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

           initialize wprtdata-draw.
           move 4.5 to wprtdata-draw-start-x.
           move 2.10 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           move "ST-DATA-13" to statement-name
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row4
                record-position of field2-p-row4
                record-position of field3-p-row4.
           move wprtunits-inches to winprint-col-units.
           move 4.5 to winprint-col-start.           
           move h-font-8 to winprint-col-font. 
           move wprtalign-center to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-14" to statement-name
           perform TEST-GIVING.
           move 5.4 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-15" to statement-name
           perform TEST-GIVING.
           move 6.7 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-16" to statement-name
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-17" to statement-name
           perform TEST-GIVING.
           move p-row4 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 3 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           move "ST-DATA-18" to statement-name
           perform TEST-GIVING.           
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row7
                record-position of field2-p-row7
                record-position of field3-p-row7
                record-position of field4-p-row7.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.
           move 0.050 to winprint-col-indent.
           move h-font-10 to winprint-col-font. 
           move wprtalign-left  to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-19" to statement-name
           perform TEST-GIVING.
           move 0.95 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-20" to statement-name
           perform TEST-GIVING.
           move 3 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-21" to statement-name
           perform TEST-GIVING.
           move 6.8 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
               winprint-column,
               giving call-result.
           move "ST-DATA-22" to statement-name
           perform TEST-GIVING.
           move p-row7 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN. 

           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 4.1 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           move "ST-DATA-23" to statement-name
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row12
                record-position of field2-p-row12
                record-position of field3-p-row12
                record-position of field4-p-row12
                record-position of field5-p-row12
                record-position of field6-p-row12
                record-position of field7-p-row12
                record-position of field8-p-row12.

           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.         
           move 0.050 to winprint-col-indent.
           move h-font-8 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-24" to statement-name
           perform TEST-GIVING.

           move wprtunits-inches to winprint-col-units.
           move 1.5 to winprint-col-start.         
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-25" to statement-name
           perform TEST-GIVING.

           move wprtunits-inches to winprint-col-units.
           move 4 to winprint-col-start.                
           move 0 to winprint-col-indent.
           move wprtalign-center to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-26" to statement-name
           perform TEST-GIVING.

           move wprtunits-inches to winprint-col-units.
           move 4.3 to winprint-col-start.         
           move 0.1 to winprint-col-separation.
           move wprtalign-right to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-27" to statement-name
           perform TEST-GIVING.

           move wprtunits-inches to winprint-col-units.
           move 5 to winprint-col-start.         
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-28" to statement-name
           perform TEST-GIVING.

           move wprtunits-inches to winprint-col-units.
           move 5.9 to winprint-col-start.         
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-29" to statement-name
           perform TEST-GIVING.

           move wprtunits-inches to winprint-col-units.           
           move 6.4 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-30" to statement-name
           perform TEST-GIVING.

           move wprtunits-inches to winprint-col-units.
           move 7.5 to winprint-col-start.
           move 0 to winprint-col-separation.
           move wprtalign-center to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-31" to statement-name
           perform TEST-GIVING.

           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result
           move "ST-DATA-32" to statement-name
           perform TEST-GIVING.

           move p-row12 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

           perform SET-FONT-10.
           initialize wprtdata-draw.
           move 0.55 to wprtdata-draw-start-x.
           move 4.5 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           move "ST-DATA-34" to statement-name
           perform TEST-GIVING.
           move "These commodities, technology or software" to p-row.
           write p-row before 1 lines.

           initialize wprtdata-draw.                      
           move 0.55 to wprtdata-draw-start-x.
           move 4.7 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
               giving call-result.
           move "ST-DATA-35" to statement-name
           perform TEST-GIVING.
           move "were exported from United States in accordance" 
                                                              to p-row.
           write p-row before 1 lines.

           initialize wprtdata-draw.
           move 0.55 to wprtdata-draw-start-x.
           move 4.9 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           move "ST-DATA-36" to statement-name
           perform TEST-GIVING.
           move "with the export administration regulations." to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN

           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 9.125 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           move "ST-DATA-37" to statement-name
           perform TEST-GIVING.

           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row14
                record-position of field2-p-row14
                record-position of field3-p-row14
                record-position of field4-p-row14
                record-position of field5-p-row14
                record-position of field6-p-row14
                record-position of field7-p-row14.
      ***---
           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.         
           move 0.050 to winprint-col-separation.
           move wprtalign-right to winprint-col-alignment.
           move h-font-6 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-38" to statement-name
           perform TEST-GIVING.
           move 1.5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-39" to statement-name
           perform TEST-GIVING.
           move 2.1 to winprint-col-start.
           move 0.050 to winprint-col-indent.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-40" to statement-name
           perform TEST-GIVING.
           move 3.2 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-41" to statement-name
           perform TEST-GIVING.
           move 4.2 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-42" to statement-name
           perform TEST-GIVING.
           move 5.7 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-43" to statement-name
           perform TEST-GIVING.
           move 6.7 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-44" to statement-name
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-46" to statement-name
           perform TEST-GIVING.
           move p-row14 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 9.6 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           move "ST-DATA-47" to statement-name
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row16
                record-position of field2-p-row16
                record-position of field3-p-row16
                record-position of field4-p-row16
                record-position of field5-p-row16
                record-position of field6-p-row16
                record-position of field7-p-row16.
           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.         
           move 0.050 to winprint-col-indent.
           move h-font-10 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-48" to statement-name
           perform TEST-GIVING.
           move 1.3 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-49" to statement-name
           perform TEST-GIVING.
           move 2.2 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-50" to statement-name
           perform TEST-GIVING.
           move 3.2 to winprint-col-start.
           move 0 to winprint-col-indent.
           move wprtalign-center to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-51" to statement-name
           perform TEST-GIVING.
           move 3.6 to winprint-col-start.
           move wprtalign-center to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-52" to statement-name
           perform TEST-GIVING.
           move 5.7 to winprint-col-start.
           move wprtalign-right to winprint-col-alignment.
           move 0.050 to winprint-col-separation.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-53" to statement-name
           perform TEST-GIVING.
           move 6.5 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-54" to statement-name
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-55" to statement-name
           perform TEST-GIVING.
           move p-row16 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

           initialize wprtdata-draw.
           move 0.5 to wprtdata-draw-start-x.
           move 10.3 to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor, winprint-data
                giving call-result.
           move "ST-DATA-56" to statement-name
           perform TEST-GIVING.
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                record-position of field1-p-row18
                record-position of field2-p-row18
                record-position of field3-p-row18.
           initialize winprint-column.
           move wprtunits-inches to winprint-col-units.
           move 0.5 to winprint-col-start.         
           move 0.050 to winprint-col-separation.
           move wprtalign-right to winprint-col-alignment.
           move h-font-10 to winprint-col-font. 
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-57" to statement-name
           perform TEST-GIVING.
           move 3.0 to winprint-col-start.
           move wprtalign-right to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-58" to statement-name
           perform TEST-GIVING.
           move 5.5 to winprint-col-start.
           move wprtalign-right to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-59" to statement-name
           perform TEST-GIVING.
           move 7.771 to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                winprint-column,
                giving call-result.
           move "ST-DATA-60" to statement-name
           perform TEST-GIVING.
           move p-row18 to p-row.
           write p-row before 1 lines.
           perform RESET-COLUMN.

       RESET-COLUMN.
           call "WIN$PRINTER" using winprint-clear-data-columns,
                             giving call-result.
           move "RESET-COLUMN-1" to statement-name
           perform TEST-GIVING.
           call "WIN$PRINTER" using winprint-clear-page-columns,
                giving call-result.
           move "RESET-COLUMN-2" to statement-name
           perform TEST-GIVING.

       TEST-GIVING.
           if call-result not = 1
              display message box "Operation failed!!"
                                  x"0D0A"
                                  "Statement: " statement-name
                                  
           end-if.

       DESTROY-HANDLE.
           call "W$BITMAP" using wbitmap-destroy, pic-company.
           destroy h-font-5
                   h-font-6
                   h-font-7
                   h-font-8
                   h-font-10.
           