      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. check-box.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  close-win               pic 9 value 0.

       77  bmp-handle              pic s9(9) comp-4.
       77  var1                    pic 9.
       77  var2                    pic 9.
       77  var3                    pic 9.
       77  vara                    pic 9.
       77  varb                    pic 9.
       77  varl1                   pic 9.
       77  varl2                   pic 9.
       77  varl3                   pic 9.
       77  var-alpha-1             pic x any length.
       77  var-alpha-2             pic x any length.
       77  var-alpha-3             pic x any length.
       77  total-ed                pic x(10).
       77  total                   pic 9(4).
       77  totalz                  pic z(4).
       77  control-font            handle of font.

       SCREEN SECTION.
       01  Mask.
           03 frame
              engraved
              line                 2 
              col                  2
              lines                11 cells 
              size                 21 cells
              title                "options"
              .
           03 Cb1 
              check-box            
              line                 5 
              col                  3
              title                "option 1"
              value                var1
              . 
           03 Cb2 
              check-box
              line                 7 
              col                  3
              title                "option 2"
              value                var2
              .
           03 Cb3 
              check-box
              line                 9 
              col                  3
              title                "option 3"
              value                var3
              .
           03 frame 
              engraved
              line                 2 
              col                  25
              lines                11 cells
              size                 21 cells
              title                "Alphanumeric Check"
              .
           03 CbA1 
              check-box 
              line                 5 
              col                  26
              title                "Hybrid"
              check-on-value       "yes" 
              check-off-value      "no"
              value                var-alpha-1
              .
           03 cbA2 
              check-box 
              line                 7 
              col                  26
              title                "Supercharged"  
              check-on-value       "Supercharged" 
              check-off-value      "Not Supercharged"
              value                var-alpha-2
              . 
           03 cbA3 
              check-box 
              line                 9 
              col                  26
              title                "Power Steering" 
              check-on-value       "Yes" 
              check-off-value      "No"
              value                var-alpha-3
              . 
           03 frame
              engraved
              line                 2 
              col                  49
              lines                11 cells 
              size                 21 cells
              title                "Optional"
              .
           03 CbL1 
              check-box            
              line                 5 
              col                  51
              title                "Optional 1"
              value                varl1
              left-text
              exception-value      101
              . 
           03 label
              line                 5
              col                  64
              title                "$ 550"
              .
           03 CbL2 
              check-box
              line                 7 
              col                  51
              title                "Optional 2"  
              value                varl2
              left-text
              exception-value      102
              .
           03 label
              line                 7
              col                  64
              title                "$ 125"
              .
           03 CbL3 
              check-box
              line                 9 
              col                  51
              title                "Optional 3" 
              value                varl3
              left-text
              exception-value      103
              .
           03 label
              line                 9
              col                  64
              title                "$ 130"
              .
           03 label
              line                 11
              col                  51
              title                "Total"
              .
           03 lb-total
              label
              line                 11
              col                  64
              title                total-ed
              transparent
              .
           03 frame 
              engraved
              line                 14
              col                  25
              lines                7 cells
              size                 21 cells
              title                "graphical options"
              .
           03 CbA 
              check-box
              line                 16
              col                  26
              lines                19
              size                 19
              bitmap 
              bitmap-width         19
              bitmap-handle        bmp-handle
              bitmap-number        6
              bitmap-pressed       10 
              bitmap-rollover      8
              bitmap-rollover-selected 9
              bitmap-selected      7
              bitmap-scale         2
              title                "bitmap only" 
              value                vara
              . 
           03 CbB check-box  
              flat
              line                 18
              col                  26
              lines                2 cells
              size                 18 cells
              bitmap 
              bitmap-width         19
              bitmap-handle        bmp-handle  
              bitmap-number        6
              bitmap-pressed       10
              bitmap-rollover      8
              bitmap-rollover-selected 9
              bitmap-selected      7
              bitmap-scale         2
              title                "bitmap and text"
              title-position       2 
              value                varb
              .
           03 Pb1 
              push-button
              line                 14 
              col                  2 
              size                 15 cells
              title                "&Confirm"
              exception-value      100
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           call "W$BITMAP" using wbitmap-load, "files/roll.gif"
                          giving bmp-handle
           
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "CHECK-BOX Control"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           move zero   to total

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    evaluate crt-status
                    when 100
                         perform SELECTED-CONTROLS
                    when 101
                    when 102
                    when 103
                         perform RECALCULATE-TOTAL
                    end-evaluate
              end-accept
              move 4 to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           call "W$BITMAP" using wbitmap-destroy, bmp-handle
           goback
           .

       SELECTED-CONTROLS.
           display message "option1: " var1 x"0D0A"
                           "option2: " var2 x"0D0A"
                           "option3: " var3 x"0D0A"
                           "Hybrid: " var-alpha-1 x"0D0A"
                           "Supercharged: " var-alpha-2  x"0D0A"
                           "Power steering: " var-alpha-3  x"0D0A"
                           "optional1: " varl1 x"0D0A"
                           "optional2: " varl2 x"0D0A"
                           "optional3: " varl3 x"0D0A"
                           "bitmap only option: " vara x"0D0A"
                           "bitmap-text option: " varb 
                     title "choice"
           .

       RECALCULATE-TOTAL.
           move zero   to total
           if varl1 = 1
              add 550  to total
           end-if
           if varl2 = 1
              add 125  to total
           end-if
           if varl3 = 1
              add 130  to total
           end-if.
           move total  to totalz

           initialize total-ed
           string "$ "    delimited by size
                  totalz  delimited by size
                  into total-ed.
           modify lb-total title total-ed.

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
