      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.    WMENU-HAMBURGER.
       
       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "iscobol.def".
       copy "isresize.def".
       copy "isfonts.def".
       77  hWin                    usage handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  crt-status              is special-names crt status pic 9(5). 

       77  w-check                 pic 9 value 1.
       77  h-img                   pic s9(9) comp-4.
       77  h-menu-font             handle of font.

       78  mnu-new                 value 1001.
       78  mnu-open                value 1002.
       78  mnu-save                value 1003.
       78  mnu-cut                 value 2001.
       78  mnu-copy                value 2002.
       78  mnu-paste               value 2003.
       
       77  p-search-panel          pic 9 value 0.
       77  p-status-bar-covering   pic 9 value 0.
       77  p-expanded              pic 9 value 1.
       77  p-height                pic 9 value 0.
       77  heigth-value            pic 9(3) value 210.
       77  p-layout-manager        pic x(10) value "none".
       
       77  wrk-attribute-value     pic x any length.
       
       SCREEN SECTION.
       01  Mask.
           03 cb
              check-box
              title                "Check/Uncheck MenuItem"
              line                 3  
              col                  4
              value                w-check
              exception-value      101
              .
           03 label
              line                 6
              col                  2
              size                 18 cells
              title                "Last menu choice: " 
              .
           03 lb-choice
              label
              line                 6
              col                  21
              size                 30
              .

           03 frame
              engraved
              title                "2022R1 new features"
              line                 8
              lines                10
              col                  2
              size                 68
              .

           03 cb-expanded
              check-box
              title                "Expanded"
              line                 10
              col                  4
              size                 20 cells
              value                p-expanded
              left-text
              left-text-alignment  1
              exception-value      102
              .
           03 cb-search-panel
              check-box
              title                "Search panel"
              line                 12
              col                  4
              size                 20 cells
              value                p-search-panel
              left-text
              left-text-alignment  1
              exception-value      103
              .

           03 cb-status-bar-covering
              check-box
              title                "Status-bar covering"
              line                 14
              col                  4
              size                 20 cells
              value                p-status-bar-covering
              left-text
              left-text-alignment  1
              exception-value      104
              .

           03 cb-heigth
              check-box
              title                "height"
              line                 16
              col                  4
              size                 20 cells
              value                p-height
              left-text
              left-text-alignment  1
              exception-value      105
              .

           03 ef-heigth
              entry-field
              line                 15.8
              col                  25
              size                 5 cells
              numeric
              max-text             3
              value                heigth-value
              enabled              p-height
              notify-change
              notify-change-delay  500
              event                EF-HEIGTH-EVENT
              .


           03 label
              title                "Layout manager"
              line                 10
              col                  35
              size                 20 cells
              .


           03 cb-layout-manager
              Combo-box
              drop-list
              notify-selchange
              unsorted
              line                 10
              col                  50
              size                 15 cells
              max-text             3
              value                p-layout-manager
              event                CB-LAYOUT-MANAGER-EVENT
              .

           03 Pb-exit  
              push-button
              line                 18.5
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       Main.
           initialize wfont-data

           move "Arial" to wfont-name
           move 11 to wfont-size

           call "W$FONT" using wfont-get-font h-menu-font wfont-data

           call "w$bitmap" using wbitmap-load, "files/tools.gif",
                          giving h-img

           perform SET-MENU-ATTRIBUTE

           perform BUILD-MENU

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "HAMBURGER MENU"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font
                   handle hWin 
                   event  WIN-EVT

           display status-bar panel-widths (10, 40, -1)
                              panel-style  (panel-lowered, 
                                            panel-lowered, 
                                            panel-lowered) 
                              panel-text ("", 
                                          "",
                                          "")

           call "w$menu" using wmenu-show 
                               menu-handle.

           display Mask
           
           modify cb-layout-manager ITEM-TO-ADD ("none"
                                                 "lm-scale"
                                                 "lm-zoom")

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              perform EXCEPTION-HANDLING
              move 4   to accept-control
           end-perform 

           destroy Mask
           destroy hWin
           destroy control-font
           call "W$MENU" using wmenu-destroy-delayed 
                               menu-handle
           destroy h-menu-font
           goback
           .

       SET-MENU-ATTRIBUTE.
           call "w$menu" using WMENU-SET-ATTRIBUTE
                               "default-font" 
                               h-menu-font.

           call "w$menu" using WMENU-SET-ATTRIBUTE
                               "width" 
                               150.

           if p-expanded = 1
              move "yes"  to wrk-attribute-value
           else 
              move "no"   to wrk-attribute-value
           end-if
           call "w$menu" using wmenu-set-attribute
                               "expanded"
                               wrk-attribute-value

           if p-search-panel = 1
              move "yes"  to wrk-attribute-value
           else 
              move "no"   to wrk-attribute-value
           end-if

           call "w$menu" using wmenu-set-attribute
                               "search-panel"
                               wrk-attribute-value

           if  p-status-bar-covering = 1
              move "yes"  to wrk-attribute-value
           else 
              move "no"   to wrk-attribute-value
           end-if
           call "w$menu" using wmenu-set-attribute
                               "status-bar-covering"
                               wrk-attribute-value

           if p-height = 1
              inquire ef-heigth value heigth-value
              call "w$menu" using wmenu-set-attribute
                                  "height"
                                  heigth-value
           else
              call "w$menu" using wmenu-set-attribute
                                  "height"
                                  -1

           end-if

           if p-layout-manager = "none"
              initialize wrk-attribute-value
           else
              move function trim (p-layout-manager) 
                                            to wrk-attribute-value
           end-if
           call "W$MENU" using wmenu-set-attribute
                               "layout-manager"
                                wrk-attribute-value
           .

       BUILD-MENU. 
           call "w$menu" using wmenu-new-hamburger giving menu-handle
      
           call "w$menu" using wmenu-new giving sub-handle-1
           
           call "w$menu" using wmenu-add, menu-handle, 0, 0,
                               "&File", 0, sub-handle-1
           call "w$menu" using wmenu-add, sub-handle-1, 0, 0,
                               "&New", mnu-new
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle mnu-new h-img 3 16
           call "w$menu" using wmenu-add, sub-handle-1, 0, 0,
                               "&Open", mnu-open
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle mnu-open h-img 9 16
           call "w$menu" using wmenu-add, sub-handle-1, 0, 0,
                               "&Save", mnu-save
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle mnu-save h-img 10 16
           call "w$menu" using wmenu-add, sub-handle-1, 0, w-separator
           call "w$menu" using wmenu-add, sub-handle-1, 0, 0,
                               "E&xit", 27
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle 27 h-img 1 16

           call "w$menu" using wmenu-new giving sub-handle-2

           call "w$menu" using wmenu-add, menu-handle, 0, 0,
                               "&Edit", 0, sub-handle-2
           call "w$menu" using wmenu-add, sub-handle-2, 0, 0,
                               "&Cut", mnu-cut
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle mnu-cut h-img 2 16
           call "w$menu" using wmenu-add, sub-handle-2, 0, 0,
                               "&Copy", mnu-copy
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle mnu-copy h-img 3 16
           call "w$menu" using wmenu-add, sub-handle-2, 0, 0,
                               "&Paste", mnu-paste
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle mnu-paste h-img 4 16
           call "w$menu" using wmenu-add, sub-handle-2, 0, w-separator
           call "w$menu" using wmenu-add, sub-handle-2, 0, w-disabled,
                               " w-disabled", 70
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle 70 h-img 5 16
           call "w$menu" using wmenu-add, sub-handle-2, 0, w-checked,
                               " w-checked", 80
           call "w$menu" using wmenu-add-bitmap 
                               menu-handle 80 h-img 8 16
           .

       RELOAD-MENU.
           call "W$MENU" using wmenu-destroy-delayed 
                               menu-handle
           perform SET-MENU-ATTRIBUTE
           perform BUILD-MENU
           call "w$menu" using wmenu-show 
                               menu-handle
           .

       EXCEPTION-HANDLING.
           evaluate crt-status
           when 101
                inquire cb value w-check
                if w-check = 0
                   call "w$menu" using wmenu-uncheck
                                       menu-handle, 80
                else
                   call "w$menu" using wmenu-check 
                                       menu-handle, 80
                end-if
           when 102
           when 103
           when 104
                perform RELOAD-MENU
           when 105
                inquire cb-heigth value p-height 
                modify ef-heigth enabled p-height
                perform RELOAD-MENU
           when mnu-new
                modify lb-choice title "New"
           when mnu-open
                modify lb-choice title "Open"
           when mnu-save
                modify lb-choice title "Save"
           when mnu-cut
                modify lb-choice title "Cut"
           when mnu-copy
                modify lb-choice title "Copy"
           when mnu-paste
                modify lb-choice title "Paste"
           end-evaluate
           .

       EF-HEIGTH-EVENT.
           if event-type = ntf-changed
              perform RELOAD-MENU
           end-if
           .

       CB-LAYOUT-MANAGER-EVENT.
           if event-type = ntf-selchange
              inquire cb-layout-manager value p-layout-manager
              perform RELOAD-MENU
           end-if
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
