      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CLISTENV.
       CONFIGURATION SECTION.
       REPOSITORY.
           class JSystem   as "java.lang.System"
           class JIterator as "java.util.Iterator"
           class JSet      as "java.util.Set"
           .

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  hWin                    handle of window.
       77  crt-status              special-names crt status pic 9(5).
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  props-set               object reference JSet.
       77  i                       object reference JIterator.
     
       01  env-var.
           03  varname             pic x(128).
           03  varvalue            pic x(128).
       77  hEnv                    handle.
       77  idx                     pic 9(3).

       77  rb-value                pic 9.
       01  execution-type          pic X.
           88 standalone-execution value "A".
           88 client-execution     value "C".
           88 server-execution     value "S".

       77  e-remote                pic 9.
       77  e-standalone            pic 9.

       SCREEN SECTION.
       01  Mask.
           03 radio-button 
              line                 2 
              col                  2
              title                "Stand alone"
              group                1
              group-value          1 
              value                rb-value
              exception-value      103
              enabled              e-standalone
              . 
           03 radio-button 
              line                 2 
              col                  17
              title                "Run on Client"
              group                1
              group-value          2
              value                rb-value
              exception-value      103
              enabled              e-remote
              . 
           03 radio-button 
              line                    2 
              col                     34
              title                   "Run on Server"
              group                   1
              group-value             3
              value                   rb-value
              exception-value         103
              enabled                 e-remote
              . 

           03 Tb1
              tab-control
              line                    4 
              col                     2
              lines                   15.5 cells
              size                    68 cells
              allow-container
              .
           03 tb1-page1 
              tab-group Tb1 tab-group-value 1.
              05 label
                 line                 6
                 col                  3
                 size                 30 cells
                 title                "Set environment variable:"
                 .
              05 ef-var
                 entry-field
                 line                 6
                 col                  25
                 size                 10 cells
                 .
              05 ef-val
                 entry-field
                 line                 6
                 col                  36
                 size                 11 cells
                 .
              05 push-button 
                 line                 6
                 col                  48
                 size                 10 cells
                 title                "Set"
                 exception-value      100
                 .
              05 push-button
                 line                 6
                 col                  59
                 size                 10 cells
                 title                "Unset"
                 exception-value      101
                 .
              05 gd-cobol
                 grid 
                 line                 8
                 col                  3
                 lines                6
                 size                 66 cells
                 display-columns      (1, 20)
                 virtual-width        200
                 data-columns         (record-position of varname,
                                       record-position of varvalue)
                 alignment            ("L", "L")
                 data-types           ("X", "X") 
                 protection           1
                 Row-Background-Color-Pattern (0, -14675438)
                 heading-menu-popup   42
                 boxed
                 column-headings 
                 centered-headings
                 tiled-headings
                 Adjustable-Columns
                 reordering-columns
                 heading-color        257
                 border-color         rgb x#ACACAC
                 vscroll
                 hscroll
                 .
           03 tb1-page2 
              tab-group Tb1 tab-group-value 2.
              05 label
                 line                 6
                 col                  3
                 size                 30 cells
                 title                "Set java variable:"
                 .
              05 ef-var-java
                 entry-field
                 line                 6
                 col                  20
                 size                 18 cells
                 .
              05 ef-val-java
                 entry-field
                 line                 6
                 col                  40
                 size                 18 cells
                 .
              05 push-button 
                 line                 6
                 col                  59
                 size                 10 cells
                 title                "Set"
                 exception-value      102
                 .
              05 gd-java
                 grid 
                 line                 8
                 col                  3
                 lines                6
                 size                 66 cells
                 display-columns      (1, 20)
                 virtual-width        200
                 data-columns         (record-position of varname,
                                       record-position of varvalue)
                 alignment            ("L", "L")
                 data-types           ("X", "X") 
                 protection           1
                 Row-Background-Color-Pattern (0, -14675438)
                 heading-menu-popup   42
                 boxed
                 column-headings 
                 centered-headings
                 tiled-headings
                 Adjustable-Columns
                 reordering-columns
                 sort-data            "000111000200"
                 Sortable-Columns
                 heading-color        257
                 border-color         rgb x#ACACAC
                 vscroll
                 hscroll
                 .
           03 Pb-exit  
              push-button
              line                    20
              col                     62 
              size                    8 cells
              title                   "Exit" 
              exception-value         27
              .

       PROCEDURE DIVISION.
       INI.    
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call

           accept terminal-abilities from terminal-info.
           if is-remote
              move 1                     to e-remote
              move zero                  to e-standalone
              move 2                     to rb-value
              set client-execution       to true
           else
              move zero                  to e-remote
              move 1                     to e-standalone
              move 1                     to rb-value
              set standalone-execution   to true
           end-if

           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "Environment Handling Routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           modify Tb1 tab-to-add ("COBOL environment", 
                                  "Java environment")

           modify gd-cobol(1, 1) cell-data = "Name"
           modify gd-cobol(1, 2) cell-data = "Value"
           modify gd-java(1, 1) cell-data = "Name"
           modify gd-java(1, 2) cell-data = "Value"

           perform ENV-CONTENT
           perform JAVA-ENV-CONTENT

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception 
                    continue 
              end-accept
              evaluate crt-status 
              when 100
                   perform SET-VAR
              when 101
                   perform REMOVE-VAR
              when 102
                   perform SET-VAR-JAVA
              when 103
                   if rb-value = 2
                      set client-execution to true
                   else
                      set server-execution to true
                   end-if
                   perform ENV-CONTENT
                   perform JAVA-ENV-CONTENT
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           GOBACK
           .

       SET-VAR.
           inquire ef-var value varname
           inquire ef-val value varvalue

           evaluate true
           when client-execution
                call client "C$SETENV" using varname, varvalue
           when standalone-execution
           when server-execution
                call "C$SETENV" using varname, varvalue
           end-evaluate

           perform ENV-CONTENT
           .

       ENV-CONTENT.
           modify gd-cobol mass-update 1
           modify gd-cobol reset-grid 2

           evaluate true
           when client-execution
                perform ENV-CONTENT-CLIENT
           when standalone-execution
           when server-execution
                perform ENV-CONTENT-SERVER
           end-evaluate.
           modify gd-cobol mass-update 0
           .

       ENV-CONTENT-CLIENT.
           call client "C$LIST-ENVIRONMENT" using listenv-open
                                           giving hEnv
           if hEnv < 1
              modify gd-cobol record-to-add "<<listenv failed>>"
              exit paragraph
           end-if
           perform test after until varname = spaces
             call client "C$LIST-ENVIRONMENT" using listenv-next
                                                    hEnv
                                                    varname
             if varname not = spaces
                call client "C$GETENV" using varname varvalue
                modify gd-cobol record-to-add env-var
             end-if
           end-perform
           call client "C$LIST-ENVIRONMENT" using listenv-close, hEnv
           .

       ENV-CONTENT-SERVER.
           call "C$LIST-ENVIRONMENT" using listenv-open
                                    giving hEnv
           if hEnv < 1
              modify gd-cobol record-to-add "<<listenv failed>>"
              exit paragraph
           end-if
           perform test after until varname = spaces
             call "C$LIST-ENVIRONMENT" using listenv-next
                                             hEnv
                                             varname
             if varname not = spaces
                call "C$GETENV" using varname varvalue
                modify gd-cobol record-to-add env-var
             end-if
           end-perform
           call "C$LIST-ENVIRONMENT" using listenv-close, hEnv
           .

       SET-VAR-JAVA.
           inquire ef-var-java value varname
           inquire ef-val-java value varvalue

           evaluate true
           when client-execution
                call client "C$SETENV" using varname, 
                                             varvalue
                                             1
           when standalone-execution
           when server-execution
                call "C$SETENV" using varname, 
                                      varvalue
                                      1
           end-evaluate

           perform JAVA-ENV-CONTENT
           .

       JAVA-ENV-CONTENT.
           modify gd-java mass-update 1
           modify gd-java reset-grid 2

           set props-set to JSystem:>getProperties()
                                   :>stringPropertyNames().
           set i to props-set:>iterator().
           perform until exit
              if i:>hasNext()
                 set varname to i:>next()
                 perform RETRIEVE-JAVA-VAR
              else
                 exit perform
              end-if
           end-perform.

           modify gd-java mass-update 0
           .

       RETRIEVE-JAVA-VAR.
           evaluate true
           when client-execution
                call client "C$GETENV" using varname
                                             varvalue
           when standalone-execution
           when server-execution
                call "C$GETENV" using varname
                                      varvalue
           end-evaluate.

           modify gd-java record-to-add env-var
           .

       REMOVE-VAR.
           inquire gd-cobol cursor-y idx
           inquire gd-cobol(idx, 1) cell-data varname
           evaluate true
           when client-execution
                call client "C$UNSET" using varname
           when standalone-execution
           when server-execution
                call "C$UNSET" using varname
           end-evaluate
           perform ENV-CONTENT
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
