      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. WINPRINTER.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select print-job assign to printer spooler-name
           organization line sequential.

       FILE SECTION.
       FD  print-job.
       01  print-record            pic x(80).

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "iscrt.def".
       copy "isopensave.def".
       copy "isprint.def".
       copy "iscobol.def".   
       copy "isresize.def".
       copy "isfonts.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  hBmp                    pic s9(9) comp-4.
       77  spooler-name            pic x(128).
       77  printer-num             pic 9(3).
       77  num-of-printers         pic 9(3).
       77  winprint-status         pic s99.
       77  e-printers              pic 9.

       77  arial-12                handle of font.
       77  Calibri-12              handle of font.
       77  Courier-New-12          handle of font.
       77  times-new-roman-12      handle of font.
       77  wrk-font                handle of font.

       77  wrk-x                   pic 9(7)v99.
       77  wrk-y                   pic 9(7)v99.

       01  print-row.
           05 pr-font-name         pic x(20).
           05 pr-text              pic x(100).

       77  w-jobs                  pic 99.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              size                 10 cells
              title                "Printers:"
              .
           03 CB-PRINTERS
              combo-box
              line                 4
              col                  2
              size                 30 cells
              enabled              e-printers
              .
           03 push-button
              line                 7
              col                  2
              title                "&Print"
              exception-value      101
              enabled              e-printers
              .
           03 push-button
              line                  7
              col                   + 2
              title                 "Pre&view"
              exception-value       102
              .
           03 push-button
              line                 7
              col                  + 2
              title                "PD&F"
              exception-value      103
              .
           03 push-button
              line                 9
              col                  2
              title                "Number of print jobs running"
              size                 29
              exception-value      104
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       main. 
       
           perform GET-NUM-OF-PRINTERS.
       
           call "w$bitmap" using wbitmap-load, "files/img.png" 
                          giving hBmp

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "WIN$PRINTER Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           if num-of-printers > 0
              perform GET-PRINTERS-NAMES
           end-if

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception
                    continue 
              end-accept
              evaluate crt-status
              when 101  
                   perform NORMAL-PRINT
              when 102  
                   perform PRINT-PREVIEW 
              when 103  
                   perform PRINT-PDF  
              when 104
                   perform GET-NO-JOBS
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           call "w$bitmap" using wbitmap-destroy, hBmp
           GOBACK
           .

       PRINT-PREVIEW.
           move "-P PREVIEW" to spooler-name
           perform PRINT-PROCEDURE
           .

       PRINT-PDF.
           initialize opensave-data, spooler-name.
           call client "C$GETENV" USING "user.home"
                                         opnsav-default-dir

           move "PDF Files (*.pdf)|*.pdf" to opnsav-filters
           move "pdf"                     to opnsav-default-ext
           call "C$OPENSAVEBOX" using opensave-save-box
                                      opensave-data
           if return-code < 0
              exit paragraph
           end-if

           string "-P PDF "       delimited by size
                  opnsav-filename delimited by trailing spaces
                                  into spooler-name

           perform PRINT-PROCEDURE
           .

       NORMAL-PRINT.
           move "-P SPOOLER" to spooler-name

           initialize winprint-selection
           inquire CB-PRINTERS value winprint-name
           call "win$printer" using winprint-set-printer
                                    winprint-selection

           perform PRINT-PROCEDURE
           .

       GET-NO-JOBS.
           initialize w-jobs
           call "win$printer" using WINPRINT-GET-NO-ASYNC-JOBS,
                                    w-jobs
                             giving winprint-status
           if winprint-status > 0
              if w-jobs = 0
                 display message "There are no async print jobs running"
              else
                 display message "There are " 
                                 w-jobs
                                 " print jobs running" 
              end-if
           else
              display message "err on op-code"
           end-if
           .
          
       GET-NUM-OF-PRINTERS.
           call "WIN$PRINTER" using WINPRINT-GET-NO-PRINTERS
                                    WINPRINT-SELECTION
                             giving winprint-status

           move winprint-no-of-printers  to num-of-printers

           if num-of-printers = zero
              move 0   to e-printers
           else
              move 1   to e-printers
           end-if.

       GET-PRINTERS-NAMES. 
           modify CB-PRINTERS reset-list 1

           perform varying printer-num from 1 by 1 
                       until winprint-no-of-printers > num-of-printers
              initialize winprint-selection
              move printer-num to winprint-no-of-printers
              call "win$printer" using winprint-get-printer-info
                                       winprint-selection
                                giving winprint-status
              if winprint-status < 1
                 exit perform
              end-if   
              modify CB-PRINTERS item-to-add winprint-name 
              if wprt-is-default
                  modify CB-PRINTERS value winprint-name
              end-if
           end-perform
           .

       PRINT-PROCEDURE.
           perform LOAD-FONTS.
           open output print-job
      *print of bitmap pictures
           initialize wprtdata-print-bitmap
           move hBmp                           to wprtdata-bitmap
           move 2                              to wprtdata-bitmap-row
           move 2                              to wprtdata-bitmap-col
           move 2.5                            to wprtdata-bitmap-height
           move 6                              to wprtdata-bitmap-width 
           move wprtbitmap-scale-centimeters   to wprtdata-bitmap-flags
           add  wprtbitmap-units-centimeters   to wprtdata-bitmap-flags
           call "win$printer" using winprint-print-bitmap
                                     winprint-data
      *print of graphical shapes (how to create a table)
           initialize wprtdata-draw
           move 2                              to wprtdata-draw-start-x
           move 5.85                           to wprtdata-draw-start-y
           move 18                             to wprtdata-draw-stop-x
           move 10.25                          to wprtdata-draw-stop-y
           move wprtunits-centimeters          to wprtdata-draw-units
           move wprt-draw-round-rectangle      to wprtdata-draw-shape
           call "win$printer" using winprint-graph-draw
                                    winprint-data   

           initialize wprtdata-draw
           move 6.0                            to wprtdata-draw-start-x
           move 5.85                           to wprtdata-draw-start-y
           move 6.0                            to wprtdata-draw-stop-x
           move 10.25                          to wprtdata-draw-stop-y
           move wprtunits-centimeters          to wprtdata-draw-units
           move wprt-draw-line                 to wprtdata-draw-shape
           call "win$printer" using winprint-graph-draw
                                    winprint-data

           initialize wprtdata-draw
           move 2                              to wprtdata-draw-start-x
           move 7.0                            to wprtdata-draw-start-y
           move 18                             to wprtdata-draw-stop-x
           move 7.0                            to wprtdata-draw-stop-y
           move wprtunits-centimeters          to wprtdata-draw-units
           move wprt-draw-line                 to wprtdata-draw-shape
           call "win$printer" using winprint-graph-draw
                                    winprint-data 

           initialize wprtdata-draw
           move 2                              to wprtdata-draw-start-x
           move 8.15                           to wprtdata-draw-start-y
           move 18                             to wprtdata-draw-stop-x
           move 8.15                           to wprtdata-draw-stop-y
           move wprtunits-centimeters          to wprtdata-draw-units
           move wprt-draw-line                 to wprtdata-draw-shape
           call "win$printer" using winprint-graph-draw
                                    winprint-data 

           initialize wprtdata-draw
           move 2                              to wprtdata-draw-start-x
           move 9.2                            to wprtdata-draw-start-y
           move 18                             to wprtdata-draw-stop-x
           move 9.2                            to wprtdata-draw-stop-y
           move wprtunits-centimeters          to wprtdata-draw-units
           move wprt-draw-line                 to wprtdata-draw-shape
           call "win$printer" using winprint-graph-draw
                                    winprint-data 

      *Set the cursor position for the string
           move 3.1                            to wrk-x
           move 1.35                           to wrk-y
           perform SET-CURSOR-POSITION

      *set the color of strings (RGB = 96,106,232)
           initialize wprtdata-text-color.   
           compute wprtdata-text-color =  96  +
                                         (106 * 256)  +
                                         (232 * 65536)
           call "win$printer" using winprint-set-text-color   
                                    wprtdata-text-color  

      *Print the string
           write print-record from "Veryant, LLC" with no control

           initialize wprtdata-text-color.   
           compute wprtdata-text-color =  0
           call "win$printer" using winprint-set-text-color   
                                    wprtdata-text-color  

           move 3.0                               to wrk-x
           move 2.45                              to wrk-y
           perform SET-CURSOR-POSITION

           move "FONT NAME"                       to pr-font-name
           move "SAMPLE TEXT"                     to pr-text
      
           initialize winprint-column.
           call "WIN$PRINTER" using winprint-set-data-columns,
                                    record-position of pr-font-name
                                    record-position of pr-text.

           move calibri-12                        to wrk-font
           perform SET-COLUMN

           write print-record from print-row with no control.

           perform RESET-COLUMN.

      *
           compute wprtdata-text-color =  255  +
                                         (0 * 256)  +
                                         (0 * 65536)
           call "win$printer" using winprint-set-text-color   
                                    wprtdata-text-color  
           move arial-12  to wrk-font
           perform SET-COLUMN
           move "Arial"  to pr-font-name
           move "This is red Arial text" to pr-text
      
           write print-record from print-row after 2 lines.
           perform RESET-COLUMN.

           compute wprtdata-text-color =  0  +
                                         (127 * 256)  +
                                         (127 * 65536)
           call "win$printer" using winprint-set-text-color   
                                    wprtdata-text-color  
      
           move Courier-New-12                       to wrk-font
           perform SET-COLUMN
           move "Courier New"                        to pr-font-name
           move "This is Dark cyan Courier New text" to pr-text
      
           write print-record from print-row after 2 lines.
           perform RESET-COLUMN.
      *
           compute wprtdata-text-color =  127  +
                                         (127 * 256)  +
                                         (0 * 65536)
           call "win$printer" using winprint-set-text-color   
                                    wprtdata-text-color  
      *
           move times-new-roman-12                   to wrk-font
           perform SET-COLUMN
           move "Times New Roman"                    to pr-font-name
           move "This is brown Times New Roman text" to pr-text
      
           write print-record from print-row after 2 lines.

           close print-job

           perform DESTROY-FONTS.
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       LOAD-FONTS.
           initialize wfont-data.
           set wfdevice-win-printer   to true.
           move "Arial"               to wfont-name.
           move 12 to wfont-size.
           call "W$FONT" using wfont-get-font,
                               arial-12, 
                               wfont-data
                        giving winprint-status.

           initialize wfont-data.
           set wfdevice-win-printer   to true.
           move "Calibri"             to wfont-name.
           move 12                    to wfont-size.
           call "W$FONT" using wfont-get-font,
                               calibri-12,
                               wfont-data
                        giving winprint-status.

           initialize wfont-data.
           set wfdevice-win-printer   to true.
           move "Courier New"         to wfont-name.
           move 12                    to wfont-size.
           call "W$FONT" using wfont-get-font,
                               Courier-New-12,
                               wfont-data
                        giving winprint-status.

           initialize wfont-data.
           set wfdevice-win-printer   to true.
           move "Times New Roman"     to wfont-name.
           move 12                    to wfont-size.
           call "W$FONT" using wfont-get-font,
                               times-new-roman-12,
                               wfont-data
                        giving winprint-status.

       DESTROY-FONTS.
           destroy arial-12.
           destroy calibri-12.
           destroy Courier-New-12.
           destroy times-new-roman-12.
       
       SET-CURSOR-POSITION.
           initialize wprtdata-draw.
           move wrk-x to wprtdata-draw-start-x.
           move wrk-y to wprtdata-draw-start-y.
           move wprtunits-inches to wprtdata-draw-units.
           call "WIN$PRINTER" using winprint-set-cursor
                                    winprint-data
                             giving winprint-status.

       RESET-COLUMN.
           call "WIN$PRINTER" using winprint-clear-page-columns,
                             giving winprint-status.

       SET-COLUMN.
           initialize winprint-column
           move wprtunits-inches   to winprint-col-units.
           move 0.8                to winprint-col-start.
           move 0.070              to winprint-col-indent.
           move wrk-font           to winprint-col-font. 
           move wprtalign-left     to winprint-col-alignment.
           call "WIN$PRINTER" using winprint-set-page-column,
                                    winprint-column,
                             giving winprint-status.

           move 2.4                to winprint-col-start.
           call "WIN$PRINTER" using winprint-set-page-column,
                                    winprint-column,
                             giving winprint-status.