      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.  WMOUSE.

       WORKING-STORAGE SECTION.
       COPY "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  text-string             pic x(20).
       77  h-font                  handle of font. 
       77  h-thread                handle of thread.

       77  cursor-handle           handle of bitmap.
       78  msg-thclose             value "C".
       77  th-message              pic x.

       SCREEN SECTION.
       01  Mask.
           05 frame
              engraved
              line                 2
              lines                15
              size                 26
              col                  3
              title                "Change mouse pointer to..."
              .
           05 push-button 
              line                 4
              col                  8
              size                 15
              title                "F1: wait shape "
              exception-value     1
              .
           05 push-button 
              line                 6 
              col                  8
              size                 15
              title                "F2: bar shape"  
              exception-value     2
              .
           05 push-button 
              line                 8 
              col                  8
              size                 15
              title                "F3: cross shape"  
              exception-value     3
              .
           05 push-button 
              line                 10 
              col                  8
              size                 15
              title                "F4: help shape"  
              exception-value     4
              .
           05 push-button 
              line                 12 
              col                  8
              size                 15
              title                "F5: arrow shape"  
              exception-value     5
              .
           05 push-button 
              line                 14 
              col                  8
              size                 15
              title                "F6: custom shape"  
              exception-value      6
              .
           05 frame
              engraved
              line                 2
              lines                7
              size                 26
              col                  40
              title                "Mouse position"
              .
           05 label 
              line                 4
              col                  45
              title                "row: "
              .
           05 lbl-row
              label 
              line                 4
              col                  50
              title                mouse-row
              .
           05 label 
              line                 6
              col                  45
              title                "col: "
              .      
           05 lbl-col
              label 
              line                 6
              col                  50
              title                mouse-col
              .
           03 Pb-exit  
              push-button
              line                20
              col                 62 
              size                8 cells
              title               "Exit" 
              exception-value     27
              .

       PROCEDURE DIVISION.
       INI.
           call "W$BITMAP" using wbitmap-load "files/cursor.png"
                       returning cursor-handle
           
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$MOUSE Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask
           
           perform thread MOUSE-POSITION handle h-thread

           perform until crt-status = 27 or close-win = 1
              accept mask
                 on exception 
                    continue 
              end-accept
              evaluate crt-status
              when 1 
                   perform CHANGE-SHAPE-WAIT
              when 2 
                   perform CHANGE-SHAPE-BAR
              when 3 
                   perform CHANGE-SHAPE-CROSS
              when 4 
                   perform CHANGE-SHAPE-HELP
              when 5 
                   perform RESTORE-ARROW-SHAPE
              when 6
                   perform CHANGE-SHAPE-CUSTOM
              end-evaluate
              move 4   to accept-control
           end-perform

           perform RESTORE-ARROW-SHAPE
           destroy Mask
           destroy hWin
           destroy control-font
           call "W$BITMAP" using wbitmap-destroy, cursor-handle

           send msg-thclose to h-thread
           wait for h-thread
           move 0 to h-thread
           goback
           .

       CHANGE-SHAPE-WAIT.
           call "W$MOUSE" using set-mouse-shape, wait-pointer
           .

       CHANGE-SHAPE-BAR.
           call "W$MOUSE" using set-mouse-shape, bar-pointer
           .

       CHANGE-SHAPE-CROSS.
           call "W$MOUSE" using set-mouse-shape, cross-pointer
           .

       CHANGE-SHAPE-HELP.
           call "W$MOUSE" using set-mouse-shape, help-pointer
           .

       RESTORE-ARROW-SHAPE.  
           call "W$MOUSE" using set-mouse-shape, arrow-pointer
           .

       CHANGE-SHAPE-CUSTOM.
           call "W$MOUSE" using set-mouse-shape, custom-pointer,
                                                 cursor-handle,
                                                 10, 10
           .

       MOUSE-POSITION.
           perform until exit
              receive th-message from last thread before time 10 
                 not on exception
                    evaluate th-message
                    when msg-thclose
                      exit perform
                    end-evaluate
              end-receive
              call "W$MOUSE" using get-mouse-status
                                   mouse-info
              modify lbl-row title mouse-row
              modify lbl-col title mouse-col
           end-perform.

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
