      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. State.

       WORKING-STORAGE SECTION.
       copy "constants.def".
       copy "state.wrk".
       copy "isfonts.def".
       copy "isgui.def".
       copy "iscrt.def".
       copy "image-handling.wrk".

       77  key-status is special-names crt status pic 999.
       77  h-main               handle of window.
       77  w-key                pic 9(5).
       77  sub-state            pic x(10).
       77  varx3                pic xxx.

       01                       pic 9.
           88 check-ok          value 0 false 1.
       77  err-message          pic x any length.
       77  err-icon             pic 9.
       77  err-code             pic 99.

       77  key-pressed          pic x.
       77  h-status             handle of status-bar.
       77  htoolbar             handle of window.

       78  78-id-state-code     value 1.
       78  78-id-name           value 2.

       SCREEN SECTION.
       01  s1.
           03 frame
              line                          2
              col                           2
              size                          111
              lines                         8
              engraved
              title                         "State"
              . 
           03 label
              size                          10
              line                          4 
              col                           3
              title                         "State code:"
              . 
           03 entry-field
              line                          4 
              col                           19
              size                          5
              value                         state-code
              id                            78-id-state-code
              .
           03 label
              size                          10
              line                          6
              col                           3
              title                         "Name:"
              . 
           03 entry-field
              line                          6
              col                           19
              size                          91
              value                         state-description
              id                            78-id-name
              .

       01  s-func.
           03 push-button
              col                           2
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-lookup
              bitmap-width                  78-tb-bmp-width
              title-position                2
              exception-value               1
              self-act
              hint                          "F1"
              title                         "Lookup"
              css-icon                      "fa-list"
              .
           03 push-button
              col                           14.4
              exception-value               5
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-first
              bitmap-width                  78-tb-bmp-width
              title-position                2
              self-act
              hint                          "F5"
              title                         "First"
              css-icon                      "fa-angle-double-left"
              .
           03 push-button
              col                           26.4
              exception-value               6
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-prev
              bitmap-width                  78-tb-bmp-width
              title-position                2
              self-act
              hint                          "F6"
              title                         "Prev"
              css-icon                      "fa-angle-left"
              .
           03 push-button
              col                           38.6
              exception-value               7
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-next
              bitmap-width                  78-tb-bmp-width
              title-position                2
              self-act
              hint                          "F7"
              title                         "Next"
              css-icon                      "fa-angle-right"
              .
           03 push-button
              col                           50.8
              exception-value               8
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-last
              bitmap-width                  78-tb-bmp-width
              title-position                2
              self-act
              hint                          "F8"
              title                         "Last"
              css-icon                      "fa-angle-double-right"
              .
           03 bar
              col                           63.1 |74.3
              lines                         2 
              width                         2
              size                          1
              color                         16
              shading                       (-1, 1)
              .
           03 push-button
              col                           63.5|74.5
              exception-value               9
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-save
              bitmap-width                  78-tb-bmp-width
              title-position                2
              self-act
              hint                          "F9"
              title                         "Save"
              css-icon                      "fa-save"
              .
           03 push-button
              col                           75.7|86.7
              exception-value               3
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-delete
              bitmap-width                  78-tb-bmp-width
              title-position                2
              self-act
              hint                          "F3"
              title                         "Delete"
              css-icon                      "fa-trash"
              .
           03 bar
              col                           88.1
              lines                         2 
              width                         2
              size                          1
              color                         16
              shading                       (-1, 1)
              .
           03 push-button
              col                           88.5
              exception-value               27
              lines                         2.2 cells 
              size                          12 cells
              bitmap-handle                 h-tools
              bitmap-number                 78-nb-exit
              bitmap-width                  78-tb-bmp-width
              title-position                2
              self-act
              hint                          "Esc"
              title                         "Exit"
              css-icon                      "fa-times"
              .

       PROCEDURE DIVISION.
       MAIN.

           call "PSTATE"    using 78-open-i-o

           display independent graphical window
                   background-low  
                   system menu
                   title "STATE MAINTENANCE"
                   size 113
                   lines 30
                   control font small-font
                   visible 0
                   handle h-main
                   event  WIN-EVT
                   .

           display s1.

           display tool-bar lines 2.5 control font small-font 
                   handle htoolbar upon h-main
           display s-func upon htoolbar.

           call "W$CENTER_WINDOW" using h-main

           modify h-main visible 1

           perform until key-status = 27
              accept s1 
                 on exception 
                    continue 
              end-accept
              evaluate key-status
              when 1
                   perform LOOKUP
              when 2
                   continue
              when 3
                   perform REC-DELETE
              when 5
                   perform REC-FIRST
              when 6
                   perform REC-PREV
              when 7
                   perform REC-NEXT
              when 8
                   perform REC-LAST
              when 9
                   perform REC-SAVE
              end-evaluate
              move 4   to accept-control
           end-perform.
           call "PSTATE"    using 78-close

           destroy h-main
           goback.
       
       SHOW-RECORD.
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              display s1
           end-if.

       REC-FIRST.
           move low-value to w-key(1:)
           call "PSTATE" using 78-start-great, w-key
           call "PSTATE" using 78-read-next, state-rec
           perform SHOW-RECORD
           .

       REC-PREV.  
           call "PSTATE" using 78-read-prev, state-rec
           perform SHOW-RECORD
           .

       REC-NEXT.  
           call "PSTATE" using 78-read-next, state-rec
           perform SHOW-RECORD
           .

       REC-LAST.  
           move high-value to w-key
           call "PSTATE" using 78-start-less, w-key
           call "PSTATE" using 78-read-next, state-rec
           perform SHOW-RECORD
           .

       REC-DELETE.
           display message 
                 "ARE YOU SURE YOU WANT TO DELETE THIS RECORD?"
                 type mb-yes-no
                 default mb-no 
                 icon mb-warning-icon 
                 giving varx3
           if varx3 = mb-yes 
              call "PSTATE" using 78-delete, state-code
              if return-code > 9
                 perform SHOW-FILE-ERROR
              else
                 initialize state-rec
                 display s1
              end-if
           end-if.

       REC-SAVE.
           perform CHECK-FIELDS.

           if check-ok
              call "PSTATE" using 78-write, state-rec
              if return-code = 22
                 call "PSTATE" using 78-rewrite, state-rec
                 if return-code > 9
                    perform SHOW-FILE-ERROR
                 end-if
              end-if
           end-if
           .

       CHECK-FIELDS.
           set check-ok   to true.

           if state-Code = space
              move "STATE CODE MANDATORY"  to err-message
              perform SHOW-ERROR
              move 78-id-state-code to control-id
              set check-ok   to false
           end-if

           if check-ok and State-Description = space
              move "STATE DESCRIPTION MANDATORY"    to err-message
              perform SHOW-ERROR
              move 78-id-name   to control-id
              set check-ok   to false
           end-if
           .

       SHOW-FILE-ERROR.
           initialize err-message
           
           if return-code = 10
              move "NO MORE RECORDS"  to err-message
              move mb-warning-icon    to err-icon
           else
              move return-code        to err-code 
              move err-code           to err-message
              move mb-error-icon      to err-icon
           end-if
           
           display message box err-message
                   title "ERROR: "
                   icon err-icon 
           .

       SHOW-ERROR.
           display message box err-message
                   title "ERROR: "
                   icon mb-error-icon 
           .

       LOOKUP.
           call "LOOKUP-STATE" using state-rec
           display s1
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 27 to key-status
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 27 to key-status
           end-evaluate
           .
