      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. Progress.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select file1 assign to "file1"
           organization line sequential.

       FILE SECTION.
       FD file1.
       01 rec-file1 pic x(100).

       WORKING-STORAGE SECTION.
       copy "isgui.def". 
       01  crt-status           is special-names crt status pic 999.
           88 k-esc                value 27. 
           88 k-go                 value 101.
       01  hWin                    handle of window.
       01  hMain                   handle of thread.
       01  hProg                   handle of thread.
       01  msg-string              pic x(1).
       78  stop-msg                value "X".
       01  receive-status          pic 99.
      
       77  w-from                  pic 9(3) value 0.
       77  w-to                    pic 9(3) value 100.
       77  i                       pic 9(3) value 0.

       77  percent                 pic 999v99.
       77  perc-disp               pic zz9.99.

       SCREEN SECTION.
       01  Scr1.
           03 label        line            2
                           col             2
                           title           "From: "
                           .
           03 efFrom           
              entry-field  line            4
                           col             2
                           size            10      cells
                           numeric          
                           max-text        3 
                           value           w-from
                           .      
           03 label        line            2
                           col             15
                           title           "To: "
                           .
           03 efTo           
              entry-field  line            4
                           col             15
                           size            10      cells
                           numeric
                           max-text        3
                           value           w-to
                           .
           03 push-button  line            6
                           col             2
                           title           "&Go"
                           exception-value 101
                           .
           03 frProgress
              frame        line            8
                           col             2
                           lines           1.5
                           size            15
                           fill-color      2
                           fill-percent    0
                           .
           03 lbCont 
              label        line            6
                           col             17
                           title           i
                           .
           03 lbPerc
              label        line            8
                           col             17
                           title           perc-disp
                           .
           03 label        line            8
                           col             22
                           title           "%"
                           .

       PROCEDURE DIVISION.
       MAIN-LOGIC.
           accept hMain from thread

           display standard window background-low
                   lines 10, size 30
                   handle hWin

           display Scr1
                  
           perform until k-esc
             accept Scr1 on exception continue end-accept
             if k-go 
                if w-from > w-to
                   display message "invalid range!" icon mb-warning-icon
                else
                   perform ELABORATION
                end-if
             end-if
           end-perform
                             
           destroy Scr1
           destroy hWin
           goback
           .

       ELABORATION.
           perform thread SHOW-PROGRESS handle hProg

           move 0 to i
           perform varying i from w-from by 1 until i = w-to
              open output file1
              perform 1000 times
                 write rec-file1 from all "a"
              end-perform
              close file1
           end-perform

           send stop-msg to hProg
           wait for hProg
           move 0 to hProg
           .

       SHOW-PROGRESS.
           perform until 1 = 2 
              compute percent = (i - w-from) * 100 / (w-to - w-from)
              modify  frProgress fill-percent percent 
              move percent to perc-disp
              display lbCont, lbPerc

              receive msg-string from hMain
                 before time 100
                 not on exception  
                    if msg-string = stop-msg
                       exit perform
                    end-if
              end-receive
           end-perform

           move 100 to percent perc-disp
           modify frProgress fill-percent percent
           display lbCont, lbPerc
           .

