/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.jdbc;

import com.veryant.jdbc.PicoBoundParam;
import com.veryant.jdbc.PicoConnection;
import com.veryant.jdbc.PicoDbApi;
import com.veryant.jdbc.PicoStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;

public class PicoPreparedStatement
extends PicoStatement
implements PreparedStatement {
    Vector boundParams = new Vector();

    public PicoPreparedStatement(PicoConnection con, PicoDbApi api) throws SQLException {
        super(con, api);
    }

    public void addBatch() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoPreparedStatement.addBatch()");
        }
        throw new UnsupportedOperationException();
    }

    public void clearParameters() throws SQLException {
        this.boundParams.removeAllElements();
    }

    public synchronized void close() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.close hStmt =" + this.hStmt);
        }
        if (!this.myConnection.isClosed()) {
            this.clearMyResultSet();
            try {
                this.clearWarnings();
                if (!this.hStmt.isDropped()) {
                    this.hStmt.drop();
                    this.clearParameters();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.myConnection.deregisterStatement(this);
    }

    public synchronized boolean execute() throws SQLException {
        boolean Return = false;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PreparedStatement.execute");
        }
        this.clearWarnings();
        this.reset();
        try {
            this.odbcApi.SQLExecuteParams(this.hStmt, this.boundParams);
        }
        catch (SQLWarning sqlwarning) {
            this.setWarning(sqlwarning);
        }
        int nCol = -1;
        nCol = this.getColumnCount();
        if (nCol > 0) {
            Return = true;
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PreparedStatement.execute nCol=" + nCol);
        }
        return Return;
    }

    public ResultSet executeQuery() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PreparedStatement.executeQuery");
        }
        ResultSet Return = null;
        if (!this.execute()) {
            throw new SQLException("No ResultSet was produced");
        }
        Return = this.getResultSet(false);
        return Return;
    }

    public ResultSet executeQuery(String s) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PreparedStatement.executeQuery (" + s + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public int executeUpdate() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PreparedStatement.executeUpdate");
        }
        int i = -1;
        if (this.execute()) {
            throw new SQLException("No row count was produced");
        }
        i = this.myGetUpdateCount();
        return i;
    }

    public int executeUpdate(String s) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PreparedStatement.executeUpdate (" + s + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet rsmd = this.executeQuery();
        ResultSetMetaData Return = rsmd.getMetaData();
        rsmd.close();
        return Return;
    }

    public static int getTypeFromObject(Object obj) {
        int Return = obj == null ? 0 : (obj instanceof String ? 12 : (obj instanceof BigDecimal ? 2 : (obj instanceof Boolean ? -7 : (obj instanceof Byte ? -6 : (obj instanceof Short ? 5 : (obj instanceof Integer ? 4 : (obj instanceof Long ? -5 : (obj instanceof Float ? 7 : (obj instanceof Double ? 8 : (obj instanceof byte[] ? -4 : (obj instanceof Date ? 91 : (obj instanceof Time ? 92 : (obj instanceof Timestamp ? 93 : 9999)))))))))))));
        return Return;
    }

    public void setObject(int paramIndex, Object obj) throws SQLException {
        this.setObject(paramIndex, obj, PicoPreparedStatement.getTypeFromObject(obj));
    }

    public void setObject(int paramIndex, Object obj, int type) throws SQLException {
        this.setObject(paramIndex, obj, type, 0);
    }

    public void setObject(int paramIndex, Object obj, int type, Calendar cal) throws SQLException {
        this.setObject(paramIndex, obj, type, 0, cal);
    }

    public void setObject(int paramIndex, Object obj, int type, int scale) throws SQLException {
        this.setObject(paramIndex, obj, type, scale, null);
    }

    public void setObject(int paramIndex, Object obj, int type, int scale, Calendar cal) throws SQLException {
        switch (type) {
            case 0: {
                break;
            }
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                break;
            }
            default: {
                throw new SQLException("Unknown SQL Type for PreparedStatement.setObject (SQL Type=" + type + ")");
            }
        }
        if (paramIndex + 1 > this.boundParams.size()) {
            this.boundParams.setSize(paramIndex + 1);
        }
        this.boundParams.set(paramIndex, new PicoBoundParam(1, (short)type, scale, obj, cal));
    }

    public void setArray(int paramIndex, Array array) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoPreparedStatement.setArray(int paramIndex, Array array)");
        }
        throw new UnsupportedOperationException();
    }

    public void setAsciiStream(int paramIndex, InputStream is, int len) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoPreparedStatement.setAsciiStream(int paramIndex, InputStream is, int len)");
        }
        throw new UnsupportedOperationException();
    }

    public void setBigDecimal(int paramIndex, BigDecimal num) throws SQLException {
        this.setObject(paramIndex, (Object)num, 2, num.scale());
    }

    public void setBinaryStream(int paramIndex, InputStream inputstream, int j) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoPreparedStatement.setBinaryStream(int paramIndex, InputStream inputstream, int j)");
        }
        throw new UnsupportedOperationException();
    }

    public void setBlob(int paramIndex, Blob blob) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoPreparedStatement.setBlob(int paramIndex, Blob blob)");
        }
        throw new UnsupportedOperationException();
    }

    public void setBoolean(int paramIndex, boolean val) throws SQLException {
        Boolean obj = new Boolean(val);
        this.setObject(paramIndex, (Object)obj, -7, 0);
    }

    public void setByte(int paramIndex, byte byte0) throws SQLException {
        Byte obj = new Byte(byte0);
        this.setObject(paramIndex, (Object)obj, -6, 0);
    }

    public void setBytes(int paramIndex, byte[] abyte0) throws SQLException {
        this.setObject(paramIndex, (Object)abyte0, -6, 0);
    }

    public void setCharacterStream(int paramIndex, Reader reader, int j) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoPreparedStatement.setCharacterStream(int paramIndex, Reader reader, int j)");
        }
        throw new UnsupportedOperationException();
    }

    public void setClob(int paramIndex, Clob clob) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoPreparedStatement.setClob(int paramIndex, Clob clob)");
        }
        throw new UnsupportedOperationException();
    }

    public void setDate(int paramIndex, Date obj) throws SQLException {
        this.setObject(paramIndex, (Object)obj, 91, 0);
    }

    public void setDate(int paramIndex, Date obj, Calendar cal) throws SQLException {
        this.setObject(paramIndex, obj, 91, 0, cal);
    }

    public void setDecimal(int paramIndex, BigDecimal obj) throws SQLException {
        this.setObject(paramIndex, (Object)obj, 2, obj.scale());
    }

    public void setDouble(int paramIndex, double val) throws SQLException {
        Double obj = new Double(val);
        this.setObject(paramIndex, (Object)obj, 8, 0);
    }

    public void setFloat(int paramIndex, float val) throws SQLException {
        Float obj = new Float(val);
        this.setObject(paramIndex, (Object)obj, 7, 0);
    }

    public void setReal(int paramIndex, float val) throws SQLException {
        Float obj = new Float(val);
        this.setObject(paramIndex, (Object)obj, 7, 0);
    }

    public void setInt(int paramIndex, int val) throws SQLException {
        Integer obj = new Integer(val);
        this.setObject(paramIndex, (Object)obj, 4, 0);
    }

    public void setLong(int paramIndex, long val) throws SQLException {
        Integer obj = new Integer((int)val);
        this.setObject(paramIndex, (Object)obj, 4, 0);
    }

    public void setNull(int paramIndex, int type) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PreparedStatement.setNull (" + paramIndex + "," + type + ")");
        }
        this.setObject(paramIndex, null, type, 0);
    }

    public void setNull(int paramIndex, int type, String s) throws SQLException {
        this.setObject(paramIndex, null, type, 0);
    }

    public void setRef(int paramIndex, Ref ref) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoPreparedStatement.setRef(int paramIndex, Ref ref)");
        }
        throw new UnsupportedOperationException();
    }

    public void setShort(int paramIndex, short val) throws SQLException {
        Integer obj = new Integer(val);
        this.setObject(paramIndex, (Object)obj, 5, 0);
    }

    public void setString(int paramIndex, String obj) throws SQLException {
        this.setObject(paramIndex, (Object)obj, 1, 0);
    }

    public void setTime(int paramIndex, Time time) throws SQLException {
        this.setObject(paramIndex, (Object)time, 92, 0);
    }

    public void setTime(int paramIndex, Time time, Calendar cal) throws SQLException {
        this.setObject(paramIndex, time, 92, 0, cal);
    }

    public void setTimestamp(int paramIndex, Timestamp ts) throws SQLException {
        this.setObject(paramIndex, (Object)ts, 93, 0);
    }

    public void setTimestamp(int paramIndex, Timestamp ts, Calendar cal) throws SQLException {
        this.setObject(paramIndex, ts, 93, 0, cal);
    }

    public void setUnicodeStream(int paramIndex, InputStream inputstream, int j) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoPreparedStatement.");
        }
        throw new UnsupportedOperationException();
    }

    public void setURL(int paramIndex, URL obj) throws SQLException {
        String o = obj.toString();
        this.setObject(paramIndex, (Object)o, PicoPreparedStatement.getTypeFromObject(o));
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoPreparedStatement.ParameterMetaData getParameterMetaData ()");
        }
        throw new UnsupportedOperationException();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        ResultSet Return = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PreparedStatement.getGeneratedKeys");
        }
        this.clearWarnings();
        try {
            this.odbcApi.SQLExecDirect(this.hStmt, "SELECT SERIAL");
            Return = this.getResultSet(false);
        }
        catch (SQLWarning sqlwarning) {
            this.setWarning(sqlwarning);
        }
        return Return;
    }
}

