/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.jdbc;

import com.veryant.jdbc.PicoDbApi;
import com.veryant.jdbc.PicoPseudoCol;
import com.veryant.jdbc.PicoResultSet;
import com.veryant.jdbc.PicoSQLWarning;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;

public class PicoResultSetMetaData
implements ResultSetMetaData {
    protected PicoDbApi odbcApi;
    protected PicoResultSet resultSet;
    private Hashtable columnNameMap;

    public PicoResultSetMetaData(PicoDbApi api, PicoResultSet rs) {
        this.odbcApi = api;
        this.resultSet = rs;
        this.columnNameMap = new Hashtable();
        this.columnNameMap.put("TABLE_QUALIFIER", "TABLE_CAT");
        this.columnNameMap.put("TABLE_OWNER", "TABLE_SCHEM");
        this.columnNameMap.put("PRECISION", "COLUMN_SIZE");
        this.columnNameMap.put("LENGTH", "BUFFER_LENGTH");
        this.columnNameMap.put("SCALE", "DECIMAL_DIGITS");
        this.columnNameMap.put("RADIX", "NUM_PREC_RADIX");
    }

    public String getCatalogName(int i) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getCatalogName (" + i + ")");
        }
        if (this.resultSet.getPseudoCol(i = this.resultSet.mapColumn(i)) != null) {
            i = 1;
        }
        return this.getColAttributeString(i, 17);
    }

    protected int getColAttribute(int i, int j) throws SQLException {
        return this.resultSet.getColAttribute(i, (short)j);
    }

    protected boolean getColAttributeBoolean(int i, int j) throws SQLException {
        int k = this.getColAttribute(i, j);
        boolean flag = false;
        if (k == 1) {
            flag = true;
        }
        return flag;
    }

    protected String getColAttributeString(int i, int j) throws SQLException {
        String s = "";
        this.resultSet.clearWarnings();
        try {
            s = this.odbcApi.SQLColAttributesString(this.resultSet.getHSTMT(), i, (short)j);
        }
        catch (PicoSQLWarning jdbcodbcsqlwarning) {
            s = (String)jdbcodbcsqlwarning.value;
            this.resultSet.setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
        }
        return s.trim();
    }

    public String getColumnClassName(int col) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoResultSetMetaData.getColumnClassName(int col)");
        }
        String Return = new String().getClass().getName();
        int type = this.getColumnType(col);
        switch (type) {
            case 2: 
            case 3: {
                Return = new BigDecimal(0.0).getClass().getName();
                break;
            }
            case -7: {
                Return = new Boolean(false).getClass().getName();
                break;
            }
            case -6: {
                Return = new Byte("0").getClass().getName();
                break;
            }
            case 5: {
                Return = new Short("0").getClass().getName();
                break;
            }
            case 4: {
                Return = new Integer(0).getClass().getName();
                break;
            }
            case -5: {
                Return = new Long(0L).getClass().getName();
                break;
            }
            case 7: {
                Return = new Float(0.0f).getClass().getName();
                break;
            }
            case 6: 
            case 8: {
                Return = new Double(0.0).getClass().getName();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] abyte0 = new byte[]{};
                Return = abyte0.getClass().getName();
                break;
            }
            case 91: {
                Return = new Date(0L).getClass().getName();
                break;
            }
            case 92: {
                Return = new Time(0L).getClass().getName();
                break;
            }
            case 93: {
                Return = new Timestamp(0L).getClass().getName();
            }
        }
        return Return;
    }

    public int getColumnCount() throws SQLException {
        return this.resultSet.getColumnCount();
    }

    public int getColumnDisplaySize(int i) throws SQLException {
        PicoPseudoCol jdbcodbcpseudocol;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getColumnDisplaySize (" + i + ")");
        }
        int j = (jdbcodbcpseudocol = this.resultSet.getPseudoCol(i = this.resultSet.mapColumn(i))) != null ? jdbcodbcpseudocol.getColumnDisplaySize() : this.getColAttribute(i, 6);
        return j;
    }

    public String getColumnLabel(int i) throws SQLException {
        PicoPseudoCol jdbcodbcpseudocol;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getColumnLabel (" + i + ")");
        }
        String s = (jdbcodbcpseudocol = this.resultSet.getPseudoCol(i = this.resultSet.mapColumn(i))) != null ? jdbcodbcpseudocol.getColumnLabel() : this.getColAttributeString(i, 18);
        return s;
    }

    public String getColumnName(int i) throws SQLException {
        String s;
        PicoPseudoCol jdbcodbcpseudocol;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getColumnName (" + i + ")");
        }
        if ((jdbcodbcpseudocol = this.resultSet.getPseudoCol(i = this.resultSet.mapColumn(i))) != null) {
            s = jdbcodbcpseudocol.getColumnLabel();
        } else {
            s = this.getColAttributeString(i, 1);
            String alias = (String)this.columnNameMap.get(s);
            if (alias != null) {
                s = alias;
            }
        }
        return s;
    }

    public int getColumnType(int i) throws SQLException {
        PicoPseudoCol jdbcodbcpseudocol = this.resultSet.getPseudoCol(i);
        int j = jdbcodbcpseudocol != null ? jdbcodbcpseudocol.getColumnType() - 1 : this.resultSet.getColumnType(i);
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getColumnType (" + i + ")=" + j);
        }
        return j;
    }

    public String getColumnTypeName(int i) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getColumnTypeName (" + i + ")");
        }
        String s = this.resultSet.getPseudoCol(i = this.resultSet.mapColumn(i)) != null ? "" : this.getColAttributeString(i, 14);
        return s;
    }

    public int getPrecision(int i) throws SQLException {
        PicoPseudoCol jdbcodbcpseudocol;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getPrecision (" + i + ")");
        }
        int j = (jdbcodbcpseudocol = this.resultSet.getPseudoCol(i = this.resultSet.mapColumn(i))) != null ? jdbcodbcpseudocol.getColumnDisplaySize() - 1 : this.getColAttribute(i, 4);
        return j;
    }

    public int getScale(int i) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getScale (" + i + ")");
        }
        return this.resultSet.getScale(i);
    }

    public String getSchemaName(int i) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getSchemaName (" + i + ")");
        }
        if (this.resultSet.getPseudoCol(i = this.resultSet.mapColumn(i)) != null) {
            i = 1;
        }
        return this.getColAttributeString(i, 16);
    }

    public String getTableName(int i) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getTableName (" + i + ")");
        }
        if (this.resultSet.getPseudoCol(i = this.resultSet.mapColumn(i)) != null) {
            i = 1;
        }
        return this.getColAttributeString(i, 15);
    }

    public boolean isAutoIncrement(int i) throws SQLException {
        boolean flag = this.resultSet.getPseudoCol(i = this.resultSet.mapColumn(i)) != null ? false : this.getColAttributeBoolean(i, 11);
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isAutoIncrement (" + i + ")=" + flag);
        }
        return flag;
    }

    public boolean isCaseSensitive(int i) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isCaseSensitive (" + i + ")");
        }
        boolean flag = this.resultSet.getPseudoCol(i = this.resultSet.mapColumn(i)) != null ? false : this.getColAttributeBoolean(i, 12);
        return flag;
    }

    public boolean isCurrency(int i) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isCurrency (" + i + ")");
        }
        boolean flag = this.resultSet.getPseudoCol(i = this.resultSet.mapColumn(i)) != null ? false : this.getColAttributeBoolean(i, 9);
        return flag;
    }

    public boolean isDefinitelyWritable(int i) throws SQLException {
        int j;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isDefinitelyWritable (" + i + ")");
        }
        boolean flag = this.resultSet.getPseudoCol(i = this.resultSet.mapColumn(i)) != null ? false : (j = this.getColAttribute(i, 10)) == 1;
        return flag;
    }

    public int isNullable(int i) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isNullable (" + i + ")");
        }
        int j = this.resultSet.getPseudoCol(i = this.resultSet.mapColumn(i)) != null ? 0 : this.getColAttribute(i, 7);
        return j;
    }

    public boolean isReadOnly(int i) throws SQLException {
        boolean flag;
        if (this.resultSet.getPseudoCol(i = this.resultSet.mapColumn(i)) != null) {
            flag = true;
        } else {
            int j = this.getColAttribute(i, 10);
            boolean bl = flag = j == 0;
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isReadOnly (" + i + ")=" + flag);
        }
        return flag;
    }

    public boolean isSearchable(int i) throws SQLException {
        int j;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isSearchable (" + i + ")");
        }
        boolean flag = this.resultSet.getPseudoCol(i = this.resultSet.mapColumn(i)) != null ? false : (j = this.getColAttribute(i, 13)) != 0;
        return flag;
    }

    public boolean isSigned(int i) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isSigned (" + i + ")");
        }
        boolean flag = this.resultSet.getPseudoCol(i = this.resultSet.mapColumn(i)) != null ? false : !this.getColAttributeBoolean(i, 8);
        return flag;
    }

    public boolean isWritable(int i) throws SQLException {
        int j;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isWritable (" + i + ")");
        }
        boolean flag = this.resultSet.getPseudoCol(i = this.resultSet.mapColumn(i)) != null ? false : (j = this.getColAttribute(i, 10)) == 2;
        return flag;
    }
}

