/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.IsamConst;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.KeyPart;
import IT.picosoft.isam.Util;

public class KeyDesc
implements IsamConst {
    public static final int NPARTS = 8;
    public short k_flags;
    public short k_nparts;
    public KeyPart[] k_part;
    protected short k_len;
    protected long k_rootnode;
    protected int tksz;
    protected int btksz;
    protected int psz;

    protected KeyDesc(boolean dummy) {
    }

    public KeyDesc() {
        this.k_part = new KeyPart[8];
    }

    public void assign(KeyDesc k) {
        int i;
        this.k_flags = k.k_flags;
        this.k_nparts = k.k_nparts;
        for (i = 0; i < this.k_nparts; ++i) {
            this.k_part[i] = new KeyPart(k.k_part[i]);
        }
        while (i < 8) {
            this.k_part[i] = null;
            ++i;
        }
        this.k_len = k.k_len;
        this.k_rootnode = k.k_rootnode;
        this.psz = k.psz;
        this.btksz = k.btksz;
        this.tksz = k.tksz;
    }

    void setRootNode(long rn) {
        this.k_rootnode = rn;
        this.psz = (this.k_flags & 1) == 1 ? 4 : 0;
        this.btksz = this.k_len + 4;
        this.tksz = this.k_len + 4 + this.psz;
    }

    int getRootNode() {
        return (int)this.k_rootnode;
    }

    void check() throws IsamException {
        switch (this.k_flags & 1) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IsamException(103);
            }
        }
        if (this.k_nparts < 0 || this.k_nparts > 8) {
            throw new IsamException(103);
        }
        for (int i = 0; i < this.k_nparts; ++i) {
            if ((this.k_part[i].kp_type & 0xFFFFFF7F) < 2) continue;
            throw new IsamException(103);
        }
    }

    void buildKey(byte[] rec, int offs, byte[] key) {
        int kp_leng;
        int i = 0;
        for (int j = 0; i < this.k_nparts && key.length > j; j += kp_leng, ++i) {
            kp_leng = key.length - j;
            if (kp_leng > this.k_part[i].kp_leng) {
                kp_leng = this.k_part[i].kp_leng;
            }
            Util.memcpy(key, j, rec, this.k_part[i].kp_start + offs, kp_leng);
        }
    }
}

