/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as;

import com.iscobol.as.ClientInfo;
import com.iscobol.gui.AppFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.IsThread;

public abstract class AbstractClientThread
extends IsThread {
    public static final int AUTH_NONE = 0;
    public static final int AUTH_ADMINONLY = 1;
    public static final int AUTH_ALL = 2;
    public static final String AUTH_FILE = Config.getProperty(".as.password_file", "password.properties");
    protected final String hostaddress;
    final int port;
    private boolean checkAlive;
    protected ClientInfo clInfo;
    private String customInfo;

    public AbstractClientThread(ThreadGroup tg, String name, int id, String host, int port) {
        super(tg, name, id);
        this.hostaddress = host;
        this.port = port;
    }

    public AbstractClientThread(ThreadGroup tg, int id, String host, int port) {
        this(tg, "IscobolThread-" + id, id, host, port);
    }

    public ClientInfo getClientInfo() {
        if (this.clInfo != null) {
            this.clInfo.setCustomInfo(this.customInfo);
        }
        return this.clInfo;
    }

    public abstract String info(String var1);

    public abstract AppFactory getAppFactory();

    public abstract void shutdown(Boolean[] var1);

    protected String getUnivoqueId() {
        return this.hostaddress;
    }

    @Override
    public void run() {
    }

    public String getRemoteHost() {
        return this.hostaddress;
    }

    public int getRemotePort() {
        return this.port;
    }

    public boolean isCheckAlive() {
        return this.checkAlive;
    }

    public void setCheckAlive(boolean checkAlive) {
        this.checkAlive = checkAlive;
    }

    protected static boolean isAllowedName(String prg) {
        int len = prg.length();
        if (len > 0 && Character.isJavaIdentifierStart(prg.charAt(0))) {
            for (int i = len - 1; i > 0; --i) {
                if (Character.isJavaIdentifierPart(prg.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final void setCustomInfo(String info) {
        this.customInfo = info;
    }

    public final String getCustomInfo() {
        return this.customInfo;
    }
}

