/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as;

import com.iscobol.rts.Config;
import java.net.InetAddress;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class ClientInfo {
    public final String UNSET = "?";
    public static final int WEB_CLIENT = 1;
    public static final int MULTITASKING_CLIENT = 2;
    public static final int WEB_MULTITASKING_CLIENT = 3;
    public static final int TURBORUN_CLIENT = 4;
    private static final int TYPE_MASK = 15;
    private final String hostaddress;
    private final String hostname;
    private final String[] clData;
    private int userId = -1;
    private String userName = "?";
    private int threadId;
    private String startProgram = "?";
    private Thread thread;
    private String argLog;
    private int flags;
    private final String timestamp;
    private String customInfo;

    public ClientInfo(String ha, int tid, String sp, String[] cld) {
        this(ha, tid, sp, cld, null);
    }

    public ClientInfo(String ha, int tid, String sp, String[] cld, String argLog) {
        String hName;
        this.hostaddress = ha;
        this.threadId = tid;
        this.thread = Thread.currentThread();
        this.clData = cld;
        this.startProgram = sp == null ? "?" : sp;
        try {
            StringTokenizer st = new StringTokenizer(this.hostaddress, ".");
            byte[] addr = new byte[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                addr[i] = (byte)Integer.parseInt(st.nextToken());
                ++i;
            }
            hName = InetAddress.getByAddress(addr).getHostName();
        }
        catch (Exception e) {
            hName = "unknown";
        }
        this.hostname = hName;
        this.argLog = argLog;
        GregorianCalendar now = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        long result = (long)now.get(1) * 1000000000000L;
        result += (long)(now.get(2) + 1) * 10000000000L;
        result += (long)now.get(5) * 100000000L;
        result += (long)(now.get(11) * 1000000);
        result += (long)(now.get(12) * 10000);
        result += (long)(now.get(13) * 100);
        this.timestamp = String.valueOf(result += (long)(now.get(14) / 10));
    }

    public String getHostAddress() {
        return this.hostaddress;
    }

    public String getHostName() {
        return this.hostname;
    }

    public String getUserName() {
        String Return2 = this.userName == "?" ? Config.getProperty(this.thread, ".user.name", System.getProperty("user.name", "")) : this.userName;
        return Return2;
    }

    public void setUserName(String n) {
        this.userName = n;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int n) {
        this.userId = n;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void setThreadId(int n) {
        this.threadId = n;
    }

    public String getStartProgram() {
        return this.startProgram;
    }

    public String getUser() {
        String Return2 = Config.getProperty(this.thread, ".user.name", System.getProperty("user.name", ""));
        return Return2;
    }

    public void setStartProgram(String s) {
        this.startProgram = s;
    }

    public String[] getClData() {
        return this.clData;
    }

    public String getArgLog() {
        return this.argLog;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isWebClient() {
        return (this.flags & 0xF) == 1;
    }

    public void setWebClient() {
        this.flags = this.flags & 0xFFFFFFF0 | 1;
    }

    public boolean isTRClient() {
        return (this.flags | 0xF) == 4;
    }

    public void setTRClient() {
        this.flags = this.flags & 0xFFFFFFF0 | 4;
    }

    public boolean isMultitaskingClient() {
        return (this.flags | 0xF) == 2;
    }

    public void setMultitaskingClient() {
        this.flags = this.flags & 0xFFFFFFF0 | 2;
    }

    public boolean isWebMultitaskingClient() {
        return (this.flags | 0xF) == 3;
    }

    public void setWebMultitaskingClient() {
        this.flags = this.flags & 0xFFFFFFF0 | 3;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getCustomInfo() {
        return this.customInfo;
    }

    public void setCustomInfo(String customInfo) {
        this.customInfo = customInfo;
    }
}

