/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as;

import com.iscobol.as.AppServerImpl;
import com.iscobol.as.AsThreadGroup;
import com.iscobol.as.ClientInfo;
import com.iscobol.as.Login;
import com.iscobol.as.MultitaskingServerHandler;
import com.iscobol.as.ProgramRunnerThread;
import com.iscobol.as.UserData;
import com.iscobol.gui.AppFactory;
import com.iscobol.gui.AppFactoryMultitasking;
import com.iscobol.gui.GuiFactory;
import com.iscobol.interfaces.debugger.IDebuggerExtension2;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rts.CallLoader;
import com.iscobol.rts.Config;
import com.iscobol.rts.ErrorBox;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.LeveledRecursiveCall;
import com.iscobol.rts.OSValidator;
import com.iscobol.rts.RtsUtil;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class ClientThread
extends ProgramRunnerThread {
    static final int NO_COMPRESS = 0;
    private static final String COBLIB_PFX = "com.iscobol.lib.";
    private static int webClientId;
    private final String[] clData;
    private String arglog = "";
    private Session session;
    protected final boolean isWebClient;
    private Process process;
    private final String univoqueId;
    private String ideDeploymentFolder;
    private Map<String, String> ideSettings;

    ClientThread(Session sess, AppFactory af, String prog, String host, int port, String[] args, String[] clData) {
        super(new AsThreadGroup(sess), sess.getSessionId(), prog, host, port, args);
        this.session = sess;
        this.getThreadGroup().setDaemon(true);
        this.af = af;
        this.clData = clData;
        String webClient = clData.length > 5 ? clData[5] : "";
        boolean bl = this.isWebClient = webClient != null && webClient.length() > 0;
        this.univoqueId = this.isWebClient ? ("true".equals(webClient) ? this.hostaddress + "$" + ++webClientId + "$" : webClient) : this.hostaddress;
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                this.arglog = this.arglog + " " + args[i];
            }
        }
    }

    private static void environment(ClientInfo clInfo) {
        Config.setProperty("iscobol.as.info.userid", "" + clInfo.getUserId());
        Config.setProperty("iscobol.as.info.username", clInfo.getUserName());
        Config.setProperty("iscobol.as.info.program", clInfo.getStartProgram());
        Config.setProperty("iscobol.as.info.arguments", clInfo.getArgLog());
        Config.setProperty("iscobol.as.info.host", clInfo.getHostAddress());
        Config.setProperty("iscobol.as.info.as_command_line", AppServerImpl.commandLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exitProgram(ClientInfo clInfo) {
        if (AppServerImpl.hook != null) {
            IscobolCall iscobolCall = AppServerImpl.hook;
            synchronized (iscobolCall) {
                ClientThread.environment(clInfo);
                Config.setProperty("iscobol.as.info.entering", "0");
                try {
                    AppServerImpl.hook.call(null);
                }
                catch (Exception _ex) {
                    Logger log = AppServerImpl.getLogger();
                    AppServerImpl.warning(log, "Exit hook failed: ", _ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enterProgram(ClientInfo clInfo) {
        ClientThread.environment(clInfo);
        if (AppServerImpl.hook != null) {
            IscobolCall iscobolCall = AppServerImpl.hook;
            synchronized (iscobolCall) {
                Config.setProperty("iscobol.as.info.entering", "1");
                try {
                    AppServerImpl.hook.call(null);
                }
                catch (Exception _ex) {
                    Logger log = AppServerImpl.getLogger();
                    AppServerImpl.warning(log, "Entering hook failed: ", _ex);
                }
            }
        }
    }

    @Override
    public String info(String eol) {
        String Return2 = "UserId " + this.clInfo.getUserId() + ", User=" + this.clInfo.getUserName() + ", prog=" + this.prog + " (" + this.arglog + "), clienthost=" + this.hostaddress;
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean multitaskingExecution;
        boolean debug = this.clData != null && this.clData.length > 3 && this.clData[3] != null && !"false".equals(this.clData[3]);
        boolean isUtility = this.clData.length > 4 && "true".equals(this.clData[4]);
        boolean bl = multitaskingExecution = (AppServerImpl.mtskValue == 1 || AppServerImpl.mtskValue == 2 && debug) && this.af instanceof AppFactoryMultitasking && !this.prog.startsWith("ASA$") && !this.prog.startsWith("AS$") && !isUtility;
        if ("ASA$DEBUG_AUTO".equals(this.prog) || multitaskingExecution) {
            Config.markNoIscobolRuntimeThread();
        }
        IscobolSystem.set(AppFactory.class, this.af);
        boolean closeCurrentConnection = false;
        UserData ud = null;
        this.clInfo = new ClientInfo(this.hostaddress, this.id, this.prog, this.clData, this.arglog);
        IscobolSystem.set(ClientInfo.class, this.clInfo);
        Logger log = AppServerImpl.getLogger();
        int auth = Config.getProperty("iscobol.as.authentication", 1);
        GuiFactory gf = null;
        boolean noexit = false;
        if (this.clData != null && this.clData.length > 1 && this.clData[1] != null) {
            Config.setProperty(".user.name", this.clData[1]);
        }
        try {
            gf = this.af.newGuiFactory();
            noexit = this.af.getNoexit();
            IscobolSystem.set(GuiFactory.class, gf);
            String[][] isconfig = this.af.getIsconfig();
            if (isconfig != null) {
                int lenisconfig = isconfig.length;
                for (int i = 0; i < lenisconfig; ++i) {
                    Config.setProperty("iscobol." + isconfig[i][0], isconfig[i][1]);
                }
            }
        }
        catch (IOException _re) {
            AppServerImpl.severe(log, "Cannot create GuiFactory", _re);
            try {
                this.af.exit("Cannot create GuiFactory");
            }
            catch (IOException ex0) {
                log.info("Exception " + ex0 + ", prog '" + this.prog + "'");
            }
            return;
        }
        boolean added = false;
        if (this.isWebClient) {
            this.clInfo.setWebClient();
        }
        if (this.prog.startsWith("ASA$") || isUtility) {
            Config.setProperty("iscobol.runtime.compile_flags.mandatory", "");
            Config.setProperty("iscobol.runtime.compile_flags.prohibited", "");
            if ("ASA$DEBUG_AUTO".equals(this.prog)) {
                this.prog = "ASA$DEBUG";
                closeCurrentConnection = true;
            } else if (auth != 0) {
                Login l = new Login();
                try {
                    ud = l.login(AUTH_FILE);
                }
                catch (IOException _ex) {
                    AppServerImpl.severe(log, null, _ex);
                }
                if (ud != null) {
                    this.clInfo.setUserId(ud.id);
                    this.clInfo.setUserName(ud.name);
                    log.info("user=[" + ud.name + "],id=" + ud.id);
                    if (ud.id != 0) {
                        try {
                            gf.exit("Operation not permitted " + this.prog + " (" + this.arglog + ")");
                        }
                        catch (IOException _re) {
                            log.info("Exception " + _re + ", prog '" + this.prog + "'");
                        }
                        AppServerImpl.cleanUp(this.id, log);
                        return;
                    }
                } else {
                    try {
                        gf.exit("login failed" + this.prog + " (" + this.arglog + ")");
                    }
                    catch (IOException _re) {
                        log.info("Exception " + _re + ", prog '" + this.prog + "'");
                    }
                    AppServerImpl.cleanUp(this.id, log);
                    return;
                }
            }
            try {
                AppServerImpl.add(this.id, this);
                added = true;
            }
            catch (Throwable _re) {
                log.info(_re.getMessage());
                ClientThread.exit(this.af, _re);
                return;
            }
            if ("ASA$INFO".equals(this.prog)) {
                AppServerImpl.info();
                this.exit(gf, log);
                return;
            }
            if ("ASA$KILL".equals(this.prog)) {
                if (this.args != null && this.args.length > 0) {
                    for (int i = 0; i < this.args.length; ++i) {
                        try {
                            int k = Integer.parseInt(this.args[i]);
                            Thread.currentThread().setName("KILL-thread");
                            AppServerImpl.kill(k, 252, true);
                            continue;
                        }
                        catch (NumberFormatException _ex) {
                            if (!this.args[i].equalsIgnoreCase("AS")) continue;
                            AppServerImpl.stop(0);
                        }
                    }
                }
                this.exit(gf, log);
                return;
            }
            if ("ASA$DEBUG".equals(this.prog)) {
                int exitCode = 0;
                if (AppServerImpl.mtskValue <= 0) {
                    Config.setProperty("iscobol.exception.message", "2");
                    if (this.args != null && this.args.length > 0) {
                        if (this.args[0].equalsIgnoreCase("start")) {
                            int rundebug = 1;
                            try {
                                rundebug = Integer.parseInt(this.args[1]);
                            }
                            catch (Exception ex) {
                                rundebug = Config.getProperty("iscobol.rundebug", rundebug);
                            }
                            if (Config.getProperty("iscobol.as.debugport_range", null) != null) {
                                log.info("as.debugport_range ignored because as.multitasking not set");
                            }
                            int debugport = 9999;
                            try {
                                debugport = Integer.parseInt(this.args[2]);
                            }
                            catch (Exception ex) {
                                debugport = Config.getProperty("iscobol.debug.port", debugport);
                            }
                            if (debugport == 0) {
                                debugport = 9999;
                            }
                            boolean redirectStreams = true;
                            try {
                                redirectStreams = Boolean.parseBoolean(this.args[3]);
                            }
                            catch (Exception ex) {
                                redirectStreams = Config.getProperty("iscobol.redirect_streams", "iscobol.rundebug.redirect_streams", redirectStreams);
                            }
                            int blockMode = 0;
                            try {
                                blockMode = Integer.parseInt(this.args[4]);
                            }
                            catch (Exception ex) {
                                blockMode = Config.getProperty("iscobol.rundebug.auto_pause", true) ? 0 : 1;
                            }
                            Config.startDebugListener(rundebug, debugport, redirectStreams, true, blockMode);
                        } else if (this.args[0].equalsIgnoreCase("stop")) {
                            Config.stopDebugListener(closeCurrentConnection);
                        }
                    }
                } else {
                    this.clData[3] = this.args != null && this.args.length > 2 ? this.args[2] : Integer.toString(9999);
                    exitCode = this.getFreePort() == 0 ? -1 : 99;
                }
                try {
                    gf.exit(Integer.toString(exitCode));
                }
                catch (IOException _re) {
                    log.info("Exception " + _re + ", prog '" + this.prog + "'");
                }
                AppServerImpl.cleanUp(this.id, log);
                return;
            }
        } else if (auth == 2) {
            Login l = new Login();
            try {
                ud = l.login(AUTH_FILE);
            }
            catch (Exception _ex) {
                AppServerImpl.severe(log, null, _ex);
                try {
                    gf.exit("" + _ex);
                }
                catch (IOException _re) {
                    log.info("Exception " + _re + ", prog '" + this.prog + "'");
                }
            }
            if (ud != null) {
                this.clInfo.setUserId(ud.id);
                this.clInfo.setUserName(ud.name);
                log.info("user=[" + ud.name + "],id=" + ud.id);
            } else {
                try {
                    gf.exit("login failed");
                }
                catch (IOException _re) {
                    log.info("Exception " + _re + ", prog '" + this.prog + "'");
                }
                return;
            }
        }
        if (!added) {
            try {
                AppServerImpl.add(this.id, this);
                added = true;
            }
            catch (Throwable _re) {
                log.info(_re.getMessage());
                ClientThread.exit(this.af, _re);
                return;
            }
        }
        if (multitaskingExecution) {
            if (this.isWebClient) {
                this.clInfo.setWebMultitaskingClient();
            } else {
                this.clInfo.setMultitaskingClient();
            }
            try {
                int i;
                ClientThread.loadProperties(log, gf, this.prog, this.clData);
                int clientPort = ((AppFactoryMultitasking)this.af).handleMultitasking();
                this.stopEnabled = false;
                this.session.closeSession();
                String separator = System.getProperty("file.separator");
                String classpath = System.getProperty("java.class.path");
                String path = System.getProperty("java.home") + separator + "bin" + separator + "java";
                if (this.ideSettings != null) {
                    String ideCp = this.ideDeploymentFolder != null && !"".equals(this.ideDeploymentFolder) && !".".equals(this.ideDeploymentFolder) ? this.ideDeploymentFolder + File.pathSeparator : "";
                    String progCp = this.ideSettings.get("iscobol.classpath");
                    if (progCp != null && progCp.length() > 0) {
                        ideCp = ideCp + progCp.replace("\t", File.pathSeparator);
                    }
                    if (ideCp.length() > 0) {
                        classpath = classpath != null && classpath.length() > 0 ? ideCp + File.pathSeparator + classpath : ideCp;
                    }
                    if ((progCp = this.ideSettings.get("iscobol.prog.cp")) != null && progCp.length() > 0) {
                        ideCp = ideCp + progCp.replace("\t", File.pathSeparator);
                    }
                    if (ideCp.length() > 0) {
                        classpath = classpath != null && classpath.length() > 0 ? ideCp + File.pathSeparator + classpath : ideCp;
                    }
                }
                ArrayList<String> argList = new ArrayList<String>();
                argList.add(path);
                if (classpath != null && classpath.length() > 0) {
                    argList.add("-cp");
                    argList.add(classpath);
                }
                if (this.ideSettings != null) {
                    String sysProps = this.ideSettings.get("iscobol.prog.sysprops");
                    if (sysProps != null) {
                        for (String p : RtsUtil.parseArguments(sysProps)) {
                            argList.add(p);
                        }
                    }
                } else {
                    argList.addAll(Factory.getJVMArguments());
                    String s = Config.getProperty("iscobol.port", null);
                    if (s != null) {
                        argList.add("-Discobol.port=" + s);
                    }
                    if ((s = Config.getProperty("iscobol.hostname", null)) != null) {
                        argList.add("-Discobol.hostname=" + s);
                    }
                }
                argList.add(MultitaskingServerHandler.class.getName());
                argList.add(this.prog);
                argList.add("-host");
                argList.add(this.getRemoteHost());
                argList.add("-port");
                argList.add(String.valueOf(clientPort));
                if (debug) {
                    int freePort = this.getFreePort();
                    argList.add("-debugport");
                    argList.add(Integer.toString(freePort));
                }
                argList.add("-tid");
                argList.add(Integer.toString(this.id));
                String uname = null;
                if (ud != null) {
                    argList.add("-uid");
                    argList.add(Integer.toString(ud.id));
                    uname = ud.name;
                } else if (this.clData != null && this.clData.length > 1) {
                    uname = this.clData[1];
                }
                if (uname != null) {
                    argList.add("-uname");
                    argList.add(uname);
                }
                boolean isWin = OSValidator.isWindows();
                if (this.clData != null && this.clData.length > 0) {
                    for (i = 0; i < this.clData.length; ++i) {
                        argList.add("-cldata");
                        if (this.clData[i] == null || this.clData[i].length() <= 0) continue;
                        if (isWin) {
                            argList.add("\"" + this.clData[i] + "\"");
                            continue;
                        }
                        argList.add(this.clData[i]);
                    }
                }
                for (i = 0; i < this.args.length; ++i) {
                    argList.add("-arg");
                    if (isWin) {
                        argList.add("\"" + this.args[i] + "\"");
                        continue;
                    }
                    argList.add(this.args[i]);
                }
                if (noexit) {
                    argList.add("-noexit");
                }
                if (this.isWebClient) {
                    argList.add("-web");
                }
                if (AppServerImpl.confOption != null) {
                    argList.add(AppServerImpl.confOption[0]);
                    argList.add(AppServerImpl.confOption[1]);
                }
                String[] ss = new String[argList.size()];
                argList.toArray(ss);
                ProcessBuilder processBuilder = new ProcessBuilder(ss);
                if (this.ideSettings != null) {
                    File f;
                    String wrkdir;
                    int envcount = 0;
                    try {
                        envcount = Integer.parseInt(this.ideSettings.get("iscobol.prog.envvarcount"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (envcount > 0) {
                        boolean append = "___iscobol.option.true".equals(this.ideSettings.get("iscobol.prog.appenv"));
                        Map<String, String> env = processBuilder.environment();
                        if (!append) {
                            env.clear();
                        }
                        for (int i2 = 0; i2 < envcount; ++i2) {
                            String prop = this.ideSettings.get("iscobol.prog.envvars" + i2);
                            if (prop == null) continue;
                            int idx = prop.indexOf(61);
                            if (idx >= 0) {
                                if (idx < prop.length() - 1) {
                                    env.put(prop.substring(0, idx), prop.substring(idx + 1));
                                    continue;
                                }
                                env.put(prop.substring(0, idx), "");
                                continue;
                            }
                            env.put(prop, "");
                        }
                    }
                    if ((wrkdir = this.ideSettings.get("iscobol.prog.workdir")) != null && (f = new File(wrkdir)).isDirectory() && f.exists()) {
                        processBuilder.directory(f);
                    }
                }
                this.process = processBuilder.start();
                RtsUtil.newStreamDreaner(this.process.getInputStream(), System.out).start();
                RtsUtil.newStreamDreaner(this.process.getErrorStream(), System.out).start();
                try {
                    this.process.waitFor();
                }
                catch (InterruptedException e) {
                    this.process.destroy();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.info("Exception " + e);
            }
            finally {
                AppServerImpl.cleanUp(this.id, log);
            }
        } else {
            ClientThread.runProgram(log, this.af, gf, this.clInfo, this.args, this.getRemotePort(), this.id, noexit, isUtility, this.isWebClient);
        }
    }

    protected Process getProcess() {
        return this.process;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String loadProperties(Logger log, GuiFactory gf, String prog, String[] clData) {
        if (Config.getProperty("iscobol.as.use_aliases", false)) {
            String alias = Config.getProperty("iscobol.as.alias." + prog.toLowerCase(), null);
            if (alias != null) {
                int comma = alias.indexOf(44);
                if (comma < 0) return alias;
                prog = alias.substring(0, comma);
                try {
                    Config.loadProperties(alias.substring(comma + 1), true);
                    return prog;
                }
                catch (IOException _re) {
                    String msg = "Cannot load conf file: " + alias.substring(comma + 1) + ", " + _re.getMessage();
                    log.info(msg);
                    ErrorBox.showError("Cannot load conf file", msg);
                    try {
                        gf.exit(msg);
                        return prog;
                    }
                    catch (IOException _ex) {
                        log.info("Exception " + _ex);
                    }
                    return prog;
                }
            }
            log.severe("Alias name not found:'" + prog.toLowerCase() + "'");
            try {
                gf.exit("Alias name not found:'" + prog.toLowerCase() + "'");
                return prog;
            }
            catch (IOException _re) {
                log.info("Exception " + _re + ", prog '" + prog + "'");
            }
            return prog;
        }
        if (clData == null) return prog;
        if (clData.length <= 0) return prog;
        if (clData[0] == null) return prog;
        if (clData[0].length() <= 0) return prog;
        try {
            Config.loadProperties(clData[0], false);
            return prog;
        }
        catch (IOException _re) {
            String msg = "Cannot load conf file: " + clData[0] + ", " + _re.getMessage();
            log.info(msg);
            ErrorBox.showError("Cannot load conf file", msg);
            try {
                gf.exit();
                return prog;
            }
            catch (IOException _ex) {
                log.info("Exception " + _ex);
            }
            return prog;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runProgram(Logger log, AppFactory af, GuiFactory gf, ClientInfo clInfo, String[] args, int remotePort, int id, boolean noexit, boolean isUtility, boolean webClient) {
        try {
            ClientThread.runProgramImpl(log, af, gf, clInfo, args, remotePort, id, noexit, isUtility, webClient);
        }
        finally {
            if (id >= 0) {
                AppServerImpl.cleanUp(id, log);
            }
        }
        log.info("Exiting " + clInfo.getStartProgram() + " (" + clInfo.getArgLog() + ")");
    }

    /*
     * Exception decompiling
     */
    private static final void runProgramImpl(Logger log, AppFactory af, GuiFactory gf, ClientInfo clInfo, String[] args, int remotePort, int id, boolean noexit, boolean isUtility, boolean webClient) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void unexpectedException(IscobolCall pc, Throwable t) {
        if (pc != null) {
            if (pc instanceof LeveledRecursiveCall) {
                pc = ((LeveledRecursiveCall)pc).getMostRecent();
            }
            try {
                IDebuggerExtension2 dbg = (IDebuggerExtension2)Class.forName("com.iscobol.debugger.DebuggerImpl").newInstance();
                if (dbg.hasIscobolDebugInfos(pc)) {
                    dbg.unexpectedException(t);
                }
            }
            catch (Throwable t0) {
                t0.printStackTrace();
            }
        }
    }

    private void exit(GuiFactory gf, Logger log) {
        try {
            gf.exit("Exiting " + this.prog + " (" + this.arglog + ")");
        }
        catch (IOException _re) {
            log.info("Exception " + _re + ", prog '" + this.prog + "'");
        }
        AppServerImpl.cleanUp(this.id, log);
    }

    private static void exit(AppFactory af, Throwable _t) {
        try {
            ErrorBox.show(_t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            af.exit(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Class loadClass(String codePrefix, String progName) throws ClassNotFoundException {
        if (codePrefix != null && codePrefix.length() > 0 && !progName.startsWith("ASA$") && !progName.startsWith(COBLIB_PFX)) {
            return CallLoader.getInstance(codePrefix).loadClass(progName);
        }
        return Factory.classForName(progName);
    }

    private static void exitGUI(GuiFactory gf, Logger log, String prog, boolean noexit) {
        try {
            if (gf != null && noexit) {
                gf.exitGUI();
                log.info("ExitGUI , prog '" + prog + "'");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected String getUnivoqueId() {
        return this.univoqueId;
    }

    private int getFreePort() {
        String def = Integer.toString(9999);
        String debugPortRange = this.clData[3];
        int debugport = 9999;
        try {
            debugport = Integer.parseInt(debugPortRange);
            if (debugport == 0) {
                debugPortRange = Config.getProperty("iscobol.as.debugport_range", "9999-10099");
            }
        }
        catch (Exception ex) {
            debugPortRange = Config.getProperty("iscobol.debug.port", def);
        }
        return ClientThread.getFreePort(debugPortRange);
    }

    private static int getFreePort(String portRange) {
        ServerSocket serverSocket = null;
        int Return2 = 0;
        try {
            StringTokenizer stn = new StringTokenizer(portRange, ",");
            int[][] ranges = new int[stn.countTokens()][2];
            int i = 0;
            while (stn.hasMoreTokens()) {
                String r = stn.nextToken();
                int idx = r.indexOf(45);
                if (idx >= 0) {
                    ranges[i][0] = Integer.parseInt(r.substring(0, idx));
                    ranges[i][1] = Integer.parseInt(r.substring(idx + 1));
                } else {
                    int n = Integer.parseInt(r);
                    ranges[i][1] = n;
                    ranges[i][0] = n;
                }
                ++i;
            }
            Throwable ioex = null;
            int port = 0;
            for (int i2 = 0; i2 < ranges.length && serverSocket == null; ++i2) {
                for (port = ranges[i2][0]; port <= ranges[i2][1] && serverSocket == null; ++port) {
                    try {
                        serverSocket = new ServerSocket(port);
                        serverSocket.close();
                        Return2 = port;
                        continue;
                    }
                    catch (IOException ex) {
                        ioex = ex;
                    }
                }
            }
            if (serverSocket == null && ioex != null) {
                ioex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Return2;
    }

    public Map<String, String> getIdeSettings() {
        return this.ideSettings;
    }

    public void setIdeSettings(Map<String, String> ideSettings) {
        this.ideSettings = ideSettings;
    }

    public String getIdeDeploymentFolder() {
        return this.ideDeploymentFolder;
    }

    public void setIdeDeploymentFolder(String ideDeploymentFolder) {
        this.ideDeploymentFolder = ideDeploymentFolder;
    }

    @Override
    protected void closeSession() {
        this.session.closeSession();
    }
}

